/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.angular.editor;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Set;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.search.provider.SearchInfoUtils;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.html.angular.Utils;
import org.netbeans.modules.html.angular.index.AngularJsController;
import org.netbeans.modules.html.angular.index.AngularJsIndex;
import org.netbeans.modules.javascript2.editor.api.lexer.JsTokenId;
import org.netbeans.modules.javascript2.editor.api.lexer.LexUtilities;
import org.netbeans.modules.javascript2.editor.spi.DeclarationFinder;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class AngularJsDeclarationFinder
implements DeclarationFinder {
    public DeclarationFinder.DeclarationLocation findDeclaration(ParserResult info, int caretOffset) {
        int embeddedOffset = info.getSnapshot().getEmbeddedOffset(caretOffset);
        TokenSequence ts = LexUtilities.getJsTokenSequence((Snapshot)info.getSnapshot(), (int)embeddedOffset);
        if (ts == null) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        FileObject fo = info.getSnapshot().getSource().getFileObject();
        if (fo == null) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        ts.move(embeddedOffset);
        if (ts.moveNext()) {
            JsTokenId id = (JsTokenId)ts.token().id();
            String tokenText = ts.token().text().toString();
            if (id == JsTokenId.IDENTIFIER) {
                return this.findControllerLocation(fo, tokenText);
            }
            if (id == JsTokenId.STRING) {
                OffsetRange range = this.isValueOfProperty("controller", (TokenSequence<? extends JsTokenId>)ts, caretOffset);
                if (range != null) {
                    return this.findControllerLocation(fo, tokenText);
                }
                range = this.isValueOfProperty("templateUrl", (TokenSequence<? extends JsTokenId>)ts, caretOffset);
                if (range != null) {
                    return this.findFileLocation(fo, Utils.cutQueryFromTemplateUrl(tokenText));
                }
            }
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    public OffsetRange getReferenceSpan(Document doc, int caretOffset) {
        TokenSequence ts = LexUtilities.getJsTokenSequence((Document)doc, (int)caretOffset);
        if (ts == null) {
            return OffsetRange.NONE;
        }
        ts.move(caretOffset);
        if (ts.moveNext()) {
            JsTokenId id = (JsTokenId)ts.token().id();
            if (id == JsTokenId.IDENTIFIER) {
                return new OffsetRange(ts.offset(), ts.offset() + ts.token().length());
            }
            OffsetRange range = this.isValueOfProperty("controller", (TokenSequence<? extends JsTokenId>)ts, caretOffset);
            if (range != null) {
                return range;
            }
            range = this.isValueOfProperty("templateUrl", (TokenSequence<? extends JsTokenId>)ts, caretOffset);
            if (range != null) {
                return range;
            }
        }
        return OffsetRange.NONE;
    }

    private DeclarationFinder.DeclarationLocation findFileLocation(FileObject fo, String endPartName) {
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        if (project == null) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        Sources sources = (Sources)project.getLookup().lookup(Sources.class);
        SourceGroup[] sourceGroups = sources.getSourceGroups("generic");
        String[] endPath = endPartName.split("/");
        HashMap<String, FileObject> files = new HashMap<String, FileObject>();
        for (SourceGroup sourceGroup : sourceGroups) {
            ArrayList<FileObject> filesInGroup = new ArrayList<FileObject>();
            this.findFilesWithEndPath(endPath, sourceGroup.getRootFolder(), filesInGroup);
            int rootPathLength = sourceGroup.getRootFolder().getPath().length();
            for (FileObject fileObject : filesInGroup) {
                if (!SearchInfoUtils.SHARABILITY_FILTER.searchFile(fileObject)) continue;
                String shortPathName = fileObject.getPath();
                shortPathName = shortPathName.substring(rootPathLength + 1);
                files.put(shortPathName, fileObject);
            }
        }
        if (!files.isEmpty()) {
            DeclarationFinder.DeclarationLocation dl = null;
            for (String shortPathName : files.keySet()) {
                FileObject fileObject = (FileObject)files.get(shortPathName);
                DeclarationFinder.DeclarationLocation dloc = new DeclarationFinder.DeclarationLocation(fileObject, 0);
                if (dl == null) {
                    dl = dloc;
                }
                AlternativeLocationImpl aloc = new AlternativeLocationImpl(shortPathName, dloc, new AngularFileHandle(shortPathName, fileObject));
                dl.addAlternative((DeclarationFinder.AlternativeLocation)aloc);
            }
            if (dl != null && dl.getAlternativeLocations().size() == 1) {
                dl.getAlternativeLocations().clear();
            }
            if (dl != null) {
                return dl;
            }
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    private void findFilesWithEndPath(String[] endPath, FileObject folder, Collection<FileObject> collected) {
        FileObject root = folder;
        boolean wasFound = true;
        for (int i = 0; i < endPath.length; ++i) {
            if ((root = root.getFileObject(endPath[i])) != null) continue;
            wasFound = false;
            break;
        }
        if (wasFound) {
            collected.add(root);
        }
        Enumeration folders = folder.getFolders(false);
        while (folders.hasMoreElements()) {
            FileObject subFolder = (FileObject)folders.nextElement();
            this.findFilesWithEndPath(endPath, subFolder, collected);
        }
    }

    private DeclarationFinder.DeclarationLocation findControllerLocation(FileObject fo, String controllerName) {
        block9: {
            Project project = FileOwnerQuery.getOwner((FileObject)fo);
            if (project == null) {
                return DeclarationFinder.DeclarationLocation.NONE;
            }
            try {
                Collection<AngularJsController> controllers = AngularJsIndex.get(project).getControllers(controllerName, true);
                if (controllers.isEmpty()) break block9;
                DeclarationFinder.DeclarationLocation dl = null;
                for (AngularJsController controller : controllers) {
                    URI uri = null;
                    try {
                        uri = controller.getDeclarationFile().toURI();
                    }
                    catch (URISyntaxException ex) {
                        // empty catch block
                    }
                    if (uri == null) continue;
                    File file = new File(uri);
                    FileObject dfo = FileUtil.toFileObject((File)file);
                    DeclarationFinder.DeclarationLocation dloc = new DeclarationFinder.DeclarationLocation(dfo, controller.getOffset());
                    if (dl == null) {
                        dl = dloc;
                    }
                    AlternativeLocationImpl aloc = new AlternativeLocationImpl(controller.getName(), dloc, (ElementHandle)new ElementHandle.UrlHandle(dfo.getPath()));
                    dl.addAlternative((DeclarationFinder.AlternativeLocation)aloc);
                }
                if (dl != null && dl.getAlternativeLocations().size() == 1) {
                    dl.getAlternativeLocations().clear();
                }
                if (dl != null) {
                    return dl;
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    private OffsetRange isValueOfProperty(String propertyName, TokenSequence<? extends JsTokenId> ts, int caretOffset) {
        JsTokenId id;
        ts.move(caretOffset);
        if (ts.moveNext() && (id = (JsTokenId)ts.token().id()) == JsTokenId.STRING) {
            OffsetRange result = new OffsetRange(ts.offset(), ts.offset() + ts.token().length());
            ts.movePrevious();
            Token previous = LexUtilities.findPrevious(ts, Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.EOL, JsTokenId.BLOCK_COMMENT, JsTokenId.LINE_COMMENT, JsTokenId.STRING_BEGIN));
            if (previous != null && previous.id() == JsTokenId.OPERATOR_COLON && ts.movePrevious() && (previous = LexUtilities.findPrevious(ts, Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.EOL, JsTokenId.BLOCK_COMMENT, JsTokenId.LINE_COMMENT))) != null && previous.id() == JsTokenId.IDENTIFIER && propertyName.equals(previous.text().toString())) {
                return result;
            }
        }
        return null;
    }

    private static class AlternativeLocationImpl
    implements DeclarationFinder.AlternativeLocation {
        private final DeclarationFinder.DeclarationLocation location;
        private final ElementHandle element;
        private String name;

        public AlternativeLocationImpl(String name, DeclarationFinder.DeclarationLocation location, ElementHandle element) {
            this.location = location;
            this.name = name;
            this.element = element;
        }

        public ElementHandle getElement() {
            return this.element;
        }

        public String getDisplayHtml(HtmlFormatter formatter) {
            StringBuilder sb = new StringBuilder();
            sb.append("<font color='black'>");
            sb.append(this.element.getName());
            sb.append("</font>");
            return sb.toString();
        }

        public DeclarationFinder.DeclarationLocation getLocation() {
            return this.location;
        }

        public int compareTo(DeclarationFinder.AlternativeLocation o) {
            return AlternativeLocationImpl.getComparableString(this).compareTo(AlternativeLocationImpl.getComparableString(o));
        }

        private static String getComparableString(DeclarationFinder.AlternativeLocation loc) {
            StringBuilder sb = new StringBuilder();
            sb.append(loc.getLocation().getOffset());
            FileObject fo = loc.getLocation().getFileObject();
            if (fo != null) {
                sb.append(fo.getPath());
            }
            return sb.toString();
        }
    }

    private static class AngularFileHandle
    implements ElementHandle {
        private final FileObject fileObject;
        private final String displayName;

        public AngularFileHandle(String displayName, FileObject fileObject) {
            this.fileObject = fileObject;
            this.displayName = displayName;
        }

        public FileObject getFileObject() {
            return this.fileObject;
        }

        public String getMimeType() {
            return null;
        }

        public String getName() {
            return this.displayName;
        }

        public String getIn() {
            return null;
        }

        public ElementKind getKind() {
            return ElementKind.FILE;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public boolean signatureEquals(ElementHandle handle) {
            return false;
        }

        public OffsetRange getOffsetRange(ParserResult result) {
            return OffsetRange.NONE;
        }
    }
}

