/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.angular;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.html.angular.index.AngularJsController;
import org.netbeans.modules.html.angular.index.AngularJsIndex;
import org.netbeans.modules.html.angular.index.AngularJsIndexer;
import org.netbeans.modules.html.angular.model.AngularModel;
import org.netbeans.modules.html.angular.model.Directive;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.spi.embedding.JsEmbeddingProviderPlugin;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.netbeans.modules.web.common.api.WebUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class AngularJsEmbeddingProviderPlugin
extends JsEmbeddingProviderPlugin {
    private final LinkedList<StackItem> stack = new LinkedList();
    private TokenSequence<HTMLTokenId> tokenSequence;
    private Snapshot snapshot;
    private List<Embedding> embeddings;
    private int processedTemplate;
    private Directive interestedAttr;
    private HashMap<String, String> propertyToFqn = new HashMap();

    public boolean startProcessing(HtmlParserResult parserResult, Snapshot snapshot, TokenSequence<HTMLTokenId> tokenSequence, List<Embedding> embeddings) {
        if (AngularJsIndexer.Factory.isScannerThread()) {
            return false;
        }
        this.snapshot = snapshot;
        this.tokenSequence = tokenSequence;
        this.embeddings = embeddings;
        this.stack.clear();
        this.processedTemplate = -1;
        AngularModel model = AngularModel.getModel(parserResult);
        if (!model.isAngularPage()) {
            return false;
        }
        FileObject file = snapshot.getSource().getFileObject();
        return file != null;
    }

    public void endProcessing() {
        super.endProcessing();
        if (this.processedTemplate > 0) {
            for (int i = 0; i < this.processedTemplate; ++i) {
                this.embeddings.add(this.snapshot.create((CharSequence)"}\n});\n", "text/javascript"));
            }
        }
    }

    public boolean processToken() {
        boolean processed = false;
        CharSequence tokenText = this.tokenSequence.token().text();
        block0 : switch ((HTMLTokenId)this.tokenSequence.token().id()) {
            case TAG_OPEN: {
                this.stack.push(new StackItem(tokenText.toString()));
                break;
            }
            case TAG_CLOSE: {
                if (this.stack.isEmpty()) break;
                StackItem top = this.stack.pop();
                while (!this.stack.isEmpty() && !LexerUtils.equals((CharSequence)top.tag, (CharSequence)tokenText, (boolean)false, (boolean)false)) {
                    if (!top.finishText.isEmpty()) {
                        this.embeddings.add(this.snapshot.create((CharSequence)top.finishText, "text/javascript"));
                    }
                    top = this.stack.pop();
                }
                if (top.finishText.isEmpty()) break;
                this.embeddings.add(this.snapshot.create((CharSequence)top.finishText, "text/javascript"));
                break;
            }
            case ARGUMENT: {
                Directive ajsDirective = Directive.getDirective(tokenText.toString().trim().toLowerCase());
                if (ajsDirective != null) {
                    this.interestedAttr = ajsDirective;
                    break;
                }
                this.interestedAttr = null;
                break;
            }
            case VALUE: {
                if (this.interestedAttr == null) break;
                String value = WebUtils.unquotedValue((CharSequence)tokenText);
                switch (this.interestedAttr) {
                    case controller: {
                        processed = this.processController(value);
                        this.stack.peek().addFinishText("}\n});\n");
                        break block0;
                    }
                    case model: 
                    case disabled: 
                    case click: {
                        processed = this.processModel(value);
                        break block0;
                    }
                    case repeat: {
                        processed = this.processRepeat(value);
                        this.stack.peek().addFinishText("}\n");
                        break block0;
                    }
                }
                processed = this.processExpression(value);
                break;
            }
            case EL_OPEN_DELIMITER: {
                if (!this.tokenSequence.moveNext()) break;
                if (this.tokenSequence.token().id() == HTMLTokenId.EL_CONTENT) {
                    int parenIndex;
                    String value = this.tokenSequence.token().text().toString();
                    int indexStart = 0;
                    boolean parenRemoved = false;
                    String name = value.trim();
                    if (value.startsWith("(")) {
                        name = value.substring(1);
                        parenRemoved = true;
                        indexStart = 1;
                    }
                    if ((parenIndex = name.indexOf(40)) > -1) {
                        name = name.substring(0, parenIndex);
                    }
                    this.processTemplate();
                    if (this.propertyToFqn.containsKey(name)) {
                        this.embeddings.add(this.snapshot.create((CharSequence)(this.propertyToFqn.get(name) + ".$scope."), "text/javascript"));
                        this.embeddings.add(this.snapshot.create(this.tokenSequence.offset(), value.length(), "text/javascript"));
                        this.embeddings.add(this.snapshot.create((CharSequence)";\n", "text/javascript"));
                        processed = true;
                        break;
                    }
                    if (!name.contains("|") && !name.contains(":")) {
                        this.embeddings.add(this.snapshot.create(this.tokenSequence.offset(), value.length(), "text/javascript"));
                        this.embeddings.add(this.snapshot.create((CharSequence)";\n", "text/javascript"));
                        processed = true;
                        break;
                    }
                    if (name.contains("|")) {
                        int indexEnd = name.indexOf(124);
                        name = name.substring(0, indexEnd);
                        if (parenRemoved && (indexEnd = name.lastIndexOf(41)) > -1) {
                            name = name.substring(0, indexEnd);
                        }
                        if (name.startsWith("-")) {
                            ++indexStart;
                            name = name.substring(1);
                        }
                        if (this.propertyToFqn.containsKey(name)) {
                            this.embeddings.add(this.snapshot.create((CharSequence)(this.propertyToFqn.get(name) + ".$scope."), "text/javascript"));
                            this.embeddings.add(this.snapshot.create(this.tokenSequence.offset() + indexStart, name.length(), "text/javascript"));
                            this.embeddings.add(this.snapshot.create((CharSequence)";\n", "text/javascript"));
                            processed = true;
                            break;
                        }
                        this.embeddings.add(this.snapshot.create(this.tokenSequence.offset() + indexStart, name.length(), "text/javascript"));
                        this.embeddings.add(this.snapshot.create((CharSequence)";\n", "text/javascript"));
                        processed = true;
                        break;
                    }
                    this.tokenSequence.movePrevious();
                    break;
                }
                if (this.tokenSequence.token().id() == HTMLTokenId.EL_CLOSE_DELIMITER) {
                    this.embeddings.add(this.snapshot.create(this.tokenSequence.offset(), 0, "text/javascript"));
                    processed = true;
                    break;
                }
                this.tokenSequence.movePrevious();
                break;
            }
        }
        return processed;
    }

    private boolean processController(String controllerName) {
        this.processTemplate();
        StringBuilder sb = new StringBuilder();
        sb.append("(function () {\n$scope = ");
        Project project = FileOwnerQuery.getOwner((FileObject)this.snapshot.getSource().getFileObject());
        String fqn = controllerName.trim();
        AngularJsIndex index = null;
        try {
            index = AngularJsIndex.get(project);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (index != null) {
            Collection<AngularJsController> controllers = index.getControllers(controllerName, true);
            for (AngularJsController controller : controllers) {
                if (!controller.getName().equals(controllerName)) continue;
                fqn = controller.getFqn();
                break;
            }
        }
        if (!fqn.isEmpty()) {
            sb.append(fqn);
            sb.append(".");
        }
        sb.append("$scope;\n");
        this.embeddings.add(this.snapshot.create((CharSequence)sb.toString(), "text/javascript"));
        sb = new StringBuilder();
        if (!controllerName.isEmpty()) {
            this.embeddings.add(this.snapshot.create(this.tokenSequence.offset() + 1, controllerName.length(), "text/javascript"));
            sb.append(";");
        } else {
            this.embeddings.add(this.snapshot.create(this.tokenSequence.offset() + 1, 0, "text/javascript"));
        }
        sb.append("\nwith ($scope) { \n");
        this.embeddings.add(this.snapshot.create((CharSequence)sb.toString(), "text/javascript"));
        return true;
    }

    private boolean processModel(String value) {
        this.processTemplate();
        if (value.isEmpty()) {
            this.embeddings.add(this.snapshot.create((CharSequence)"( function () {", "text/javascript"));
            this.embeddings.add(this.snapshot.create(this.tokenSequence.offset() + 1, 0, "text/javascript"));
            this.embeddings.add(this.snapshot.create((CharSequence)";})();\n", "text/javascript"));
        } else {
            this.embeddings.add(this.snapshot.create(this.tokenSequence.offset() + 1, value.length() - (this.tokenSequence.index() == this.tokenSequence.tokenCount() - 1 ? 1 : 0), "text/javascript"));
            this.embeddings.add(this.snapshot.create((CharSequence)";\n", "text/javascript"));
        }
        return true;
    }

    private boolean processRepeat(String expression) {
        this.processTemplate();
        boolean processed = false;
        String[] parts = expression.split("\\|");
        if (parts.length > 0) {
            int lastPartPos;
            if (parts[0].contains(" in ")) {
                String[] forParts = parts[0].trim().split(" in ");
                if (forParts.length < 2) {
                    return false;
                }
                this.embeddings.add(this.snapshot.create((CharSequence)"for (var ", "text/javascript"));
                if (!forParts[0].contains(",")) {
                    if (forParts.length == 2 && this.propertyToFqn.containsKey(forParts[1])) {
                        lastPartPos = expression.indexOf(forParts[1]);
                        this.embeddings.add(this.snapshot.create(this.tokenSequence.offset() + 1, lastPartPos, "text/javascript"));
                        this.embeddings.add(this.snapshot.create((CharSequence)(this.propertyToFqn.get(forParts[1]) + ".$scope."), "text/javascript"));
                        this.embeddings.add(this.snapshot.create(this.tokenSequence.offset() + 1 + lastPartPos, forParts[1].length(), "text/javascript"));
                    } else {
                        this.embeddings.add(this.snapshot.create(this.tokenSequence.offset() + 1, parts[0].length(), "text/javascript"));
                    }
                    this.embeddings.add(this.snapshot.create((CharSequence)") {\n", "text/javascript"));
                } else {
                    String valueExp = forParts[0].trim();
                    if (valueExp.startsWith("(")) {
                        valueExp = valueExp.substring(1);
                    }
                    if (valueExp.endsWith(")")) {
                        valueExp = valueExp.substring(0, valueExp.length() - 1);
                    }
                    valueExp = valueExp.trim();
                    String[] keyValue = valueExp.split(",");
                    int lastPartPos2 = expression.indexOf(forParts[1]);
                    int keyPos = expression.indexOf(keyValue[0]);
                    this.embeddings.add(this.snapshot.create(this.tokenSequence.offset() + 1 + keyPos, keyValue[0].length(), "text/javascript"));
                    this.embeddings.add(this.snapshot.create((CharSequence)" in ", "text/javascript"));
                    if (forParts.length == 2 && this.propertyToFqn.containsKey(forParts[1])) {
                        this.embeddings.add(this.snapshot.create((CharSequence)(this.propertyToFqn.get(forParts[1]) + ".$scope."), "text/javascript"));
                        this.embeddings.add(this.snapshot.create(this.tokenSequence.offset() + 1 + lastPartPos2, forParts[1].length(), "text/javascript"));
                    } else {
                        this.embeddings.add(this.snapshot.create(this.tokenSequence.offset() + 1 + lastPartPos2, forParts[1].length(), "text/javascript"));
                    }
                    this.embeddings.add(this.snapshot.create((CharSequence)") {\nvar ", "text/javascript"));
                    int valuePos = expression.indexOf(keyValue[1]);
                    this.embeddings.add(this.snapshot.create(this.tokenSequence.offset() + 1 + valuePos, keyValue[1].length(), "text/javascript"));
                    this.embeddings.add(this.snapshot.create((CharSequence)";\n", "text/javascript"));
                }
                processed = true;
            }
            lastPartPos = parts[0].length() + 1;
            for (int partIndex = 1; partIndex < parts.length; ++partIndex) {
                String[] conditionParts;
                if (parts[partIndex].contains(":") && (conditionParts = parts[partIndex].trim().split(":")).length > 1) {
                    String propName = conditionParts[1].trim();
                    int indexInName = 0;
                    char ch = propName.charAt(indexInName);
                    while (indexInName < propName.length() - 1 && (Character.isWhitespace(ch) || ch == '{')) {
                        ch = propName.charAt(++indexInName);
                    }
                    if (indexInName > 0) {
                        propName = propName.substring(indexInName);
                    }
                    int position = lastPartPos + parts[partIndex].indexOf(propName) + 1;
                    indexInName = propName.length() - 1;
                    ch = propName.charAt(indexInName);
                    while (indexInName > 0 && (Character.isWhitespace(ch) || ch == '{' || ch == '}')) {
                        ch = propName.charAt(--indexInName);
                    }
                    if (indexInName < propName.length() - 1) {
                        propName = propName.substring(0, indexInName - 1);
                    }
                    if (this.propertyToFqn.containsKey(propName)) {
                        this.embeddings.add(this.snapshot.create((CharSequence)(this.propertyToFqn.get(propName) + ".$scope."), "text/javascript"));
                    }
                    this.embeddings.add(this.snapshot.create(this.tokenSequence.offset() + position, propName.length(), "text/javascript"));
                    this.embeddings.add(this.snapshot.create((CharSequence)";\n", "text/javascript"));
                }
                lastPartPos = lastPartPos + parts[partIndex].length() + 1;
            }
        }
        return processed;
    }

    private boolean processExpression(String value) {
        this.processTemplate();
        boolean processed = false;
        if (value.isEmpty()) {
            this.embeddings.add(this.snapshot.create((CharSequence)"( function () {", "text/javascript"));
            this.embeddings.add(this.snapshot.create(this.tokenSequence.offset() + 1, 0, "text/javascript"));
            this.embeddings.add(this.snapshot.create((CharSequence)";})();\n", "text/javascript"));
            processed = true;
        } else {
            String valueTrim;
            int lastPartPos = 0;
            int valueTrimPos = 0;
            if (value.startsWith("{")) {
                value = value.substring(1);
                lastPartPos = 1;
            }
            if ((valueTrim = value.trim()).endsWith("}")) {
                value = valueTrim.substring(0, valueTrim.length() - 1);
                valueTrim = "";
            } else if (valueTrim.contains("}")) {
                valueTrimPos = valueTrim.indexOf(125);
                value = valueTrim.substring(0, valueTrimPos);
                valueTrim = valueTrim.substring(valueTrimPos + 1);
                valueTrimPos = valueTrimPos + lastPartPos + 2;
            } else {
                valueTrim = "";
            }
            int index = value.indexOf(58);
            if (index > -1) {
                String[] parts;
                for (String part : parts = value.split(",")) {
                    String propName;
                    String[] conditionParts;
                    index = value.indexOf(58);
                    if (index > 0 && (conditionParts = part.trim().split(":")).length > 1 && !(propName = conditionParts[1].trim()).startsWith("//")) {
                        int position = lastPartPos + part.indexOf(propName) + 1;
                        if (propName.charAt(0) == '\"' || propName.charAt(0) == '\'') {
                            propName = propName.substring(1);
                            ++position;
                            if (propName.endsWith("\"") || propName.endsWith("'")) {
                                propName = propName.substring(0, propName.length() - 1);
                            }
                        }
                        if (this.propertyToFqn.containsKey(propName)) {
                            this.embeddings.add(this.snapshot.create((CharSequence)(this.propertyToFqn.get(propName) + ".$scope."), "text/javascript"));
                        }
                        this.embeddings.add(this.snapshot.create(this.tokenSequence.offset() + position, propName.length(), "text/javascript"));
                        this.embeddings.add(this.snapshot.create((CharSequence)";\n", "text/javascript"));
                        processed = true;
                    }
                    lastPartPos = lastPartPos + part.length() + 1;
                }
            }
            if (!valueTrim.isEmpty()) {
                this.embeddings.add(this.snapshot.create(this.tokenSequence.offset() + lastPartPos + 1, valueTrim.length(), "text/javascript"));
                this.embeddings.add(this.snapshot.create((CharSequence)";\n", "text/javascript"));
            }
        }
        return processed;
    }

    private void processTemplate() {
        if (this.processedTemplate > -1) {
            return;
        }
        this.processedTemplate = 0;
        FileObject fo = this.snapshot.getSource().getFileObject();
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        AngularJsIndex index = null;
        try {
            index = AngularJsIndex.get(project);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (index != null) {
            Collection<String> controllersForTemplate = index.getControllersForTemplate(fo.toURI());
            block2: for (String controllerName : controllersForTemplate) {
                Collection<AngularJsController> controllers = index.getControllers(controllerName, true);
                if (!controllers.isEmpty()) {
                    for (AngularJsController controller : controllers) {
                        if (!controller.getName().equals(controllerName)) continue;
                        String fqn = controller.getFqn();
                        ++this.processedTemplate;
                        StringBuilder sb = new StringBuilder();
                        sb.append("(function () {\n$scope = ");
                        if (!fqn.isEmpty()) {
                            sb.append(fqn);
                        } else {
                            sb.append(controllerName);
                        }
                        sb.append(".");
                        sb.append("$scope;\n");
                        sb.append("\nwith ($scope) { \n");
                        this.embeddings.add(this.snapshot.create((CharSequence)sb.toString(), "text/javascript"));
                        continue block2;
                    }
                    continue;
                }
                ++this.processedTemplate;
                StringBuilder sb = new StringBuilder();
                sb.append("(function () {\n$scope = ");
                sb.append(controllerName);
                sb.append(".");
                sb.append("$scope;\n");
                sb.append("\nwith ($scope) { \n");
                this.embeddings.add(this.snapshot.create((CharSequence)sb.toString(), "text/javascript"));
            }
        }
    }

    private static class StackItem {
        final String tag;
        String finishText;

        public StackItem(String tag) {
            this.tag = tag;
            this.finishText = "";
        }

        public void addFinishText(String text) {
            this.finishText = text + this.finishText;
        }
    }
}

