/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.angular;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.html.angular.Bundle;
import org.netbeans.modules.html.angular.Utils;
import org.netbeans.modules.html.angular.model.Directive;
import org.openide.modules.Places;
import org.openide.util.Enumerations;
import org.openide.util.RequestProcessor;

public class AngularDoc {
    private static final Logger LOG = Logger.getLogger(AngularDoc.class.getSimpleName());
    private static RequestProcessor RP = new RequestProcessor(AngularDoc.class);
    private static AngularDoc INSTANCE;
    private boolean loadingStarted;
    private static final String CACHE_FOLDER_NAME = "ajs-doc";
    public static final String DOC_VERSION = "1.2.12";
    private Directive directive;
    private Enumeration<Directive> directives;
    private ProgressHandle progress;
    private int loaded = 0;

    public static synchronized AngularDoc getDefault() {
        if (INSTANCE == null) {
            INSTANCE = new AngularDoc();
        }
        return INSTANCE;
    }

    public String getDirectiveDocumentation(Directive directive) {
        return this.getDoc(directive);
    }

    private void startLoading() {
        LOG.fine("start loading doc");
        Directive[] dirs = Directive.values();
        this.directives = Enumerations.array((Object[])dirs);
        this.progress = ProgressHandleFactory.createHandle((String)Bundle.doc_building());
        this.progress.start(dirs.length);
        this.buildDoc();
    }

    private File getCacheFile(Directive directive) {
        return Places.getCacheSubfile((String)(CACHE_FOLDER_NAME + '/' + DOC_VERSION + '/' + directive.name()));
    }

    private String getDoc(Directive directive) {
        try {
            File cacheFile = this.getCacheFile(directive);
            if (!cacheFile.exists()) {
                this.loadDoc(directive, cacheFile);
                if (!this.loadingStarted) {
                    this.loadingStarted = true;
                    this.startLoading();
                }
            }
            return Utils.getFileContent(cacheFile);
        }
        catch (IOException | URISyntaxException ex) {
            LOG.log(Level.INFO, "Cannot load AngularJS documentation from \"{0}\".", new Object[]{directive.getExternalDocumentationURL_partial()});
            return Bundle.doc_cannotGet(directive.getExternalDocumentationURL_partial());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDoc(Directive directive, File cacheFile) throws URISyntaxException, MalformedURLException, IOException {
        LOG.fine("start loading doc");
        String docURL = directive.getExternalDocumentationURL_partial();
        URL url = new URI(docURL).toURL();
        File file = cacheFile;
        synchronized (file) {
            String tmpFileName = cacheFile.getAbsolutePath() + ".tmp";
            File tmpFile = new File(tmpFileName);
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(tmpFile), "UTF-8");){
                ((Writer)writer).append("<!doctype html><html><head><title>AngularJS documentation</title></head><body>");
                Utils.loadURL(url, writer, null);
                ((Writer)writer).append("</body></html>");
                tmpFile.renameTo(cacheFile);
            }
            finally {
                if (tmpFile.exists()) {
                    tmpFile.delete();
                }
            }
        }
    }

    private void buildDoc() {
        if (this.directives.hasMoreElements()) {
            this.directive = this.directives.nextElement();
            this.getDoc(this.directive);
            this.progress.progress(++this.loaded);
            RP.post(new Runnable(){

                @Override
                public void run() {
                    AngularDoc.this.buildDoc();
                }
            });
        } else {
            this.progress.finish();
            this.progress = null;
            LOG.log(Level.FINE, "Loading doc finished.");
        }
    }
}

