/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.common.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.common.api.CssPreprocessor;
import org.netbeans.modules.web.common.api.CssPreprocessorsListener;
import org.netbeans.modules.web.common.cssprep.CssPreprocessorAccessor;
import org.netbeans.modules.web.common.cssprep.CssPreprocessorsAccessor;
import org.netbeans.modules.web.common.cssprep.CssPreprocessorsCustomizer;
import org.netbeans.modules.web.common.cssprep.CssPreprocessorsProblemProvider;
import org.netbeans.modules.web.common.spi.CssPreprocessorImplementation;
import org.netbeans.modules.web.common.spi.CssPreprocessorImplementationListener;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public final class CssPreprocessors {
    public static final String PREPROCESSORS_PATH = "CSS/PreProcessors";
    public static final String CUSTOMIZER_IDENT = "CssPreprocessors";
    public static final String OPTIONS_CATEGORY = "Advanced";
    public static final String OPTIONS_SUBCATEGORY = "CssPreprocessors";
    public static final String OPTIONS_PATH = "Advanced/CssPreprocessors";
    private static final RequestProcessor RP = new RequestProcessor(CssPreprocessors.class.getName(), 2);
    private static final Lookup.Result<CssPreprocessorImplementation> PREPROCESSORS = Lookups.forPath((String)"CSS/PreProcessors").lookupResult(CssPreprocessorImplementation.class);
    private static final CssPreprocessors INSTANCE = new CssPreprocessors();
    private final List<CssPreprocessor> preprocessors = new CopyOnWriteArrayList<CssPreprocessor>();
    final CssPreprocessorsListener.Support listenersSupport = new CssPreprocessorsListener.Support();
    private final PreprocessorImplementationsListener preprocessorImplementationsListener = new PreprocessorImplementationsListener();

    private CssPreprocessors() {
        this.initProcessors();
    }

    public static CssPreprocessors getDefault() {
        return INSTANCE;
    }

    List<CssPreprocessor> getPreprocessors() {
        return new ArrayList<CssPreprocessor>(this.preprocessors);
    }

    public ProjectCustomizer.CompositeCategoryProvider createCustomizer() {
        return new CssPreprocessorsCustomizer();
    }

    public ProjectProblemsProvider createProjectProblemsProvider(Project project) {
        return CssPreprocessorsProblemProvider.create(project);
    }

    public void addCssPreprocessorsListener(@NullAllowed CssPreprocessorsListener listener) {
        this.listenersSupport.addCssPreprocessorListener(listener);
    }

    public void removeCssPreprocessorsListener(@NullAllowed CssPreprocessorsListener listener) {
        this.listenersSupport.removeCssPreprocessorListener(listener);
    }

    public void process(@NullAllowed Project project, @NonNull FileObject fileObject) {
        Parameters.notNull((CharSequence)"fileObject", (Object)fileObject);
        this.processInternal(this.getPreprocessors(), project, fileObject, null, null);
    }

    public void process(@NullAllowed Project project, @NonNull FileObject fileObject, @NonNull String originalName, @NonNull String originalExtension) {
        Parameters.notNull((CharSequence)"fileObject", (Object)fileObject);
        Parameters.notNull((CharSequence)"originalName", (Object)originalName);
        Parameters.notNull((CharSequence)"originalExtension", (Object)originalExtension);
        this.processInternal(this.getPreprocessors(), project, fileObject, originalName, originalExtension);
    }

    public void process(@NonNull CssPreprocessor cssPreprocessor, @NullAllowed Project project, @NonNull FileObject fileObject) {
        Parameters.notNull((CharSequence)"cssPreprocessor", (Object)cssPreprocessor);
        Parameters.notNull((CharSequence)"fileObject", (Object)fileObject);
        this.processInternal(Collections.singletonList(cssPreprocessor), project, fileObject, null, null);
    }

    public void process(@NonNull CssPreprocessor cssPreprocessor, @NullAllowed Project project, @NonNull FileObject fileObject, @NonNull String originalName, @NonNull String originalExtension) {
        Parameters.notNull((CharSequence)"cssPreprocessor", (Object)cssPreprocessor);
        Parameters.notNull((CharSequence)"fileObject", (Object)fileObject);
        Parameters.notNull((CharSequence)"originalName", (Object)originalName);
        Parameters.notNull((CharSequence)"originalExtension", (Object)originalExtension);
        this.processInternal(Collections.singletonList(cssPreprocessor), project, fileObject, originalName, originalExtension);
    }

    void processInternal(final List<CssPreprocessor> preprocessors, final Project project, final FileObject fileObject, final String originalName, final String originalExtension) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                for (CssPreprocessor cssPreprocessor : preprocessors) {
                    cssPreprocessor.getDelegate().process(project, fileObject, originalName, originalExtension);
                }
            }
        });
    }

    private void initProcessors() {
        assert (this.preprocessors.isEmpty()) : "Empty preprocessors expected but: " + this.preprocessors;
        this.preprocessors.addAll(this.map(PREPROCESSORS.allInstances()));
        for (CssPreprocessor cssPreprocessor : this.preprocessors) {
            cssPreprocessor.getDelegate().addCssPreprocessorListener(this.preprocessorImplementationsListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reinitProcessors() {
        List<CssPreprocessor> list = this.preprocessors;
        synchronized (list) {
            this.clearProcessors();
            this.initProcessors();
        }
        this.listenersSupport.firePreprocessorsChanged();
    }

    private void clearProcessors() {
        for (CssPreprocessor cssPreprocessor : this.preprocessors) {
            cssPreprocessor.getDelegate().removeCssPreprocessorListener(this.preprocessorImplementationsListener);
        }
        this.preprocessors.clear();
    }

    @CheckForNull
    CssPreprocessor findCssPreprocessor(CssPreprocessorImplementation cssPreprocessorImplementation) {
        assert (cssPreprocessorImplementation != null);
        for (CssPreprocessor cssPreprocessor : this.preprocessors) {
            if (cssPreprocessor.getDelegate() != cssPreprocessorImplementation) continue;
            return cssPreprocessor;
        }
        assert (false) : "Cannot find CSS preprocessor for implementation: " + cssPreprocessorImplementation.getIdentifier();
        return null;
    }

    private List<CssPreprocessor> map(Collection<? extends CssPreprocessorImplementation> preprocessors) {
        ArrayList<CssPreprocessor> result = new ArrayList<CssPreprocessor>();
        for (CssPreprocessorImplementation cssPreprocessorImplementation : preprocessors) {
            result.add(CssPreprocessorAccessor.getDefault().create(cssPreprocessorImplementation));
        }
        return result;
    }

    static {
        PREPROCESSORS.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent ev) {
                INSTANCE.reinitProcessors();
            }
        });
        CssPreprocessorsAccessor.setDefault(new CssPreprocessorsAccessor(){

            @Override
            public List<CssPreprocessor> getPreprocessors() {
                return INSTANCE.getPreprocessors();
            }
        });
    }

    private final class PreprocessorImplementationsListener
    implements CssPreprocessorImplementationListener {
        private PreprocessorImplementationsListener() {
        }

        @Override
        public void optionsChanged(CssPreprocessorImplementation cssPreprocessor) {
            Parameters.notNull((CharSequence)"cssPreprocessor", (Object)cssPreprocessor);
            CssPreprocessor preprocessor = CssPreprocessors.this.findCssPreprocessor(cssPreprocessor);
            if (preprocessor != null) {
                CssPreprocessors.this.listenersSupport.fireOptionsChanged(preprocessor);
            }
        }

        @Override
        public void customizerChanged(Project project, CssPreprocessorImplementation cssPreprocessor) {
            Parameters.notNull((CharSequence)"project", (Object)project);
            Parameters.notNull((CharSequence)"cssPreprocessor", (Object)cssPreprocessor);
            CssPreprocessor preprocessor = CssPreprocessors.this.findCssPreprocessor(cssPreprocessor);
            if (preprocessor != null) {
                CssPreprocessors.this.listenersSupport.fireCustomizerChanged(project, preprocessor);
            }
        }

        @Override
        public void processingErrorOccured(Project project, CssPreprocessorImplementation cssPreprocessor, String error) {
            Parameters.notNull((CharSequence)"project", (Object)project);
            Parameters.notNull((CharSequence)"cssPreprocessor", (Object)cssPreprocessor);
            Parameters.notNull((CharSequence)"error", (Object)error);
            CssPreprocessor preprocessor = CssPreprocessors.this.findCssPreprocessor(cssPreprocessor);
            if (preprocessor != null) {
                CssPreprocessors.this.listenersSupport.fireProcessingErrorOccured(project, preprocessor, error);
            }
        }
    }
}

