/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.tools.tftpserver.impl;

import de.proveo.tools.tftpserver.TFTPServerWrapper;
import de.proveo.tools.tftpserver.factory.TFTPServerFactory;
import de.proveo.tools.tftpserver.impl.TFTPServer;
import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InProcessWrapper
implements TFTPServerWrapper {
    private static final Log log = LogFactory.getLog(InProcessWrapper.class);
    private TFTPServerFactory.ServerState state = TFTPServerFactory.ServerState.STOPPED;
    private String tftpServerDir = System.getProperty("user.home");
    private TFTPServer ts = null;
    private int tftpServerPort = 69;

    public InProcessWrapper(String tftpServerDir, int tftpServerPort) {
        this.tftpServerDir = tftpServerDir;
        this.tftpServerPort = tftpServerPort;
    }

    @Override
    public void addCallback(Object obj) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public TFTPServerFactory.ServerState getState() {
        return this.state;
    }

    @Override
    public void shutdown() {
        this.stop();
    }

    @Override
    public void start() {
        this.state = TFTPServerFactory.ServerState.STARTING;
        File serverDir = new File(this.tftpServerDir);
        try {
            if (log.isDebugEnabled()) {
                log.debug("Starting TFTP server (root directory='" + serverDir.getAbsolutePath() + "') ...");
            }
            this.ts = new TFTPServer(serverDir, serverDir, this.tftpServerPort, TFTPServer.ServerMode.GET_AND_PUT, System.out, System.err);
            this.ts.setLog(System.out);
            this.ts.setLogError(System.err);
            this.ts.setSocketTimeout(2000);
            this.ts.setMaxTimeoutRetries(5);
            this.state = TFTPServerFactory.ServerState.STARTED;
            if (log.isDebugEnabled()) {
                log.debug("TFTP server running.");
            }
        }
        catch (IOException ex) {
            this.state = TFTPServerFactory.ServerState.STOPPED;
            log.error("Could not start TFTP server", ex);
        }
    }

    @Override
    public void stop() {
        this.state = TFTPServerFactory.ServerState.SHUTING_DOWN;
        if (log.isDebugEnabled()) {
            log.debug("Shutting down TFTP server ...");
        }
        this.ts.shutdown();
        this.state = TFTPServerFactory.ServerState.STOPPED;
        if (log.isDebugEnabled()) {
            log.debug("TFTP server shut down.");
        }
    }
}

