/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.retriever.catalog;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.xml.retriever.catalog.CatalogWriteModel;
import org.netbeans.modules.xml.retriever.catalog.impl.CatalogModelFactoryImpl;
import org.netbeans.modules.xml.retriever.catalog.impl.XAMCatalogWriteModelImpl;
import org.netbeans.modules.xml.retriever.impl.Util;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.locator.CatalogModel;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.netbeans.modules.xml.xam.locator.CatalogModelFactory;
import org.netbeans.spi.xml.cookies.DataObjectAdapters;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.UserQuestionException;
import org.openide.util.lookup.Lookups;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Utilities {
    public static final String NO_NAME_SPACE = "NO_NAME_SPACE";
    private static final Logger logger = Logger.getLogger(Utilities.class.getName());
    private static boolean firstRoot = true;
    private static Map<String, String> namespaces = new HashMap<String, String>();
    private static Map<String, String> prefixes = new HashMap<String, String>();
    private static CatalogWriteModel testCatalogModel = null;
    public static final String DEFAULT_PRIVATE_CATALOG_URI_STR = "private/cache/retriever/catalog.xml";
    public static final String DEFAULT_PRIVATE_CAHCE_URI_STR = "private/cache/retriever";
    public static final String PRIVATE_CATALOG_URI_STR = "retriever/catalog.xml";
    public static final String PRIVATE_CAHCE_URI_STR = "retriever";

    public static URL appendURL(URL prefixURL, String suffixStr) {
        String str = prefixURL.toString();
        String newurl = null;
        newurl = str.endsWith("/") ? str + suffixStr : str + "/" + suffixStr;
        try {
            return new URL(newurl);
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public static boolean localResourceExists(URL localURL) {
        File locaFile = null;
        try {
            locaFile = new File(localURL.toURI());
            return locaFile.exists();
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }

    public static File toFile(URL url) {
        URI uri;
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException ex) {
            return null;
        }
        return new File(uri);
    }

    public static void deleteRecursively(File aDir) {
        if (aDir.isDirectory()) {
            File[] children;
            for (File file : children = aDir.listFiles()) {
                Utilities.deleteRecursively(file);
            }
            aDir.delete();
        } else {
            aDir.delete();
        }
    }

    public static String normalizeURI(String uriref) {
        byte[] bytes;
        StringBuilder newRef = new StringBuilder();
        if (uriref == null) {
            return null;
        }
        try {
            bytes = uriref.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            return uriref;
        }
        for (int count = 0; count < bytes.length; ++count) {
            int ch = bytes[count] & 0xFF;
            if (ch <= 32 || ch > 127 || ch == 34 || ch == 60 || ch == 62 || ch == 92 || ch == 94 || ch == 96 || ch == 123 || ch == 124 || ch == 125 || ch == 127) {
                newRef.append(Utilities.encodedByte(ch));
                continue;
            }
            newRef.append((char)bytes[count]);
        }
        return newRef.toString();
    }

    public static String encodedByte(int b) {
        String hex = Integer.toHexString(b).toUpperCase();
        if (hex.length() < 2) {
            return "%0" + hex;
        }
        return "%" + hex;
    }

    public static String relativize(URI master, URI slave) {
        StringBuilder slaveResult;
        String masterStr = master.toString();
        String slaveStr = slave.toString();
        StringTokenizer masterTok = new StringTokenizer(masterStr, "/");
        StringTokenizer slaveTok = new StringTokenizer(slaveStr, "/");
        String masterLast = null;
        String slaveLast = null;
        int iteration = -1;
        do {
            ++iteration;
        } while (masterTok.hasMoreTokens() && slaveTok.hasMoreTokens() && (masterLast = masterTok.nextToken()).equals(slaveLast = slaveTok.nextToken()));
        if (iteration < 2) {
            return slave.toString();
        }
        int dirCount = masterTok.countTokens();
        if (masterStr.endsWith("/") && dirCount != 0) {
            ++dirCount;
        }
        String pathPrefix = "";
        StringBuffer pathPrefixBuff = new StringBuffer("");
        for (int i = 0; i < dirCount; ++i) {
            pathPrefixBuff.append("../");
        }
        pathPrefix = pathPrefixBuff.toString();
        StringBuilder stringBuilder = slaveResult = masterLast.equals(slaveLast) ? new StringBuilder() : new StringBuilder(slaveLast);
        while (slaveTok.hasMoreTokens()) {
            if (slaveResult.length() != 0) {
                slaveResult.append('/');
            }
            slaveResult.append(slaveTok.nextToken());
        }
        return pathPrefix + slaveResult.toString();
    }

    public static List<FileObject> getFilesOfNSInProj(Project prj, DocumentTypesEnum docType, String nameSpace, List<String> sourceGroupTypeList) {
        ArrayList<FileObject> result = new ArrayList<FileObject>();
        Map<FileObject, String> fobj2nsMap = Utilities.getFiles2NSMappingInProj(prj, docType, sourceGroupTypeList);
        Set<FileObject> fileList = fobj2nsMap.keySet();
        for (FileObject fobj : fileList) {
            if (Thread.currentThread().isInterrupted()) break;
            if (!fobj2nsMap.get(fobj).equals(nameSpace)) continue;
            result.add(fobj);
        }
        return result;
    }

    public static List<FileObject> getFilesOfNoNSInProj(Project prj, DocumentTypesEnum docType, List<String> sourceGroupTypeList) {
        return Utilities.getFilesOfNSInProj(prj, docType, NO_NAME_SPACE, sourceGroupTypeList);
    }

    public static Map<FileObject, String> getFiles2NSMappingInProj(Project prj, DocumentTypesEnum docType, List<String> sourceGroupTypeList) {
        HashMap<FileObject, String> result = new HashMap<FileObject, String>();
        List<FileObject> rootList = Utilities.getAllSourceRoots(prj, sourceGroupTypeList);
        for (FileObject fob : rootList) {
            result.putAll(Utilities.getFiles2NSMappingInProj(FileUtil.toFile((FileObject)fob), docType));
        }
        return result;
    }

    private static List<FileObject> getAllSourceRoots(Project prj, List<String> sourceGroupTypeList) {
        ArrayList<FileObject> result = new ArrayList<FileObject>();
        for (String type : sourceGroupTypeList) {
            SourceGroup[] srcGrps = ProjectUtils.getSources((Project)prj).getSourceGroups(type);
            if (srcGrps == null) continue;
            for (SourceGroup srcGrp : srcGrps) {
                result.add(srcGrp.getRootFolder());
            }
        }
        return result;
    }

    public static Map<FileObject, String> getFiles2NSMappingInProj(File rootFile, DocumentTypesEnum docType) {
        List<File> fileList = Utilities.getFilesWithExtension(rootFile, docType.toString(), new ArrayList<File>());
        HashMap<FileObject, String> result = new HashMap<FileObject, String>();
        String xpathQuery = null;
        xpathQuery = docType == DocumentTypesEnum.schema ? "//xsd:schema/@targetNamespace" : "//wsdl:definitions/@targetNamespace";
        for (File file : fileList) {
            if (Thread.currentThread().isInterrupted()) break;
            List<String> targetNSList = null;
            try {
                targetNSList = Utilities.runXPathQuery(file, xpathQuery);
                String targetNS = null;
                FileObject fobj = FileUtil.toFileObject((File)file);
                targetNS = targetNSList.size() > 0 ? targetNSList.get(0) : NO_NAME_SPACE;
                if (docType == DocumentTypesEnum.wsdl && targetNS == NO_NAME_SPACE) continue;
                result.put(fobj, targetNS);
            }
            catch (Exception ex) {}
        }
        return result;
    }

    public static List<File> getFilesWithExtension(File startFile, String fileExtension, List<File> curList) {
        File[] children;
        String extn;
        int index;
        if (Thread.currentThread().isInterrupted()) {
            firstRoot = true;
            return curList;
        }
        if (curList == null) {
            curList = new ArrayList<File>();
        }
        if (startFile.isFile() && (index = startFile.getName().lastIndexOf(".")) != -1 && (extn = startFile.getName().substring(index + 1)) != null && extn.equalsIgnoreCase(fileExtension)) {
            curList.add(startFile);
        }
        if (startFile.isDirectory() && (children = startFile.listFiles()) != null) {
            for (File child : children) {
                if (firstRoot && child.getName().endsWith("build")) continue;
                firstRoot = false;
                Utilities.getFilesWithExtension(child, fileExtension, curList);
            }
        }
        firstRoot = true;
        return curList;
    }

    public static List<String> runXPathQuery(File parsedFile, String xpathExpr) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(Utilities.getNamespaceContext());
        InputSource inputSource = new InputSource(new FileInputStream(parsedFile));
        NodeList nodes = (NodeList)xpath.evaluate(xpathExpr, inputSource, XPathConstants.NODESET);
        if (nodes != null && nodes.getLength() > 0) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                result.add(node.getNodeValue());
            }
        }
        return result;
    }

    private static NamespaceContext getNamespaceContext() {
        namespaces.put("xsd", "http://www.w3.org/2001/XMLSchema");
        prefixes.put("http://www.w3.org/2001/XMLSchema", "xsd");
        namespaces.put("wsdl", "http://schemas.xmlsoap.org/wsdl/");
        prefixes.put("http://schemas.xmlsoap.org/wsdl/", "wsdl");
        return new HashNamespaceResolver(namespaces, prefixes);
    }

    public static int countPushdownFolders(URI master, URI slave) {
        String masterStr = master.toString();
        String slaveStr = slave.toString();
        StringTokenizer masterTok = new StringTokenizer(masterStr, "/");
        StringTokenizer slaveTok = new StringTokenizer(slaveStr, "/");
        String masterLast = null;
        String slaveLast = null;
        while (masterTok.hasMoreTokens() && slaveTok.hasMoreTokens() && (masterLast = masterTok.nextToken()).equals(slaveLast = slaveTok.nextToken())) {
        }
        return slaveTok.countTokens() + 1;
    }

    public static File downloadURLAndSave(URL downloadURL, File saveFile) throws IOException {
        return Utilities.downloadURLUsingProxyAndSave(downloadURL, null, saveFile);
    }

    public static File downloadURLUsingProxyAndSave(URL downloadURL, Proxy proxy, File saveFile) throws IOException {
        IOException expn = null;
        URLConnection ucn = null;
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        ucn = proxy != null ? downloadURL.openConnection(proxy) : downloadURL.openConnection();
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        ucn.connect();
        byte[] buffer = new byte[1024];
        BufferedInputStream bis = new BufferedInputStream(ucn.getInputStream());
        saveFile.getParentFile().mkdirs();
        BufferedOutputStream bos = null;
        try {
            bos = new BufferedOutputStream(new FileOutputStream(saveFile));
        }
        catch (FileNotFoundException ex) {
            bis.close();
            throw ex;
        }
        int len = 1024;
        while ((len = bis.read(buffer, 0, 1024)) > 0) {
            try {
                if (Thread.currentThread().isInterrupted()) break;
                Thread.sleep(10L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            try {
                bos.write(buffer, 0, len);
            }
            catch (IOException e) {
                expn = e;
                break;
            }
        }
        try {
            bis.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        try {
            bos.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (expn != null) {
            throw expn;
        }
        return saveFile;
    }

    public static InputStream getInputStreamOfURL(URL downloadURL, Proxy proxy) throws IOException {
        URLConnection ucn = null;
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        ucn = proxy != null ? downloadURL.openConnection(proxy) : downloadURL.openConnection();
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        ucn.connect();
        return ucn.getInputStream();
    }

    public static Document getDocument(FileObject modelSourceFileObject) {
        BaseDocument result = null;
        try {
            DataObject dObject = DataObject.find((FileObject)modelSourceFileObject);
            EditorCookie ec = (EditorCookie)dObject.getCookie(EditorCookie.class);
            StyledDocument doc = ec.openDocument();
            if (doc instanceof BaseDocument) {
                return doc;
            }
            result = new BaseDocument(true, modelSourceFileObject.getMIMEType());
            String str = doc.getText(0, doc.getLength());
            result.insertString(0, str, null);
        }
        catch (Exception dObjEx) {
            return null;
        }
        return result;
    }

    private static Document _getDocument(DataObject modelSourceDataObject) throws IOException {
        StyledDocument result = null;
        if (modelSourceDataObject != null && modelSourceDataObject.isValid()) {
            EditorCookie ec = (EditorCookie)modelSourceDataObject.getCookie(EditorCookie.class);
            assert (ec != null) : "Data object " + modelSourceDataObject.getPrimaryFile().getPath() + " has no editor cookies.";
            if (ec != null) {
                StyledDocument doc = null;
                try {
                    doc = ec.openDocument();
                }
                catch (UserQuestionException uce) {
                    uce.confirmed();
                    doc = ec.openDocument();
                }
                assert (doc instanceof BaseDocument);
                result = doc;
            }
        }
        return result;
    }

    protected static Document _getDocument(FileObject modelSourceFileObject) throws DataObjectNotFoundException, IOException {
        DataObject dObject = DataObject.find((FileObject)modelSourceFileObject);
        return Utilities._getDocument(dObject);
    }

    public static CatalogWriteModel getTestCatalogWriteModel() throws IOException {
        if (testCatalogModel == null) {
            XAMCatalogWriteModelImpl cm = null;
            try {
                cm = new XAMCatalogWriteModelImpl(new File(System.getProperty("java.io.tmpdir")));
            }
            catch (CatalogModelException ex) {
                return null;
            }
            File file = FileUtil.toFile((FileObject)cm.getCatalogFileObject());
            file.deleteOnExit();
            return cm;
        }
        return testCatalogModel;
    }

    public static FileObject getProjectCatalogFileObject(Project prj) throws IOException {
        return Util.getProjectCatalogFileObject(prj, true);
    }

    public static FileObject getFileObject(ModelSource ms) {
        return (FileObject)ms.getLookup().lookup(FileObject.class);
    }

    public static CatalogModel getCatalogModel(ModelSource ms) throws CatalogModelException {
        return CatalogModelFactory.getDefault().getCatalogModel(ms);
    }

    public static ModelSource getModelSource(FileObject bindingHandlerFO, boolean editable) {
        try {
            return Utilities.createModelSource(bindingHandlerFO, editable);
        }
        catch (CatalogModelException ex) {
            return null;
        }
    }

    public static ModelSource createModelSource(FileObject thisFileObj, boolean editable) throws CatalogModelException {
        DataObject dobj;
        assert (thisFileObj != null) : "Null file object.";
        final CatalogModel catalogModel = Utilities.createCatalogModel(thisFileObj);
        try {
            dobj = DataObject.find((FileObject)thisFileObj);
        }
        catch (DataObjectNotFoundException ex) {
            throw new CatalogModelException((Throwable)ex);
        }
        Lookup proxyLookup = Lookups.proxy((Lookup.Provider)new Lookup.Provider(){

            public Lookup getLookup() {
                Document document = null;
                try {
                    document = Utilities._getDocument(dobj);
                    if (document != null) {
                        return Lookups.fixed((Object[])new Object[]{dobj.getPrimaryFile(), document, dobj, DataObjectAdapters.source((DataObject)dobj), catalogModel});
                    }
                    return Lookups.fixed((Object[])new Object[]{dobj.getPrimaryFile(), dobj, catalogModel});
                }
                catch (IOException ioe) {
                    logger.log(Level.SEVERE, ioe.getMessage());
                    return Lookups.fixed((Object[])new Object[]{dobj, catalogModel});
                }
            }
        });
        return new ModelSource(proxyLookup, editable);
    }

    public static CatalogModel createCatalogModel(FileObject fo) throws CatalogModelException {
        return new CatalogModelFactoryImpl().getCatalogModel(fo);
    }

    public static boolean retrieveAndCache(URI locationURI, FileObject sourceFileObject) {
        return Util.retrieveAndCache(locationURI, sourceFileObject, true, true);
    }

    public static enum DocumentTypesEnum {
        schema,
        wsdl;


        public String toString() {
            if (this.name().equals("schema")) {
                return "xsd";
            }
            return this.name();
        }
    }

    public static final class HashNamespaceResolver
    implements NamespaceContext {
        private Map<String, String> prefixes;
        private Map<String, String> namespaces;

        public HashNamespaceResolver(Map<String, String> nsTable) {
            this.namespaces = nsTable;
            this.prefixes = new HashMap<String, String>();
            for (Map.Entry<String, String> e : this.namespaces.entrySet()) {
                this.prefixes.put(e.getValue(), e.getKey());
            }
        }

        public HashNamespaceResolver(Map<String, String> namespaces, Map<String, String> prefixes) {
            this.namespaces = namespaces;
            this.prefixes = prefixes;
        }

        public Iterator getPrefixes(String namespaceURI) {
            return Collections.singletonList(this.getPrefix(namespaceURI)).iterator();
        }

        @Override
        public String getPrefix(String namespaceURI) {
            return this.prefixes.get(namespaceURI);
        }

        @Override
        public String getNamespaceURI(String prefix) {
            return this.namespaces.get(prefix);
        }
    }
}

