/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils.system;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.installer.utils.FileUtils;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.StreamUtils;
import org.netbeans.installer.utils.StringUtils;
import org.netbeans.installer.utils.SystemUtils;
import org.netbeans.installer.utils.exceptions.NativeException;
import org.netbeans.installer.utils.helper.ApplicationDescriptor;
import org.netbeans.installer.utils.helper.EnvironmentScope;
import org.netbeans.installer.utils.helper.FilesList;
import org.netbeans.installer.utils.helper.Pair;
import org.netbeans.installer.utils.helper.Platform;
import org.netbeans.installer.utils.progress.Progress;
import org.netbeans.installer.utils.system.NativeUtils;
import org.netbeans.installer.utils.system.cleaner.OnExitCleanerHandler;
import org.netbeans.installer.utils.system.cleaner.ProcessOnExitCleanerHandler;
import org.netbeans.installer.utils.system.launchers.Launcher;
import org.netbeans.installer.utils.system.shortcut.FileShortcut;
import org.netbeans.installer.utils.system.shortcut.InternetShortcut;
import org.netbeans.installer.utils.system.shortcut.LocationType;
import org.netbeans.installer.utils.system.shortcut.Shortcut;
import org.netbeans.installer.utils.system.unix.shell.BourneShell;
import org.netbeans.installer.utils.system.unix.shell.CShell;
import org.netbeans.installer.utils.system.unix.shell.KornShell;
import org.netbeans.installer.utils.system.unix.shell.Shell;
import org.netbeans.installer.utils.system.unix.shell.TCShell;

public class UnixNativeUtils
extends NativeUtils {
    private boolean isUserAdminSet;
    private boolean isUserAdmin;
    private boolean checkQuota = true;
    private File quotaExecutable = null;
    private File browserExecutable = null;
    private boolean browserExecutableSet = false;
    private Boolean isSystem64Bit = null;
    private static final String[] FORBIDDEN_DELETING_FILES_UNIX = new String[]{System.getProperty("user.home"), System.getProperty("java.home"), "/", "/bin", "/boot", "/dev", "/etc", "/home", "/lib", "/mnt", "/opt", "/sbin", "/share", "/usr", "/usr/bin", "/usr/include", "/usr/lib", "/usr/man", "/usr/sbin", "/var"};
    private static final String CLEANER_RESOURCE = "native/cleaner/unix/cleaner.sh";
    private static final String CLEANER_FILENAME = "nbi-cleaner.sh";
    public static final String XDG_DATA_HOME_ENV_VARIABLE = "XDG_DATA_HOME";
    public static final String XDG_DATA_DIRS_ENV_VARIABLE = "XDG_DATA_DIRS";
    public static final String XDG_DESKTOP_DIR_ENV_VARIABLE = "XDG_DESKTOP_DIR";
    public static final String XDG_USERDIRS_DIRS = ".config/user-dirs.dirs";
    public static final String XDG_USERDIRS_CONF = ".config/user-dirs.conf";
    public static final String XDG_USERDIRS_GLOBAL_CONF = "/etc/xdg/user-dirs.conf";
    public static final String DESKTOP_EXT = ".desktop";
    public static final String XDG_CONFIG_HOME_ENV_VARIABLE = "XDG_CONFIG_HOME";
    public static final String XDG_CONFIG_HOME_DEFAULT = ".config";
    public static final String XDG_APPLICATION_MENU_FILE = "menus/applications.menu";
    public static final String DEFAULT_XDG_DATA_HOME = ".local/share";
    public static final String DEFAULT_XDG_DATA_DIRS = "/usr/share";
    private static final String[] QUOTA_LOCATIONS = new String[]{"/usr/sbin/quota", "/usr/bin/quota", "/sbin/quota", "/bin/quota"};
    private static final byte[] ELF_BYTES = new byte[]{127, 69, 76, 70};
    private static final long QUOTA_TIMEOUT_MILLIS = 5000L;

    public UnixNativeUtils() {
        this.initializeForbiddenFiles(new String[0]);
    }

    protected void loadLibrary(String path) {
        try {
            this.loadNativeLibrary(path);
        }
        catch (NativeException e) {
            LogManager.log("Could not load native library due to some reasons, falling back to the Java implementation", (Throwable)e);
        }
    }

    @Override
    protected Platform getPlatform() {
        String osName = System.getProperty("os.name");
        if (osName.equals("FreeBSD")) {
            return this.getPlatformFreeBSD();
        }
        if (osName.equals("OpenBSD")) {
            return this.getPlatformOpenBSD();
        }
        if (osName.endsWith("BSD")) {
            return this.getPlatformBSD();
        }
        if (osName.equals("AIX")) {
            return this.getPlatformAIX();
        }
        if (osName.toLowerCase(Locale.ENGLISH).startsWith("hp-ux")) {
            return this.getPlatformHPUX();
        }
        return Platform.UNIX;
    }

    private Platform getPlatformOpenBSD() {
        String osArch = System.getProperty("os.arch");
        if (osArch.contains("ppc") || osArch.contains("PowerPC")) {
            return SystemUtils.isCurrentJava64Bit() ? Platform.OPENBSD_PPC64 : Platform.OPENBSD_PPC;
        }
        if (osArch.contains("sparc")) {
            return Platform.OPENBSD_SPARC;
        }
        if (osArch.matches("i[3-6]86|x86|amd64|x86_64")) {
            return SystemUtils.isCurrentJava64Bit() ? Platform.OPENBSD_X64 : Platform.OPENBSD_X86;
        }
        return Platform.OPENBSD;
    }

    private Platform getPlatformFreeBSD() {
        String osArch = System.getProperty("os.arch");
        if (osArch.contains("ppc") || osArch.contains("PowerPC")) {
            return SystemUtils.isCurrentJava64Bit() ? Platform.FREEBSD_PPC64 : Platform.FREEBSD_PPC;
        }
        if (osArch.contains("sparc")) {
            return Platform.FREEBSD_SPARC;
        }
        if (osArch.matches("i[3-6]86|x86|amd64|x86_64")) {
            return SystemUtils.isCurrentJava64Bit() ? Platform.FREEBSD_X64 : Platform.FREEBSD_X86;
        }
        return Platform.FREEBSD;
    }

    private Platform getPlatformBSD() {
        String osArch = System.getProperty("os.arch");
        if (osArch.contains("ppc") || osArch.contains("PowerPC")) {
            return SystemUtils.isCurrentJava64Bit() ? Platform.BSD_PPC64 : Platform.BSD_PPC;
        }
        if (osArch.contains("sparc")) {
            return Platform.BSD_SPARC;
        }
        if (osArch.matches("i[3-6]86|x86|amd64|x86_64")) {
            return SystemUtils.isCurrentJava64Bit() ? Platform.BSD_X64 : Platform.BSD_X86;
        }
        return Platform.BSD;
    }

    private Platform getPlatformAIX() {
        String osArch = System.getProperty("os.arch");
        if (osArch.contains("ppc") || osArch.contains("PowerPC")) {
            return SystemUtils.isCurrentJava64Bit() ? Platform.AIX_PPC64 : Platform.AIX_PPC;
        }
        return Platform.AIX;
    }

    private Platform getPlatformHPUX() {
        String osArch = System.getProperty("os.arch");
        if (osArch.toLowerCase(Locale.ENGLISH).replace("-", "_").startsWith("pa_risc")) {
            return osArch.startsWith("PA_RISC2.0") ? Platform.HPUX_PA_RISC20 : Platform.HPUX_PA_RISC;
        }
        if (osArch.toLowerCase(Locale.ENGLISH).startsWith("ia64")) {
            return Platform.HPUX_IA64;
        }
        return Platform.HPUX;
    }

    @Override
    public boolean isSystem64Bit() {
        if (this.isSystem64Bit == null) {
            this.isSystem64Bit = false;
            try {
                BufferedReader br;
                Process p = Runtime.getRuntime().exec("uname -m");
                for (int i = 0; i < 5; ++i) {
                    try {
                        p.exitValue();
                        break;
                    }
                    catch (IllegalThreadStateException ex) {
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException ex2) {
                            // empty catch block
                        }
                        continue;
                    }
                }
                if ((br = new BufferedReader(new InputStreamReader(p.getInputStream()))).ready()) {
                    String line = br.readLine();
                    this.isSystem64Bit = line.endsWith("64");
                }
            }
            catch (IOException ex) {
                LogManager.log(2, (Throwable)ex);
            }
        }
        return this.isSystem64Bit;
    }

    @Override
    public boolean isCurrentUserAdmin() throws NativeException {
        boolean result;
        if (this.isUserAdminSet) {
            return this.isUserAdmin;
        }
        this.isUserAdmin = result = this.isCurrentUserAdminNative();
        this.isUserAdminSet = true;
        return result;
    }

    @Override
    protected OnExitCleanerHandler newDeleteOnExitCleanerHandler() {
        return new UnixProcessOnExitCleanerHandler(CLEANER_FILENAME);
    }

    public void updateApplicationsMenu() {
        try {
            SystemUtils.executeCommand(null, new String[]{"pkill", "-u", SystemUtils.getUserName(), "panel"});
        }
        catch (IOException ex) {
            LogManager.log(2, (Throwable)ex);
        }
    }

    @Override
    public File getShortcutLocation(Shortcut shortcut, LocationType locationType) throws NativeException {
        File shortcutFile;
        LogManager.logIndent("devising the shortcut location by type: " + (Object)((Object)locationType));
        if (shortcut.getPath() != null) {
            return new File(shortcut.getPath());
        }
        switch (locationType) {
            case CURRENT_USER_DESKTOP: 
            case ALL_USERS_DESKTOP: {
                File desktopLocation = this.getDesktopFolder();
                LogManager.log("... desktop folder : " + desktopLocation);
                shortcutFile = new File(desktopLocation, this.getShortcutFileName(shortcut));
                break;
            }
            case CURRENT_USER_START_MENU: {
                File currentUserAppFolder = this.getApplicationsLocation(this.getCurrentUserLocation());
                LogManager.log("... current user app folder : " + currentUserAppFolder);
                shortcutFile = new File(currentUserAppFolder, this.getShortcutFileName(shortcut));
                break;
            }
            case ALL_USERS_START_MENU: {
                File allUsersAppFolder = this.getApplicationsLocation(this.getAllUsersLocation());
                LogManager.log("... all users app folder : " + allUsersAppFolder);
                shortcutFile = new File(allUsersAppFolder, this.getShortcutFileName(shortcut));
                break;
            }
            case CUSTOM: {
                String folder = shortcut.getRelativePath();
                LogManager.log("... custom folder : " + folder);
                shortcutFile = new File(folder, this.getShortcutFileName(shortcut));
                break;
            }
            default: {
                shortcutFile = null;
            }
        }
        if (shortcutFile != null) {
            shortcut.setPath(shortcutFile.getAbsolutePath());
        }
        LogManager.logUnindent("shortcut file: " + shortcutFile);
        return shortcutFile;
    }

    private String getShortcutFileName(Shortcut shortcut) {
        String fileName = shortcut.getFileName();
        if (fileName == null) {
            if (shortcut instanceof FileShortcut) {
                File target = ((FileShortcut)shortcut).getTarget();
                fileName = target.getName();
                if (!target.isDirectory()) {
                    fileName = fileName + DESKTOP_EXT;
                }
            } else if (shortcut instanceof InternetShortcut) {
                fileName = ((InternetShortcut)shortcut).getURL().getFile() + DESKTOP_EXT;
            }
        }
        return fileName;
    }

    private File getApplicationsLocation(File location) {
        return new File(location, "applications");
    }

    private File getAllUsersLocation() {
        File allUsersLocation;
        String XDG_DATA_DIRS = System.getenv(XDG_DATA_DIRS_ENV_VARIABLE);
        if (XDG_DATA_DIRS == null) {
            allUsersLocation = new File(DEFAULT_XDG_DATA_DIRS);
        } else {
            String firstPath = XDG_DATA_DIRS.split(SystemUtils.getPathSeparator())[0].trim();
            if (firstPath.contains(File.separator) && !firstPath.startsWith(File.separator)) {
                firstPath = File.separator + firstPath;
            }
            allUsersLocation = new File(firstPath);
        }
        LogManager.log("XDG_DATA_DIRS = " + allUsersLocation);
        return allUsersLocation;
    }

    private File getCurrentUserLocation() {
        String XDG_DATA_HOME = System.getenv(XDG_DATA_HOME_ENV_VARIABLE);
        File currentUserLocation = XDG_DATA_HOME == null ? new File(SystemUtils.getUserHomeDirectory(), DEFAULT_XDG_DATA_HOME) : new File(XDG_DATA_HOME);
        LogManager.log("XDG_DATA_DIRS = " + currentUserLocation);
        return currentUserLocation;
    }

    private File getDesktopFolder() {
        String desktopDir = System.getenv(XDG_DESKTOP_DIR_ENV_VARIABLE);
        File globalConfigFile = new File(XDG_USERDIRS_GLOBAL_CONF);
        File userHome = SystemUtils.getUserHomeDirectory();
        File userDirsFile = new File(userHome, XDG_USERDIRS_DIRS);
        File userConfigFile = new File(userHome, XDG_USERDIRS_CONF);
        LogManager.log("... getting desktop folder");
        if (desktopDir != null && !desktopDir.equals("")) {
            LogManager.log("XDG_DESKTOP_DIR = " + desktopDir);
            File f = new File(desktopDir);
            if (f.exists()) {
                LogManager.log("... desktop dir : " + f);
                return f;
            }
            LogManager.log("... XDG_DESKTOP_DIR is defined but does not exist:" + desktopDir);
        } else if (System.getenv("XDG_SESSION_COOKIE") == null && System.getenv(XDG_DATA_DIRS_ENV_VARIABLE) == null) {
            LogManager.log("... neither XDG_SESSION_COOKIE nor XDG_DATA_DIRS environment variable is defined");
        } else if (!FileUtils.exists(globalConfigFile)) {
            LogManager.log("... global XDG config file does not exist");
        } else if (!FileUtils.exists(userDirsFile)) {
            LogManager.log("... user XDG config file does not exist");
        } else if (!FileUtils.canRead(userDirsFile)) {
            LogManager.log("... cannot read user XDG config file");
        } else {
            try {
                boolean useXdgDirs = false;
                block4: for (File configFile : new File[]{userConfigFile, globalConfigFile}) {
                    if (!FileUtils.exists(configFile)) continue;
                    for (String s : FileUtils.readStringList(configFile)) {
                        Matcher matcher = Pattern.compile("enabled=(.*)").matcher(s);
                        if (!matcher.find()) continue;
                        if (!Boolean.parseBoolean(matcher.group(1).toLowerCase(Locale.ENGLISH))) {
                            LogManager.log("... XDG dirs are disabled");
                            useXdgDirs = false;
                            continue block4;
                        }
                        LogManager.log("... XDG dirs are enabled");
                        useXdgDirs = true;
                    }
                }
                if (useXdgDirs) {
                    String encoding = "";
                    for (File configFile : new File[]{userConfigFile, globalConfigFile}) {
                        if (!FileUtils.exists(configFile)) continue;
                        for (String s : FileUtils.readStringList(configFile)) {
                            Matcher matcher = Pattern.compile("filename_encoding=(.*)").matcher(s);
                            if (!matcher.find()) continue;
                            encoding = matcher.group(1);
                            if (!encoding.equals("locale")) break;
                            encoding = null;
                            break;
                        }
                        if (encoding == null || !encoding.equals("")) break;
                        encoding = "UTF-8";
                    }
                    LogManager.log("... using encoding for config file reading : " + encoding);
                    List<String> content = encoding == null ? FileUtils.readStringList(userDirsFile) : FileUtils.readStringList(userDirsFile, encoding);
                    for (String s : content) {
                        LogManager.log("...... evaluating string : " + s);
                        Matcher matcher = Pattern.compile("^XDG_DESKTOP_DIR=\"(.*)\"").matcher(s);
                        if (!matcher.find()) continue;
                        LogManager.log("...... matches expected pattern");
                        String value = matcher.group(1).replace("$HOME", userHome.getAbsolutePath());
                        File f = new File(value);
                        if (FileUtils.exists(f)) {
                            return f;
                        }
                        LogManager.log("... custom desktop directory defined but does not exist: " + f);
                        LogManager.log("... probably wrong encoding used, fallback to system utils");
                        throw new IOException("File " + f + " is defined as desktop folder but does not exist");
                    }
                }
            }
            catch (Exception e) {
                LogManager.log(e);
                try {
                    String stdout;
                    File bin = new File("/usr/bin/xdg-user-dir");
                    if (FileUtils.exists(bin) && (stdout = SystemUtils.executeCommand(bin.getAbsolutePath(), "DESKTOP").getStdOut()).length() > 0) {
                        File dsk = new File(stdout);
                        if (FileUtils.exists(dsk)) {
                            return dsk;
                        }
                        LogManager.log("... custom desktop directory defined (system util) but does not exist: " + dsk);
                        LogManager.log("... probably wrong encoding, fallback to default");
                    }
                }
                catch (Exception ex) {
                    LogManager.log(ex);
                }
            }
        }
        return new File(userHome, "Desktop");
    }

    private void addLocalizedMapEntry(List<String> list, String entryName, Map<Locale, String> entryMap) {
        if (!entryMap.isEmpty()) {
            String name = entryMap.get(new Locale(""));
            if (name == null) {
                name = entryMap.get(Locale.getDefault());
            }
            list.add(entryName + "=" + name);
            for (Locale locale : entryMap.keySet()) {
                if (name.equals(entryMap.get(locale))) continue;
                list.add(entryName + "[" + locale + "]=" + StringUtils.getLocalizedString(entryMap, locale));
            }
        }
    }

    private List<String> getDesktopEntry(FileShortcut shortcut) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("[Desktop Entry]");
        list.add("Encoding=UTF-8");
        this.addLocalizedMapEntry(list, "Name", shortcut.getNames());
        this.addLocalizedMapEntry(list, "Comment", shortcut.getDescriptions());
        list.add("Exec=/bin/sh \"" + shortcut.getTarget() + "\"" + (shortcut.getArguments() != null && shortcut.getArguments().size() != 0 ? " " + shortcut.getArgumentsString() : ""));
        if (shortcut.getIcon() != null) {
            list.add("Icon=" + shortcut.getIconPath());
        }
        if (shortcut.getCategories().length != 0) {
            list.add("Categories=" + StringUtils.asString(shortcut.getCategories(), ";"));
        }
        list.add("Version=1.0");
        list.add("Type=Application");
        list.add("Terminal=0");
        Properties props = shortcut.getAdditionalProperties();
        for (Object key : props.keySet()) {
            list.add(key.toString() + "=" + props.get(key));
        }
        list.add(SystemUtils.getLineSeparator());
        return list;
    }

    protected List<String> getDesktopEntry(InternetShortcut shortcut) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("[Desktop Entry]");
        list.add("Encoding=UTF-8");
        this.addLocalizedMapEntry(list, "Name", shortcut.getNames());
        this.addLocalizedMapEntry(list, "Comment", shortcut.getDescriptions());
        list.add("URL=" + shortcut.getURL());
        if (shortcut.getIcon() != null) {
            list.add("Icon=" + shortcut.getIconPath());
        }
        if (shortcut.getCategories().length != 0) {
            list.add("Categories=" + StringUtils.asString(shortcut.getCategories(), ";"));
        }
        list.add("Version=1.0");
        list.add("Type=Link");
        Properties props = shortcut.getAdditionalProperties();
        for (Object key : props.keySet()) {
            list.add(key.toString() + "=" + props.get(key));
        }
        list.add(SystemUtils.getLineSeparator());
        return list;
    }

    private void addExecutablePermissions(File file) throws IOException {
        int permissions;
        int newPermissions = permissions + (((permissions = SystemUtils.getPermissions(file)) & 0x100) != 0 && (permissions & 0x40) == 0 ? 64 : 0) + ((permissions & 0x20) != 0 && (permissions & 8) == 0 ? 8 : 0) + ((permissions & 4) != 0 && (permissions & 1) == 0 ? 1 : 0);
        SystemUtils.setPermissions(file, newPermissions, 1);
    }

    @Override
    public File createShortcut(Shortcut shortcut, LocationType locationType) throws NativeException {
        File file = this.getShortcutLocation(shortcut, locationType);
        try {
            if (shortcut instanceof FileShortcut) {
                File target = ((FileShortcut)shortcut).getTarget();
                if (target.isDirectory()) {
                    this.createSymLink(file, target);
                } else {
                    FileUtils.writeStringList(file, this.getDesktopEntry((FileShortcut)shortcut));
                    this.addExecutablePermissions(file);
                    this.postShortcutCreate(shortcut, locationType);
                }
            } else if (shortcut instanceof InternetShortcut) {
                FileUtils.writeStringList(file, this.getDesktopEntry((InternetShortcut)shortcut));
                this.addExecutablePermissions(file);
                this.postShortcutCreate(shortcut, locationType);
            }
        }
        catch (IOException e) {
            throw new NativeException("Cannot create shortcut", e);
        }
        return file;
    }

    private void postShortcutCreate(Shortcut shortcut, LocationType locationType) {
        String XDG_CONFIG_HOME;
        File configHome;
        File appsMenu;
        if (locationType.equals((Object)LocationType.CURRENT_USER_START_MENU) && !FileUtils.exists(appsMenu = new File(configHome = (XDG_CONFIG_HOME = System.getenv(XDG_CONFIG_HOME_ENV_VARIABLE)) != null ? new File(XDG_CONFIG_HOME) : new File(SystemUtils.getUserHomeDirectory(), XDG_CONFIG_HOME_DEFAULT), XDG_APPLICATION_MENU_FILE))) {
            try {
                FileUtils.mkdirs(appsMenu.getParentFile());
                boolean created = appsMenu.createNewFile();
                if (created) {
                    SystemUtils.sleep(50L);
                    FileUtils.deleteFile(appsMenu);
                }
            }
            catch (IOException e) {
                LogManager.log(e);
            }
        }
    }

    @Override
    public void removeShortcut(Shortcut shortcut, LocationType locationType, boolean cleanupParents) throws NativeException {
        try {
            File shortcutFile = this.getShortcutLocation(shortcut, locationType);
            FileUtils.deleteFile(shortcutFile);
            if (cleanupParents && (locationType == LocationType.ALL_USERS_START_MENU || locationType == LocationType.CURRENT_USER_START_MENU)) {
                FileUtils.deleteEmptyParents(shortcutFile);
            }
        }
        catch (IOException e) {
            throw new NativeException("Cannot remove shortcut", e);
        }
    }

    @Override
    public boolean isBrowseSupported() {
        this.initBrowser();
        return this.browserExecutable != null;
    }

    @Override
    public boolean openBrowser(URI uri) {
        this.initBrowser();
        if (this.browserExecutable != null) {
            LogManager.log("... using browser: " + this.browserExecutable);
            try {
                Runtime.getRuntime().exec(new String[]{this.browserExecutable.getAbsolutePath(), uri.toString()});
                return true;
            }
            catch (IOException e) {
                LogManager.log(e);
            }
        }
        return false;
    }

    protected String[] getPossibleBrowserLocations() {
        return new String[0];
    }

    private void initBrowser() {
        String[] possibleBrowsers;
        if (this.browserExecutableSet) {
            return;
        }
        for (String s : possibleBrowsers = this.getPossibleBrowserLocations()) {
            File f = new File(s);
            if (!f.exists()) continue;
            this.browserExecutable = f;
            break;
        }
        this.browserExecutableSet = true;
    }

    @Override
    public List<File> findExecutableFiles(File parent) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        if (parent.exists()) {
            if (parent.isDirectory()) {
                File[] children;
                for (File child : children = parent.listFiles()) {
                    files.addAll(this.findExecutableFiles(child));
                }
            } else {
                String[] scriptExtensions;
                File child = parent;
                String name = child.getName();
                for (String ext : scriptExtensions = new String[]{".sh", ".pl", ".py"}) {
                    if (!name.endsWith(ext)) continue;
                    files.add(child);
                    return files;
                }
                String line = FileUtils.readFirstLine(child);
                if (line != null && line.startsWith("#!")) {
                    files.add(child);
                    return files;
                }
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(child));
                byte[] buf = new byte[4];
                bis.read(buf);
                bis.close();
                if (Arrays.equals(buf, ELF_BYTES)) {
                    files.add(child);
                    return files;
                }
            }
        }
        return files;
    }

    @Override
    public List<File> findIrrelevantFiles(File parent) throws IOException {
        ArrayList<File> files;
        block4: {
            files = new ArrayList<File>();
            if (!parent.exists()) break block4;
            if (parent.isDirectory()) {
                File[] children;
                for (File child : children = parent.listFiles()) {
                    files.addAll(this.findIrrelevantFiles(child));
                }
            } else {
                String[] windowsExtensions;
                File child = parent;
                String name = child.getName();
                for (String ext : windowsExtensions = new String[]{".bat", ".cmd", ".dll", ".exe", ".com", ".vbs", ".vbe", ".wsf", ".wsh"}) {
                    if (!name.endsWith(ext)) continue;
                    files.add(child);
                    break;
                }
            }
        }
        return files;
    }

    public void chmod(File file, String mode) throws IOException {
        this.chmod(Arrays.asList(file), mode);
    }

    public void chmod(File file, int mode) throws IOException {
        this.chmod(file, Integer.toString(mode, 8));
    }

    public void chmod(List<File> files, String mode) throws IOException {
        for (File file : files) {
            File directory = file.getParentFile();
            String name = file.getName();
            SystemUtils.executeCommand(directory, "chmod", mode, name);
        }
    }

    @Override
    public void setPermissions(File file, int mode, int change) throws IOException {
        LogManager.log("setting permissions " + Integer.toString(mode, 8) + " on " + file);
        this.setPermissionsNative(file.getAbsolutePath(), mode, change);
    }

    @Override
    public int getPermissions(File file) throws IOException {
        return this.getPermissionsNative(file.getAbsolutePath());
    }

    public void removeIrrelevantFiles(File parent) throws IOException {
        FileUtils.deleteFiles(this.findIrrelevantFiles(parent));
    }

    @Override
    public void correctFilesPermissions(File parent) throws IOException {
        this.chmod(this.findExecutableFiles(parent), "ugo+x");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFreeSpace(File file) {
        if (file == null || file.getPath().equals("")) {
            return 0L;
        }
        long freeSpace = this.getFreeSpaceNative(file.getPath());
        if (this.checkQuota) {
            try {
                LogManager.indent();
                long freeSpaceQuota = this.getFreeSpaceUsingQuota(file);
                if (freeSpaceQuota != -1L) {
                    LogManager.log("... free space (due to the quote) is " + freeSpaceQuota + ", physical is : " + freeSpace);
                    freeSpace = freeSpaceQuota;
                }
            }
            catch (IOException e) {
                LogManager.log("... quota check is disabled");
                this.checkQuota = false;
            }
            finally {
                LogManager.unindent();
            }
        }
        return freeSpace;
    }

    private long getFreeSpaceUsingQuota(File file) throws IOException {
        String path = file.getAbsolutePath();
        try {
            path = file.getCanonicalPath();
        }
        catch (IOException e) {
            LogManager.log(e);
        }
        LogManager.log("Checking free space with quota in " + path);
        try {
            this.setEnvironmentVariable("LANG", "C", EnvironmentScope.PROCESS, false);
            this.setEnvironmentVariable("LC_COLLATE", "C", EnvironmentScope.PROCESS, false);
            this.setEnvironmentVariable("LC_CTYPE", "C", EnvironmentScope.PROCESS, false);
            this.setEnvironmentVariable("LC_MESSAGES", "C", EnvironmentScope.PROCESS, false);
            this.setEnvironmentVariable("LC_MONETARY", "C", EnvironmentScope.PROCESS, false);
            this.setEnvironmentVariable("LC_NUMERIC", "C", EnvironmentScope.PROCESS, false);
            this.setEnvironmentVariable("LC_TIME", "C", EnvironmentScope.PROCESS, false);
        }
        catch (NativeException e) {
            LogManager.log(e);
        }
        if (this.quotaExecutable == null) {
            for (String q : QUOTA_LOCATIONS) {
                File f = new File(q);
                if (!FileUtils.exists(f)) continue;
                this.quotaExecutable = f;
                break;
            }
            if (this.quotaExecutable == null) {
                LogManager.log("... no quota executable found");
                throw new IOException();
            }
        }
        final ArrayList stdoutList = new ArrayList();
        Thread quotaThread = null;
        try {
            quotaThread = new Thread(){

                @Override
                public void run() {
                    try {
                        LogManager.log("... running command : " + UnixNativeUtils.this.quotaExecutable.getPath() + " -v");
                        Process p = new ProcessBuilder(UnixNativeUtils.this.quotaExecutable.getPath(), "-v").start();
                        InputStream is = p.getInputStream();
                        InputStream err = p.getErrorStream();
                        p.waitFor();
                        String output = StringUtils.readStream(is);
                        String error = StringUtils.readStream(err);
                        LogManager.log("... stdout:");
                        LogManager.log(output);
                        LogManager.log("... stderr:");
                        LogManager.log(error);
                        LogManager.log("... return : " + p.exitValue());
                        stdoutList.add(output);
                        is.close();
                        err.close();
                    }
                    catch (IOException e) {
                        LogManager.log("... error occured when running quota executable", (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        LogManager.log("... interrupted");
                    }
                }
            };
            quotaThread.start();
            quotaThread.join(5000L);
            if (quotaThread.isAlive()) {
                LogManager.log("... quota command is hanging more than 5 seconds so killing it");
                quotaThread.interrupt();
                LogManager.log("... killed");
            }
        }
        catch (InterruptedException ie) {
            LogManager.log("... interrupted", (Throwable)ie);
            quotaThread.interrupt();
        }
        if (stdoutList.size() == 0) {
            LogManager.log("... quota produced no stdout for analysis");
            throw new IOException();
        }
        String stdout = (String)stdoutList.get(0);
        String[] lines = StringUtils.splitByLines(stdout);
        if (lines.length <= 2) {
            LogManager.log("... no quota set for the user (number of lines in output less that 3)");
            throw new IOException();
        }
        ArrayList<Pair<String, Long>> pathSpace = new ArrayList<Pair<String, Long>>();
        try {
            for (int i = 2; i < lines.length; ++i) {
                String s = lines[i].trim();
                if (!s.startsWith(File.separator) || s.indexOf(" ") == -1) continue;
                String quotedPath = s.substring(0, s.indexOf(" "));
                String[] numbers = s.substring(s.indexOf(" ") + 1).trim().split("[ |\t]+");
                if (numbers.length < 6) {
                    LogManager.log("...cannot parse the quota numbers [" + numbers.length + "]");
                    throw new IOException();
                }
                long l = new Long(numbers[2]);
                long usage = new Long(numbers[0]);
                long freespace = (l - usage) * 1024L;
                if (l <= 0L || freespace < 0L) continue;
                pathSpace.add(new Pair<String, Long>(quotedPath, freespace));
            }
            if (pathSpace.size() == 0) {
                LogManager.log("... no quota set for the user (no paths in quota output)");
                throw new IOException();
            }
            String longestPath = "";
            long freespace = -1L;
            for (Pair pair : pathSpace) {
                String s = (String)pair.getFirst();
                if (s.length() <= longestPath.length() || !path.startsWith(s)) continue;
                longestPath = s;
                freespace = (Long)pair.getSecond();
            }
            return freespace;
        }
        catch (NumberFormatException e) {
            LogManager.log("...cannot parse the quota numbers", (Throwable)e);
            throw new IOException();
        }
        catch (PatternSyntaxException e) {
            LogManager.log("...cannot parse the quota numbers", (Throwable)e);
            throw new IOException();
        }
    }

    @Override
    public boolean isUNCPath(String path) {
        return path.matches("^.+:/.+");
    }

    @Override
    public String getEnvironmentVariable(String name, EnvironmentScope scope, boolean flag) {
        return System.getenv(name);
    }

    @Override
    public void setEnvironmentVariable(String name, String value, EnvironmentScope scope, boolean flag) throws NativeException {
        if (EnvironmentScope.PROCESS == scope) {
            SystemUtils.getEnvironment().put(name, value);
        } else {
            try {
                this.getCurrentShell().setVar(name, value, scope);
            }
            catch (IOException e) {
                throw new NativeException("Cannot set the environment variable value", e);
            }
        }
    }

    public Shell getCurrentShell() {
        LogManager.log(4, "Getting current shell..");
        LogManager.indent();
        Shell[] avaliableShells = new Shell[]{new BourneShell(), new CShell(), new TCShell(), new KornShell()};
        String shell = System.getenv("SHELL");
        Shell result = null;
        if (shell == null) {
            shell = System.getenv("shell");
        }
        LogManager.log(4, "... shell env variable = " + shell);
        if (shell != null) {
            if (shell.lastIndexOf(File.separator) != -1) {
                shell = shell.substring(shell.lastIndexOf(File.separator) + 1);
            }
            LogManager.log(4, "... searching for the shell with name [" + shell + "] " + "among available shells names");
            for (Shell sh : avaliableShells) {
                if (!sh.isCurrentShell(shell)) continue;
                result = sh;
                LogManager.log(4, "... detected shell: " + sh.getClass().getSimpleName());
                break;
            }
        }
        if (result == null) {
            LogManager.log(4, "... no shell found");
        }
        LogManager.unindent();
        LogManager.log(4, "... finished detecting shell");
        return result;
    }

    @Override
    public File getDefaultApplicationsLocation() {
        File opt = new File("/opt");
        if (opt.exists() && opt.isDirectory() && FileUtils.canWrite(opt)) {
            return opt;
        }
        return SystemUtils.getUserHomeDirectory();
    }

    @Override
    public boolean isPathValid(String path) {
        return true;
    }

    @Override
    public FilesList addComponentToSystemInstallManager(ApplicationDescriptor descriptor) throws NativeException {
        Launcher launcher;
        FilesList list = new FilesList();
        if (descriptor.getModifyCommand() != null) {
            try {
                launcher = this.createUninstaller(descriptor, false, new Progress());
                this.correctFilesPermissions(launcher.getOutputFile());
                list.add(launcher.getOutputFile());
            }
            catch (IOException e) {
                throw new NativeException("Can't create uninstaller", e);
            }
        }
        if (descriptor.getUninstallCommand() != null) {
            try {
                launcher = this.createUninstaller(descriptor, true, new Progress());
                this.correctFilesPermissions(launcher.getOutputFile());
                list.add(launcher.getOutputFile());
            }
            catch (IOException e) {
                throw new NativeException("Can't create uninstaller", e);
            }
        }
        return list;
    }

    @Override
    public void removeComponentFromSystemInstallManager(ApplicationDescriptor descriptor) {
    }

    public FilesList createSymLink(File source, File target) throws IOException {
        return this.createSymLink(source, target, true);
    }

    public FilesList createSymLink(File source, File target, boolean useRelativePath) throws IOException {
        FilesList list = new FilesList();
        list.add(FileUtils.mkdirs(source.getParentFile()));
        list.add(source);
        String relativePath = null;
        if (useRelativePath) {
            relativePath = FileUtils.getRelativePath(source, target);
        }
        SystemUtils.executeCommand("ln", "-s", relativePath == null ? target.getAbsolutePath() : relativePath, source.getAbsolutePath());
        return list;
    }

    private String[] getDfCommand(String ... args) {
        ArrayList<String> command = new ArrayList<String>();
        command.add("df");
        command.add(this.getCurrentPlatform().isCompatibleWith(Platform.HPUX) ? "-kP" : "-k");
        if (args != null && args.length > 0) {
            for (String arg : args) {
                command.add(this.getExistingParent(arg));
            }
        }
        return command.toArray(new String[0]);
    }

    private String getExistingParent(String fileName) {
        File file = new File(fileName);
        if (file.exists()) {
            return fileName;
        }
        return this.getExistingParent(file.getParent());
    }

    @Override
    public List<File> getFileSystemRoots(String ... files) throws IOException {
        try {
            this.setEnvironmentVariable("LANG", "C", EnvironmentScope.PROCESS, false);
            this.setEnvironmentVariable("LC_COLLATE", "C", EnvironmentScope.PROCESS, false);
            this.setEnvironmentVariable("LC_CTYPE", "C", EnvironmentScope.PROCESS, false);
            this.setEnvironmentVariable("LC_MESSAGES", "C", EnvironmentScope.PROCESS, false);
            this.setEnvironmentVariable("LC_MONETARY", "C", EnvironmentScope.PROCESS, false);
            this.setEnvironmentVariable("LC_NUMERIC", "C", EnvironmentScope.PROCESS, false);
            this.setEnvironmentVariable("LC_TIME", "C", EnvironmentScope.PROCESS, false);
            String stdout = SystemUtils.executeCommand(this.getDfCommand(files)).getStdOut();
            String[] lines = StringUtils.splitByLines(stdout);
            LinkedList<File> roots = new LinkedList<File>();
            for (int i = 1; i < lines.length; ++i) {
                String path;
                File file;
                int index = lines[i].indexOf("%");
                if (index == -1 || (index = lines[i].indexOf("/", index)) == -1 || roots.contains(file = new File(path = lines[i].substring(index)))) continue;
                roots.add(file);
            }
            return roots;
        }
        catch (NativeException e) {
            IOException ioException = new IOException("Cannot define the environment");
            throw (IOException)ioException.initCause(e);
        }
    }

    private native long getFreeSpace0(String var1);

    private native void setPermissions0(String var1, int var2, int var3);

    private native int getPermissions0(String var1);

    private native boolean isCurrentUserAdmin0();

    private long getFreeSpaceNative(String s) {
        return nativeLibraryLoaded ? this.getFreeSpace0(s) : this.getFreeSpaceJ(s);
    }

    private long getFreeSpaceJ(String s) {
        try {
            this.setEnvironmentVariable("LANG", "C", EnvironmentScope.PROCESS, false);
            this.setEnvironmentVariable("LC_COLLATE", "C", EnvironmentScope.PROCESS, false);
            this.setEnvironmentVariable("LC_CTYPE", "C", EnvironmentScope.PROCESS, false);
            this.setEnvironmentVariable("LC_MESSAGES", "C", EnvironmentScope.PROCESS, false);
            this.setEnvironmentVariable("LC_MONETARY", "C", EnvironmentScope.PROCESS, false);
            this.setEnvironmentVariable("LC_NUMERIC", "C", EnvironmentScope.PROCESS, false);
            this.setEnvironmentVariable("LC_TIME", "C", EnvironmentScope.PROCESS, false);
        }
        catch (NativeException e) {
            LogManager.log(e);
        }
        try {
            String stdout = SystemUtils.executeCommand(this.getDfCommand(s)).getStdOut().trim();
            String[] lines = StringUtils.splitByLines(stdout);
            for (int i = 1; i < lines.length; ++i) {
                String[] parts;
                int index = lines[i].indexOf("%");
                if (index == -1 || (parts = lines[i].substring(0, index).split("[ ]+")).length <= 1) continue;
                return new Long(parts[parts.length - 2]) * 1024L;
            }
        }
        catch (IOException e) {
            LogManager.log(e);
        }
        catch (NumberFormatException e) {
            LogManager.log(e);
        }
        return 0L;
    }

    private void setPermissionsJ(String path, int mode, int change) throws IOException {
        switch (change) {
            case 1: {
                this.chmod(new File(path), mode);
                break;
            }
            case 2: 
            case 4: {
                if (mode == 0) {
                    return;
                }
                String fullmode = "";
                Integer[] rModes = new Integer[]{256, 32, 4};
                Integer[] wModes = new Integer[]{128, 16, 2};
                Integer[] xModes = new Integer[]{64, 8, 1};
                ArrayList<Pair<ArrayList<Integer>, String>> modes = new ArrayList<Pair<ArrayList<Integer>, String>>();
                modes.add(new Pair<ArrayList<Integer>, String>(new ArrayList<Integer>(Arrays.asList(rModes)), "r"));
                modes.add(new Pair<ArrayList<Integer>, String>(new ArrayList<Integer>(Arrays.asList(wModes)), "w"));
                modes.add(new Pair<ArrayList<Integer>, String>(new ArrayList<Integer>(Arrays.asList(xModes)), "x"));
                for (int i = 0; i < modes.size(); ++i) {
                    String m = "";
                    List list = (List)((Pair)modes.get(i)).getFirst();
                    for (int j = 0; j < list.size(); ++j) {
                        if ((mode & (Integer)list.get(j)) == 0) continue;
                        m = m + (j == 0 ? "u" : (j == 1 ? "g" : "o"));
                    }
                    if (m.equals("")) continue;
                    m = m + (change == 2 ? "+" : "-") + (String)((Pair)modes.get(i)).getSecond();
                    fullmode = fullmode.equals("") ? m : fullmode + "," + m;
                    m = "";
                }
                if (fullmode.equals("")) break;
                this.chmod(new File(path), fullmode);
                break;
            }
        }
    }

    private void setPermissionsNative(String path, int mode, int change) throws IOException {
        if (nativeLibraryLoaded) {
            this.setPermissions0(path, mode, change);
        } else {
            this.setPermissionsJ(path, mode, change);
        }
    }

    private int getPermissionsNative(String path) {
        return nativeLibraryLoaded ? this.getPermissions0(path) : this.getPermissionsJ(path);
    }

    private int getPermissionsJ(String path) {
        try {
            String output = SystemUtils.executeCommand("ls", "-ld", path).getStdOut().trim();
            int permissions = 0;
            for (int i = 0; i < 9; ++i) {
                char character = output.charAt(i + 1);
                if (i % 3 == 0) {
                    permissions *= 10;
                }
                if (character == '-') continue;
                if (i % 3 == 0 && character == 'r') {
                    permissions += 4;
                    continue;
                }
                if (i % 3 == 1 && character == 'w') {
                    permissions += 2;
                    continue;
                }
                if (i % 3 == 2 && character == 'x') {
                    ++permissions;
                    continue;
                }
                return -1;
            }
            return permissions;
        }
        catch (IOException e) {
            return -1;
        }
        catch (IndexOutOfBoundsException e) {
            return -1;
        }
    }

    private boolean isCurrentUserAdminNative() {
        return nativeLibraryLoaded ? this.isCurrentUserAdmin0() : this.isCurrentUserAdminJ();
    }

    private boolean isCurrentUserAdminJ() {
        boolean adm = false;
        try {
            try {
                this.setEnvironmentVariable("LANG", "C", EnvironmentScope.PROCESS, false);
                this.setEnvironmentVariable("LC_COLLATE", "C", EnvironmentScope.PROCESS, false);
                this.setEnvironmentVariable("LC_CTYPE", "C", EnvironmentScope.PROCESS, false);
                this.setEnvironmentVariable("LC_MESSAGES", "C", EnvironmentScope.PROCESS, false);
                this.setEnvironmentVariable("LC_MONETARY", "C", EnvironmentScope.PROCESS, false);
                this.setEnvironmentVariable("LC_NUMERIC", "C", EnvironmentScope.PROCESS, false);
                this.setEnvironmentVariable("LC_TIME", "C", EnvironmentScope.PROCESS, false);
            }
            catch (NativeException e) {
                LogManager.log(e);
            }
            String stdout = SystemUtils.executeCommand("id").getStdOut();
            Matcher matcher = Pattern.compile("euid=([0-9]+)\\(").matcher(stdout);
            if (!matcher.find()) {
                matcher = Pattern.compile("uid=([0-9]+)\\(").matcher(stdout);
            }
            if (matcher.find()) {
                adm = new Integer(matcher.group(1)) == 0;
            }
        }
        catch (IOException e) {
            LogManager.log(e);
        }
        catch (NumberFormatException e) {
            LogManager.log(e);
        }
        return adm;
    }

    @Override
    protected void initializeForbiddenFiles(String ... files) {
        super.initializeForbiddenFiles(FORBIDDEN_DELETING_FILES_UNIX);
        super.initializeForbiddenFiles(files);
    }

    public static class FileAccessMode {
        public static final int RU = 256;
        public static final int WU = 128;
        public static final int EU = 64;
        public static final int RG = 32;
        public static final int WG = 16;
        public static final int EG = 8;
        public static final int RO = 4;
        public static final int WO = 2;
        public static final int EO = 1;
    }

    private class UnixProcessOnExitCleanerHandler
    extends ProcessOnExitCleanerHandler {
        public UnixProcessOnExitCleanerHandler(String cleanerFileName) {
            super(cleanerFileName);
        }

        @Override
        protected void writeCleaner(File cleanerFile) throws IOException {
            InputStream is = ResourceUtils.getResource(UnixNativeUtils.CLEANER_RESOURCE);
            CharSequence cs = StreamUtils.readStream(is);
            is.close();
            Object[] lines = StringUtils.splitByLines(cs);
            FileUtils.writeFile(cleanerFile, StringUtils.asString(lines, SystemUtils.getLineSeparator()));
        }

        @Override
        protected void writeCleaningFileList(File listFile, List<String> files) throws IOException {
            LinkedList<String> newList = new LinkedList<String>(files);
            newList.add(SystemUtils.getLineSeparator());
            FileUtils.writeStringList(listFile, newList);
        }
    }
}

