/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.hints.css;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.html.editor.hints.HtmlRuleContext;
import org.netbeans.modules.html.editor.hints.css.AddStylesheetLinkHintFix;
import org.netbeans.modules.html.editor.hints.css.CreateRuleInStylesheet;
import org.netbeans.modules.html.editor.hints.css.HintContext;
import org.openide.filesystems.FileObject;

public class MissingCssElement
extends Hint {
    public MissingCssElement(Rule rule, String msg, HtmlRuleContext context, OffsetRange range, HintContext hintContext) {
        super(rule, msg, context.getFile(), range, MissingCssElement.createFixes(context, hintContext), 10);
    }

    private static List<HintFix> createFixes(HtmlRuleContext context, HintContext hintContext) {
        ArrayList<HintFix> fixes = new ArrayList<HintFix>();
        FileObject sourceFile = context.getFile();
        if (hintContext.getElement2files().get(hintContext.getElementName()) != null) {
            for (FileObject file : hintContext.getElement2files().get(hintContext.getElementName())) {
                fixes.add(new AddStylesheetLinkHintFix(sourceFile, file));
            }
        } else if (!hintContext.getAllStylesheets().isEmpty()) {
            for (FileObject stylesheet : hintContext.getAllStylesheets()) {
                fixes.add(new CreateRuleInStylesheet(sourceFile, stylesheet, hintContext.getElementName(), !hintContext.getReferredFiles().contains(stylesheet), false));
            }
        } else {
            fixes.add(new CreateRuleInStylesheet(sourceFile, null, hintContext.getElementName(), true, true));
        }
        return fixes;
    }
}

