/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.hints;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.html.editor.hints.HtmlRuleContext;
import org.netbeans.modules.html.editor.hints.PatternRule;
import org.netbeans.modules.html.editor.spi.HintFixProvider;
import org.netbeans.modules.web.common.api.WebUtils;
import org.openide.util.Lookup;

public class Nesting
extends PatternRule {
    private static final String[] PATTERNS_SOURCES = new String[]{"Element (.*?) not allowed as child of element (.*?) in this context.", "Heading cannot be a child of another heading.", ".*? start tag found but the .*? element is already open.", "Unclosed elements inside a list.", "An .*? start tag seen with already an active .*? element.", ".*? start tag seen when there was an open .*? element in scope.", "Start tag for .*? seen when .*? was already open.", "Bad start tag in .*? in", ".*? start tag with .*? open", ".*? start tag where end tag expected.", ".*? start tag seen in", ".*? element outside", ".*? element between", "Unclosed elements on stack.", "No .*? element in scope but a .*? end tag seen.", "No .*? element in list scope", "Saw an end tag after .*? had been closed.", "No element .*? to close.", "End tag .*? violates nesting rules.", "XHTML element .*? is missing a required instance of child element .*?"};
    private static final Pattern[] PATTERNS = Nesting.buildPatterns(PATTERNS_SOURCES);
    private static final int UNKNOWN_ELEMENT_PATTERN_INDEX = 0;

    @Override
    public HintSeverity getDefaultSeverity() {
        return HintSeverity.ERROR;
    }

    @Override
    public Pattern[] getPatterns() {
        return PATTERNS;
    }

    @Override
    protected List<HintFix> getExtraHintFixes(Error e, HtmlRuleContext context) {
        if (this.matched_pattern_index == 0) {
            ArrayList<HintFix> fixes = new ArrayList<HintFix>();
            fixes.addAll(super.getExtraHintFixes(e, context));
            fixes.addAll(this.getSPIHintFixes(e, context));
            return fixes;
        }
        return super.getExtraHintFixes(e, context);
    }

    private List<HintFix> getSPIHintFixes(Error e, HtmlRuleContext context) {
        ArrayList<HintFix> fixes = new ArrayList<HintFix>();
        Pattern p = PATTERNS[0];
        Matcher matcher = p.matcher(e.getDescription());
        if (matcher.matches()) {
            String unknownElement = WebUtils.unquotedValue((CharSequence)matcher.group(1).trim());
            String contextElement = WebUtils.unquotedValue((CharSequence)matcher.group(2).trim());
            HashMap<String, Object> meta = new HashMap<String, Object>();
            meta.put("unknown_element_found", unknownElement);
            meta.put("unknown_element_context", contextElement);
            HintFixProvider.Context ctx = new HintFixProvider.Context(context.getSnapshot(), context.getHtmlParserResult(), meta);
            for (HintFixProvider provider : Lookup.getDefault().lookupAll(HintFixProvider.class)) {
                fixes.addAll(provider.getHintFixes(ctx));
            }
        }
        return fixes;
    }
}

