/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.hints;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.HintsProvider;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.html.editor.HtmlErrorFilter;
import org.netbeans.modules.html.editor.HtmlExtensions;
import org.netbeans.modules.html.editor.HtmlPreferences;
import org.netbeans.modules.html.editor.ProjectDefaultHtmlSourceVersionController;
import org.netbeans.modules.html.editor.api.Utils;
import org.netbeans.modules.html.editor.api.gsf.ErrorBadgingRule;
import org.netbeans.modules.html.editor.api.gsf.HtmlErrorFilterContext;
import org.netbeans.modules.html.editor.api.gsf.HtmlExtension;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.hints.EmbeddingUtil;
import org.netbeans.modules.html.editor.hints.FatalHtmlRule;
import org.netbeans.modules.html.editor.hints.HtmlRule;
import org.netbeans.modules.html.editor.hints.HtmlRuleContext;
import org.netbeans.modules.html.editor.hints.HtmlValidatorRule;
import org.netbeans.modules.html.editor.hints.other.ExtractInlinedStyleHint;
import org.netbeans.modules.html.editor.hints.other.ExtractInlinedStyleRule;
import org.netbeans.modules.html.editor.hints.other.RemoveSurroundingTag;
import org.netbeans.modules.html.editor.hints.other.SurroundWithTag;
import org.netbeans.modules.html.editor.lib.api.HtmlVersion;
import org.netbeans.modules.html.editor.lib.api.SyntaxAnalyzerResult;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.indexing.IndexingManager;
import org.netbeans.spi.lexer.MutableTextInput;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class HtmlHintsProvider
implements HintsProvider {
    private static RequestProcessor RP = new RequestProcessor(HtmlHintsProvider.class);
    private static final Logger LOG = Logger.getLogger(HtmlHintsProvider.class.getName());
    private static final HtmlRule ERROR_RULE = new HtmlRule(HintSeverity.ERROR, true);
    private static final HtmlRule WARNING_RULE = new HtmlRule(HintSeverity.WARNING, true);
    private static final HtmlRule INFO_RULE = new HtmlRule(HintSeverity.INFO, true);
    private static Comparator<org.netbeans.modules.html.editor.hints.HtmlRule> HTML_RULES_COMPARATOR = new Comparator<org.netbeans.modules.html.editor.hints.HtmlRule>(){

        @Override
        public int compare(org.netbeans.modules.html.editor.hints.HtmlRule o1, org.netbeans.modules.html.editor.hints.HtmlRule o2) {
            int prio_diff = o1.getPriority() - o2.getPriority();
            return prio_diff != 0 ? prio_diff : o1.getDisplayName().compareTo(o2.getDisplayName());
        }
    };

    public void computeHints(HintsProvider.HintsManager manager, RuleContext context, List<Hint> hints) {
        HtmlParserResult result = (HtmlParserResult)context.parserResult;
        HtmlVersion version = result.getDetectedHtmlVersion();
        FileObject file = result.getSnapshot().getSource().getFileObject();
        if (file == null) {
            return;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)file);
        boolean xhtml = result.getSyntaxAnalyzerResult().mayBeXhtml();
        if (version == null) {
            if (project == null) {
                hints.add(new Hint((Rule)HtmlHintsProvider.getRule(Severity.INFO), NbBundle.getMessage(HtmlHintsProvider.class, (String)"MSG_CANNOT_DETERMINE_HTML_VERSION_NO_PROJECT"), file, new OffsetRange(0, 0), Collections.emptyList(), 100){});
            } else {
                HtmlVersion defaulted = ProjectDefaultHtmlSourceVersionController.getDefaultHtmlVersion(project, xhtml);
                String msg = defaulted == null ? NbBundle.getMessage(HtmlHintsProvider.class, (String)(xhtml ? "MSG_CANNOT_DETERMINE_XHTML_VERSION" : "MSG_CANNOT_DETERMINE_HTML_VERSION")) : NbBundle.getMessage(HtmlHintsProvider.class, (String)(xhtml ? "MSG_CANNOT_DETERMINE_XHTML_VERSION_DEFAULTED_ALREADY" : "MSG_CANNOT_DETERMINE_HTML_VERSION_DEFAULTED_ALREADY"), (Object)defaulted.getDisplayName());
                hints.add(new Hint((Rule)HtmlHintsProvider.getRule(Severity.INFO), msg, file, new OffsetRange(0, 0), HtmlHintsProvider.generateSetDefaultHtmlVersionHints(project, result.getSnapshot().getSource().getDocument(false), xhtml), 100){});
            }
        }
    }

    private static List<HintFix> generateSetDefaultHtmlVersionHints(Project project, Document doc, boolean xhtml) {
        LinkedList<HintFix> fixes = new LinkedList<HintFix>();
        if (project != null) {
            for (HtmlVersion v : HtmlVersion.values()) {
                if (xhtml != v.isXhtml()) continue;
                fixes.add(new SetDefaultHtmlVersionHintFix(v, project, doc, xhtml));
            }
        }
        return fixes;
    }

    public void computeSuggestions(HintsProvider.HintsManager manager, RuleContext context, List<Hint> suggestions, int caretOffset) {
        HtmlParserResult result;
        SyntaxAnalyzerResult saresult;
        int errorType = 0;
        if (context instanceof HtmlErrorFilterContext) {
            int n = errorType = ((HtmlErrorFilterContext)context).isOnlyBadging() ? 2 : 1;
        }
        if (HtmlErrorFilter.isErrorCheckingEnabled(saresult = (result = (HtmlParserResult)context.parserResult).getSyntaxAnalyzerResult())) {
            HtmlRuleContext htmlRuleContext = new HtmlRuleContext(result, saresult, Collections.emptyList());
            for (org.netbeans.modules.html.editor.hints.HtmlRule htmlRule : HtmlHintsProvider.getSortedRules(manager, context, true)) {
                if (errorType > 0 && !htmlRule.showInTasklist() && !(htmlRule instanceof ErrorBadgingRule) || errorType == 2 != htmlRule instanceof ErrorBadgingRule || !manager.isEnabled((Rule.UserConfigurableRule)htmlRule)) continue;
                htmlRule.run(htmlRuleContext, suggestions);
            }
        }
        if (ExtractInlinedStyleRule.SINGLETON.appliesTo(context)) {
            suggestions.add(new ExtractInlinedStyleHint(context, new OffsetRange(context.caretOffset, context.caretOffset)));
        }
        if (RemoveSurroundingTag.RULE.appliesTo(context)) {
            suggestions.add(new RemoveSurroundingTag(context, new OffsetRange(context.caretOffset, context.caretOffset)));
        }
        String sourceMimetype = Utils.getWebPageMimeType(result.getSyntaxAnalyzerResult());
        for (HtmlExtension htmlExtension : HtmlExtensions.getRegisteredExtensions(sourceMimetype)) {
            htmlExtension.computeSuggestions(manager, context, suggestions, caretOffset);
        }
    }

    public void computeSelectionHints(HintsProvider.HintsManager manager, RuleContext context, List<Hint> suggestions, int start, int end) {
        HtmlParserResult result = (HtmlParserResult)context.parserResult;
        String sourceMimetype = Utils.getWebPageMimeType(result.getSyntaxAnalyzerResult());
        for (HtmlExtension htmlExtension : HtmlExtensions.getRegisteredExtensions(sourceMimetype)) {
            htmlExtension.computeSelectionHints(manager, context, suggestions, start, end);
        }
        suggestions.add(new SurroundWithTag(context, new OffsetRange(start, end)));
        suggestions.add(new RemoveSurroundingTag(context, new OffsetRange(start, end)));
    }

    public void computeErrors(HintsProvider.HintsManager manager, RuleContext context, List<Hint> hints, List<Error> unhandled) {
        int errorType = 0;
        if (context instanceof HtmlErrorFilterContext) {
            errorType = ((HtmlErrorFilterContext)context).isOnlyBadging() ? 2 : 1;
        }
        LOG.log(Level.FINE, "computing errors (errorType:{0}) for source {1}", new Object[]{errorType, context.parserResult.getSnapshot().getSource()});
        LOG.log(Level.FINER, null, new Exception());
        HtmlParserResult result = (HtmlParserResult)context.parserResult;
        SyntaxAnalyzerResult saresult = result.getSyntaxAnalyzerResult();
        Snapshot snapshot = result.getSnapshot();
        FileObject fo = snapshot.getSource().getFileObject();
        if (fo == null) {
            return;
        }
        ArrayList<HintFix> defaultFixes = new ArrayList<HintFix>(3);
        if (!HtmlErrorFilter.isErrorCheckingDisabledForFile(saresult)) {
            defaultFixes.add(new DisableErrorChecksFix(snapshot));
        }
        if (HtmlErrorFilter.isErrorCheckingEnabledForMimetype(saresult)) {
            defaultFixes.add(new DisableErrorChecksForMimetypeFix(saresult));
        }
        HtmlRuleContext htmlRuleContext = new HtmlRuleContext(result, saresult, defaultFixes);
        ArrayList<Error> fatalErrors = new ArrayList<Error>();
        for (Error error : htmlRuleContext.getLeftDiagnostics()) {
            if (error.getSeverity() != Severity.FATAL) continue;
            fatalErrors.add(error);
        }
        if (this.isXmlBasedMimetype(saresult)) {
            for (Error error : fatalErrors) {
                htmlRuleContext.getLeftDiagnostics().remove(error);
                if (errorType > 1) continue;
                String string = error.getDescription() + '\n' + NbBundle.getMessage(HtmlValidatorRule.class, (String)"MSG_FatalHtmlErrorAddendum");
                Hint fatalErrorHint = new Hint((Rule)new FatalHtmlRule(), string, fo, EmbeddingUtil.getErrorOffsetRange(error, snapshot), Collections.emptyList(), 5);
                hints.add(fatalErrorHint);
            }
        }
        if (HtmlErrorFilter.isErrorCheckingEnabled(saresult)) {
            for (org.netbeans.modules.html.editor.hints.HtmlRule htmlRule : HtmlHintsProvider.getSortedRules(manager, context, false)) {
                LOG.log(Level.FINE, "checking rule {0}", htmlRule.getDisplayName());
                if (errorType > 0 && !htmlRule.showInTasklist() && !(htmlRule instanceof ErrorBadgingRule) || errorType == 2 != htmlRule instanceof ErrorBadgingRule) continue;
                boolean bl = manager.isEnabled((Rule.UserConfigurableRule)htmlRule);
                LOG.log(Level.FINE, "rule runs");
                if (htmlRule.isSpecialHtmlValidatorRule()) {
                    htmlRule.setEnabled(bl);
                    htmlRule.run(htmlRuleContext, hints);
                    continue;
                }
                if (!bl) continue;
                htmlRule.run(htmlRuleContext, hints);
            }
        } else if (errorType < 2) {
            ArrayList<Object> fixes = new ArrayList<Object>(3);
            if (HtmlErrorFilter.isErrorCheckingDisabledForFile(saresult)) {
                fixes.add(new EnableErrorChecksFix(snapshot));
            }
            if (!HtmlErrorFilter.isErrorCheckingEnabledForMimetype(saresult)) {
                fixes.add(new EnableErrorChecksForMimetypeFix(saresult));
            }
            Hint hint = new Hint((Rule)new HtmlRule(HintSeverity.INFO, false), NbBundle.getMessage(HtmlHintsProvider.class, (String)"MSG_HINT_ENABLE_ERROR_CHECKS_FILE_DESCR"), fo, new OffsetRange(0, 0), fixes, 50);
            hints.add(hint);
        }
        String sourceMimetype = Utils.getWebPageMimeType(result.getSyntaxAnalyzerResult());
        for (HtmlExtension htmlExtension : HtmlExtensions.getRegisteredExtensions(sourceMimetype)) {
            htmlExtension.computeErrors(manager, context, hints, unhandled);
        }
    }

    static List<? extends org.netbeans.modules.html.editor.hints.HtmlRule> getSortedRules(HintsProvider.HintsManager manager, RuleContext context, boolean lineContext) {
        Map allHints = manager.getHints(lineContext, context);
        List ids = (List)allHints.get((Object)HtmlRule.Kinds.DEFAULT);
        if (ids == null) {
            return Collections.emptyList();
        }
        Collections.sort(ids, HTML_RULES_COMPARATOR);
        return ids;
    }

    public void cancel() {
    }

    public List<Rule> getBuiltinRules() {
        return null;
    }

    public RuleContext createRuleContext() {
        return new RuleContext();
    }

    private static HtmlRule getRule(Severity s) {
        switch (s) {
            case INFO: {
                return INFO_RULE;
            }
            case WARNING: {
                return WARNING_RULE;
            }
            case ERROR: {
                return ERROR_RULE;
            }
        }
        throw new AssertionError((Object)"Unexpected severity level");
    }

    private boolean isXmlBasedMimetype(SyntaxAnalyzerResult saresult) {
        String mimeType = Utils.getWebPageMimeType(saresult);
        return mimeType.indexOf("xml") != -1 || mimeType.indexOf("xhtml") != -1;
    }

    private static void reindexFile(final FileObject fo) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                IndexingManager.getDefault().refreshIndexAndWait(fo.getParent().toURL(), Collections.singleton(fo.toURL()), true, false);
            }
        });
    }

    private static void reindexActionItems() {
        RP.post(new Runnable(){

            @Override
            public void run() {
                IndexingManager.getDefault().refreshAllIndices("TLIndexer");
            }
        });
    }

    private static void refreshDocument(final FileObject fo) throws IOException {
        RP.post(new Runnable(){

            @Override
            public void run() {
                try {
                    DataObject dobj = DataObject.find((FileObject)fo);
                    EditorCookie editorCookie = (EditorCookie)dobj.getLookup().lookup(EditorCookie.class);
                    StyledDocument document = editorCookie.openDocument();
                    HtmlHintsProvider.forceReparse(document);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
    }

    private static void forceReparse(final Document doc) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NbEditorDocument nbdoc = (NbEditorDocument)doc;
                nbdoc.runAtomic(new Runnable(){

                    @Override
                    public void run() {
                        MutableTextInput mti = (MutableTextInput)doc.getProperty(MutableTextInput.class);
                        if (mti != null) {
                            mti.tokenHierarchyControl().rebuild();
                        }
                    }
                });
            }
        });
    }

    private static abstract class AbstractErrorChecksForMimetypeFix
    implements HintFix {
        protected Document doc;
        protected String mimeType;
        protected FileObject file;

        public AbstractErrorChecksForMimetypeFix(SyntaxAnalyzerResult result) {
            this.doc = result.getSource().getSnapshot().getSource().getDocument(false);
            this.file = result.getSource().getSourceFileObject();
            this.mimeType = Utils.getWebPageMimeType(result);
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }

    private static final class DisableErrorChecksFix
    implements HintFix {
        private Document doc;
        private FileObject fo;

        public DisableErrorChecksFix(Snapshot snapshot) {
            this.doc = snapshot.getSource().getDocument(false);
            this.fo = snapshot.getSource().getFileObject();
        }

        public String getDescription() {
            return NbBundle.getMessage(HtmlHintsProvider.class, (String)"MSG_HINT_DISABLE_ERROR_CHECKS_FILE");
        }

        public void implement() throws Exception {
            if (this.fo == null) {
                return;
            }
            this.fo.setAttribute("disable_error_checking", (Object)Boolean.TRUE);
            HtmlHintsProvider.reindexFile(this.fo);
            HtmlHintsProvider.refreshDocument(this.fo);
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }

    private static final class DisableErrorChecksForMimetypeFix
    extends AbstractErrorChecksForMimetypeFix {
        public DisableErrorChecksForMimetypeFix(SyntaxAnalyzerResult result) {
            super(result);
        }

        public String getDescription() {
            return NbBundle.getMessage(HtmlHintsProvider.class, (String)"MSG_HINT_DISABLE_ERROR_CHECKS_MIMETYPE", (Object)this.mimeType);
        }

        public void implement() throws Exception {
            HtmlPreferences.setHtmlErrorChecking(this.mimeType, false);
            HtmlHintsProvider.reindexActionItems();
            HtmlHintsProvider.reindexFile(this.file);
            HtmlHintsProvider.refreshDocument(this.file);
        }
    }

    private static final class EnableErrorChecksFix
    implements HintFix {
        private Document doc;
        private FileObject fo;

        public EnableErrorChecksFix(Snapshot snapshot) {
            this.doc = snapshot.getSource().getDocument(false);
            this.fo = snapshot.getSource().getFileObject();
        }

        public String getDescription() {
            return NbBundle.getMessage(HtmlHintsProvider.class, (String)"MSG_HINT_ENABLE_ERROR_CHECKS_FILE");
        }

        public void implement() throws Exception {
            if (this.fo == null) {
                return;
            }
            this.fo.setAttribute("disable_error_checking", null);
            HtmlHintsProvider.reindexFile(this.fo);
            HtmlHintsProvider.refreshDocument(this.fo);
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }

    private static final class EnableErrorChecksForMimetypeFix
    extends AbstractErrorChecksForMimetypeFix {
        public EnableErrorChecksForMimetypeFix(SyntaxAnalyzerResult result) {
            super(result);
        }

        public String getDescription() {
            return NbBundle.getMessage(HtmlHintsProvider.class, (String)"MSG_HINT_ENABLE_ERROR_CHECKS_MIMETYPE", (Object)this.mimeType);
        }

        public void implement() throws Exception {
            HtmlPreferences.setHtmlErrorChecking(this.mimeType, true);
            HtmlHintsProvider.reindexActionItems();
            HtmlHintsProvider.reindexFile(this.file);
            HtmlHintsProvider.refreshDocument(this.file);
        }
    }

    private static final class HtmlRule
    implements Rule.ErrorRule {
        private HintSeverity severity;
        private boolean showInTasklist;

        private HtmlRule(HintSeverity severity, boolean showInTaskList) {
            this.severity = severity;
            this.showInTasklist = showInTaskList;
        }

        public Set<?> getCodes() {
            return Collections.emptySet();
        }

        public boolean appliesTo(RuleContext context) {
            return true;
        }

        public String getDisplayName() {
            return "html";
        }

        public boolean showInTasklist() {
            return this.showInTasklist;
        }

        public HintSeverity getDefaultSeverity() {
            return this.severity;
        }
    }

    private static class SetDefaultHtmlVersionHintFix
    implements HintFix {
        private HtmlVersion version;
        private Document doc;
        private Project project;
        private boolean xhtml;

        public SetDefaultHtmlVersionHintFix(HtmlVersion version, Project project, Document doc, boolean xhtml) {
            this.version = version;
            this.project = project;
            this.doc = doc;
            this.xhtml = xhtml;
        }

        public String getDescription() {
            return NbBundle.getMessage(HtmlHintsProvider.class, (String)"MSG_SET_DEFAULT_HTML_VERSION", (Object)this.version.getDisplayName());
        }

        public void implement() throws Exception {
            ProjectDefaultHtmlSourceVersionController.setDefaultHtmlVersion(this.project, this.version, this.xhtml);
            HtmlHintsProvider.forceReparse(this.doc);
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }
}

