/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator.support;

import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.prefs.Preferences;
import javax.swing.UIManager;

public final class TermOptions {
    private static TermOptions DEFAULT;
    private static final String PREFIX = "term.";
    private boolean dirty = false;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private Preferences preferences;
    public static final String PROP_FONT = "font";
    public static final String PROP_FONT_STYLE = "fontStyle";
    public static final String PROP_FONT_FAMILY = "fontFamily";
    private Font font;
    public static final String PROP_FONT_SIZE = "fontSize";
    private int fontSize;
    public static final String PROP_FOREGROUND = "foreground";
    private Color foreground;
    public static final String PROP_BACKGROUND = "background";
    private Color background;
    public static final String PROP_SELECTION_BACKGROUND = "selectionBackground";
    private Color selectionBackground;
    public static final String PROP_HISTORY_SIZE = "historySize";
    private int historySize;
    public static final String PROP_TAB_SIZE = "tabSize";
    private int tabSize;
    public static final String PROP_SELECT_BY_WORD_DELIMITERS = "selectByWordDelimiters";
    private String selectByWordDelimiters;
    public static final String PROP_CLICK_TO_TYPE = "clickToType";
    private boolean clickToType;
    public static final String PROP_SCROLL_ON_INPUT = "scrollOnInput";
    private boolean scrollOnInput;
    public static final String PROP_SCROLL_ON_OUTPUT = "scrollOnOutput";
    private boolean scrollOnOutput;
    public static final String PROP_LINE_WRAP = "lineWrap";
    private boolean lineWrap;
    public static final String PROP_IGNORE_KEYMAP = "ignoreKeymap";
    private boolean ignoreKeymap;

    private TermOptions() {
        this.resetToDefault();
    }

    private TermOptions(TermOptions orig) {
        this.assign(orig);
    }

    public final void resetToDefault() {
        Font controlFont = UIManager.getFont("controlFont");
        this.fontSize = controlFont == null ? 12 : controlFont.getSize();
        this.font = new Font("monospaced", 0, this.fontSize);
        this.foreground = TermOptions.getDefaultColorStandard();
        this.background = TermOptions.getDefaultColorBackground();
        this.selectionBackground = TermOptions.getDefaultSelectionBackground();
        this.historySize = 5000;
        this.tabSize = 8;
        this.selectByWordDelimiters = "!$^*();<>\\[]{}|";
        this.clickToType = true;
        this.scrollOnInput = true;
        this.scrollOnOutput = true;
        this.lineWrap = true;
        this.ignoreKeymap = false;
        this.markDirty();
    }

    private static Color getDefaultColorStandard() {
        Color out = UIManager.getColor("nb.output.foreground");
        if (out == null && (out = UIManager.getColor("TextField.foreground")) == null) {
            out = Color.BLACK;
        }
        return out;
    }

    private static Color getDefaultColorBackground() {
        Color back = UIManager.getColor("nb.output.backgorund");
        if (back == null) {
            back = UIManager.getColor("TextField.background");
            if (back == null) {
                back = Color.WHITE;
            } else if ("Nimbus".equals(UIManager.getLookAndFeel().getName())) {
                back = new Color(back.getRGB());
            }
        }
        return back;
    }

    private static Color getDefaultSelectionBackground() {
        Color color = UIManager.getColor("TextArea.selectionBackground");
        if (color == null) {
            color = UIManager.getColor("textHighlight");
        }
        return color;
    }

    public static synchronized TermOptions getDefault(Preferences prefs) {
        if (DEFAULT == null) {
            DEFAULT = new TermOptions();
            DEFAULT.loadFrom(prefs);
        }
        return DEFAULT;
    }

    public TermOptions makeCopy() {
        return new TermOptions(this);
    }

    public void assign(TermOptions that) {
        this.preferences = that.preferences;
        this.font = that.font;
        this.fontSize = that.fontSize;
        this.tabSize = that.tabSize;
        this.historySize = that.historySize;
        this.foreground = that.foreground;
        this.background = that.background;
        this.selectionBackground = that.selectionBackground;
        this.selectByWordDelimiters = that.selectByWordDelimiters;
        this.clickToType = that.clickToType;
        this.scrollOnInput = that.scrollOnInput;
        this.scrollOnOutput = that.scrollOnOutput;
        this.lineWrap = that.lineWrap;
        this.ignoreKeymap = that.ignoreKeymap;
        this.dirty = false;
        this.pcs.firePropertyChange(null, null, null);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    void loadFrom(Preferences prefs) {
        if (prefs == null) {
            return;
        }
        this.preferences = prefs;
        String fontFamily = prefs.get("term.fontFamily", this.font.getFamily());
        int fontStyle = prefs.getInt("term.fontStyle", this.font.getStyle());
        this.fontSize = prefs.getInt("term.fontSize", this.fontSize);
        this.tabSize = prefs.getInt("term.tabSize", this.tabSize);
        this.historySize = prefs.getInt("term.historySize", this.historySize);
        this.selectByWordDelimiters = prefs.get("term.selectByWordDelimiters", this.selectByWordDelimiters);
        int foregroundRGB = prefs.getInt("term.foreground", this.foreground.getRGB());
        this.foreground = new Color(foregroundRGB);
        int backgroundRGB = prefs.getInt("term.background", this.background.getRGB());
        this.background = new Color(backgroundRGB);
        int selectionRGB = prefs.getInt("term.selectionBackground", this.selectionBackground.getRGB());
        this.selectionBackground = new Color(selectionRGB);
        this.clickToType = prefs.getBoolean("term.clickToType", this.clickToType);
        this.scrollOnInput = prefs.getBoolean("term.scrollOnInput", this.scrollOnInput);
        this.scrollOnOutput = prefs.getBoolean("term.scrollOnOutput", this.scrollOnOutput);
        this.lineWrap = prefs.getBoolean("term.lineWrap", this.lineWrap);
        this.ignoreKeymap = prefs.getBoolean("term.ignoreKeymap", this.ignoreKeymap);
        this.font = new Font(fontFamily, fontStyle, this.fontSize);
        if ("Dialog".equals(this.font.getFamily())) {
            this.font = new Font("Monospaced", fontStyle, this.fontSize);
        }
    }

    public void storeTo(Preferences prefs) {
        if (prefs == null) {
            return;
        }
        prefs.put("term.fontFamily", this.font.getFamily());
        prefs.putInt("term.fontStyle", this.font.getStyle());
        prefs.putInt("term.fontSize", this.fontSize);
        prefs.putInt("term.tabSize", this.tabSize);
        prefs.putInt("term.historySize", this.historySize);
        prefs.putInt("term.foreground", this.foreground.getRGB());
        prefs.putInt("term.background", this.background.getRGB());
        prefs.putInt("term.selectionBackground", this.selectionBackground.getRGB());
        prefs.put("term.selectByWordDelimiters", this.selectByWordDelimiters);
        prefs.putBoolean("term.clickToType", this.clickToType);
        prefs.putBoolean("term.scrollOnInput", this.scrollOnInput);
        prefs.putBoolean("term.scrollOnOutput", this.scrollOnOutput);
        prefs.putBoolean("term.lineWrap", this.lineWrap);
        prefs.putBoolean("term.ignoreKeymap", this.ignoreKeymap);
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
        this.fontSize = this.font.getSize();
        this.markDirty();
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
        this.font = new Font(this.font.getFamily(), this.font.getStyle(), this.fontSize);
        this.markDirty();
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color foreground) {
        this.foreground = foreground;
        this.markDirty();
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color background) {
        this.background = background;
        this.markDirty();
    }

    public Color getSelectionBackground() {
        return this.selectionBackground;
    }

    public void setSelectionBackground(Color selectionBackground) {
        this.selectionBackground = selectionBackground;
        this.markDirty();
    }

    public int getHistorySize() {
        return this.historySize;
    }

    public void setHistorySize(int historySize) {
        this.historySize = historySize;
        this.markDirty();
    }

    public int getTabSize() {
        return this.tabSize;
    }

    public void setTabSize(int tabSize) {
        this.tabSize = tabSize;
        this.markDirty();
    }

    public String getSelectByWordDelimiters() {
        return this.selectByWordDelimiters;
    }

    public void setSelectByWordDelimiters(String selectByWordDelimiters) {
        this.selectByWordDelimiters = selectByWordDelimiters;
        this.markDirty();
    }

    public boolean getClickToType() {
        return this.clickToType;
    }

    public void setClickToType(boolean clickToType) {
        this.clickToType = clickToType;
        this.markDirty();
    }

    public boolean getScrollOnInput() {
        return this.scrollOnInput;
    }

    public void setScrollOnInput(boolean scrollOnInput) {
        this.scrollOnInput = scrollOnInput;
        this.markDirty();
    }

    public boolean getScrollOnOutput() {
        return this.scrollOnOutput;
    }

    public void setScrollOnOutput(boolean scrollOnOutput) {
        this.scrollOnOutput = scrollOnOutput;
        this.markDirty();
    }

    public boolean getLineWrap() {
        return this.lineWrap;
    }

    public void setLineWrap(boolean lineWrap) {
        this.lineWrap = lineWrap;
        this.markDirty();
    }

    public boolean getIgnoreKeymap() {
        return this.ignoreKeymap;
    }

    public void setIgnoreKeymap(boolean ignoreKeymap) {
        this.ignoreKeymap = ignoreKeymap;
        this.markDirty();
    }

    private void markDirty() {
        this.pcs.firePropertyChange(null, null, null);
        if (this.preferences == null || !this.preferences.get("term.fontFamily", this.font.getFamily()).equals(this.font.getFamily()) || this.preferences.getInt("term.fontStyle", this.font.getStyle()) != this.font.getStyle() || this.preferences.getInt("term.fontSize", this.fontSize) != this.fontSize || this.preferences.getInt("term.tabSize", this.tabSize) != this.tabSize || this.preferences.getInt("term.historySize", this.historySize) != this.historySize || this.preferences.getInt("term.foreground", this.foreground.getRGB()) != this.foreground.getRGB() || this.preferences.getInt("term.background", this.background.getRGB()) != this.background.getRGB() || this.preferences.getInt("term.selectionBackground", this.selectionBackground.getRGB()) != this.selectionBackground.getRGB() || !this.preferences.get("term.selectByWordDelimiters", this.selectByWordDelimiters).equals(this.selectByWordDelimiters) || this.preferences.getBoolean("term.clickToType", this.clickToType) != this.clickToType || this.preferences.getBoolean("term.scrollOnInput", this.scrollOnInput) != this.scrollOnInput || this.preferences.getBoolean("term.scrollOnOutput", this.scrollOnOutput) != this.scrollOnOutput || this.preferences.getBoolean("term.lineWrap", this.lineWrap) != this.lineWrap || this.preferences.getBoolean("term.ignoreKeymap", this.ignoreKeymap) != this.ignoreKeymap) {
            this.dirty = true;
            return;
        }
        this.dirty = false;
    }
}

