/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator.support;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.lib.terminalemulator.support.Catalog;
import org.netbeans.lib.terminalemulator.support.TermOptionsPanel;

class FontPanel
extends JPanel {
    static final Color ERROR_COLOR = new Color(235, 0, 0);
    private static final boolean simulateSlowness = false;
    private JDialog containingJDialog;
    private JCheckBox showFixedCheckBox;
    private JTextField tfFont;
    private JTextField tfStyle;
    private JTextField tfSize;
    private JList<FontDescr> lFont;
    private JList<String> lStyle;
    private JList<Integer> lSize;
    private boolean dontSetValue = false;
    private static boolean showFixed = true;
    private static Fonts fonts;
    private String fontFamily;
    private int size = 12;
    private int style;
    private Font font = null;
    private String errorMsg = null;
    private Runnable continuation;
    private ProgressMonitor progressMonitor;
    private Cursor originalCursor;
    private Cursor waitCursor = Cursor.getPredefinedCursor(3);
    static final Integer[] sizes;
    static final String[] styles;
    private final ListSelectionListener lFontListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!FontPanel.this.lFont.isSelectionEmpty() && fonts.size() > 0) {
                int i = FontPanel.this.lFont.getSelectedIndex();
                String newFontName = fonts.get(i).name();
                if (!newFontName.equals(FontPanel.this.fontFamily)) {
                    FontPanel.this.tfFont.setText(newFontName);
                    FontPanel.this.setValue(null);
                }
            }
        }
    };

    private static boolean isFixedWidth(Component context, Font font) {
        FontMetrics metrics = context.getFontMetrics(font);
        int[] widths = metrics.getWidths();
        int Swidth = widths[0];
        for (int cx = 1; cx < widths.length; ++cx) {
            int width = widths[cx];
            if (width == 0 || Swidth == width) continue;
            return false;
        }
        return true;
    }

    private void setModal(boolean modal) {
        assert (this.containingJDialog() != null);
        if (modal) {
            this.originalCursor = this.containingJDialog().getCursor();
            this.containingJDialog().setCursor(this.waitCursor);
            this.containingJDialog().getGlassPane().setVisible(true);
            this.containingJDialog().getGlassPane().addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    e.consume();
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    e.consume();
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    e.consume();
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    e.consume();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    e.consume();
                }
            });
        } else {
            this.containingJDialog().setCursor(this.originalCursor);
            this.containingJDialog().getGlassPane().setVisible(false);
        }
    }

    private void gotFonts(Fonts fonts) {
        assert (SwingUtilities.isEventDispatchThread());
        if (fonts != null) {
            FontPanel.fonts = fonts;
        }
        this.progressMonitor.close();
        this.progressMonitor = null;
        this.setModal(false);
        if (this.continuation != null) {
            this.continuation.run();
        }
    }

    private void lFontListen(boolean listen) {
        if (listen) {
            this.lFont.addListSelectionListener(this.lFontListener);
        } else {
            this.lFont.removeListSelectionListener(this.lFontListener);
        }
    }

    FontPanel(Font font, TermOptionsPanel parent) {
        this.font = font;
        this.dontSetValue = false;
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(12, 12, 0, 11));
        if (font == null) {
            font = fonts != null && fonts.size() > 0 ? new Font(fonts.get(0).name(), 0, 10) : UIManager.getFont("Label.font");
        }
        this.size = font.getSize();
        this.style = font.getStyle();
        this.fontFamily = font.getFamily();
        if (fonts == null || fonts.size() == 1) {
            Fonts new_fonts = new Fonts();
            if (!font.getFamily().equals("Monospaced")) {
                new_fonts.add(new FontDescr(font.getFamily(), FontPanel.isFixedWidth(parent, font)));
            }
            fonts = new_fonts;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FontPanel.this.updateFontList();
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FontPanel.this.trackFont();
                }
            });
        }
        this.lFont = new JList<FontDescr>(fonts.toArray());
        this.lFont.setSelectionMode(0);
        this.lFont.getAccessibleContext().setAccessibleDescription("ACSD_CTL_Font");
        this.lFont.setCellRenderer(new MyListCellRenderer(this.lFont.getCellRenderer()));
        this.lStyle = new JList<String>(styles);
        this.lStyle.setSelectionMode(0);
        this.lStyle.getAccessibleContext().setAccessibleDescription("ACSD_CTL_FontStyle");
        this.lSize = new JList<Integer>(sizes);
        this.lSize.setSelectionMode(0);
        this.lSize.getAccessibleContext().setAccessibleDescription("ACSD_CTL_Size");
        this.tfSize = new JTextField(String.valueOf(font.getSize()));
        this.tfSize.getAccessibleContext().setAccessibleDescription(this.lSize.getAccessibleContext().getAccessibleDescription());
        this.getAccessibleContext().setAccessibleDescription("ACSD_FontCustomEditor");
        GridBagLayout la = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(la);
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.anchor = 17;
        c.insets = new Insets(0, 0, 10, 0);
        c.fill = 2;
        c.gridwidth = 0;
        this.showFixedCheckBox = new JCheckBox();
        this.showFixedCheckBox.setSelected(showFixed);
        this.showFixedCheckBox.setText(Catalog.get("LBL_FixedOnly"));
        this.showFixedCheckBox.setMnemonic(Catalog.get("MNM_FixedOnly").charAt(0));
        this.showFixedCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                showFixed = FontPanel.this.showFixedCheckBox.isSelected();
                FontPanel.this.updateFontList();
            }
        });
        this.add((Component)this.showFixedCheckBox, c);
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 0;
        c.gridwidth = 1;
        JLabel l = new JLabel();
        l.setText(Catalog.get("LBL_Font"));
        l.setDisplayedMnemonic(Catalog.mnemonic("MNM_Font"));
        l.setLabelFor(this.lFont);
        la.setConstraints(l, c);
        this.add(l);
        c.insets = new Insets(0, 5, 0, 0);
        l = new JLabel();
        l.setText(Catalog.get("LBL_FontStyle"));
        l.setDisplayedMnemonic(Catalog.mnemonic("MNM_FontStyle"));
        l.setLabelFor(this.lStyle);
        la.setConstraints(l, c);
        this.add(l);
        c.insets = new Insets(0, 5, 0, 0);
        c.gridwidth = 0;
        l = new JLabel();
        l.setText(Catalog.get("LBL_Size"));
        l.setDisplayedMnemonic(Catalog.mnemonic("MNM_Size"));
        l.setLabelFor(this.tfSize);
        la.setConstraints(l, c);
        this.add(l);
        c.insets = new Insets(5, 0, 0, 0);
        c.gridwidth = 1;
        c.fill = 2;
        this.tfFont = new JTextField(font.getFamily());
        this.tfFont.setEnabled(false);
        la.setConstraints(this.tfFont, c);
        this.add(this.tfFont);
        c.insets = new Insets(5, 5, 0, 0);
        this.tfStyle = new JTextField(Catalog.get(parent.getStyleName(font.getStyle())));
        this.tfStyle.setEnabled(false);
        la.setConstraints(this.tfStyle, c);
        this.add(this.tfStyle);
        c.insets = new Insets(5, 5, 0, 0);
        c.gridwidth = 0;
        this.tfSize.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    FontPanel.this.setValue(null);
                }
            }
        });
        this.tfSize.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                if (FontPanel.this.dontSetValue) {
                    return;
                }
                FontPanel.this.dontSetValue = true;
                Component c = evt.getOppositeComponent();
                if (c != null) {
                    if (c instanceof JButton) {
                        if (((JButton)c).getText().equals("CTL_OK")) {
                            FontPanel.this.setValue(null);
                        }
                    } else {
                        FontPanel.this.setValue(null);
                    }
                }
            }

            @Override
            public void focusGained(FocusEvent evt) {
                FontPanel.this.dontSetValue = false;
            }
        });
        la.setConstraints(this.tfSize, c);
        this.add(this.tfSize);
        c.gridwidth = 1;
        c.insets = new Insets(5, 0, 0, 0);
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.lFont.setVisibleRowCount(5);
        this.lFontListen(true);
        JScrollPane sp = new JScrollPane(this.lFont);
        sp.setVerticalScrollBarPolicy(22);
        la.setConstraints(sp, c);
        this.add(sp);
        this.style = font.getStyle();
        this.lStyle.setVisibleRowCount(5);
        this.lStyle.setSelectedValue(parent.getStyleName(this.style), true);
        this.lStyle.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int i;
                String newStyleName;
                if (!FontPanel.this.lStyle.isSelectionEmpty() && !(newStyleName = styles[i = FontPanel.this.lStyle.getSelectedIndex()]).equals(FontPanel.this.tfStyle.getText())) {
                    FontPanel.this.tfStyle.setText(styles[i]);
                    FontPanel.this.setValue(null);
                }
            }
        });
        sp = new JScrollPane(this.lStyle);
        sp.setVerticalScrollBarPolicy(22);
        c.insets = new Insets(5, 5, 0, 0);
        la.setConstraints(sp, c);
        this.add(sp);
        c.gridwidth = 0;
        this.lSize.getAccessibleContext().setAccessibleName(this.tfSize.getAccessibleContext().getAccessibleName());
        this.lSize.setVisibleRowCount(5);
        this.updateSizeList(font.getSize());
        this.lSize.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!FontPanel.this.lSize.isSelectionEmpty()) {
                    int i = FontPanel.this.lSize.getSelectedIndex();
                    FontPanel.this.tfSize.setText(String.valueOf(sizes[i]));
                    FontPanel.this.setValue(null);
                }
            }
        });
        sp = new JScrollPane(this.lSize);
        sp.setVerticalScrollBarPolicy(22);
        c.insets = new Insets(5, 5, 0, 0);
        la.setConstraints(sp, c);
        this.add(sp);
        c.gridwidth = 0;
        c.weighty = 2.0;
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(new TitledBorder(" " + Catalog.get("CTL_Preview") + " "));
        JPanel pp = new JPanel(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(150, 60);
            }

            @Override
            public void paint(Graphics g) {
                FontPanel.this.paintValue(g, new Rectangle(0, 0, this.getSize().width - 1, this.getSize().height - 1), FontPanel.this.font(), Catalog.get("MSG_Sample"), FontPanel.this.errorMsg);
            }
        };
        p.add("Center", pp);
        c.insets = new Insets(12, 0, 0, 0);
        la.setConstraints(p, c);
        this.add(p);
    }

    private JDialog containingJDialog() {
        if (this.containingJDialog == null) {
            Container dialogCandidate;
            for (dialogCandidate = this; dialogCandidate != null && !(dialogCandidate instanceof JDialog); dialogCandidate = dialogCandidate.getParent()) {
            }
            this.containingJDialog = dialogCandidate == null ? null : (JDialog)dialogCandidate;
        }
        return this.containingJDialog;
    }

    private void updateFontList() {
        Runnable whenDone;
        this.continuation = whenDone = new Runnable(){

            @Override
            public void run() {
                FontPanel.this.fontListUpdated();
            }
        };
        this.setModal(true);
        final GetFontsWorker worker = new GetFontsWorker(this, showFixed, this.size, this.style);
        this.progressMonitor = new ProgressMonitor(this, Catalog.get("MSG_TakingInventory"), " ", 0, 2);
        this.progressMonitor.setProgress(1);
        worker.addPropertyChangeListener(new PropertyChangeListener(){

            private boolean ckCancel() {
                if (worker.isCancelled()) {
                    return true;
                }
                if (FontPanel.this.progressMonitor == null || FontPanel.this.progressMonitor.isCanceled()) {
                    boolean withInterrupts = true;
                    worker.cancel(withInterrupts);
                    return true;
                }
                return false;
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                switch (evt.getPropertyName()) {
                    case "progress": {
                        if (this.ckCancel()) {
                            return;
                        }
                        FontPanel.this.progressMonitor.setProgress((Integer)evt.getNewValue());
                        break;
                    }
                    case "nfonts": {
                        if (this.ckCancel()) {
                            return;
                        }
                        FontPanel.this.progressMonitor.setNote(Catalog.get("MSG_CheckingFixedWidth"));
                        FontPanel.this.progressMonitor.setMaximum((Integer)evt.getNewValue());
                    }
                }
            }
        });
        worker.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fontListUpdated() {
        assert (SwingUtilities.isEventDispatchThread());
        try {
            this.lFontListen(false);
            this.lFont.setListData((FontDescr[])fonts.toArray());
            this.trackFont();
        }
        finally {
            this.lFontListen(true);
        }
    }

    private void trackFont() {
        String err;
        this.fontFamily = this.font.getFamily();
        this.lFont.setSelectedValue(fonts.descrByName(this.fontFamily), true);
        int is = this.lFont.getSelectedIndex();
        if (is == -1) {
            String fallbackFontFamily = fonts.get(0).name();
            err = Catalog.format("FMT_FontUnavailable", this.fontFamily, fallbackFontFamily);
            this.fontFamily = fallbackFontFamily;
            this.lFont.setSelectedValue(fonts.get(0), true);
            this.tfFont.setText(this.fontFamily);
            this.font = new Font(this.fontFamily, this.style, this.size);
        } else {
            err = null;
        }
        this.setValue(err);
    }

    public Font font() {
        return this.font;
    }

    public void paintValue(Graphics g, Rectangle rectangle, Font font, String sample, String errorMsg) {
        Font paintFont;
        Font originalFont = g.getFont();
        Font font2 = paintFont = font == null ? originalFont : font;
        assert (paintFont != null) : "paintFont must exist.";
        FontMetrics fm = g.getFontMetrics(paintFont);
        if (fm.getHeight() > rectangle.height) {
            paintFont = paintFont.deriveFont(12.0f);
            fm = g.getFontMetrics(paintFont);
        }
        g.setFont(paintFont);
        int height = (rectangle.height - fm.getHeight()) / 2 + fm.getAscent();
        g.drawString(sample == null ? "null" : sample, rectangle.x, rectangle.y + height);
        if (errorMsg != null) {
            Color originalColor = g.getColor();
            g.setColor(ERROR_COLOR);
            g.drawString(errorMsg, rectangle.x, rectangle.y + height + fm.getAscent());
            g.setColor(originalColor);
        }
        g.setFont(originalFont);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(400, 350);
    }

    private void updateSizeList(int size) {
        if (Arrays.asList(sizes).contains(size)) {
            this.lSize.setSelectedValue(size, true);
        } else {
            this.lSize.clearSelection();
        }
    }

    private void setValue(String errorMsg) {
        int oldSize = this.size;
        this.size = 12;
        this.size = Integer.parseInt(this.tfSize.getText());
        if (this.size <= 0) {
            IllegalArgumentException iae = new IllegalArgumentException();
            throw iae;
        }
        this.updateSizeList(this.size);
        boolean sizeChanged = this.size != oldSize;
        int oldStyle = this.style;
        int i = this.lStyle.getSelectedIndex();
        this.style = 0;
        switch (i) {
            case 0: {
                this.style = 0;
                break;
            }
            case 1: {
                this.style = 1;
                break;
            }
            case 2: {
                this.style = 2;
                break;
            }
            case 3: {
                this.style = 3;
            }
        }
        boolean styleChanged = this.style != oldStyle;
        this.fontFamily = this.tfFont.getText();
        if (sizeChanged || styleChanged) {
            this.errorMsg = errorMsg;
            this.updateFontList();
        } else {
            this.errorMsg = errorMsg;
        }
        this.font = new Font(this.fontFamily, this.style, this.size);
        this.invalidate();
        Container p = this.getParent();
        if (p != null) {
            ((Component)p).validate();
        }
        this.repaint();
    }

    static {
        sizes = new Integer[]{3, 5, 8, 10, 12, 14, 18, 24, 36, 48};
        styles = new String[]{Catalog.get("CTL_Plain"), Catalog.get("CTL_Bold"), Catalog.get("CTL_Italic"), Catalog.get("CTL_BoldItalic")};
    }

    private static class FontDescr {
        private String name;
        private boolean isFixed;

        public FontDescr(String name, boolean isFixed) {
            this.name = name;
            this.isFixed = isFixed;
        }

        public String toString() {
            return this.name;
        }

        public String name() {
            return this.name;
        }

        public boolean isFixed() {
            return this.isFixed;
        }
    }

    private static final class Fonts {
        private final List<FontDescr> fonts = new ArrayList<FontDescr>();

        public Fonts() {
            this.add(new FontDescr("Monospaced", true));
        }

        public FontDescr[] toArray() {
            return this.fonts.toArray(new FontDescr[this.fonts.size()]);
        }

        public FontDescr descrByName(String fontName) {
            for (FontDescr fontDescr : this.fonts) {
                if (!fontDescr.name().equals(fontName)) continue;
                return fontDescr;
            }
            return null;
        }

        public void add(FontDescr fontDescr) {
            this.fonts.add(fontDescr);
        }

        public FontDescr get(int x) {
            return this.fonts.get(x);
        }

        public int size() {
            return this.fonts.size();
        }
    }

    private class GetFontsWorker
    extends SwingWorker<Fonts, Object> {
        public static final String PROP_NFONTS = "nfonts";
        private final Component comp;
        private final boolean showFixed;
        private final int size;
        private final int style;
        private Fonts result;

        public GetFontsWorker(Component comp, boolean showFixed, int size, int style) {
            this.comp = comp;
            this.showFixed = showFixed;
            this.size = size;
            this.style = style;
        }

        @Override
        protected Fonts doInBackground() throws Exception {
            String[] fontNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
            this.firePropertyChange(PROP_NFONTS, null, fontNames.length);
            this.result = new Fonts();
            for (int fx = 0; fx < fontNames.length && !this.isCancelled(); ++fx) {
                Font f = new Font(fontNames[fx], this.style, this.size);
                boolean isFixedWidth = FontPanel.isFixedWidth(this.comp, f);
                if (this.showFixed) {
                    if (isFixedWidth) {
                        this.result.add(new FontDescr(fontNames[fx], isFixedWidth));
                    }
                } else {
                    this.result.add(new FontDescr(fontNames[fx], isFixedWidth));
                }
                this.setProgress(100 * fx / fontNames.length);
            }
            return this.result;
        }

        @Override
        protected void done() {
            Fonts fonts = null;
            try {
                fonts = (Fonts)this.get();
            }
            catch (InterruptedException | ExecutionException ex) {
                Logger.getLogger(FontPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (CancellationException cancellationException) {
                // empty catch block
            }
            FontPanel.this.gotFonts(fonts);
        }
    }

    static class MyListCellRenderer
    implements ListCellRenderer<FontDescr> {
        private final ListCellRenderer<? super FontDescr> delegate;

        MyListCellRenderer(ListCellRenderer<? super FontDescr> delegate) {
            this.delegate = delegate;
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends FontDescr> list, FontDescr value, int index, boolean isSelected, boolean cellHasFocus) {
            FontDescr fd = value;
            Component c = this.delegate.getListCellRendererComponent(list, fd, index, isSelected, cellHasFocus);
            if (fd.isFixed()) {
                c.setForeground(Color.BLACK);
            } else {
                c.setForeground(Color.GRAY);
            }
            return c;
        }
    }
}

