/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator;

import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import org.netbeans.lib.terminalemulator.AbstractInterp;
import org.netbeans.lib.terminalemulator.InterpProtoANSI;
import org.netbeans.lib.terminalemulator.Ops;

class InterpProtoANSIX
extends InterpProtoANSI {
    protected String text = null;
    private InterpTypeProtoANSIX type;
    private static final InterpTypeProtoANSIX type_singleton = new InterpTypeProtoANSIX();
    private boolean DECCKM;
    private boolean DECPAM;

    public InterpProtoANSIX(Ops ops) {
        super(ops, type_singleton);
        this.type = type_singleton;
        this.setup();
    }

    protected InterpProtoANSIX(Ops ops, InterpTypeProtoANSIX type) {
        super(ops, type);
        this.type = type;
        this.setup();
    }

    @Override
    public String name() {
        return "proto-ansi-x";
    }

    @Override
    public void reset() {
        super.reset();
        this.text = null;
    }

    private void setup() {
    }

    private static boolean numLock() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        try {
            return toolkit.getLockingKeyState(144);
        }
        catch (UnsupportedOperationException x) {
            return false;
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        boolean pam = this.DECPAM && !InterpProtoANSIX.numLock();
        switch (e.getKeyCode()) {
            case 155: {
                this.sendChars(e, "\u001b[2~");
                break;
            }
            case 127: {
                this.sendChars(e, "\u001b[3~");
                break;
            }
            case 33: {
                this.sendChars(e, "\u001b[5~");
                break;
            }
            case 34: {
                this.sendChars(e, "\u001b[6~");
                break;
            }
            case 36: {
                this.sendChars(e, this.DECCKM ? "\u001bOH" : "\u001b[H");
                break;
            }
            case 35: {
                this.sendChars(e, this.DECCKM ? "\u001bOF" : "\u001b[F");
                break;
            }
            case 38: {
                this.sendChars(e, this.DECCKM ? "\u001bOA" : "\u001b[A");
                break;
            }
            case 40: {
                this.sendChars(e, this.DECCKM ? "\u001bOB" : "\u001b[B");
                break;
            }
            case 39: {
                this.sendChars(e, this.DECCKM ? "\u001bOC" : "\u001b[C");
                break;
            }
            case 37: {
                this.sendChars(e, this.DECCKM ? "\u001bOD" : "\u001b[D");
                break;
            }
            case 112: {
                this.sendChars(e, "\u001bOP");
                break;
            }
            case 113: {
                this.sendChars(e, "\u001bOQ");
                break;
            }
            case 114: {
                this.sendChars(e, "\u001bOR");
                break;
            }
            case 115: {
                this.sendChars(e, "\u001bOS");
                break;
            }
            case 116: {
                this.sendChars(e, "\u001b[15~");
                break;
            }
            case 117: {
                this.sendChars(e, "\u001b[17~");
                break;
            }
            case 118: {
                this.sendChars(e, "\u001b[18~");
                break;
            }
            case 119: {
                this.sendChars(e, "\u001b[19~");
                break;
            }
            case 120: {
                this.sendChars(e, "\u001b[20~");
                break;
            }
            case 121: {
                this.sendChars(e, "\u001b[21~");
                break;
            }
            case 122: {
                this.sendChars(e, "\u001b[23~");
                break;
            }
            case 123: {
                this.sendChars(e, "\u001b[24~");
                break;
            }
            case 111: {
                this.sendChars(e, pam ? "\u001bOo" : "/");
                break;
            }
            case 106: {
                this.sendChars(e, pam ? "\u001bOj" : "*");
                break;
            }
            case 109: {
                this.sendChars(e, pam ? "\u001bOm" : "-");
                break;
            }
            case 107: {
                this.sendChars(e, pam ? "\u001bOk" : "+");
                break;
            }
            case 96: {
                this.sendChars(e, "0");
                break;
            }
            case 97: {
                this.sendChars(e, "1");
                break;
            }
            case 98: {
                this.sendChars(e, "2");
                break;
            }
            case 99: {
                this.sendChars(e, "3");
                break;
            }
            case 100: {
                this.sendChars(e, "4");
                break;
            }
            case 101: {
                this.sendChars(e, "5");
                break;
            }
            case 102: {
                this.sendChars(e, "6");
                break;
            }
            case 103: {
                this.sendChars(e, "7");
                break;
            }
            case 104: {
                this.sendChars(e, "8");
                break;
            }
            case 105: {
                this.sendChars(e, "9");
                break;
            }
            case 110: {
                this.sendChars(e, ".");
                break;
            }
            case 65368: {
                this.sendChars(e, "\u001b[E");
                break;
            }
            case 224: {
                this.sendChars(e, "\u001b[A");
                break;
            }
            case 225: {
                this.sendChars(e, "\u001b[B");
                break;
            }
            case 226: {
                this.sendChars(e, "\u001b[D");
                break;
            }
            case 227: {
                this.sendChars(e, "\u001b[C");
            }
        }
    }

    @Override
    public char mapACS(char inChar) {
        switch (inChar) {
            default: {
                return '\u0000';
            }
            case '+': {
                return inChar;
            }
            case ',': {
                return inChar;
            }
            case '-': {
                return inChar;
            }
            case '.': {
                return inChar;
            }
            case '0': {
                return inChar;
            }
            case '`': {
                return inChar;
            }
            case 'a': {
                return inChar;
            }
            case 'f': {
                return inChar;
            }
            case 'g': {
                return inChar;
            }
            case 'h': {
                return inChar;
            }
            case 'j': {
                return inChar;
            }
            case 'k': {
                return inChar;
            }
            case 'l': {
                return inChar;
            }
            case 'm': {
                return inChar;
            }
            case 'n': {
                return inChar;
            }
            case 'o': {
                return inChar;
            }
            case 'q': {
                return inChar;
            }
            case 's': {
                return inChar;
            }
            case 't': {
                return inChar;
            }
            case 'u': {
                return inChar;
            }
            case 'v': {
                return inChar;
            }
            case 'w': {
                return inChar;
            }
            case 'x': {
                return inChar;
            }
            case 'y': {
                return inChar;
            }
            case 'z': {
                return inChar;
            }
            case '{': {
                return inChar;
            }
            case '|': {
                return inChar;
            }
            case '}': {
                return inChar;
            }
            case '~': 
        }
        return inChar;
    }

    @Override
    public void softReset() {
        this.DECCKM = false;
        this.DECPAM = false;
    }

    protected static class InterpTypeProtoANSIX
    extends InterpProtoANSI.InterpTypeProtoANSI {
        protected final AbstractInterp.State st_wait = new AbstractInterp.State("wait");
        protected final AbstractInterp.State st_esc_rb = new AbstractInterp.State("esc_rb");
        protected final AbstractInterp.State st_esc_rb_N = new AbstractInterp.State("esc_rb_N");
        protected final AbstractInterp.State st_esc_lb_q = new AbstractInterp.State("esc_lb_q");
        protected final AbstractInterp.State st_esc_lb_b = new AbstractInterp.State("esc_lb_b");
        protected final AbstractInterp.Actor act_ind = new ACT_IND();
        protected final AbstractInterp.Actor act_start_collect = new ACT_START_COLLECT();
        protected final AbstractInterp.Actor act_collect = new ACT_COLLECT();
        protected final AbstractInterp.Actor act_done_collect_bel = new ACT_DONE_COLLECT_BEL();
        protected final AbstractInterp.Actor act_DEC_private = new ACT_DEC_PRIVATE();

        protected InterpTypeProtoANSIX() {
            char c;
            this.st_esc.setAction('7', this.st_base, new ACT_SC());
            this.st_esc.setAction('8', this.st_base, new ACT_RC());
            this.st_esc.setAction('>', this.st_base, new ACT_PNM());
            this.st_esc.setAction('=', this.st_base, new ACT_PAM());
            this.st_esc.setAction('D', this.st_base, this.act_ind);
            this.st_esc.setAction(']', this.st_esc_rb, this.act_start_collect);
            for (c = '0'; c <= '9'; c = (char)(c + '\u0001')) {
                this.st_esc_rb.setAction(c, this.st_esc_rb_N, this.act_collect);
            }
            for (c = '\u0000'; c < '\u0080'; c = (char)(c + '\u0001')) {
                this.st_esc_rb_N.setAction(c, this.st_esc_rb_N, this.act_collect);
            }
            this.st_esc_rb_N.setAction('\u0007', this.st_base, this.act_done_collect_bel);
            this.st_esc_lb.setAction('?', this.st_esc_lb_q, this.act_reset_number);
            for (c = '0'; c <= '9'; c = (char)(c + '\u0001')) {
                this.st_esc_lb_q.setAction(c, this.st_esc_lb_q, this.act_remember_digit);
            }
            this.st_esc_lb_q.setAction(';', this.st_esc_lb_q, this.act_push_number);
            this.st_esc_lb_q.setAction('h', this.st_base, this.act_DEC_private);
            this.st_esc_lb_q.setAction('l', this.st_base, this.act_DEC_private);
            this.st_esc_lb_q.setAction('r', this.st_base, this.act_DEC_private);
            this.st_esc_lb_q.setAction('s', this.st_base, this.act_DEC_private);
            this.st_esc_lb.setAction('!', this.st_esc_lb_b, this.act_reset_number);
            this.st_esc_lb_b.setAction('p', this.st_base, new ACT_DEC_STR());
        }

        static final class ACT_COLLECT
        implements AbstractInterp.Actor {
            ACT_COLLECT() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                InterpProtoANSIX i = (InterpProtoANSIX)ai;
                i.text = i.text + c;
                return null;
            }
        }

        static final class ACT_DEC_PRIVATE
        implements AbstractInterp.Actor {
            ACT_DEC_PRIVATE() {
            }

            private static String decPrivateSet(AbstractInterp ai, char c, int n) {
                switch (n) {
                    case 1: {
                        ((InterpProtoANSIX)ai).DECCKM = true;
                        break;
                    }
                    case 5: {
                        ai.ops.op_reverse(true);
                        break;
                    }
                    case 12: {
                        break;
                    }
                    case 25: {
                        ai.ops.op_cursor_visible(true);
                        break;
                    }
                    default: {
                        return "act_DEC_private: unrecognized code " + n;
                    }
                }
                return null;
            }

            private static String decPrivateReset(AbstractInterp ai, char c, int n) {
                switch (n) {
                    case 1: {
                        ((InterpProtoANSIX)ai).DECCKM = false;
                        break;
                    }
                    case 5: {
                        ai.ops.op_reverse(false);
                        break;
                    }
                    case 12: {
                        break;
                    }
                    case 25: {
                        ai.ops.op_cursor_visible(false);
                        break;
                    }
                    default: {
                        return "act_DEC_private: unrecognized code " + n;
                    }
                }
                return null;
            }

            private static String decPrivateSave(AbstractInterp ai, char c, int n) {
                return "act_DEC_private: unrecognized code " + n;
            }

            private static String decPrivateRestore(AbstractInterp ai, char c, int n) {
                return "act_DEC_private: unrecognized code " + n;
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                if (ai.noNumber()) {
                    return "act_DEC_private: no number";
                }
                int nx = 0;
                if (nx <= ai.nNumbers()) {
                    int n = ai.numberAt(nx);
                    switch (c) {
                        case 'h': {
                            return ACT_DEC_PRIVATE.decPrivateSet(ai, c, n);
                        }
                        case 'l': {
                            return ACT_DEC_PRIVATE.decPrivateReset(ai, c, n);
                        }
                        case 'r': {
                            return ACT_DEC_PRIVATE.decPrivateRestore(ai, c, n);
                        }
                        case 's': {
                            return ACT_DEC_PRIVATE.decPrivateSave(ai, c, n);
                        }
                    }
                    return "act_DEC_private: unrecognized cmd " + c;
                }
                return null;
            }
        }

        protected static final class ACT_DEC_STR
        implements AbstractInterp.Actor {
            protected ACT_DEC_STR() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                ai.ops.op_soft_reset();
                return null;
            }
        }

        static final class ACT_DONE_COLLECT_BEL
        implements AbstractInterp.Actor {
            ACT_DONE_COLLECT_BEL() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                InterpProtoANSIX i = (InterpProtoANSIX)ai;
                int semix = i.text.indexOf(59);
                if (semix == -1) {
                    return null;
                }
                String p1 = i.text.substring(0, semix);
                String p2 = i.text.substring(semix + 1);
                int code = Integer.parseInt(p1);
                switch (code) {
                    case 0: {
                        ai.ops.op_icon_name(p2);
                        ai.ops.op_win_title(p2);
                        break;
                    }
                    case 1: {
                        ai.ops.op_icon_name(p2);
                        break;
                    }
                    case 2: {
                        ai.ops.op_win_title(p2);
                        break;
                    }
                    case 3: {
                        ai.ops.op_cwd(p2);
                        break;
                    }
                    case 10: {
                        int semix2 = p2.indexOf(59);
                        if (semix == -1) {
                            return null;
                        }
                        String p3 = p2.substring(semix2 + 1);
                        p2 = p2.substring(0, semix2);
                        ai.ops.op_hyperlink(p2, p3);
                    }
                }
                return null;
            }
        }

        static final class ACT_IND
        implements AbstractInterp.Actor {
            ACT_IND() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                ai.ops.op_ind(1);
                return null;
            }
        }

        static final class ACT_PAM
        implements AbstractInterp.Actor {
            ACT_PAM() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                ((InterpProtoANSIX)ai).DECPAM = true;
                return null;
            }
        }

        static final class ACT_PNM
        implements AbstractInterp.Actor {
            ACT_PNM() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                ((InterpProtoANSIX)ai).DECPAM = false;
                return null;
            }
        }

        static final class ACT_RC
        implements AbstractInterp.Actor {
            ACT_RC() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                ai.ops.op_rc();
                return null;
            }
        }

        static final class ACT_SC
        implements AbstractInterp.Actor {
            ACT_SC() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                ai.ops.op_sc();
                return null;
            }
        }

        static final class ACT_START_COLLECT
        implements AbstractInterp.Actor {
            ACT_START_COLLECT() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                InterpProtoANSIX i = (InterpProtoANSIX)ai;
                i.text = "";
                return null;
            }
        }
    }
}

