/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator;

import org.netbeans.lib.terminalemulator.AbstractInterp;
import org.netbeans.lib.terminalemulator.InterpDumb;
import org.netbeans.lib.terminalemulator.Ops;

class InterpProtoANSI
extends InterpDumb {
    private InterpTypeProtoANSI type;
    private static final InterpTypeProtoANSI type_singleton = new InterpTypeProtoANSI();
    private char rememberedChar;

    public InterpProtoANSI(Ops ops) {
        super(ops, type_singleton);
        this.type = type_singleton;
        this.setup();
    }

    protected InterpProtoANSI(Ops ops, InterpTypeProtoANSI type) {
        super(ops, type);
        this.type = type;
        this.setup();
    }

    @Override
    public String name() {
        return "proto-ansi";
    }

    @Override
    public void reset() {
        super.reset();
    }

    protected boolean dispatchAttr(AbstractInterp ai, int n) {
        return false;
    }

    private void setup() {
        this.state = this.type.st_base;
    }

    protected static class Ascii {
        public static final char ESC = '\u001b';
        public static final char CTRL_N = '\u000e';
        public static final char CTRL_O = '\u000f';

        protected Ascii() {
        }
    }

    protected static class InterpTypeProtoANSI
    extends InterpDumb.InterpTypeDumb {
        protected final AbstractInterp.Actor act_reset_number = new ACT_RESET_NUMBER();
        protected final AbstractInterp.Actor act_remember_digit = new ACT_REMEMBER_DIGIT();
        protected final AbstractInterp.Actor act_push_number = new ACT_PUSH_NUMBER();
        protected final AbstractInterp.Actor act_remember1 = new ACT_REMEMBER1();
        protected final AbstractInterp.Actor act_setg = new ACT_SETG();
        protected final AbstractInterp.State st_esc = new AbstractInterp.State("esc");
        protected final AbstractInterp.State st_esc_lb = new AbstractInterp.State("esc_lb");
        protected final AbstractInterp.State st_esc_setg = new AbstractInterp.State("esc_setg");

        protected InterpTypeProtoANSI() {
            this.st_base.setAction('\u001b', this.st_esc, new ACT_TO_ESC());
            this.st_base.setAction('\u000e', this.st_base, new ACT_AS());
            this.st_base.setAction('\u000f', this.st_base, new ACT_AE());
            this.st_esc.setRegular(this.st_esc, this.act_regular);
            this.st_esc.setAction('M', this.st_base, new ACT_M());
            this.st_esc.setAction('c', this.st_base, new ACT_FULL_RESET());
            this.st_esc.setAction('n', this.st_base, new ACT_LS2());
            this.st_esc.setAction('o', this.st_base, new ACT_LS3());
            this.st_esc.setAction('(', this.st_esc_setg, this.act_remember1);
            this.st_esc.setAction(')', this.st_esc_setg, this.act_remember1);
            this.st_esc.setAction('*', this.st_esc_setg, this.act_remember1);
            this.st_esc.setAction('+', this.st_esc_setg, this.act_remember1);
            this.st_esc_setg.setAction('B', this.st_base, this.act_setg);
            this.st_esc_setg.setAction('0', this.st_base, this.act_setg);
            this.st_esc.setAction('[', this.st_esc_lb, this.act_reset_number);
            this.st_esc_lb.setRegular(this.st_esc_lb, this.act_regular);
            for (char c = '0'; c <= '9'; c = (char)(c + '\u0001')) {
                this.st_esc_lb.setAction(c, this.st_esc_lb, this.act_remember_digit);
            }
            this.st_esc_lb.setAction(';', this.st_esc_lb, this.act_push_number);
            this.st_esc_lb.setAction('A', this.st_base, new ACT_UP());
            this.st_esc_lb.setAction('B', this.st_base, new ACT_CUD());
            this.st_esc_lb.setAction('C', this.st_base, new ACT_ND());
            this.st_esc_lb.setAction('D', this.st_base, new ACT_BC());
            this.st_esc_lb.setAction('G', this.st_base, new ACT_CHA());
            this.st_esc_lb.setAction('H', this.st_base, new ACT_HO());
            this.st_esc_lb.setAction('I', this.st_base, new ACT_CHT());
            this.st_esc_lb.setAction('J', this.st_base, new ACT_J());
            this.st_esc_lb.setAction('K', this.st_base, new ACT_K());
            this.st_esc_lb.setAction('L', this.st_base, new ACT_AL());
            this.st_esc_lb.setAction('M', this.st_base, new ACT_DL());
            this.st_esc_lb.setAction('P', this.st_base, new ACT_DC());
            this.st_esc_lb.setAction('X', this.st_base, new ACT_ECH());
            this.st_esc_lb.setAction('Z', this.st_base, new ACT_CBT());
            this.st_esc_lb.setAction('@', this.st_base, new ACT_IC());
            this.st_esc_lb.setAction('d', this.st_base, new ACT_VPA());
            this.st_esc_lb.setAction('h', this.st_base, new ACT_SM());
            this.st_esc_lb.setAction('l', this.st_base, new ACT_RM());
            this.st_esc_lb.setAction('m', this.st_base, new ACT_ATTR());
            this.st_esc_lb.setAction('n', this.st_base, new ACT_DSR());
            this.st_esc_lb.setAction('r', this.st_base, new ACT_MARGIN());
        }

        static final class ACT_AE
        implements AbstractInterp.Actor {
            ACT_AE() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                ai.ops.op_ae();
                return null;
            }
        }

        static final class ACT_AL
        implements AbstractInterp.Actor {
            ACT_AL() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                if (ai.noNumber()) {
                    ai.ops.op_al(1);
                } else {
                    ai.ops.op_al(ai.numberAt(0));
                }
                return null;
            }
        }

        static final class ACT_AS
        implements AbstractInterp.Actor {
            ACT_AS() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                ai.ops.op_as();
                return null;
            }
        }

        static final class ACT_ATTR
        implements AbstractInterp.Actor {
            ACT_ATTR() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                if (ai.noNumber()) {
                    ai.ops.op_attr(0);
                } else {
                    for (int n = 0; n <= ai.nNumbers(); ++n) {
                        int attr = ai.numberAt(n);
                        if (((InterpProtoANSI)ai).dispatchAttr(ai, attr)) continue;
                        return "ACT_ATTR: unrecognized attribute " + attr;
                    }
                }
                return null;
            }
        }

        static final class ACT_BC
        implements AbstractInterp.Actor {
            ACT_BC() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                if (ai.noNumber()) {
                    ai.ops.op_bc(1);
                } else {
                    ai.ops.op_bc(ai.numberAt(0));
                }
                return null;
            }
        }

        static final class ACT_CBT
        implements AbstractInterp.Actor {
            ACT_CBT() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                if (ai.noNumber()) {
                    ai.ops.op_cbt(1);
                } else {
                    ai.ops.op_cbt(ai.numberAt(0));
                }
                return null;
            }
        }

        static final class ACT_CHA
        implements AbstractInterp.Actor {
            ACT_CHA() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                if (ai.noNumber()) {
                    ai.ops.op_cha(1);
                } else {
                    ai.ops.op_cha(ai.numberAt(0));
                }
                return null;
            }
        }

        static final class ACT_CHT
        implements AbstractInterp.Actor {
            ACT_CHT() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                if (ai.noNumber()) {
                    ai.ops.op_cht(1);
                } else {
                    ai.ops.op_cht(ai.numberAt(0));
                }
                return null;
            }
        }

        static final class ACT_CUD
        implements AbstractInterp.Actor {
            ACT_CUD() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                if (ai.noNumber()) {
                    ai.ops.op_cud(1);
                } else {
                    ai.ops.op_cud(ai.numberAt(0));
                }
                return null;
            }
        }

        static final class ACT_DC
        implements AbstractInterp.Actor {
            ACT_DC() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                if (ai.noNumber()) {
                    ai.ops.op_dc(1);
                } else {
                    ai.ops.op_dc(ai.numberAt(0));
                }
                return null;
            }
        }

        static final class ACT_DL
        implements AbstractInterp.Actor {
            ACT_DL() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                if (ai.noNumber()) {
                    ai.ops.op_dl(1);
                } else {
                    ai.ops.op_dl(ai.numberAt(0));
                }
                return null;
            }
        }

        static final class ACT_DSR
        implements AbstractInterp.Actor {
            ACT_DSR() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                if (ai.noNumber()) {
                    ai.ops.op_status_report(5);
                } else {
                    ai.ops.op_status_report(ai.numberAt(0));
                }
                return null;
            }
        }

        static final class ACT_ECH
        implements AbstractInterp.Actor {
            ACT_ECH() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                if (ai.noNumber()) {
                    ai.ops.op_ech(1);
                } else {
                    ai.ops.op_ech(ai.numberAt(0));
                }
                return null;
            }
        }

        static final class ACT_FULL_RESET
        implements AbstractInterp.Actor {
            ACT_FULL_RESET() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                ai.ops.op_full_reset();
                return null;
            }
        }

        static final class ACT_HO
        implements AbstractInterp.Actor {
            ACT_HO() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                if (ai.noNumber()) {
                    ai.ops.op_ho();
                } else {
                    ai.ops.op_cm(ai.numberAt(0), ai.numberAt(1));
                }
                return null;
            }
        }

        static final class ACT_IC
        implements AbstractInterp.Actor {
            ACT_IC() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                if (ai.noNumber()) {
                    ai.ops.op_ic(1);
                } else {
                    ai.ops.op_ic(ai.numberAt(0));
                }
                return null;
            }
        }

        static final class ACT_J
        implements AbstractInterp.Actor {
            ACT_J() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                if (ai.noNumber()) {
                    ai.ops.op_ed(0);
                } else {
                    int code = ai.numberAt(0);
                    switch (code) {
                        case 0: 
                        case 1: 
                        case 2: {
                            ai.ops.op_ed(code);
                            break;
                        }
                        default: {
                            return "ACT J: count of > 2 not supported";
                        }
                    }
                }
                return null;
            }
        }

        static final class ACT_K
        implements AbstractInterp.Actor {
            ACT_K() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                if (ai.noNumber()) {
                    ai.ops.op_el(0);
                } else {
                    int code = ai.numberAt(0);
                    switch (code) {
                        case 0: 
                        case 1: 
                        case 2: {
                            ai.ops.op_el(code);
                            break;
                        }
                        default: {
                            return "ACT K: count of > 2 not supported";
                        }
                    }
                }
                return null;
            }
        }

        static final class ACT_LS2
        implements AbstractInterp.Actor {
            ACT_LS2() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                ai.ops.op_selectGL(2);
                return null;
            }
        }

        static final class ACT_LS3
        implements AbstractInterp.Actor {
            ACT_LS3() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                ai.ops.op_selectGL(3);
                return null;
            }
        }

        static final class ACT_M
        implements AbstractInterp.Actor {
            ACT_M() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                ai.ops.op_ri(1);
                return null;
            }
        }

        static final class ACT_MARGIN
        implements AbstractInterp.Actor {
            ACT_MARGIN() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                if (ai.noNumber()) {
                    ai.ops.op_margin(0, 0);
                } else {
                    ai.ops.op_margin(ai.numberAt(0), ai.numberAt(1));
                }
                return null;
            }
        }

        static final class ACT_ND
        implements AbstractInterp.Actor {
            ACT_ND() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                if (ai.noNumber()) {
                    ai.ops.op_nd(1);
                } else {
                    ai.ops.op_nd(ai.numberAt(0));
                }
                return null;
            }
        }

        static final class ACT_PUSH_NUMBER
        implements AbstractInterp.Actor {
            ACT_PUSH_NUMBER() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                if (!ai.pushNumber()) {
                    return "ACT PUSH_NUMBER";
                }
                return null;
            }
        }

        static final class ACT_REMEMBER1
        implements AbstractInterp.Actor {
            ACT_REMEMBER1() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                InterpProtoANSI i = (InterpProtoANSI)ai;
                i.rememberedChar = c;
                return null;
            }
        }

        static final class ACT_REMEMBER_DIGIT
        implements AbstractInterp.Actor {
            ACT_REMEMBER_DIGIT() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                ai.remember_digit(c);
                return null;
            }
        }

        static class ACT_RESET_NUMBER
        implements AbstractInterp.Actor {
            ACT_RESET_NUMBER() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                ai.resetNumber();
                return null;
            }
        }

        static final class ACT_RM
        implements AbstractInterp.Actor {
            ACT_RM() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                if (ai.noNumber()) {
                    ai.ops.op_reset_mode(1);
                } else {
                    ai.ops.op_reset_mode(ai.numberAt(0));
                }
                return null;
            }
        }

        static final class ACT_SETG
        implements AbstractInterp.Actor {
            ACT_SETG() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                int gx = 0;
                InterpProtoANSI i = (InterpProtoANSI)ai;
                switch (i.rememberedChar) {
                    case '(': {
                        gx = 0;
                        break;
                    }
                    case ')': {
                        gx = 1;
                        break;
                    }
                    case '*': {
                        gx = 2;
                        break;
                    }
                    case '+': {
                        gx = 3;
                    }
                }
                int fx = 0;
                switch (c) {
                    case 'B': {
                        fx = 0;
                        break;
                    }
                    case '0': {
                        fx = 1;
                    }
                }
                ai.ops.op_setG(gx, fx);
                return null;
            }
        }

        static final class ACT_SM
        implements AbstractInterp.Actor {
            ACT_SM() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                if (ai.noNumber()) {
                    ai.ops.op_set_mode(1);
                } else {
                    ai.ops.op_set_mode(ai.numberAt(0));
                }
                return null;
            }
        }

        static final class ACT_TO_ESC
        implements AbstractInterp.Actor {
            ACT_TO_ESC() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                return null;
            }
        }

        static final class ACT_UP
        implements AbstractInterp.Actor {
            ACT_UP() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                if (ai.noNumber()) {
                    ai.ops.op_cuu(1);
                } else {
                    ai.ops.op_cuu(ai.numberAt(0));
                }
                return null;
            }
        }

        static final class ACT_VPA
        implements AbstractInterp.Actor {
            ACT_VPA() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                if (ai.noNumber()) {
                    ai.ops.op_vpa(1);
                } else {
                    ai.ops.op_vpa(ai.numberAt(0));
                }
                return null;
            }
        }
    }
}

