/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator;

import java.awt.event.KeyEvent;
import org.netbeans.lib.terminalemulator.Interp;
import org.netbeans.lib.terminalemulator.Ops;

public abstract class AbstractInterp
implements Interp {
    public Ops ops;
    public State state;
    private static final int max_numbers = 5;
    private int numberx = 0;
    private String[] number = new String[5];

    protected AbstractInterp(Ops ops) {
        this.ops = ops;
    }

    public void reset() {
    }

    protected final void sendChars(KeyEvent e, String s) {
        e.consume();
        this.ops.op_send_chars(s);
    }

    protected void resetNumber() {
        for (int x = 0; x < 5; ++x) {
            this.number[x] = "";
        }
        this.numberx = 0;
    }

    protected void remember_digit(char c) {
        int n = this.numberx;
        this.number[n] = this.number[n] + c;
    }

    protected boolean pushNumber() {
        ++this.numberx;
        return this.numberx < 5;
    }

    protected boolean noNumber() {
        return this.number[0].equals("");
    }

    protected int numberAt(int position) {
        if (position > this.numberx) {
            return 1;
        }
        try {
            return Integer.parseInt(this.number[position]);
        }
        catch (NumberFormatException x) {
            return 0;
        }
    }

    protected int nNumbers() {
        return this.numberx;
    }

    protected static interface Actor {
        public String action(AbstractInterp var1, char var2);
    }

    protected static class State {
        Actor act_error = new Actor(){

            @Override
            public String action(AbstractInterp ai, char c) {
                return "generic error";
            }
        };
        private String name;
        private Action[] action = new Action[128];
        private Action action_regular = new Action();

        public String name() {
            return this.name;
        }

        public State(String name) {
            this.name = name;
            for (int i = 0; i < this.action.length; ++i) {
                this.action[i] = new Action();
            }
            this.action_regular.actor = null;
            this.action_regular.new_state = null;
        }

        public void setRegular(State new_state, Actor actor) {
            this.action_regular.actor = actor;
            this.action_regular.new_state = new_state;
        }

        public void setAction(char c, State new_state, Actor actor) {
            if (c > '\u007f') {
                return;
            }
            this.action[c].actor = actor;
            this.action[c].new_state = new_state;
        }

        Action getAction(char c) {
            if (c > '\u007f') {
                return this.action_regular;
            }
            return this.action[c];
        }

        class Action {
            public State new_state = null;
            public Actor actor;

            Action() {
                this.actor = State.this.act_error;
            }
        }
    }
}

