/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.history;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.options.AnnotationColorProvider;
import org.netbeans.modules.subversion.ui.diff.DiffSetupSource;
import org.netbeans.modules.subversion.ui.diff.Setup;
import org.netbeans.modules.subversion.ui.history.Bundle;
import org.netbeans.modules.subversion.ui.history.RepositoryRevision;
import org.netbeans.modules.subversion.ui.history.SearchHistoryPanel;
import org.netbeans.modules.subversion.ui.update.RevertModifications;
import org.netbeans.modules.subversion.ui.update.RevertModificationsAction;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.history.AbstractSummaryView;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.VCSKenaiAccessor;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

class SummaryView
extends AbstractSummaryView
implements DiffSetupSource {
    private final SearchHistoryPanel master;
    private static final DateFormat defaultFormat = DateFormat.getDateTimeInstance(3, 3);

    public SummaryView(SearchHistoryPanel master, List<? extends AbstractSummaryView.LogEntry> results, Map<String, VCSKenaiAccessor.KenaiUser> kenaiUserMap) {
        super(SummaryView.createViewSummaryMaster(master), results, kenaiUserMap);
        this.master = master;
    }

    @Override
    public Collection<Setup> getSetups() {
        Object[] sel;
        Node[] nodes = TopComponent.getRegistry().getActivatedNodes();
        if (nodes.length == 0) {
            List<RepositoryRevision> results = this.master.getResults();
            return this.master.getSetups(results.toArray(new RepositoryRevision[results.size()]), new RepositoryRevision.Event[0]);
        }
        HashSet<RepositoryRevision.Event> events = new HashSet<RepositoryRevision.Event>();
        HashSet<RepositoryRevision> revisions = new HashSet<RepositoryRevision>();
        for (Object revCon : sel = this.getSelection()) {
            if (revCon instanceof RepositoryRevision) {
                revisions.add((RepositoryRevision)revCon);
                continue;
            }
            events.add((RepositoryRevision.Event)revCon);
        }
        return this.master.getSetups(revisions.toArray(new RepositoryRevision[revisions.size()]), events.toArray(new RepositoryRevision.Event[events.size()]));
    }

    @Override
    public String getSetupDisplayName() {
        return null;
    }

    private static AbstractSummaryView.SummaryViewMaster createViewSummaryMaster(final SearchHistoryPanel master) {
        final HashMap<String, String> colors = new HashMap<String, String>();
        colors.put("A", SvnUtils.getColorString(AnnotationColorProvider.getInstance().ADDED_LOCALLY_FILE.getActualColor()));
        colors.put("C", SvnUtils.getColorString(AnnotationColorProvider.getInstance().COPIED_LOCALLY_FILE.getActualColor()));
        colors.put("R", SvnUtils.getColorString(AnnotationColorProvider.getInstance().COPIED_LOCALLY_FILE.getActualColor()));
        colors.put("M", SvnUtils.getColorString(AnnotationColorProvider.getInstance().MODIFIED_LOCALLY_FILE.getActualColor()));
        colors.put("D", SvnUtils.getColorString(AnnotationColorProvider.getInstance().REMOVED_LOCALLY_FILE.getActualColor()));
        colors.put("?", SvnUtils.getColorString(AnnotationColorProvider.getInstance().EXCLUDED_FILE.getActualColor()));
        return new AbstractSummaryView.SummaryViewMaster(){

            public JComponent getComponent() {
                return master;
            }

            public File[] getRoots() {
                return master.getRoots();
            }

            public Collection<AbstractSummaryView.SummaryViewMaster.SearchHighlight> getSearchHighlights() {
                return master.getSearchHighlights();
            }

            public Map<String, String> getActionColors() {
                return colors;
            }

            public void getMoreResults(PropertyChangeListener callback, int count) {
                master.getMoreRevisions(callback, count);
            }

            public boolean hasMoreResults() {
                return master.hasMoreResults();
            }
        };
    }

    protected void onPopup(JComponent invoker, Point p, final Object[] selection) {
        boolean diffToPrevEnabled;
        ArrayList<RepositoryRevision.Event> drevList;
        RepositoryRevision container;
        boolean revisionSelected;
        JPopupMenu menu = new JPopupMenu();
        Object previousRevision = null;
        Object revCon = selection[0];
        boolean noExDeletedExistingFiles = true;
        boolean missingFile = false;
        boolean oneRevisionMultiselected = true;
        boolean deleted = false;
        if (revCon instanceof SvnLogEntry && selection.length == 1) {
            revisionSelected = true;
            container = ((SvnLogEntry)selection[0]).revision;
            drevList = new ArrayList(0);
            oneRevisionMultiselected = true;
            noExDeletedExistingFiles = true;
        } else {
            revisionSelected = false;
            drevList = new ArrayList<RepositoryRevision.Event>(selection.length);
            for (int i = 0; i < selection.length; ++i) {
                if (!(selection[i] instanceof SvnLogEvent)) {
                    return;
                }
                RepositoryRevision.Event event = ((SvnLogEvent)((Object)selection[i])).getEvent();
                drevList.add(event);
                File file = event.getFile();
                if (!deleted && file != null && !file.exists() && event.getChangedPath().getAction() == 'D') {
                    deleted = true;
                }
                if (!missingFile && event.getFile() == null) {
                    missingFile = true;
                }
                if (oneRevisionMultiselected && i > 0 && ((RepositoryRevision.Event)drevList.get(0)).getLogInfoHeader().getLog().getRevision().getNumber() != ((RepositoryRevision.Event)drevList.get(0)).getLogInfoHeader().getLog().getRevision().getNumber()) {
                    oneRevisionMultiselected = false;
                }
                if (file == null || event.getChangedPath().getAction() != 'D' || !file.exists()) continue;
                noExDeletedExistingFiles = false;
            }
            container = ((RepositoryRevision.Event)drevList.get(0)).getLogInfoHeader();
        }
        final RepositoryRevision.Event[] drev = drevList.toArray(new RepositoryRevision.Event[drevList.size()]);
        long revision = container.getLog().getRevision().getNumber();
        final boolean rollbackToEnabled = !deleted && !missingFile && !revisionSelected && oneRevisionMultiselected;
        final boolean rollbackChangeEnabled = !missingFile && oneRevisionMultiselected && (drev.length == 0 || noExDeletedExistingFiles);
        final boolean viewEnabled = selection.length == 1 && !revisionSelected && drev[0].getFile() != null && !drev[0].getFile().isDirectory() && drev[0].getChangedPath().getAction() != 'D';
        boolean bl = diffToPrevEnabled = selection.length == 1;
        if (revision > 1L) {
            menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_DiffToPrevious", previousRevision)){
                {
                    super(x0);
                    this.setEnabled(diffToPrevEnabled);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    SummaryView.diffPrevious(SummaryView.this.master, selection[0]);
                }
            }));
        }
        menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_RollbackChange")){
            {
                super(x0);
                this.setEnabled(rollbackChangeEnabled);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                SummaryView.revertModifications(SummaryView.this.master, selection);
            }
        }));
        if (!revisionSelected) {
            menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_RollbackTo", (Object)revision)){
                {
                    super(x0);
                    this.setEnabled(rollbackToEnabled);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    Subversion.getInstance().getParallelRequestProcessor().post(new Runnable(){

                        @Override
                        public void run() {
                            SummaryView.rollback(drev);
                        }
                    });
                }
            }));
            menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_View")){
                {
                    super(x0);
                    this.setEnabled(viewEnabled);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    Subversion.getInstance().getParallelRequestProcessor().post(new Runnable(){

                        @Override
                        public void run() {
                            SummaryView.view(selection[0], false);
                        }
                    });
                }
            }));
            menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_ShowAnnotations")){
                {
                    super(x0);
                    this.setEnabled(viewEnabled);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    Subversion.getInstance().getParallelRequestProcessor().post(new Runnable(){

                        @Override
                        public void run() {
                            SummaryView.view(selection[0], true);
                        }
                    });
                }
            }));
            menu.add(new JMenuItem(new AbstractAction(Bundle.CTL_Action_ViewCurrent_name()){
                {
                    super(x0);
                    this.setEnabled(viewEnabled);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    Subversion.getInstance().getParallelRequestProcessor().post(new Runnable(){

                        @Override
                        public void run() {
                            Utils.openFile((File)FileUtil.normalizeFile((File)drev[0].getFile()));
                        }
                    });
                }
            }));
        }
        menu.show(invoker, p.x, p.y);
    }

    private static void rollback(final RepositoryRevision.Event[] events) {
        SVNUrl repository = events[0].getLogInfoHeader().getRepositoryRootUrl();
        RequestProcessor rp = Subversion.getInstance().getRequestProcessor(repository);
        SvnProgressSupport support = new SvnProgressSupport(){

            @Override
            public void perform() {
                for (RepositoryRevision.Event event : events) {
                    File file = event.getFile();
                    boolean wasDeleted = event.getChangedPath().getAction() == 'D';
                    SVNUrl repoUrl = event.getLogInfoHeader().getRepositoryRootUrl();
                    SVNUrl fileUrl = repoUrl.appendPath(event.getChangedPath().getPath());
                    SVNRevision.Number revision = event.getLogInfoHeader().getLog().getRevision();
                    SvnUtils.rollback(file, repoUrl, fileUrl, (SVNRevision)revision, wasDeleted, this.getLogger());
                }
            }
        };
        support.start(rp, repository, NbBundle.getMessage(SummaryView.class, (String)"MSG_Rollback_Progress"));
    }

    private static void revertModifications(SearchHistoryPanel master, Object[] selection) {
        HashSet<RepositoryRevision.Event> events = new HashSet<RepositoryRevision.Event>();
        HashSet<RepositoryRevision> revisions = new HashSet<RepositoryRevision>();
        for (Object o : selection) {
            if (o instanceof RepositoryRevision) {
                revisions.add((RepositoryRevision)o);
                continue;
            }
            if (o instanceof SvnLogEntry) {
                revisions.add(((SvnLogEntry)o).revision);
                continue;
            }
            if (o instanceof SvnLogEvent) {
                events.add(((SvnLogEvent)((Object)o)).event);
                continue;
            }
            events.add((RepositoryRevision.Event)o);
        }
        SummaryView.revert(master, revisions.toArray(new RepositoryRevision[revisions.size()]), events.toArray(new RepositoryRevision.Event[events.size()]));
    }

    private static void revert(final SearchHistoryPanel master, final RepositoryRevision[] revisions, final RepositoryRevision.Event[] events) {
        SVNUrl url;
        try {
            url = master.getSearchRepositoryRootUrl();
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
            return;
        }
        RequestProcessor rp = Subversion.getInstance().getRequestProcessor(url);
        SvnProgressSupport support = new SvnProgressSupport(){

            @Override
            public void perform() {
                SummaryView.revertImpl(master, revisions, events, this);
            }
        };
        support.start(rp, url, NbBundle.getMessage(SummaryView.class, (String)"MSG_Revert_Progress"));
    }

    private static void revertImpl(SearchHistoryPanel master, RepositoryRevision[] revisions, RepositoryRevision.Event[] events, SvnProgressSupport progress) {
        Context ctx;
        RevertModifications.RevisionInterval revisionInterval;
        for (RepositoryRevision revision : revisions) {
            revisionInterval = new RevertModifications.RevisionInterval((SVNRevision)revision.getLog().getRevision());
            ctx = new Context(master.getRoots());
            RevertModificationsAction.performRevert(revisionInterval, false, false, ctx, progress);
        }
        for (RepositoryRevision.Event event : events) {
            if (event.getFile() == null) continue;
            revisionInterval = new RevertModifications.RevisionInterval((SVNRevision)event.getLogInfoHeader().getLog().getRevision());
            ctx = new Context(event.getFile());
            RevertModificationsAction.performRevert(revisionInterval, false, false, ctx, progress);
        }
    }

    private static void view(Object o, boolean showAnnotations) {
        RepositoryRevision.Event drev = null;
        if (o instanceof RepositoryRevision.Event) {
            drev = (RepositoryRevision.Event)o;
        } else if (o instanceof SvnLogEvent) {
            drev = ((SvnLogEvent)((Object)o)).event;
        }
        if (drev != null) {
            drev.viewFile(showAnnotations);
        }
    }

    private static void diffPrevious(SearchHistoryPanel master, Object o) {
        if (o instanceof RepositoryRevision.Event) {
            RepositoryRevision.Event drev = (RepositoryRevision.Event)o;
            master.showDiff(drev);
        } else if (o instanceof SvnLogEvent) {
            RepositoryRevision.Event drev = ((SvnLogEvent)((Object)o)).event;
            master.showDiff(drev);
        } else if (o instanceof SvnLogEntry) {
            RepositoryRevision container = ((SvnLogEntry)o).revision;
            master.showDiff(container);
        } else {
            RepositoryRevision container = (RepositoryRevision)o;
            master.showDiff(container);
        }
    }

    static final class SvnLogEntry
    extends AbstractSummaryView.LogEntry
    implements PropertyChangeListener {
        private final RepositoryRevision revision;
        private List events = new ArrayList(10);
        private List<AbstractSummaryView.LogEntry.Event> dummyEvents;
        private final SearchHistoryPanel master;
        private final PropertyChangeListener list;

        public SvnLogEntry(RepositoryRevision revision, SearchHistoryPanel master) {
            this.revision = revision;
            this.master = master;
            this.dummyEvents = Collections.emptyList();
            if (revision.isEventsInitialized()) {
                this.refreshEvents();
                this.list = null;
            } else {
                this.prepareDummyEvents();
                this.list = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)revision);
                revision.addPropertyChangeListener("eventsChanged", this.list);
            }
        }

        public Collection<AbstractSummaryView.LogEntry.Event> getEvents() {
            return this.events;
        }

        public Collection<AbstractSummaryView.LogEntry.Event> getDummyEvents() {
            return this.dummyEvents;
        }

        public String getAuthor() {
            return this.revision.getLog().getAuthor();
        }

        public String getDate() {
            Date date = this.revision.getLog().getDate();
            return date != null ? defaultFormat.format(date) : null;
        }

        public String getRevision() {
            return this.revision.getLog().getRevision().toString();
        }

        protected Collection<AbstractSummaryView.LogEntry.RevisionHighlight> getRevisionHighlights() {
            return Collections.emptyList();
        }

        public String getMessage() {
            return this.revision.getLog().getMessage();
        }

        public Action[] getActions() {
            ArrayList<Action> actions = new ArrayList<Action>();
            long revisionNumber = this.revision.getLog().getRevision().getNumber();
            if (revisionNumber > 1L) {
                actions.add(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_DiffToPreviousShort")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SummaryView.diffPrevious(SvnLogEntry.this.master, SvnLogEntry.this.revision);
                    }
                });
            }
            actions.addAll(Arrays.asList(this.revision.getActions()));
            return actions.toArray(new Action[actions.size()]);
        }

        public String toString() {
            return this.revision.toString();
        }

        protected void expand() {
            this.revision.expandEvents();
        }

        protected void cancelExpand() {
            this.revision.cancelExpand();
        }

        protected boolean isEventsInitialized() {
            return this.revision.isEventsInitialized();
        }

        public boolean isVisible() {
            return this.master.applyFilter(this.revision);
        }

        protected boolean isLessInteresting() {
            return false;
        }

        RepositoryRevision getRepositoryRevision() {
            return this.revision;
        }

        void prepareDummyEvents() {
            ArrayList<AbstractSummaryView.LogEntry.Event> evts = new ArrayList<AbstractSummaryView.LogEntry.Event>(this.revision.getDummyEvents().size());
            for (RepositoryRevision.Event event : this.revision.getDummyEvents()) {
                evts.add(new SvnLogEvent(this.master, event));
            }
            this.dummyEvents = evts;
        }

        void refreshEvents() {
            ArrayList<SvnLogEvent> evts = new ArrayList<SvnLogEvent>(this.revision.getEvents().size());
            for (RepositoryRevision.Event event : this.revision.getEvents()) {
                evts.add(new SvnLogEvent(this.master, event));
            }
            ArrayList newEvents = new ArrayList(evts);
            this.events = evts;
            this.dummyEvents.clear();
            this.eventsChanged(null, newEvents);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("eventsChanged".equals(evt.getPropertyName()) && this.revision == evt.getSource()) {
                this.refreshEvents();
            }
        }
    }

    static class SvnLogEvent
    extends AbstractSummaryView.LogEntry.Event {
        private final RepositoryRevision.Event event;
        private final SearchHistoryPanel master;

        SvnLogEvent(SearchHistoryPanel master, RepositoryRevision.Event event) {
            this.master = master;
            this.event = event;
        }

        public String getPath() {
            String path = this.event.getChangedPath().getPath();
            return path;
        }

        public String getOriginalPath() {
            String path = this.event.getOriginalPath();
            return path;
        }

        public String getAction() {
            return this.event.getAction();
        }

        public RepositoryRevision.Event getEvent() {
            return this.event;
        }

        public Action[] getUserActions() {
            ArrayList<Action> actions = new ArrayList<Action>();
            long revisionNumber = this.event.getLogInfoHeader().getLog().getRevision().getNumber();
            if (revisionNumber > 1L) {
                actions.add(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_DiffToPreviousShort")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SummaryView.diffPrevious(SvnLogEvent.this.master, SvnLogEvent.this.event);
                    }
                });
            }
            actions.addAll(Arrays.asList(this.event.getActions()));
            return actions.toArray(new Action[actions.size()]);
        }

        public boolean isVisibleByDefault() {
            return this.master.isShowInfo() || this.event.isUnderRoots();
        }

        public String toString() {
            return this.event.toString();
        }
    }
}

