/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.diff;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.diff.Difference;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnFileNode;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.diff.Bundle;
import org.netbeans.modules.subversion.ui.diff.DiffNode;
import org.netbeans.modules.subversion.ui.diff.MultiDiffPanel;
import org.netbeans.modules.subversion.ui.diff.Setup;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.spi.diff.DiffProvider;
import org.openide.util.Lookup;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNDiffSummary;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.utils.SVNUrlUtils;

class RevisionSetupsSupport {
    private final RepositoryFile repositoryTreeLeft;
    private final RepositoryFile repositoryTreeRight;
    private final SVNUrl repositoryUrl;
    private final Context context;
    private final FileStatusCache cache;
    private final Map<File, Setup> wcSetups;
    private final boolean workingCopy;
    private final boolean base;
    private final Map<String, SVNDiffSummary[]> diffSummaryCache;
    private final Set<String> missingURLs;
    private static final Logger LOG = Logger.getLogger(RevisionSetupsSupport.class.getName());
    private boolean logged;

    public RevisionSetupsSupport(RepositoryFile repositoryTreeLeft, RepositoryFile repositoryTreeRight, SVNUrl repositoryUrl, Context context) {
        this.repositoryTreeLeft = repositoryTreeLeft;
        this.repositoryTreeRight = repositoryTreeRight;
        this.repositoryUrl = repositoryUrl;
        this.context = context;
        this.cache = Subversion.getInstance().getStatusCache();
        this.wcSetups = new LinkedHashMap<File, Setup>();
        this.diffSummaryCache = new LinkedHashMap<String, SVNDiffSummary[]>();
        this.missingURLs = new LinkedHashSet<String>();
        this.workingCopy = SVNRevision.WORKING.equals((Object)this.repositoryTreeRight.getRevision());
        this.base = SVNRevision.BASE.equals((Object)this.repositoryTreeRight.getRevision()) || SVNRevision.BASE.equals((Object)this.repositoryTreeLeft.getRevision());
    }

    Setup[] computeSetupsBetweenRevisions(SvnProgressSupport supp) {
        RepositoryFile left = this.repositoryTreeLeft;
        RepositoryFile right = this.repositoryTreeRight;
        assert (left != null && right != null);
        if (left.toString().equals(right.toString())) {
            return new Setup[0];
        }
        try {
            File[] roots;
            SvnClient client = Subversion.getInstance().getClient(this.repositoryUrl);
            ArrayList<Setup> setups = new ArrayList<Setup>();
            for (File root : roots = this.getRoots()) {
                SVNUrl rightUrl;
                boolean flatFile = VersioningSupport.isFlat((File)root);
                SVNUrl leftUrl = roots.length > 1 ? left.replaceLastSegment(root.getName(), 0).getFileUrl() : left.getFileUrl();
                SVNUrl sVNUrl = rightUrl = roots.length > 1 ? right.replaceLastSegment(root.getName(), 0).getFileUrl() : right.getFileUrl();
                if (this.base || this.workingCopy) {
                    ISVNStatus[] statuses = client.getStatus(root, !flatFile, true, false, true);
                    HashMap<File, ISVNStatus> statusMap = new HashMap<File, ISVNStatus>(statuses.length);
                    for (ISVNStatus s : statuses) {
                        statusMap.put(s.getFile(), s);
                    }
                    for (ISVNStatus s : statuses) {
                        SVNRevision.Number rightRevision;
                        SVNUrl rightFileUrl;
                        SVNRevision.Number leftRevision;
                        SVNUrl leftFileUrl;
                        if (supp.isCanceled()) {
                            return null;
                        }
                        File f = s.getFile();
                        if ((this.cache.getStatus(f).getStatus() & 2) != 0 || flatFile && !f.equals(root) && s.getNodeKind() == SVNNodeKind.DIR) continue;
                        SVNRevision.Number revision = s.getRevision();
                        SVNUrl url = s.getUrl();
                        if (s.isCopied() || revision == null) {
                            url = null;
                            revision = null;
                            if (!this.workingCopy) continue;
                        }
                        String relativePath = this.getRelativePath(root, f);
                        if (SVNRevision.BASE.equals((Object)right.getRevision()) || this.workingCopy) {
                            leftFileUrl = leftUrl.appendPath(relativePath);
                            leftRevision = left.getRevision();
                            rightFileUrl = url;
                            rightRevision = revision;
                        } else {
                            leftFileUrl = url;
                            leftRevision = revision;
                            rightFileUrl = rightUrl.appendPath(relativePath);
                            rightRevision = right.getRevision();
                        }
                        List<Setup> partialSetups = this.buildSetups(client, leftFileUrl, (SVNRevision)leftRevision, rightFileUrl, (SVNRevision)rightRevision, supp, flatFile, flatFile ? 3 : 5, f, false, statusMap);
                        if (partialSetups == null) {
                            return null;
                        }
                        setups.addAll(partialSetups);
                    }
                    continue;
                }
                List<Setup> partialSetups = this.buildSetups(client, leftUrl, left.getRevision(), rightUrl, right.getRevision(), supp, flatFile, flatFile ? 3 : 5, root, true, Collections.emptyMap());
                if (partialSetups == null) {
                    return null;
                }
                setups.addAll(partialSetups);
            }
            if (this.workingCopy) {
                for (Map.Entry<File, Setup> e : this.wcSetups.entrySet()) {
                    setups.add(e.getValue());
                }
            }
            return setups.toArray(new Setup[setups.size()]);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, false);
            return new Setup[0];
        }
    }

    void setWCSetups(Setup[] wcSetups) {
        for (Setup s : wcSetups) {
            File f = s.getBaseFile();
            if (s.getPropertyName() != null) continue;
            this.wcSetups.put(f, s);
        }
    }

    private ISVNInfo checkUrlExistance(SvnClient client, SVNUrl url, SVNRevision revision) throws SVNClientException {
        if (url == null) {
            return null;
        }
        if (this.parentMissing(url, revision)) {
            return null;
        }
        try {
            return client.getInfo(url, revision, revision);
        }
        catch (SVNClientException ex) {
            if (SvnClientExceptionHandler.isWrongURLInRevision(ex.getMessage())) {
                this.cacheParentMissing(url, revision);
                return null;
            }
            throw ex;
        }
    }

    private List<Setup> addPropertySetups(SvnClient client, SVNUrl leftFileUrl, SVNRevision leftRevision, SVNUrl rightFileUrl, SVNRevision rightRevision) throws SVNClientException {
        ArrayList<Setup> propSetups = new ArrayList<Setup>();
        DiffProvider diffAlgorithm = (DiffProvider)Lookup.getDefault().lookup(DiffProvider.class);
        try {
            Map leftProps = leftFileUrl == null ? Collections.emptyMap() : this.toMap(client.getProperties(leftFileUrl, leftRevision, leftRevision));
            Map rightProps = rightFileUrl == null ? Collections.emptyMap() : this.toMap(client.getProperties(rightFileUrl, rightRevision, rightRevision));
            TreeSet allProps = new TreeSet(leftProps.keySet());
            allProps.addAll(rightProps.keySet());
            for (String key : allProps) {
                boolean isLeft = leftProps.containsKey(key);
                boolean isRight = rightProps.containsKey(key);
                boolean propertiesDiffer = true;
                if (isLeft && isRight) {
                    MultiDiffPanel.Property p1 = new MultiDiffPanel.Property(leftProps.get(key));
                    MultiDiffPanel.Property p2 = new MultiDiffPanel.Property(rightProps.get(key));
                    Difference[] diffs = diffAlgorithm.computeDiff(p1.toReader(), p2.toReader());
                    boolean bl = propertiesDiffer = diffs.length != 0;
                }
                if (!propertiesDiffer) continue;
            }
        }
        catch (IOException e) {
            Subversion.LOG.log(Level.INFO, null, e);
        }
        return propSetups;
    }

    private Map<String, byte[]> toMap(ISVNProperty[] properties) {
        LinkedHashMap<String, byte[]> map = new LinkedHashMap<String, byte[]>(properties.length);
        for (ISVNProperty prop : properties) {
            map.put(prop.getName(), prop.getData());
        }
        return map;
    }

    private boolean isSkippedInParent(List<String> skippedPaths, String filePath) {
        for (String p : skippedPaths) {
            if (!filePath.startsWith(p)) continue;
            return true;
        }
        return false;
    }

    private String getRelativePath(File root, File f) {
        String path = "";
        while (f != null && !f.equals(root)) {
            path = f.getName() + "/" + path;
            f = f.getParentFile();
        }
        if (f == null) {
            return null;
        }
        return path.isEmpty() ? path : path.substring(0, path.length() - 1);
    }

    private Setup createSetup(SVNDiffSummary summary, File file, SVNUrl leftUrl, SVNRevision leftRevision, SVNUrl rightUrl, String rightRevision) {
        boolean added;
        FileInformation fi = null;
        Setup localSetup = this.wcSetups.get(file);
        boolean deleted = summary.getDiffKind() == SVNDiffSummary.SVNDiffKind.DELETED;
        boolean bl = added = summary.getDiffKind() == SVNDiffSummary.SVNDiffKind.ADDED;
        if (localSetup != null) {
            fi = this.cache.getStatus(file);
            if (added && (fi.getStatus() & 0x14FF8) == 0) {
                fi = null;
            } else {
                deleted = (fi.getStatus() & 0x900) != 0;
                boolean bl2 = added = (fi.getStatus() & 0x1004) != 0;
            }
        }
        if (fi == null) {
            fi = new RevisionsFileInformation(summary);
        }
        this.wcSetups.remove(file);
        Setup setup = new Setup(file, this.repositoryUrl, leftUrl, added ? null : leftRevision.toString(), SVNUrlUtils.getRelativePath((SVNUrl)this.repositoryUrl, (SVNUrl)leftUrl) + "@" + leftRevision, rightUrl, deleted ? null : rightRevision, "LOCAL".equals(rightRevision) ? file.getName() + "@" + rightRevision : SVNUrlUtils.getRelativePath((SVNUrl)this.repositoryUrl, (SVNUrl)rightUrl) + "@" + rightRevision, fi);
        setup.setNode(new DiffNode(setup, new SvnFileNode(file), -1));
        return setup;
    }

    private List<Setup> buildSetups(SvnClient client, SVNUrl leftFileUrl, SVNRevision leftRevision, SVNUrl rightFileUrl, SVNRevision rightRevision, SvnProgressSupport supp, boolean flatFile, int depth, File root, boolean addAll, Map<File, ISVNStatus> statusMap) throws SVNClientException {
        boolean sameURLs = leftFileUrl != null && leftFileUrl.equals((Object)rightFileUrl) && leftRevision != null && leftRevision.equals((Object)rightRevision);
        ArrayList<Setup> setups = new ArrayList<Setup>();
        if (!sameURLs) {
            boolean rightExists;
            boolean leftExists;
            SVNDiffSummary[] diffSummaries = this.getCachedSummaries(leftFileUrl, leftRevision, rightRevision);
            ISVNInfo infoLeft = null;
            ISVNInfo infoRight = null;
            if (diffSummaries == null) {
                infoLeft = this.checkUrlExistance(client, leftFileUrl, leftRevision);
                infoRight = this.checkUrlExistance(client, rightFileUrl, rightRevision);
                leftExists = infoLeft != null;
                rightExists = infoRight != null;
            } else {
                rightExists = true;
                leftExists = true;
            }
            if (supp.isCanceled()) {
                return null;
            }
            if (leftExists && rightExists) {
                if (diffSummaries == null) {
                    diffSummaries = client.diffSummarize(leftFileUrl, leftRevision, rightFileUrl, rightRevision, depth, true);
                    this.cacheSummaries(diffSummaries, leftFileUrl, leftRevision, rightRevision);
                }
                ArrayList<String> skippedPaths = new ArrayList<String>();
                HashSet<String> deletedPaths = new HashSet<String>();
                for (SVNDiffSummary summary : diffSummaries) {
                    if (summary.getDiffKind() != SVNDiffSummary.SVNDiffKind.DELETED) continue;
                    deletedPaths.add(summary.getPath());
                }
                for (SVNDiffSummary summary : diffSummaries) {
                    boolean skipItem;
                    if (supp.isCanceled()) {
                        return null;
                    }
                    String filePath = summary.getPath();
                    File file = filePath.isEmpty() ? root : new File(root, filePath);
                    boolean bl = skipItem = !filePath.isEmpty();
                    if (addAll || summary.getDiffKind() == SVNDiffSummary.SVNDiffKind.DELETED && this.containsAllParents(filePath, deletedPaths) && (!flatFile || summary.getNodeKind() != SVNNodeKind.DIR.toInt() && !filePath.contains("/")) && !this.isSkippedInParent(skippedPaths, filePath)) {
                        skipItem = false;
                        ISVNStatus fileStatus = statusMap.get(file);
                        if (fileStatus != null && !fileStatus.isCopied() && fileStatus.getRevision() != null) {
                            skipItem = true;
                            skippedPaths.add(filePath);
                        }
                    }
                    if (summary.getDiffKind() == SVNDiffSummary.SVNDiffKind.NORMAL || skipItem) continue;
                    Setup setup = this.createSetup(summary, file, leftFileUrl.appendPath(filePath), leftRevision, this.workingCopy ? null : rightFileUrl.appendPath(filePath), this.workingCopy ? "LOCAL" : rightRevision.toString());
                    setups.add(setup);
                }
            } else {
                SVNDiffSummary summary = new SVNDiffSummary("", leftExists ? SVNDiffSummary.SVNDiffKind.DELETED : SVNDiffSummary.SVNDiffKind.ADDED, false, 0);
                Setup setup = this.createSetup(summary, root, leftFileUrl, leftRevision, this.workingCopy ? null : rightFileUrl, this.workingCopy ? "LOCAL" : rightRevision.toString());
                setups.add(setup);
            }
        }
        if (this.workingCopy && this.wcSetups.containsKey(root)) {
            SVNDiffSummary summary = new SVNDiffSummary("", SVNDiffSummary.SVNDiffKind.NORMAL, false, 0);
            Setup setup = this.createSetup(summary, root, leftFileUrl, leftRevision, null, "LOCAL");
            setups.add(setup);
        }
        return setups;
    }

    private void cacheSummaries(SVNDiffSummary[] diffSummaries, SVNUrl leftUrl, SVNRevision leftRevision, SVNRevision rightRevision) {
        String revisionString = "@" + leftRevision + ":" + rightRevision;
        LinkedHashMap sums = new LinkedHashMap();
        sums.put("", new ArrayList(diffSummaries.length));
        for (SVNDiffSummary s : diffSummaries) {
            int index;
            String path = s.getPath();
            do {
                String suffix;
                ArrayList<SVNDiffSummary> list;
                if ((list = (ArrayList<SVNDiffSummary>)sums.get(path)) == null) {
                    list = new ArrayList<SVNDiffSummary>();
                    sums.put(path, list);
                }
                if ((suffix = s.getPath().substring(path.length())).startsWith("/")) {
                    suffix = suffix.substring(1);
                }
                list.add(new SVNDiffSummary(suffix, s.getDiffKind(), s.propsChanged(), s.getNodeKind()));
            } while ((path = (index = path.lastIndexOf("/")) > -1 ? path.substring(0, index) : (!path.isEmpty() ? "" : null)) != null);
        }
        for (Map.Entry e : sums.entrySet()) {
            SVNDiffSummary[] summaryArray = ((List)e.getValue()).toArray(new SVNDiffSummary[((List)e.getValue()).size()]);
            String key = ((String)e.getKey()).isEmpty() ? leftUrl.toString() : leftUrl.toString() + "/" + (String)e.getKey();
            key = key + revisionString;
            this.diffSummaryCache.put(key, summaryArray);
        }
    }

    private SVNDiffSummary[] getCachedSummaries(SVNUrl url, SVNRevision leftRevision, SVNRevision rightRevision) {
        String revisionString = "@" + leftRevision + ":" + rightRevision;
        boolean direct = true;
        while (url != null) {
            SVNDiffSummary[] sums = this.diffSummaryCache.get(url.toString() + revisionString);
            if (sums != null) {
                return direct ? sums : new SVNDiffSummary[]{};
            }
            direct = false;
            url = url.getParent();
        }
        return null;
    }

    private void cacheParentMissing(SVNUrl url, SVNRevision revision) {
        this.missingURLs.add(url.toString() + "@" + revision);
    }

    private boolean parentMissing(SVNUrl url, SVNRevision revision) {
        while (url != null) {
            if (this.missingURLs.contains(url.toString() + "@" + revision)) {
                return true;
            }
            url = url.getParent();
        }
        return false;
    }

    private boolean containsAllParents(String filePath, Set<String> deletedPaths) {
        while (filePath != null) {
            if (!deletedPaths.contains(filePath)) {
                return false;
            }
            int pos = filePath.lastIndexOf("/");
            if (pos > -1) {
                filePath = filePath.substring(0, pos);
                continue;
            }
            filePath = null;
        }
        return true;
    }

    protected File[] getRoots() {
        return SvnUtils.getActionRoots(this.context, false);
    }

    private static class RevisionsFileInformation
    extends FileInformation {
        private final String name;

        public RevisionsFileInformation(SVNDiffSummary item) {
            super(RevisionsFileInformation.toStatus(item.getDiffKind()), 0, item.getNodeKind() == SVNNodeKind.DIR.toInt());
            this.name = RevisionsFileInformation.toStatusText(item.getDiffKind());
        }

        @Override
        public String getStatusText(int displayStatuses) {
            return this.name;
        }

        private static String toStatusText(SVNDiffSummary.SVNDiffKind diffKind) {
            if (diffKind == SVNDiffSummary.SVNDiffKind.DELETED) {
                return Bundle.LBL_DiffRevisions_status_removed();
            }
            if (diffKind == SVNDiffSummary.SVNDiffKind.ADDED) {
                return Bundle.LBL_DiffRevisions_status_added();
            }
            if (diffKind == SVNDiffSummary.SVNDiffKind.MODIFIED) {
                return Bundle.LBL_DiffRevisions_status_modified();
            }
            return Bundle.LBL_DiffRevisions_status_uptodate();
        }

        private static int toStatus(SVNDiffSummary.SVNDiffKind diffKind) {
            if (diffKind == SVNDiffSummary.SVNDiffKind.ADDED) {
                return 4096;
            }
            if (diffKind == SVNDiffSummary.SVNDiffKind.DELETED) {
                return 256;
            }
            if (diffKind == SVNDiffSummary.SVNDiffKind.MODIFIED) {
                return 65552;
            }
            return 8;
        }
    }
}

