/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.copy;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.ui.copy.BranchPicker;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.utils.SVNUrlUtils;

public abstract class CopyDialog {
    private DialogDescriptor dialogDescriptor;
    private JButton okButton;
    private JButton cancelButton;
    private JPanel panel;
    private static final Pattern TEMPLATE_PATTERN_BRANCH = Pattern.compile("^(.*/)*?((?:branches|tags)/(?:.+?))(/.*)+$");
    private static final Pattern TEMPLATE_PATTERN_TRUNK = Pattern.compile("^(.*/)*?(trunk)(/.*)+$");
    private static final String BRANCHES_FOLDER = "branches";
    private static final String TRUNK_FOLDER = "trunk";
    private static final String BRANCH_TEMPLATE = "[BRANCH_NAME]";
    private static final String SEP = "----------";
    private static final String MORE_BRANCHES = NbBundle.getMessage(CopyDialog.class, (String)"LBL_CopyDialog.moreBranchesAndTags");
    private Set<JComboBox> urlComboBoxes;

    protected CopyDialog(JPanel panel, String title, String okLabel) {
        this.panel = panel;
        this.okButton = new JButton(okLabel);
        this.okButton.getAccessibleContext().setAccessibleDescription(okLabel);
        this.cancelButton = new JButton(NbBundle.getMessage(CopyDialog.class, (String)"CTL_Copy_Cancel"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CopyDialog.class, (String)"CTL_Copy_Cancel"));
        this.dialogDescriptor = new DialogDescriptor((Object)panel, title, true, new Object[]{this.okButton, this.cancelButton}, (Object)this.okButton, 0, new HelpCtx(this.getClass()), null);
        this.okButton.setEnabled(false);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(this.dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CopyDialog.class, (String)"CTL_Title"));
    }

    protected void setupUrlComboBox(RepositoryFile repositoryFile, JComboBox cbo) {
        if (cbo == null) {
            return;
        }
        LinkedList<String> recentFolders = new LinkedList<String>(Utils.getStringList((Preferences)SvnModuleConfig.getDefault().getPreferences(), (String)CopyDialog.class.getName()));
        Map<String, String> comboItems = CopyDialog.setupModel(cbo, repositoryFile, recentFolders);
        cbo.setRenderer(new LocationRenderer(comboItems));
        this.getUrlComboBoxes().add(cbo);
    }

    private Set<JComboBox> getUrlComboBoxes() {
        if (this.urlComboBoxes == null) {
            this.urlComboBoxes = new HashSet<JComboBox>();
        }
        return this.urlComboBoxes;
    }

    protected JPanel getPanel() {
        return this.panel;
    }

    public final boolean showDialog() {
        boolean ret;
        Dialog dialog = DialogDisplayer.getDefault().createDialog(this.dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CopyDialog.class, (String)"CTL_Title"));
        dialog.setVisible(true);
        boolean bl = ret = this.dialogDescriptor.getValue() == this.okButton;
        if (ret) {
            this.storeValidValues();
        }
        return ret;
    }

    private void storeValidValues() {
        for (JComboBox cbo : this.urlComboBoxes) {
            Object item = cbo.getEditor().getItem();
            if (item == null || item.equals("")) continue;
            Utils.insert((Preferences)SvnModuleConfig.getDefault().getPreferences(), (String)CopyDialog.class.getName(), (String)((String)item), (int)-1);
        }
    }

    protected JButton getOKButton() {
        return this.okButton;
    }

    static Map<String, String> setupModel(JComboBox cbo, RepositoryFile repositoryFile, List<String> recentFolders) {
        String branchPrefix;
        String[] pathSegments;
        HashMap<String, String> locations = new HashMap<String, String>(Math.min(recentFolders.size(), 10));
        LinkedList<String> model = new LinkedList<String>();
        Comparator<String> comparator = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        };
        TreeMap relatedLocations = new TreeMap(comparator);
        TreeMap<String, String> branchLocations = new TreeMap<String, String>(comparator);
        String relativePath = SVNUrlUtils.getRelativePath((SVNUrl)repositoryFile.getRepositoryUrl(), (SVNUrl)repositoryFile.getFileUrl());
        String fileName = repositoryFile.getName();
        String[] branchPathSegments = CopyDialog.getBranchPathSegments(relativePath);
        String pathInBranch = branchPathSegments[2];
        String preselectedPath = null;
        for (String recentUrl : recentFolders) {
            if (pathInBranch != null && branchLocations.size() < 10 && branchPathSegments[0].equals((pathSegments = CopyDialog.getBranchPathSegments(recentUrl))[0]) && !TRUNK_FOLDER.equals(pathSegments[1])) {
                branchPrefix = pathSegments[0] + pathSegments[1];
                String loc = branchPrefix + '/' + pathInBranch;
                branchLocations.put(loc, CopyDialog.getHtmlVersion(branchPrefix, pathInBranch));
                if (preselectedPath == null) {
                    preselectedPath = loc;
                }
            }
            if (!recentUrl.endsWith("/" + fileName) || relatedLocations.size() >= 10) continue;
            if (pathInBranch == null && preselectedPath == null) {
                preselectedPath = recentUrl;
            }
            relatedLocations.put(recentUrl, null);
        }
        if (pathInBranch != null) {
            String pref = TRUNK_FOLDER;
            if (branchPathSegments[0] != null) {
                pref = branchPathSegments[0] + pref;
            }
            String loc = pref + "/" + pathInBranch;
            locations.put(loc, CopyDialog.getHtmlVersion(pref, pathInBranch));
            model.add(loc);
            model.add(SEP);
            model.addAll(branchLocations.keySet());
            locations.putAll(branchLocations);
            model.add(MORE_BRANCHES);
            if (preselectedPath == null) {
                pref = BRANCHES_FOLDER;
                if (branchPathSegments[0] != null) {
                    pref = branchPathSegments[0] + pref;
                }
                preselectedPath = pref + "/" + BRANCH_TEMPLATE + "/" + pathInBranch;
            }
            SelectionListener list = new SelectionListener(repositoryFile, cbo, branchPathSegments[0]);
            cbo.addActionListener(list);
            cbo.addPopupMenuListener(list);
        }
        relatedLocations.keySet().removeAll(locations.keySet());
        locations.putAll(relatedLocations);
        if (!model.isEmpty() && !relatedLocations.isEmpty()) {
            model.add(SEP);
        }
        model.addAll(relatedLocations.keySet());
        DefaultComboBoxModel<String> rootsModel = new DefaultComboBoxModel<String>(model.toArray(new String[model.size()]));
        cbo.setModel(rootsModel);
        JTextComponent comp = (JTextComponent)cbo.getEditor().getEditorComponent();
        if (preselectedPath != null) {
            int pos;
            comp.setText(preselectedPath);
            if (pathInBranch != null && (pos = (branchPrefix = (pathSegments = CopyDialog.getBranchPathSegments(preselectedPath))[0] + pathSegments[1]).lastIndexOf(47) + 1) > 0) {
                comp.setCaretPosition(pos);
                comp.moveCaretPosition(branchPrefix.length());
            }
        }
        return locations;
    }

    private static String[] getBranchPathSegments(String relativePath) {
        String prefix = null;
        String path = null;
        String branchName = null;
        for (Pattern p : new Pattern[]{TEMPLATE_PATTERN_BRANCH, TEMPLATE_PATTERN_TRUNK}) {
            Matcher m = p.matcher(relativePath);
            if (!m.matches()) continue;
            prefix = m.group(1);
            if (prefix == null) {
                prefix = "";
            }
            branchName = m.group(2);
            path = m.group(3);
            break;
        }
        if (path != null) {
            path = path.substring(1);
        }
        return new String[]{prefix, branchName, path};
    }

    private static String getHtmlVersion(String branchPrefix, String relativePathInBranch) {
        int branchStart = branchPrefix.lastIndexOf(47);
        if (branchStart > 0) {
            return new StringBuilder(2 * (branchPrefix.length() + relativePathInBranch.length())).append("<html>").append(branchPrefix.substring(0, branchStart + 1)).append("<strong>").append(branchPrefix.substring(branchStart + 1)).append("</strong>").append('/').append(relativePathInBranch).append("</html>").toString();
        }
        return null;
    }

    private static class LocationRenderer
    extends DefaultListCellRenderer {
        private final Map<String, String> empLocations;

        public LocationRenderer(Map<String, String> locations) {
            this.empLocations = locations;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String html;
            if (value instanceof String && (html = this.empLocations.get((String)value)) != null) {
                value = html;
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }

    private static class SelectionListener
    implements ActionListener,
    PopupMenuListener {
        private final RepositoryFile repositoryFile;
        private final JComboBox combo;
        private boolean popupOn;
        private final String branchesFolderPath;

        public SelectionListener(RepositoryFile repositoryFile, JComboBox combo, String branchesFolderPath) {
            this.repositoryFile = repositoryFile;
            this.combo = combo;
            this.branchesFolderPath = branchesFolderPath;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.combo) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!(SelectionListener.this.popupOn || SelectionListener.this.combo.getSelectedItem() != CopyDialog.SEP && SelectionListener.this.combo.getSelectedItem() != MORE_BRANCHES)) {
                            BranchPicker picker;
                            String text = "";
                            if (SelectionListener.this.combo.getSelectedItem() == MORE_BRANCHES && (picker = new BranchPicker(SelectionListener.this.repositoryFile, SelectionListener.this.branchesFolderPath)).openDialog()) {
                                String relativePath = SVNUrlUtils.getRelativePath((SVNUrl)SelectionListener.this.repositoryFile.getRepositoryUrl(), (SVNUrl)SelectionListener.this.repositoryFile.getFileUrl());
                                text = picker.getSelectedPath() + "/" + CopyDialog.getBranchPathSegments(relativePath)[2];
                            }
                            ((JTextComponent)SelectionListener.this.combo.getEditor().getEditorComponent()).setText(text);
                        }
                    }
                });
            }
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            this.popupOn = true;
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            this.popupOn = false;
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            this.popupOn = true;
        }
    }
}

