/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.proxy.Base64Encoder;
import org.netbeans.modules.subversion.Bundle;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.turbo.CacheIndex;
import org.netbeans.modules.turbo.TurboProvider;
import org.netbeans.modules.versioning.util.FileUtils;
import org.openide.modules.Places;

class DiskMapTurboProvider
implements TurboProvider {
    static final String ATTR_STATUS_MAP = "subversion.STATUS_MAP";
    private static final int STATUS_VALUABLE = -12;
    private static final String CACHE_DIRECTORY = "svncache";
    private static final int DIRECTORY = Integer.highestOneBit(Integer.MAX_VALUE);
    private static final Logger LOG = Logger.getLogger(DiskMapTurboProvider.class.getName());
    private File cacheStore;
    private final CacheIndex index = DiskMapTurboProvider.createCacheIndex();
    private final CacheIndex conflictedIndex = DiskMapTurboProvider.createCacheIndex();
    private final CacheIndex ignoresIndex = DiskMapTurboProvider.createCacheIndex();

    DiskMapTurboProvider() {
        this.initCacheStore();
    }

    File[] getIndexValues(File file, int includeStatus) {
        if (includeStatus == 16448) {
            return this.conflictedIndex.get(file);
        }
        if (includeStatus == 2) {
            return this.ignoresIndex.get(file);
        }
        if ((includeStatus & 2) != 0) {
            File[] files = this.index.get(file);
            File[] ignores = this.ignoresIndex.get(file);
            return this.mergeArrays(files, ignores);
        }
        return this.index.get(file);
    }

    File[] getAllIndexValues() {
        File[] files = this.index.getAllValues();
        File[] ignores = this.ignoresIndex.getAllValues();
        return this.mergeArrays(files, ignores);
    }

    private File[] mergeArrays(File[] arr1, File[] arr2) {
        if (arr1.length == 0) {
            return arr2;
        }
        if (arr2.length == 0) {
            return arr1;
        }
        HashSet<File> merged = new HashSet<File>(Arrays.asList(arr2));
        merged.addAll(Arrays.asList(arr1));
        return merged.toArray(new File[merged.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeIndex() {
        long failedReadCount;
        long entriesCount;
        long ts;
        block44: {
            File[] files;
            block42: {
                ts = System.currentTimeMillis();
                entriesCount = 0L;
                failedReadCount = 0L;
                if (!this.cacheStore.isDirectory()) {
                    this.cacheStore.mkdirs();
                }
                DiskMapTurboProvider diskMapTurboProvider = this;
                synchronized (diskMapTurboProvider) {
                    files = this.cacheStore.listFiles();
                }
                if (files != null) break block42;
                Subversion.LOG.log(Level.INFO, "Finished indexing svn cache with {0} entries. Elapsed time: {1} ms.", new Object[]{entriesCount, System.currentTimeMillis() - ts});
                if (failedReadCount > 0L) {
                    Subversion.LOG.log(Level.INFO, " read failed {0} times.", failedReadCount);
                }
                return;
            }
            try {
                int modifiedFiles = 0;
                int locallyNewFiles = 0;
                HashMap<String, Integer> locallyNewFolders = new HashMap<String, Integer>();
                HashMap<String, Integer> modifiedFolders = new HashMap<String, Integer>();
                for (int i = 0; i < files.length; ++i) {
                    File file = files[i];
                    DiskMapTurboProvider diskMapTurboProvider = this;
                    synchronized (diskMapTurboProvider) {
                        if (!file.getName().endsWith(".bin")) {
                            continue;
                        }
                        boolean readFailed = false;
                        int itemIndex = -1;
                        FilterInputStream dis = null;
                        try {
                            int retry = 0;
                            while (true) {
                                try {
                                    dis = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
                                }
                                catch (IOException ioex) {
                                    if (++retry > 7) {
                                        throw ioex;
                                    }
                                    Thread.sleep(retry * 30);
                                    continue;
                                }
                                break;
                            }
                            itemIndex = 0;
                            block30: while (true) {
                                int pathLen;
                                ++itemIndex;
                                try {
                                    pathLen = ((DataInputStream)dis).readInt();
                                }
                                catch (EOFException e) {
                                    break;
                                }
                                ((DataInputStream)dis).readInt();
                                String path = this.readChars((DataInputStream)dis, pathLen);
                                Map<File, FileInformation> value = this.readValue((DataInputStream)dis, path);
                                Iterator<File> j = value.keySet().iterator();
                                while (true) {
                                    if (!j.hasNext()) continue block30;
                                    ++entriesCount;
                                    File f = j.next();
                                    FileInformation info = value.get(f);
                                    if ((info.getStatus() & 0x4040) != 0) {
                                        this.conflictedIndex.add(f);
                                    }
                                    if ((info.getStatus() & 0xFFFFFFF4) == 0) continue;
                                    this.index.add(f);
                                    ++modifiedFiles;
                                    this.addModifiedFile(modifiedFolders, f);
                                    if ((info.getStatus() & 4) == 0) continue;
                                    ++locallyNewFiles;
                                    this.addLocallyNewFile(locallyNewFolders, info.isDirectory() ? f.getAbsolutePath() : f.getParent());
                                }
                                break;
                            }
                        }
                        catch (EOFException e) {
                            this.logCorruptedCacheFile(file, itemIndex, e);
                            readFailed = true;
                        }
                        catch (Exception e) {
                            Subversion.LOG.log(Level.SEVERE, null, e);
                        }
                        finally {
                            if (dis != null) {
                                try {
                                    dis.close();
                                }
                                catch (IOException e) {}
                            }
                        }
                        if (readFailed) {
                            file.delete();
                            ++failedReadCount;
                        }
                        continue;
                    }
                }
                if (locallyNewFiles > 1000) {
                    this.logTooManyNewFiles(locallyNewFolders, locallyNewFiles);
                    break block44;
                }
                if (modifiedFiles <= 5000) break block44;
                this.logTooManyModifications(modifiedFolders, modifiedFiles);
            }
            catch (Throwable throwable) {
                Subversion.LOG.log(Level.INFO, "Finished indexing svn cache with {0} entries. Elapsed time: {1} ms.", new Object[]{entriesCount, System.currentTimeMillis() - ts});
                if (failedReadCount > 0L) {
                    Subversion.LOG.log(Level.INFO, " read failed {0} times.", failedReadCount);
                }
                throw throwable;
            }
        }
        Subversion.LOG.log(Level.INFO, "Finished indexing svn cache with {0} entries. Elapsed time: {1} ms.", new Object[]{entriesCount, System.currentTimeMillis() - ts});
        if (failedReadCount > 0L) {
            Subversion.LOG.log(Level.INFO, " read failed {0} times.", failedReadCount);
        }
    }

    public boolean recognizesAttribute(String name) {
        return ATTR_STATUS_MAP.equals(name);
    }

    public boolean recognizesEntity(Object key) {
        return key instanceof File;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object readEntry(Object key, String name, TurboProvider.MemoryCache memoryCache) {
        assert (key instanceof File);
        assert (name != null);
        boolean readFailed = false;
        File dir = (File)key;
        File store = this.getStore(dir);
        if (!store.isFile()) {
            return null;
        }
        String dirPath = dir.getAbsolutePath();
        int dirPathLen = dirPath.length();
        FilterInputStream dis = null;
        int itemIndex = -1;
        try {
            int retry = 0;
            while (true) {
                try {
                    dis = new DataInputStream(new BufferedInputStream(new FileInputStream(store)));
                }
                catch (IOException ioex) {
                    if (++retry > 7) {
                        throw ioex;
                    }
                    Thread.sleep(retry * 30);
                    continue;
                }
                break;
            }
            itemIndex = 0;
            while (true) {
                int pathLen;
                ++itemIndex;
                try {
                    pathLen = ((DataInputStream)dis).readInt();
                }
                catch (EOFException e) {
                    break;
                }
                int mapLen = ((DataInputStream)dis).readInt();
                if (pathLen != dirPathLen) {
                    this.skip(dis, pathLen * 2 + mapLen);
                    continue;
                }
                String path = this.readChars((DataInputStream)dis, pathLen);
                if (dirPath.equals(path)) {
                    Map<File, FileInformation> map = this.readValue((DataInputStream)dis, path);
                    return map;
                }
                this.skip(dis, mapLen);
            }
        }
        catch (EOFException e) {
            this.logCorruptedCacheFile(store, itemIndex, e);
            readFailed = true;
        }
        catch (Exception e) {
            Subversion.LOG.log(Level.INFO, e.getMessage(), e);
            readFailed = true;
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException e) {}
            }
        }
        if (readFailed) {
            store.delete();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean writeEntry(Object key, String name, Object value) {
        boolean readFailed;
        File storeNew;
        File store;
        File dir;
        block52: {
            assert (key instanceof File);
            assert (name != null);
            if (value != null) {
                if (!(value instanceof Map)) {
                    return false;
                }
                if (!this.isValuable(value)) {
                    value = null;
                }
            }
            dir = (File)key;
            String dirPath = dir.getAbsolutePath();
            int dirPathLen = dirPath.length();
            store = this.getStore(dir);
            if (value == null && !store.exists()) {
                return true;
            }
            storeNew = new File(store.getParentFile(), store.getName() + ".new");
            if (!this.cacheStore.isDirectory()) {
                this.cacheStore.mkdirs();
            }
            FilterOutputStream oos = null;
            FilterInputStream dis = null;
            readFailed = false;
            int itemIndex = -1;
            try {
                oos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(storeNew)));
                if (value != null) {
                    this.writeEntry((DataOutputStream)oos, dirPath, value);
                }
                if (!store.exists()) break block52;
                int retry = 0;
                while (true) {
                    try {
                        dis = new DataInputStream(new BufferedInputStream(new FileInputStream(store)));
                    }
                    catch (IOException ioex) {
                        if (++retry > 7) {
                            throw ioex;
                        }
                        Thread.sleep(retry * 30);
                        continue;
                    }
                    break;
                }
                itemIndex = 0;
                while (true) {
                    int pathLen;
                    ++itemIndex;
                    try {
                        pathLen = ((DataInputStream)dis).readInt();
                    }
                    catch (EOFException e) {
                        break;
                    }
                    int mapLen = ((DataInputStream)dis).readInt();
                    if (pathLen == dirPathLen) {
                        String path = this.readChars((DataInputStream)dis, pathLen);
                        if (dirPath.equals(path)) {
                            this.skip(dis, mapLen);
                            continue;
                        }
                        ((DataOutputStream)oos).writeInt(pathLen);
                        ((DataOutputStream)oos).writeInt(mapLen);
                        ((DataOutputStream)oos).writeChars(path);
                        DiskMapTurboProvider.copyStreams(oos, dis, mapLen);
                        continue;
                    }
                    ((DataOutputStream)oos).writeInt(pathLen);
                    ((DataOutputStream)oos).writeInt(mapLen);
                    DiskMapTurboProvider.copyStreams(oos, dis, mapLen + pathLen * 2);
                }
            }
            catch (EOFException e) {
                this.logCorruptedCacheFile(store, itemIndex, e);
                readFailed = true;
            }
            catch (FileNotFoundException ex) {
                Subversion.LOG.log(Level.INFO, "File could not be created, check if you are running only a single instance of netbeans for this userdir", ex);
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                Subversion.LOG.log(Level.INFO, "Copy: " + store.getAbsolutePath() + " to: " + storeNew.getAbsolutePath(), e);
                boolean bl = true;
                return bl;
            }
            finally {
                if (oos != null) {
                    try {
                        oos.close();
                    }
                    catch (IOException e) {}
                }
                if (dis != null) {
                    try {
                        dis.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        this.adjustIndex(dir, value);
        if (readFailed) {
            store.delete();
            return true;
        }
        try {
            FileUtils.renameFile((File)storeNew, (File)store);
        }
        catch (FileNotFoundException ex) {
            Subversion.LOG.log(Level.INFO, "File could not be renamed, check if you are running only a single instance of netbeans for this userdir", ex);
        }
        catch (IOException ex) {
            Subversion.LOG.log(Level.SEVERE, null, ex);
        }
        return true;
    }

    private void adjustIndex(File dir, Object value) {
        assert (!dir.isFile());
        Map map = (Map)value;
        Set set = map != null ? map.keySet() : null;
        HashSet<File> conflictedSet = new HashSet<File>();
        HashSet<File> newSet = new HashSet<File>();
        HashSet<File> ignoredSet = new HashSet<File>();
        if (set != null) {
            for (File file : set) {
                FileInformation info = (FileInformation)map.get(file);
                if ((info.getStatus() & 0x4040) != 0) {
                    conflictedSet.add(file);
                }
                if (info.getStatus() == 2) {
                    ignoredSet.add(file);
                    continue;
                }
                if ((info.getStatus() & 2) != 0) {
                    assert (false);
                    ignoredSet.add(file);
                }
                if ((info.getStatus() & 0xFFFFFFF4) == 0) continue;
                newSet.add(file);
            }
        }
        this.index.add(dir, newSet);
        this.ignoresIndex.add(dir, ignoredSet);
        this.conflictedIndex.add(dir, conflictedSet);
    }

    private void logCorruptedCacheFile(File file, int itemIndex, EOFException e) {
        try {
            File tmpFile = File.createTempFile("svn_", ".bin");
            Subversion.LOG.log(Level.INFO, "Corrupted cache file " + file.getAbsolutePath() + " at position " + itemIndex, e);
            FileUtils.copyFile((File)file, (File)tmpFile);
            byte[] contents = FileUtils.getFileContentsAsByteArray((File)tmpFile);
            Subversion.LOG.log(Level.INFO, "Corrupted cache file length: {0}", contents.length);
            String encodedContent = Base64Encoder.encode((byte[])contents);
            Subversion.LOG.log(Level.INFO, "Corrupted cache file content:\n{0}\n", encodedContent);
            Exception ex = new Exception("Corrupted cache file \"" + file.getAbsolutePath() + "\", please report in subversion module issues and attach " + tmpFile.getAbsolutePath() + " plus the IDE message log", e);
            Subversion.LOG.log(Level.INFO, null, ex);
        }
        catch (IOException ex) {
            Subversion.LOG.log(Level.SEVERE, null, ex);
        }
    }

    private void skip(InputStream is, long len) throws IOException {
        while (len > 0L) {
            long n = is.skip(len);
            if (n < 0L) {
                throw new EOFException("Missing " + len + " bytes.");
            }
            len -= n;
        }
    }

    private String readChars(DataInputStream dis, int len) throws IOException {
        if (len < 0 || len > 0xA00000) {
            throw new EOFException("Len: " + len);
        }
        StringBuilder sb = new StringBuilder(len);
        while (len-- > 0) {
            sb.append(dis.readChar());
        }
        return sb.toString();
    }

    private Map<File, FileInformation> readValue(DataInputStream dis, String dirPath) throws IOException {
        HashMap<File, FileInformation> map = new HashMap<File, FileInformation>();
        int len = dis.readInt();
        while (len-- > 0) {
            int status;
            int nameLen = dis.readInt();
            String name = this.readChars(dis, nameLen);
            File file = new File(dirPath, name);
            FileInformation info = new FileInformation(status & DIRECTORY - 1, (status = dis.readInt()) > DIRECTORY - 1);
            map.put(file, info);
        }
        return map;
    }

    private void writeEntry(DataOutputStream dos, String dirPath, Object value) throws IOException {
        Map map = (Map)value;
        Set set = map.keySet();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(set.size() * 50);
        DataOutputStream temp = new DataOutputStream(baos);
        temp.writeInt(set.size());
        for (File file : set) {
            FileInformation info = (FileInformation)map.get(file);
            temp.writeInt(file.getName().length());
            temp.writeChars(file.getName());
            temp.writeInt(info.getStatus() + (info.isDirectory() ? DIRECTORY : 0));
        }
        temp.close();
        byte[] valueBytes = baos.toByteArray();
        dos.writeInt(dirPath.length());
        dos.writeInt(valueBytes.length);
        dos.writeChars(dirPath);
        dos.write(valueBytes);
    }

    private boolean isValuable(Object value) {
        Map map = (Map)value;
        for (FileInformation info : map.values()) {
            if ((info.getStatus() & 0xFFFFFFF4) == 0) continue;
            return true;
        }
        return false;
    }

    private File getStore(File dir) {
        String dirPath = dir.getAbsolutePath();
        int dirHash = dirPath.hashCode();
        return new File(this.cacheStore, Integer.toString(dirHash % 173 + 172) + ".bin");
    }

    private void initCacheStore() {
        this.cacheStore = Places.getCacheSubdirectory((String)CACHE_DIRECTORY);
    }

    private static void copyStreams(OutputStream out, InputStream in, int len) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        int totalLen = len;
        do {
            n = len >= 0 && len <= 4096 ? len : 4096;
            if ((n = in.read(buffer, 0, n)) < 0) {
                throw new EOFException("Missing " + len + " bytes from total " + totalLen + " bytes.");
            }
            out.write(buffer, 0, n);
        } while ((len -= n) != 0);
        out.flush();
    }

    private static CacheIndex createCacheIndex() {
        return new CacheIndex(){

            protected boolean isManaged(File file) {
                return SvnUtils.isManaged(file);
            }
        };
    }

    private void addLocallyNewFile(Map<String, Integer> locallyNewFolders, String path) {
        if (path == null) {
            return;
        }
        boolean toAdd = true;
        String toRemove = null;
        Integer val = locallyNewFolders.get(path);
        if (val != null) {
            locallyNewFolders.put(path, val + 1);
            return;
        }
        for (Map.Entry<String, Integer> e : locallyNewFolders.entrySet()) {
            if (path.startsWith(e.getKey() + File.separator)) {
                e.setValue(e.getValue() + 1);
                toAdd = false;
                break;
            }
            if (!e.getKey().startsWith(path + File.separator)) continue;
            toRemove = e.getKey();
            break;
        }
        if (toRemove != null) {
            locallyNewFolders.put(path, locallyNewFolders.remove(toRemove));
        } else if (toAdd) {
            locallyNewFolders.put(path, 1);
        }
    }

    private void addModifiedFile(Map<String, Integer> modifiedFolders, File file) {
        File topmost = Subversion.getInstance().getTopmostManagedAncestor(file);
        if (topmost != null) {
            String path = topmost.getAbsolutePath();
            Integer val = modifiedFolders.get(path);
            if (val == null) {
                modifiedFolders.put(path, 1);
            } else {
                modifiedFolders.put(path, val + 1);
            }
        }
    }

    private void logTooManyNewFiles(Map<String, Integer> locallyNewFolders, int locallyNewFiles) {
        Map<Integer, List<String>> sortedFolders = DiskMapTurboProvider.sortFolders(locallyNewFolders);
        ArrayList<String> biggestFolders = new ArrayList<String>(3);
        block0: for (Map.Entry<Integer, List<String>> e : sortedFolders.entrySet()) {
            for (String folder : e.getValue()) {
                biggestFolders.add(Bundle.MSG_FileStatusCache_cacheTooBig_ignoreCandidate(folder, e.getKey()));
                if (biggestFolders.size() != 3) continue;
                break block0;
            }
        }
        LOG.log(Level.WARNING, Bundle.MSG_FileStatusCache_cacheTooBig_newFiles_text(locallyNewFiles, biggestFolders));
    }

    private void logTooManyModifications(Map<String, Integer> modifiedFolders, int modifiedFiles) {
        Map<Integer, List<String>> sortedFolders = DiskMapTurboProvider.sortFolders(modifiedFolders);
        ArrayList<String> biggestFolders = new ArrayList<String>(3);
        block0: for (Map.Entry<Integer, List<String>> e : sortedFolders.entrySet()) {
            for (String folder : e.getValue()) {
                biggestFolders.add(Bundle.MSG_FileStatusCache_cacheTooBig_checkoutWithModifications(folder, e.getKey()));
                if (biggestFolders.size() != 3) continue;
                break block0;
            }
        }
        LOG.log(Level.WARNING, Bundle.MSG_FileStatusCache_cacheTooBig_text(modifiedFiles, biggestFolders));
    }

    private static Map<Integer, List<String>> sortFolders(Map<String, Integer> unsortedFolders) {
        TreeMap<Integer, List<String>> sortedFolders = new TreeMap<Integer, List<String>>(new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return -o1.compareTo(o2);
            }
        });
        for (Map.Entry<String, Integer> e : unsortedFolders.entrySet()) {
            ArrayList<String> folders = (ArrayList<String>)sortedFolders.get(e.getValue());
            if (folders == null) {
                folders = new ArrayList<String>();
                sortedFolders.put(e.getValue(), folders);
            }
            folders.add(e.getKey());
        }
        return sortedFolders;
    }
}

