/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.html.lexer;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.PartType;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.html.lexer.HtmlLexer;
import org.netbeans.lib.html.lexer.HtmlPlugins;
import org.netbeans.spi.lexer.EmbeddingPresence;
import org.netbeans.spi.lexer.LanguageEmbedding;
import org.netbeans.spi.lexer.LanguageHierarchy;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerRestartInfo;

public enum HTMLTokenId implements TokenId
{
    TEXT("text"),
    SCRIPT("script"),
    STYLE("style"),
    WS("ws"),
    ERROR("error"),
    TAG_OPEN("tag"),
    TAG_CLOSE("tag"),
    ARGUMENT("argument"),
    OPERATOR("operator"),
    VALUE("value"),
    VALUE_JAVASCRIPT("value"),
    VALUE_CSS("value"),
    BLOCK_COMMENT("block-comment"),
    SGML_COMMENT("sgml-comment"),
    DECLARATION("sgml-declaration"),
    XML_PI("xml-pi"),
    CHARACTER("character"),
    EOL("text"),
    TAG_OPEN_SYMBOL("tag"),
    TAG_CLOSE_SYMBOL("tag"),
    EL_OPEN_DELIMITER("el-delimiter"),
    EL_CLOSE_DELIMITER("el-delimiter"),
    EL_CONTENT("el-content");

    private final String primaryCategory;
    private static final String JAVASCRIPT_MIMETYPE = "text/javascript";
    private static final String STYLE_MIMETYPE = "text/css";
    public static final String VALUE_CSS_TOKEN_TYPE_PROPERTY = "valueCssType";
    public static final String VALUE_CSS_TOKEN_TYPE_ID = "id";
    public static final String VALUE_CSS_TOKEN_TYPE_CLASS = "class";
    public static final String SCRIPT_TYPE_TOKEN_PROPERTY = "type";
    private static final Logger LOGGER;
    private static final boolean LOG;
    private static final Language<HTMLTokenId> language;

    private HTMLTokenId(String primaryCategory) {
        this.primaryCategory = primaryCategory;
    }

    public static Language<HTMLTokenId> language() {
        return language;
    }

    public String primaryCategory() {
        return this.primaryCategory;
    }

    static {
        LOGGER = Logger.getLogger(HtmlLexer.class.getName());
        LOG = LOGGER.isLoggable(Level.FINE);
        language = new LanguageHierarchy<HTMLTokenId>(){

            protected Collection<HTMLTokenId> createTokenIds() {
                return EnumSet.allOf(HTMLTokenId.class);
            }

            protected Map<String, Collection<HTMLTokenId>> createTokenCategories() {
                return null;
            }

            protected Lexer<HTMLTokenId> createLexer(LexerRestartInfo<HTMLTokenId> info) {
                return new HtmlLexer(info);
            }

            protected EmbeddingPresence embeddingPresence(HTMLTokenId id) {
                switch (id) {
                    case VALUE: 
                    case VALUE_JAVASCRIPT: 
                    case VALUE_CSS: 
                    case SCRIPT: 
                    case STYLE: 
                    case EL_CONTENT: {
                        return EmbeddingPresence.ALWAYS_QUERY;
                    }
                }
                return super.embeddingPresence((TokenId)id);
            }

            protected LanguageEmbedding embedding(Token<HTMLTokenId> token, LanguagePath languagePath, InputAttributes inputAttributes) {
                String mimeType = null;
                int startSkipLen = 0;
                int endSkipLen = 0;
                boolean joinSections = true;
                switch ((HTMLTokenId)token.id()) {
                    case VALUE_JAVASCRIPT: {
                        mimeType = HTMLTokenId.JAVASCRIPT_MIMETYPE;
                        PartType ptype = token.partType();
                        startSkipLen = ptype == PartType.COMPLETE || ptype == PartType.START ? 1 : 0;
                        endSkipLen = ptype == PartType.COMPLETE || ptype == PartType.END ? 1 : 0;
                        joinSections = ptype != PartType.END && ptype != PartType.COMPLETE;
                        break;
                    }
                    case VALUE_CSS: {
                        mimeType = HTMLTokenId.STYLE_MIMETYPE;
                        PartType ptype = token.partType();
                        startSkipLen = ptype == PartType.COMPLETE || ptype == PartType.START ? 1 : 0;
                        endSkipLen = ptype == PartType.COMPLETE || ptype == PartType.END ? 1 : 0;
                        joinSections = ptype != PartType.END && ptype != PartType.COMPLETE;
                        break;
                    }
                    case VALUE: {
                        mimeType = (String)token.getProperty((Object)"embeddingMimeType");
                        PartType ptype = token.partType();
                        startSkipLen = ptype == PartType.COMPLETE || ptype == PartType.START ? 1 : 0;
                        endSkipLen = ptype == PartType.COMPLETE || ptype == PartType.END ? 1 : 0;
                        joinSections = ptype != PartType.END && ptype != PartType.COMPLETE;
                        break;
                    }
                    case SCRIPT: {
                        String scriptType = (String)token.getProperty((Object)HTMLTokenId.SCRIPT_TYPE_TOKEN_PROPERTY);
                        mimeType = scriptType != null ? scriptType : HTMLTokenId.JAVASCRIPT_MIMETYPE;
                        break;
                    }
                    case STYLE: {
                        mimeType = HTMLTokenId.STYLE_MIMETYPE;
                        break;
                    }
                    case EL_CONTENT: {
                        Byte elContentProviderIndex = (Byte)token.getProperty((Object)"elci");
                        if (elContentProviderIndex == null) break;
                        mimeType = HtmlPlugins.getDefault().getMimeTypes()[elContentProviderIndex];
                    }
                }
                if (LOG) {
                    LOGGER.log(Level.FINE, String.format("creating embedding for %s on %s (%s)", mimeType, token.text() != null ? token.text().toString() : "no-text", token.id()));
                }
                if (mimeType != null && MimePath.validate((CharSequence)mimeType)) {
                    Language lang = Language.find((String)mimeType);
                    if (lang == null) {
                        LOGGER.log(Level.FINE, String.format("can't find language for mimetype %s!", mimeType));
                        return null;
                    }
                    return LanguageEmbedding.create((Language)lang, (int)startSkipLen, (int)endSkipLen, (boolean)joinSections);
                }
                return null;
            }

            protected String mimeType() {
                return "text/html";
            }
        }.language();
    }
}

