/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.analysis.spi;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.modules.analysis.AnalysisProblem;
import org.netbeans.modules.analysis.SPIAccessor;
import org.netbeans.modules.analysis.ui.AdjustConfigurationPanel;
import org.netbeans.modules.refactoring.api.Scope;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.util.Cancellable;
import org.openide.util.ImageUtilities;

public interface Analyzer
extends Cancellable {
    public Iterable<? extends ErrorDescription> analyze();

    public static abstract class AnalyzerFactory {
        private final String id;
        private final String displayName;
        private final String iconPath;
        private final Image icon;

        public AnalyzerFactory(String id, String displayName, String iconPath) {
            this.id = id;
            this.displayName = displayName;
            this.iconPath = iconPath;
            this.icon = null;
        }

        public AnalyzerFactory(String id, String displayName, Image icon) {
            this.id = id;
            this.displayName = displayName;
            this.iconPath = null;
            this.icon = icon;
        }

        public Collection<? extends MissingPlugin> requiredPlugins(Context context) {
            return Collections.emptyList();
        }

        public abstract Iterable<? extends WarningDescription> getWarnings();

        @CheckForNull
        public abstract <D, C extends JComponent> CustomizerProvider<D, C> getCustomizerProvider();

        public abstract Analyzer createAnalyzer(Context var1);

        public Analyzer createAnalyzer(Context context, Result result) {
            return this.createAnalyzer(context);
        }

        public void warningOpened(ErrorDescription warning) {
        }
    }

    public static final class Context {
        private final Scope scope;
        private final Preferences settings;
        private final String singleWarningId;
        private final ProgressHandle progress;
        private final int bucketStart;
        private final int bucketSize;
        private final Collection<AnalysisProblem> problems = new ArrayList<AnalysisProblem>();
        private int totalWork;

        Context(Scope scope, Preferences settings, String singleWarningId, ProgressHandle progress, int bucketStart, int bucketSize) {
            this.scope = scope;
            this.settings = settings;
            this.singleWarningId = singleWarningId;
            this.progress = progress;
            this.bucketStart = bucketStart;
            this.bucketSize = bucketSize;
        }

        public Scope getScope() {
            return this.scope;
        }

        public Preferences getSettings() {
            return this.settings;
        }

        public String getSingleWarningId() {
            return this.singleWarningId;
        }

        public void start(int workunits) {
            this.totalWork = workunits;
        }

        public void progress(String message, int unit) {
            this.progress.progress(message, this.computeProgress(unit));
        }

        private int computeProgress(int unit) {
            return this.bucketStart + (int)((double)unit / (double)this.totalWork * (double)this.bucketSize);
        }

        public void progress(String message) {
            this.progress.progress(message);
        }

        public void progress(int workunit) {
            this.progress.progress(this.computeProgress(workunit));
        }

        public void finish() {
            this.progress.progress(this.bucketStart + this.bucketSize);
        }

        public void reportAnalysisProblem(String displayName, CharSequence description) {
            this.problems.add(new AnalysisProblem(displayName, description));
        }

        static {
            SPIAccessor.ACCESSOR = new SPIAccessor(){

                @Override
                public Context createContext(Scope scope, Preferences settings, String singleWarningId, ProgressHandle progress, int bucketStart, int bucketSize) {
                    return new Context(scope, settings, singleWarningId, progress, bucketStart, bucketSize);
                }

                @Override
                public Result createResult(List<ErrorDescription> errors, Map<ErrorDescription, Project> errorsToProjects, Collection<AnalysisProblem> analysisProblem) {
                    return new Result(errors, errorsToProjects, analysisProblem);
                }

                @Override
                public String getDisplayName(MissingPlugin missing) {
                    return missing.displayName;
                }

                @Override
                public String getCNB(MissingPlugin missing) {
                    return missing.cnb;
                }

                @Override
                public String getWarningDisplayName(WarningDescription description) {
                    return description.warningDisplayName;
                }

                @Override
                public String getWarningCategoryId(WarningDescription description) {
                    return description.categoryId;
                }

                @Override
                public String getWarningCategoryDisplayName(WarningDescription description) {
                    return description.categoryDisplayName;
                }

                @Override
                public String getWarningId(WarningDescription description) {
                    return description.warningId;
                }

                @Override
                public String getSelectedId(CustomizerContext<?, ?> cc) {
                    return ((CustomizerContext)cc).selectedId;
                }

                @Override
                public String getAnalyzerId(AnalyzerFactory selected) {
                    return selected.id;
                }

                @Override
                public String getAnalyzerDisplayName(AnalyzerFactory a) {
                    return a.displayName;
                }

                @Override
                public Image getAnalyzerIcon(AnalyzerFactory analyzer) {
                    if (analyzer.icon != null) {
                        return analyzer.icon;
                    }
                    return ImageUtilities.loadImage((String)analyzer.iconPath);
                }

                @Override
                public Collection<? extends AnalysisProblem> getAnalysisProblems(Context context) {
                    return context.problems;
                }
            };
        }
    }

    public static final class CustomizerContext<D, C extends JComponent> {
        private final Preferences preferences;
        private final String preselectId;
        private final C previousComponent;
        private final D data;
        private final AdjustConfigurationPanel.ErrorListener errorListener;
        private String selectedId;

        public CustomizerContext(Preferences preferences, String preselectId, C previousComponent, D data, AdjustConfigurationPanel.ErrorListener errorListener) {
            this.preferences = preferences;
            this.preselectId = preselectId;
            this.previousComponent = previousComponent;
            this.data = data;
            this.errorListener = errorListener;
        }

        public Preferences getSettings() {
            return this.preferences;
        }

        public String getPreselectId() {
            return this.preselectId;
        }

        public C getPreviousComponent() {
            return this.previousComponent;
        }

        public D getData() {
            return this.data;
        }

        public void setSelectedId(String id) {
            this.selectedId = id;
        }

        public void setError(@NullAllowed String error) {
            this.errorListener.setError(error);
        }
    }

    public static interface CustomizerProvider<D, C extends JComponent> {
        public D initialize();

        public C createComponent(CustomizerContext<D, C> var1);
    }

    public static final class MissingPlugin {
        private final String cnb;
        private final String displayName;

        public MissingPlugin(String cnb, String displayName) {
            this.cnb = cnb;
            this.displayName = displayName;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MissingPlugin other = (MissingPlugin)obj;
            return !(this.cnb == null ? other.cnb != null : !this.cnb.equals(other.cnb));
        }

        public int hashCode() {
            int hash = 7;
            hash = 89 * hash + (this.cnb != null ? this.cnb.hashCode() : 0);
            return hash;
        }
    }

    public static final class Result {
        private final List<ErrorDescription> errors;
        private final Map<ErrorDescription, Project> errorsToProjects;
        private final Collection<AnalysisProblem> analysisProblems;

        Result(List<ErrorDescription> errors, Map<ErrorDescription, Project> errorsToProjects, Collection<AnalysisProblem> analysisProblems) {
            this.errors = errors;
            this.errorsToProjects = errorsToProjects;
            this.analysisProblems = analysisProblems;
        }

        public void reportAnalysisProblem(String displayName, CharSequence description) {
            this.analysisProblems.add(new AnalysisProblem(displayName, description));
        }

        public void reportError(@NonNull ErrorDescription errorDescription) {
            this.errors.add(errorDescription);
        }

        public void reportError(@NonNull Project owner, @NonNull ErrorDescription errorDescription) {
            this.errors.add(errorDescription);
            this.errorsToProjects.put(errorDescription, owner);
        }
    }

    public static final class WarningDescription {
        private final String warningId;
        private final String warningDisplayName;
        private final String categoryId;
        private final String categoryDisplayName;

        public static WarningDescription create(String warningId, String warningDisplayName, String categoryId, String categoryDisplayName) {
            return new WarningDescription(warningId, warningDisplayName, categoryId, categoryDisplayName);
        }

        private WarningDescription(String warningId, String warningDisplayName, String categoryId, String categoryDisplayName) {
            this.warningId = warningId;
            this.warningDisplayName = warningDisplayName;
            this.categoryId = categoryId;
            this.categoryDisplayName = categoryDisplayName;
        }
    }
}

