/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localtasks.task;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.JTextComponent;
import javax.swing.text.NumberFormatter;
import org.netbeans.modules.bugtracking.api.Issue;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.api.RepositoryManager;
import org.netbeans.modules.bugtracking.api.Util;
import org.netbeans.modules.bugtracking.commons.AttachmentsPanel;
import org.netbeans.modules.bugtracking.commons.CollapsibleSectionPanel;
import org.netbeans.modules.bugtracking.commons.LinkButton;
import org.netbeans.modules.bugtracking.commons.UIUtils;
import org.netbeans.modules.bugtracking.issuetable.TableSorter;
import org.netbeans.modules.bugtracking.spi.SchedulePicker;
import org.netbeans.modules.localtasks.LocalRepository;
import org.netbeans.modules.localtasks.LocalRepositoryConfig;
import org.netbeans.modules.localtasks.task.AddSubtaskPanel;
import org.netbeans.modules.localtasks.task.Bundle;
import org.netbeans.modules.localtasks.task.LocalTask;
import org.netbeans.modules.localtasks.task.SubtaskTableModel;
import org.netbeans.modules.mylyn.util.NbDateRange;
import org.netbeans.modules.mylyn.util.localtasks.IssueField;
import org.netbeans.modules.spellchecker.api.Spellchecker;
import org.netbeans.modules.team.ide.spi.IDEServices;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

final class TaskPanel
extends JPanel {
    private final LocalTask task;
    private final Map<Component, Boolean> enableMap = new HashMap<Component, Boolean>();
    private static final RequestProcessor RP = LocalRepository.getInstance().getRequestProcessor();
    private boolean skipReload;
    private final Set<String> unsavedFields = new UnsavedFieldSet();
    private boolean reloading;
    private boolean noSummary;
    private static final String ATTRIBUTE_PRIVATE_NOTES = "nb.private.notes";
    private static final String ATTRIBUTE_ESTIMATE = "nb.estimate";
    private static final String ATTRIBUTE_DUE_DATE = "nb.due.date";
    private static final String ATTRIBUTE_SCHEDULE_DATE = "nb.schedule.date";
    private static final String ATTRIBUTE_ATTACHMENTS = "nb.unsaved.attachments";
    private static final String ATTRIBUTE_SUBTASKS = "nb.unsaved.subtasks";
    private static final String SECTION_ATTRIBUTES = ".attributes";
    private static final String SECTION_ATTACHMENTS = ".attachments";
    private static final String SECTION_REFERENCES = ".references";
    private JTable subTaskTable;
    private JScrollPane subTaskScrollPane;
    private final AttachmentsPanel attachmentsPanel;
    private static final Logger LOG = LocalRepository.LOG;
    private final IDEServices.DatePickerComponent dueDatePicker;
    private final SchedulePicker scheduleDatePicker;
    private static final NumberFormatter estimateFormatter = new NumberFormatter(new DecimalFormat("#0")){

        @Override
        public Object stringToValue(String text) throws ParseException {
            Number value = (Number)super.stringToValue(text);
            if (value == null) {
                value = 0;
            }
            if (value.intValue() < 0) {
                return 0;
            }
            return value.intValue();
        }
    };
    private Action[] referenceSectionActions;
    private Action[] attachmentsSectionActions;
    private CollapsibleSectionPanel attachmentsSection;
    private JPanel attributesPanel;
    private CollapsibleSectionPanel attributesSection;
    private LinkButton btnAddTaskReference;
    private LinkButton btnCancel;
    private LinkButton btnDismiss;
    private LinkButton btnFinish;
    private LinkButton btnOpen;
    private JLabel dueDateLabel;
    private JTextField dummyDueDateField;
    private JTextField dummyScheduleDateField;
    private JPanel emptyTaskReferencesPanel;
    private JFormattedTextField estimateField;
    private JLabel estimateLabel;
    private JTextField headerField;
    private JPanel headerPanel;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane mainScrollPane;
    private JPanel messagePanel;
    private JLabel notesLabel;
    private JTextArea privateNotesField;
    private JPanel referencesPanel;
    private CollapsibleSectionPanel referencesSection;
    private JLabel scheduleDateLabel;
    private JLabel separatorDismissLabel;
    private JLabel separatorFinishLabel;
    private JLabel separatorOpenLabel;
    private JTextField summaryField;
    private JLabel summaryLabel;

    public TaskPanel(LocalTask task) {
        this.task = task;
        this.initComponents();
        this.updateReadOnlyField(this.headerField);
        Font font = new JLabel().getFont();
        this.headerField.setFont(font.deriveFont((float)((double)font.getSize() * 1.7)));
        this.mainScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.privateNotesField.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                TaskPanel.this.makeCaretVisible(TaskPanel.this.privateNotesField);
            }
        });
        UIUtils.fixFocusTraversalKeys((JComponent)this.privateNotesField);
        this.initSpellChecker();
        this.attachmentsPanel = new AttachmentsPanel((JComponent)this);
        this.attachmentsSection.setContent((JComponent)this.attachmentsPanel);
        GroupLayout layout = (GroupLayout)this.attributesPanel.getLayout();
        this.dueDatePicker = UIUtils.createDatePickerComponent();
        this.scheduleDatePicker = new SchedulePicker();
        layout.replace(this.dummyDueDateField, this.dueDatePicker.getComponent());
        this.dueDateLabel.setLabelFor(this.dueDatePicker.getComponent());
        layout.replace(this.dummyScheduleDateField, this.scheduleDatePicker.getComponent());
        this.scheduleDateLabel.setLabelFor(this.scheduleDatePicker.getComponent());
        this.attachListeners();
    }

    void opened() {
        this.enableComponents(false);
        this.restoreSections();
    }

    void closed() {
        this.persistSections();
    }

    void refreshViewData() {
        assert (EventQueue.isDispatchThread());
        if (this.skipReload) {
            return;
        }
        this.enableComponents(true);
        this.reloading = true;
        String headerTxt = Bundle.LBL_TaskEditor_headerField_text(this.task.getID(), this.task.getSummary());
        this.headerField.setText(headerTxt);
        Dimension dim = this.headerField.getPreferredSize();
        this.headerField.setMinimumSize(new Dimension(0, dim.height));
        this.headerField.setPreferredSize(new Dimension(0, dim.height));
        this.reloadField(this.summaryField, IssueField.SUMMARY);
        this.privateNotesField.setText(this.task.getPrivateNotes());
        this.dueDatePicker.setDate(this.task.getDueDate());
        NbDateRange scheduleDate = this.task.getScheduleDate();
        this.scheduleDatePicker.setScheduleDate(scheduleDate == null ? null : scheduleDate.toSchedulingInfo());
        this.estimateField.setValue(this.task.getEstimate());
        boolean finished = this.task.isFinished();
        this.btnOpen.setVisible(finished);
        this.separatorOpenLabel.setVisible(finished);
        this.btnFinish.setVisible(!finished);
        this.separatorFinishLabel.setVisible(!finished);
        boolean hasSubtasks = this.task.hasSubtasks();
        this.btnAddTaskReference.setVisible(hasSubtasks);
        if (hasSubtasks) {
            if (this.subTaskTable == null) {
                this.subTaskTable = new JTable();
                this.subTaskTable.addMouseListener(new SubTaskTableMouseListener());
                this.subTaskScrollPane = new JScrollPane(this.subTaskTable);
            }
            RP.post(new Runnable(){

                @Override
                public void run() {
                    final SubtaskTableModel tableModel = new SubtaskTableModel(TaskPanel.this.task.getTaskReferences());
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TableSorter sorter = new TableSorter((TableModel)tableModel);
                            TaskPanel.this.subTaskTable.setModel((TableModel)sorter);
                            sorter.setTableHeader(TaskPanel.this.subTaskTable.getTableHeader());
                            int height = 0;
                            for (int row = 0; row < tableModel.getRowCount(); ++row) {
                                height += TaskPanel.this.subTaskTable.getRowHeight(row);
                            }
                            TaskPanel.this.subTaskTable.setPreferredScrollableViewportSize(new Dimension(((TaskPanel)TaskPanel.this).subTaskTable.getPreferredScrollableViewportSize().width, height));
                            if (TaskPanel.this.subTaskScrollPane.getParent() == null) {
                                ((GroupLayout)TaskPanel.this.referencesPanel.getLayout()).replace(TaskPanel.this.emptyTaskReferencesPanel, TaskPanel.this.subTaskScrollPane);
                            }
                            TaskPanel.this.referencesSection.setLabel(NbBundle.getMessage(TaskPanel.class, (String)"TaskPanel.taskReferencesLabel.text", (Object)tableModel.getRowCount()));
                            TaskPanel.this.revalidate();
                        }
                    });
                }
            });
        } else {
            this.referencesSection.setLabel(NbBundle.getMessage(TaskPanel.class, (String)"TaskPanel.taskReferencesLabel.text", (Object)0));
        }
        List<LocalTask.Attachment> attachments = this.task.getAttachments();
        List<AttachmentsPanel.AttachmentInfo> unsaved = this.task.getUnsubmittedAttachments();
        this.attachmentsPanel.setAttachments(attachments, unsaved, null);
        this.attachmentsSection.setLabel(NbBundle.getMessage(TaskPanel.class, (String)"TaskPanel.attachmentsLabel.text", (Object)attachments.size()));
        UIUtils.keepFocusedComponentVisible((Component)this.attachmentsPanel, (JComponent)this);
        this.updateFieldStatuses();
        this.updateNoSummary();
        this.updateMessagePanel();
        this.btnCancel.setEnabled(this.task.hasUnsavedChanges());
        this.reloading = false;
        this.repaint();
    }

    private void initComponents() {
        this.referencesPanel = new JPanel();
        this.emptyTaskReferencesPanel = new JPanel();
        this.btnAddTaskReference = new LinkButton();
        this.attributesPanel = new JPanel();
        this.dueDateLabel = new JLabel();
        this.summaryLabel = new JLabel();
        this.summaryField = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.privateNotesField = new JTextArea(){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                Dimension dim = super.getPreferredScrollableViewportSize();
                JScrollPane scrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, this);
                int delta = 0;
                if (scrollPane != null) {
                    JScrollBar comp = scrollPane.getHorizontalScrollBar();
                    delta = comp.isVisible() ? ((Component)comp).getHeight() : 0;
                }
                Insets insets = this.getInsets();
                int prefHeight = 5 * this.getRowHeight() + insets.top + insets.bottom;
                dim = new Dimension(dim.width, delta + (dim.height < prefHeight ? prefHeight : dim.height));
                return dim;
            }
        };
        this.estimateField = new JFormattedTextField();
        this.estimateLabel = new JLabel();
        this.scheduleDateLabel = new JLabel();
        this.dummyScheduleDateField = new JTextField();
        this.notesLabel = new JLabel();
        this.dummyDueDateField = new JTextField();
        this.headerPanel = new JPanel();
        this.headerField = new JTextField();
        this.jPanel2 = new JPanel();
        this.btnCancel = new LinkButton();
        this.separatorDismissLabel = new JLabel();
        this.btnDismiss = new LinkButton();
        this.separatorFinishLabel = new JLabel();
        this.btnFinish = new LinkButton();
        this.separatorOpenLabel = new JLabel();
        this.btnOpen = new LinkButton();
        this.mainScrollPane = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.messagePanel = new JPanel();
        this.attributesSection = new CollapsibleSectionPanel();
        this.referencesSection = new CollapsibleSectionPanel();
        this.attachmentsSection = new CollapsibleSectionPanel();
        this.referencesPanel.setBackground(UIManager.getDefaults().getColor("TextArea.background"));
        this.emptyTaskReferencesPanel.setBackground(UIManager.getDefaults().getColor("TextArea.background"));
        GroupLayout emptyTaskReferencesPanelLayout = new GroupLayout(this.emptyTaskReferencesPanel);
        this.emptyTaskReferencesPanel.setLayout(emptyTaskReferencesPanelLayout);
        emptyTaskReferencesPanelLayout.setHorizontalGroup(emptyTaskReferencesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        emptyTaskReferencesPanelLayout.setVerticalGroup(emptyTaskReferencesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAddTaskReference, (String)NbBundle.getMessage(TaskPanel.class, (String)"TaskPanel.btnAddTaskReference.text"));
        this.btnAddTaskReference.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TaskPanel.this.btnAddTaskReferenceActionPerformed(evt);
            }
        });
        GroupLayout referencesPanelLayout = new GroupLayout(this.referencesPanel);
        this.referencesPanel.setLayout(referencesPanelLayout);
        referencesPanelLayout.setHorizontalGroup(referencesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(referencesPanelLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(referencesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(referencesPanelLayout.createSequentialGroup().addComponent((Component)this.btnAddTaskReference, -2, -1, -2).addContainerGap(322, Short.MAX_VALUE)).addComponent(this.emptyTaskReferencesPanel, -1, -1, Short.MAX_VALUE))));
        referencesPanelLayout.setVerticalGroup(referencesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(referencesPanelLayout.createSequentialGroup().addComponent(this.emptyTaskReferencesPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.btnAddTaskReference, -2, -1, -2)));
        this.attributesPanel.setBackground(UIManager.getDefaults().getColor("TextArea.background"));
        this.dueDateLabel.setLabelFor(this.dummyDueDateField);
        Mnemonics.setLocalizedText((JLabel)this.dueDateLabel, (String)NbBundle.getMessage(TaskPanel.class, (String)"TaskPanel.dueDateLabel.text"));
        this.dueDateLabel.setToolTipText(NbBundle.getMessage(TaskPanel.class, (String)"TaskPanel.dueDateLabel.toolTipText"));
        this.summaryLabel.setLabelFor(this.summaryField);
        Mnemonics.setLocalizedText((JLabel)this.summaryLabel, (String)NbBundle.getMessage(TaskPanel.class, (String)"TaskPanel.summaryLabel.text"));
        this.summaryLabel.setToolTipText(NbBundle.getMessage(TaskPanel.class, (String)"TaskPanel.summaryLabel.TTtext"));
        this.jScrollPane1.setVerticalScrollBarPolicy(21);
        this.privateNotesField.setColumns(20);
        this.privateNotesField.setLineWrap(true);
        this.privateNotesField.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.privateNotesField);
        this.estimateField.setFormatterFactory(new DefaultFormatterFactory(estimateFormatter));
        this.estimateField.setText(NbBundle.getMessage(TaskPanel.class, (String)"TaskPanel.estimateField.text"));
        this.estimateLabel.setLabelFor(this.estimateField);
        Mnemonics.setLocalizedText((JLabel)this.estimateLabel, (String)NbBundle.getMessage(TaskPanel.class, (String)"TaskPanel.estimateLabel.text"));
        this.estimateLabel.setToolTipText(NbBundle.getMessage(TaskPanel.class, (String)"TaskPanel.estimateLabel.TTtext"));
        this.scheduleDateLabel.setLabelFor(this.dummyScheduleDateField);
        Mnemonics.setLocalizedText((JLabel)this.scheduleDateLabel, (String)NbBundle.getMessage(TaskPanel.class, (String)"TaskPanel.scheduleDateLabel.text"));
        this.scheduleDateLabel.setToolTipText(NbBundle.getMessage(TaskPanel.class, (String)"TaskPanel.scheduleDateLabel.TTtext"));
        this.notesLabel.setLabelFor(this.privateNotesField);
        Mnemonics.setLocalizedText((JLabel)this.notesLabel, (String)NbBundle.getMessage(TaskPanel.class, (String)"TaskPanel.notesLabel.text"));
        this.notesLabel.setToolTipText(NbBundle.getMessage(TaskPanel.class, (String)"TaskPanel.notesLabel.TTtext"));
        GroupLayout attributesPanelLayout = new GroupLayout(this.attributesPanel);
        this.attributesPanel.setLayout(attributesPanelLayout);
        attributesPanelLayout.setHorizontalGroup(attributesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(attributesPanelLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(attributesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(attributesPanelLayout.createSequentialGroup().addGap(3, 3, 3).addComponent(this.dueDateLabel)).addGroup(attributesPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.notesLabel).addComponent(this.summaryLabel))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(attributesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.summaryField).addComponent(this.jScrollPane1).addGroup(attributesPanelLayout.createSequentialGroup().addComponent(this.dummyDueDateField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scheduleDateLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dummyScheduleDateField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.estimateLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.estimateField, -2, 65, -2).addGap(0, 38, Short.MAX_VALUE))).addGap(0, 0, 0)));
        attributesPanelLayout.setVerticalGroup(attributesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(attributesPanelLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(attributesPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.summaryLabel).addComponent(this.summaryField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(attributesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.scheduleDateLabel).addComponent(this.dueDateLabel).addComponent(this.estimateLabel).addComponent(this.dummyDueDateField, -2, -1, -2).addComponent(this.estimateField, -2, -1, -2).addComponent(this.dummyScheduleDateField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(attributesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.notesLabel).addComponent(this.jScrollPane1, -2, -1, -2)).addGap(0, 0, 0)));
        this.setBackground(UIManager.getDefaults().getColor("TextArea.background"));
        this.headerPanel.setBackground(UIManager.getDefaults().getColor("TextArea.background"));
        this.headerField.setEditable(false);
        this.headerField.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jPanel2.setBackground(UIManager.getDefaults().getColor("TextArea.background"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnCancel, (String)NbBundle.getMessage(TaskPanel.class, (String)"TaskPanel.btnCancel.text"));
        this.btnCancel.setToolTipText(NbBundle.getMessage(TaskPanel.class, (String)"TaskPanel.btnCancel.TTtext"));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TaskPanel.this.btnCancelActionPerformed(evt);
            }
        });
        this.separatorDismissLabel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.separatorDismissLabel.setFocusable(false);
        Mnemonics.setLocalizedText((AbstractButton)this.btnDismiss, (String)NbBundle.getMessage(TaskPanel.class, (String)"TaskPanel.btnDismiss.text"));
        this.btnDismiss.setToolTipText(NbBundle.getMessage(TaskPanel.class, (String)"TaskPanel.btnDismiss.TTtext"));
        this.btnDismiss.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TaskPanel.this.btnDismissActionPerformed(evt);
            }
        });
        this.separatorFinishLabel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.separatorFinishLabel.setFocusable(false);
        Mnemonics.setLocalizedText((AbstractButton)this.btnFinish, (String)NbBundle.getMessage(TaskPanel.class, (String)"TaskPanel.btnFinish.text"));
        this.btnFinish.setToolTipText(NbBundle.getMessage(TaskPanel.class, (String)"TaskPanel.btnFinish.TTtext"));
        this.btnFinish.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TaskPanel.this.btnFinishActionPerformed(evt);
            }
        });
        this.separatorOpenLabel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.separatorOpenLabel.setFocusable(false);
        Mnemonics.setLocalizedText((AbstractButton)this.btnOpen, (String)NbBundle.getMessage(TaskPanel.class, (String)"TaskPanel.btnOpen.text"));
        this.btnOpen.setToolTipText(NbBundle.getMessage(TaskPanel.class, (String)"TaskPanel.btnOpen.TTtext"));
        this.btnOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TaskPanel.this.btnOpenActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent((Component)this.btnCancel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.separatorDismissLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.btnDismiss, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.separatorFinishLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.btnFinish, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.separatorOpenLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.btnOpen, -2, -1, -2).addGap(0, 0, 0)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(0, 0, 0).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent((Component)this.btnCancel, -2, -1, -2).addComponent(this.separatorDismissLabel, -1, -1, Short.MAX_VALUE).addComponent((Component)this.btnDismiss, -2, -1, -2).addComponent(this.separatorFinishLabel, -1, -1, Short.MAX_VALUE).addComponent((Component)this.btnFinish, -2, -1, -2).addComponent(this.separatorOpenLabel, -1, -1, Short.MAX_VALUE).addComponent((Component)this.btnOpen, -2, -1, -2))));
        GroupLayout headerPanelLayout = new GroupLayout(this.headerPanel);
        this.headerPanel.setLayout(headerPanelLayout);
        headerPanelLayout.setHorizontalGroup(headerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(headerPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.headerField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addContainerGap()));
        headerPanelLayout.setVerticalGroup(headerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(headerPanelLayout.createSequentialGroup().addContainerGap().addGroup(headerPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.headerField, -2, -1, -2).addComponent(this.jPanel2, -1, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.mainScrollPane.setBorder(null);
        this.jPanel1.setBackground(UIManager.getDefaults().getColor("TextArea.background"));
        this.messagePanel.setBackground(UIManager.getDefaults().getColor("TextArea.background"));
        this.messagePanel.setLayout(new BoxLayout(this.messagePanel, 1));
        this.attributesSection.setBackground(UIManager.getDefaults().getColor("TextArea.background"));
        this.attributesSection.setContent((JComponent)this.attributesPanel);
        this.attributesSection.setLabel(NbBundle.getMessage(TaskPanel.class, (String)"TaskPanel.attributesSection.label"));
        this.referencesSection.setBackground(UIManager.getDefaults().getColor("TextArea.background"));
        this.referencesSection.setActions(this.getReferencesSectionActions());
        this.referencesSection.setContent((JComponent)this.referencesPanel);
        this.referencesSection.setLabel(NbBundle.getMessage(TaskPanel.class, (String)"TaskPanel.taskReferencesLabel.text", (Object)0));
        this.attachmentsSection.setBackground(UIManager.getDefaults().getColor("TextArea.background"));
        this.attachmentsSection.setActions(this.getAttachmentsSectionActions());
        this.attachmentsSection.setLabel(NbBundle.getMessage(TaskPanel.class, (String)"TaskPanel.attachmentsLabel.text", (Object)0));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.messagePanel, -1, -1, Short.MAX_VALUE).addComponent((Component)this.attachmentsSection, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent((Component)this.referencesSection, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent((Component)this.attributesSection, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent((Component)this.attributesSection, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.referencesSection, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.attachmentsSection, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.messagePanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.mainScrollPane.setViewportView(this.jPanel1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.headerPanel, -1, -1, Short.MAX_VALUE).addComponent(this.mainScrollPane)).addGap(0, 0, 0)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.headerPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mainScrollPane)));
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.discardUnsavedChanges();
    }

    private void btnDismissActionPerformed(ActionEvent evt) {
        if (0 != JOptionPane.showConfirmDialog(WindowManager.getDefault().getMainWindow(), Bundle.MSG_IssuePanel_deleteTask_message(), Bundle.LBL_IssuePanel_deleteTask_title(), 0, 3)) {
            return;
        }
        RP.post(new Runnable(){

            @Override
            public void run() {
                TaskPanel.this.task.delete();
            }
        });
    }

    private void btnFinishActionPerformed(ActionEvent evt) {
        this.skipReload = true;
        this.enableComponents(false);
        RP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean fFinished;
                boolean finished = false;
                try {
                    fFinished = finished = TaskPanel.this.task.finish();
                }
                catch (Throwable throwable) {
                    boolean fFinished2 = finished;
                    EventQueue.invokeLater(new Runnable(fFinished2){
                        final /* synthetic */ boolean val$fFinished;
                        {
                            this.val$fFinished = bl;
                        }

                        @Override
                        public void run() {
                            TaskPanel.this.enableComponents(true);
                            TaskPanel.this.btnOpen.setVisible(this.val$fFinished);
                            TaskPanel.this.separatorOpenLabel.setVisible(this.val$fFinished);
                            TaskPanel.this.btnFinish.setVisible(!this.val$fFinished);
                            TaskPanel.this.separatorFinishLabel.setVisible(!this.val$fFinished);
                            TaskPanel.this.skipReload = false;
                        }
                    });
                    throw throwable;
                }
                EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
    }

    private void btnOpenActionPerformed(ActionEvent evt) {
        this.skipReload = true;
        this.enableComponents(false);
        RP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean fOpened;
                boolean open = false;
                try {
                    fOpened = open = TaskPanel.this.task.reopen();
                }
                catch (Throwable throwable) {
                    boolean fOpened2 = open;
                    EventQueue.invokeLater(new Runnable(fOpened2){
                        final /* synthetic */ boolean val$fOpened;
                        {
                            this.val$fOpened = bl;
                        }

                        @Override
                        public void run() {
                            TaskPanel.this.enableComponents(true);
                            TaskPanel.this.btnOpen.setVisible(!this.val$fOpened);
                            TaskPanel.this.separatorOpenLabel.setVisible(!this.val$fOpened);
                            TaskPanel.this.btnFinish.setVisible(this.val$fOpened);
                            TaskPanel.this.separatorFinishLabel.setVisible(this.val$fOpened);
                            TaskPanel.this.skipReload = false;
                        }
                    });
                    throw throwable;
                }
                EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
    }

    private void btnAddTaskReferenceActionPerformed(ActionEvent evt) {
        this.referencesSection.setExpanded(true);
        final JButton okButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)okButton, (String)Bundle.CTL_SelectSubtask_ok());
        okButton.setEnabled(false);
        final AddSubtaskPanel panel = new AddSubtaskPanel();
        panel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean enabled = panel.getIssue() != null;
                panel.errorLabel.setVisible(false);
                if (enabled) {
                    String repoId = panel.getIssue().getRepository().getId();
                    String taskId = panel.getIssue().getID();
                    if (repoId.equals(LocalRepository.getInstance().getRepository().getId()) && taskId.equals(TaskPanel.this.task.getID())) {
                        panel.errorLabel.setText(Bundle.MSG_SelectSubtask_error_sametask());
                        panel.errorLabel.setVisible(true);
                        enabled = false;
                    } else {
                        for (LocalTask.TaskReference ref : TaskPanel.this.task.getTaskReferences()) {
                            if (!repoId.equals(ref.getRepositoryId()) || !taskId.equals(ref.getTaskId())) continue;
                            panel.errorLabel.setText(Bundle.MSG_SelectSubtask_error_alreadyreferenced());
                            panel.errorLabel.setVisible(true);
                            enabled = false;
                        }
                    }
                }
                okButton.setEnabled(enabled);
            }
        });
        DialogDescriptor dd = new DialogDescriptor((Object)panel, Bundle.LBL_SelectSubtask_title(), true, new Object[]{okButton, DialogDescriptor.CANCEL_OPTION}, (Object)okButton, 0, null, null);
        Dialog dlg = DialogDisplayer.getDefault().createDialog(dd);
        dlg.pack();
        panel.errorLabel.setVisible(false);
        dlg.setVisible(true);
        Issue issue = panel.getIssue();
        if (dd.getValue() == okButton && issue != null) {
            this.unsavedFields.add(ATTRIBUTE_SUBTASKS);
            this.updateFieldDecorations(ATTRIBUTE_SUBTASKS, this.referencesSection.getLabelComponent());
            this.task.addTaskReference(issue);
            this.refreshViewData();
        }
    }

    private void enableComponents(boolean enable) {
        this.enableComponents(this, enable);
        if (enable) {
            this.enableMap.clear();
        }
    }

    private void enableComponents(Component comp, boolean enable) {
        if (comp instanceof Container) {
            for (Component subComp : ((Container)comp).getComponents()) {
                this.enableComponents(subComp, enable);
            }
        }
        if (comp instanceof JComboBox || comp instanceof JTextComponent && ((JTextComponent)comp).isEditable() || comp instanceof AbstractButton || comp instanceof JList) {
            if (enable) {
                Boolean b = this.enableMap.get(comp);
                if (b != null) {
                    comp.setEnabled(b);
                }
            } else {
                this.enableMap.put(comp, comp.isEnabled());
                comp.setEnabled(false);
            }
        }
    }

    private void updateReadOnlyField(JTextField field) {
        Color bkColor;
        if ("GTK".equals(UIManager.getLookAndFeel().getID())) {
            field.setUI(new BasicTextFieldUI());
        }
        if (null != (bkColor = this.getBackground())) {
            bkColor = new Color(bkColor.getRGB());
        }
        field.setBackground(bkColor);
        Caret caret = field.getCaret();
        if (caret instanceof DefaultCaret) {
            ((DefaultCaret)caret).setUpdatePolicy(1);
        }
    }

    private void updateFieldStatuses() {
        this.updateFieldDecorations(IssueField.SUMMARY.getKey(), this.summaryLabel);
        this.updateFieldDecorations(ATTRIBUTE_PRIVATE_NOTES, this.notesLabel);
        this.updateFieldDecorations(ATTRIBUTE_ATTACHMENTS, this.attachmentsSection.getLabelComponent());
        this.updateFieldDecorations(ATTRIBUTE_SUBTASKS, this.referencesSection.getLabelComponent());
        this.updateFieldDecorations(ATTRIBUTE_DUE_DATE, this.dueDateLabel);
        this.updateFieldDecorations(ATTRIBUTE_SCHEDULE_DATE, this.scheduleDateLabel);
        this.updateFieldDecorations(ATTRIBUTE_ESTIMATE, this.estimateLabel);
    }

    private void updateFieldDecorations(String key, JComponent fieldLabel) {
        boolean fieldDirty = this.unsavedFields.contains(key);
        if (fieldLabel != null) {
            if (fieldDirty) {
                fieldLabel.setFont(fieldLabel.getFont().deriveFont(fieldLabel.getFont().getStyle() | 1));
            } else {
                fieldLabel.setFont(fieldLabel.getFont().deriveFont(fieldLabel.getFont().getStyle() & 0xFFFFFFFE));
            }
        }
    }

    void modelStateChanged(final boolean dirty) {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                if (!TaskPanel.this.reloading && dirty) {
                    TaskPanel.this.task.markUserChange();
                }
                if (!dirty) {
                    TaskPanel.this.unsavedFields.clear();
                }
                if (TaskPanel.this.enableMap.isEmpty()) {
                    TaskPanel.this.btnCancel.setEnabled(dirty);
                } else {
                    TaskPanel.this.enableMap.put(TaskPanel.this.btnCancel, dirty);
                }
                if (dirty) {
                    TaskPanel.this.task.fireChangeEvent();
                }
            }
        });
    }

    private void reloadField(JComponent component, IssueField field) {
        String newValue = this.task.getFieldValue(field);
        boolean fieldDirty = this.unsavedFields.contains(field.getKey());
        if (!fieldDirty) {
            if (component instanceof JComboBox) {
                throw new UnsupportedOperationException();
            }
            if (component instanceof JTextComponent) {
                ((JTextComponent)component).setText(newValue);
            } else if (component instanceof JList) {
                JList list = (JList)component;
                list.clearSelection();
                ListModel model = list.getModel();
                for (String value : this.task.getFieldValues(field)) {
                    for (int i = 0; i < model.getSize(); ++i) {
                        if (!value.equals(model.getElementAt(i))) continue;
                        list.addSelectionInterval(i, i);
                    }
                }
            } else if (component instanceof JCheckBox) {
                ((JCheckBox)component).setSelected("1".equals(newValue));
            }
        }
    }

    private void updateNoSummary() {
        boolean oldSummary = this.noSummary;
        this.noSummary = this.summaryField.getText().trim().isEmpty();
        if (this.noSummary != oldSummary) {
            this.updateMessagePanel();
        }
    }

    private void updateMessagePanel() {
        this.messagePanel.removeAll();
        if (this.noSummary) {
            JLabel noSummaryLabel = new JLabel();
            noSummaryLabel.setText(Bundle.IssuePanel_noSummary());
            String icon = "org/netbeans/modules/localtasks/resources/error.gif";
            noSummaryLabel.setIcon(new ImageIcon(ImageUtilities.loadImage((String)icon)));
            this.messagePanel.add(noSummaryLabel);
        }
        if (this.noSummary) {
            this.messagePanel.setVisible(true);
            this.messagePanel.revalidate();
        } else {
            this.messagePanel.setVisible(false);
        }
    }

    private void attachListeners() {
        this.summaryField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                TaskPanel.this.updateNoSummary();
            }
        });
        this.summaryField.getDocument().addDocumentListener(new FieldChangeListener(this.summaryField, IssueField.SUMMARY, this.summaryLabel));
        this.privateNotesField.getDocument().addDocumentListener(new TaskAttributeListener(this.privateNotesField, ATTRIBUTE_PRIVATE_NOTES, this.notesLabel){

            @Override
            protected boolean storeValue() {
                TaskPanel.this.task.setTaskPrivateNotes(TaskPanel.this.privateNotesField.getText());
                return true;
            }
        });
        this.dueDatePicker.addChangeListener((ChangeListener)new DatePickerListener(this.dueDatePicker.getComponent(), ATTRIBUTE_DUE_DATE, this.dueDateLabel){

            @Override
            protected boolean storeValue() {
                TaskPanel.this.task.setTaskDueDate(TaskPanel.this.dueDatePicker.getDate(), false);
                return true;
            }
        });
        this.scheduleDatePicker.addChangeListener((ChangeListener)new DatePickerListener(this.scheduleDatePicker.getComponent(), ATTRIBUTE_SCHEDULE_DATE, this.scheduleDateLabel){

            @Override
            protected boolean storeValue() {
                TaskPanel.this.task.setTaskScheduleDate(TaskPanel.this.scheduleDatePicker.getScheduleDate(), false);
                return true;
            }
        });
        this.estimateField.getDocument().addDocumentListener(new TaskAttributeListener(this.estimateField, ATTRIBUTE_ESTIMATE, this.estimateLabel){

            @Override
            protected boolean storeValue() {
                int value = ((Number)TaskPanel.this.estimateField.getValue()).intValue();
                if (value != TaskPanel.this.task.getEstimate()) {
                    TaskPanel.this.task.setTaskEstimate(value, false);
                    return true;
                }
                return false;
            }
        });
        this.attachmentsPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!TaskPanel.this.reloading && TaskPanel.this.attachmentsPanel.isVisible()) {
                    TaskPanel.this.task.setUnsubmittedAttachments(TaskPanel.this.attachmentsPanel.getNewAttachments());
                    TaskPanel.this.unsavedFields.add(TaskPanel.ATTRIBUTE_ATTACHMENTS);
                    TaskPanel.this.updateFieldDecorations(TaskPanel.ATTRIBUTE_ATTACHMENTS, TaskPanel.this.attachmentsSection.getLabelComponent());
                }
            }
        });
    }

    private void storeFieldValue(IssueField field, JTextComponent textComponent) {
        this.storeFieldValue(field, textComponent.getText());
    }

    private void storeFieldValue(IssueField field, String value) {
        boolean changed = false;
        if (changed || !this.task.getFieldValue(field).equals(value)) {
            this.unsavedFields.add(field.getKey());
            this.task.setFieldValue(field, value);
        }
    }

    void attachmentDeleted() {
        this.unsavedFields.add(ATTRIBUTE_ATTACHMENTS);
        this.refreshViewData();
    }

    private void makeCaretVisible(JTextArea textArea) {
        int pos = textArea.getCaretPosition();
        try {
            Rectangle rec = textArea.getUI().modelToView(textArea, pos);
            if (rec != null) {
                Point p = SwingUtilities.convertPoint(textArea, rec.x, rec.y, this);
                this.scrollRectToVisible(new Rectangle(p.x, p.y, rec.width, rec.height));
            }
        }
        catch (BadLocationException blex) {
            LOG.log(Level.INFO, blex.getMessage(), blex);
        }
    }

    private void initSpellChecker() {
        Spellchecker.register((JTextComponent)this.summaryField);
        Spellchecker.register((JTextComponent)this.privateNotesField);
    }

    private Action[] getReferencesSectionActions() {
        if (this.referenceSectionActions == null) {
            this.referenceSectionActions = new Action[]{new AbstractAction(NbBundle.getMessage(TaskPanel.class, (String)"TaskPanel.btnAddTaskReference.text")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TaskPanel.this.btnAddTaskReferenceActionPerformed(e);
                }
            }};
        }
        return this.referenceSectionActions;
    }

    private Action[] getAttachmentsSectionActions() {
        if (this.attachmentsSectionActions == null) {
            this.attachmentsSectionActions = new Action[]{new AbstractAction(Bundle.CTL_Attachment_action_create()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TaskPanel.this.attachmentsSection.setExpanded(true);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TaskPanel.this.attachmentsPanel.createAttachment();
                        }
                    });
                }
            }};
        }
        return this.attachmentsSectionActions;
    }

    private void persistSections() {
        LocalRepositoryConfig config = LocalRepositoryConfig.getInstance();
        config.setEditorSectionCollapsed(this.task.getID(), SECTION_ATTRIBUTES, !this.attributesSection.isExpanded());
        config.setEditorSectionCollapsed(this.task.getID(), SECTION_REFERENCES, !this.referencesSection.isExpanded());
        config.setEditorSectionCollapsed(this.task.getID(), SECTION_ATTACHMENTS, !this.attachmentsSection.isExpanded());
    }

    private void restoreSections() {
        LocalRepositoryConfig config = LocalRepositoryConfig.getInstance();
        this.attributesSection.setExpanded(!config.isEditorSectionCollapsed(this.task.getID(), SECTION_ATTRIBUTES, false));
        this.attachmentsSection.setExpanded(!config.isEditorSectionCollapsed(this.task.getID(), SECTION_ATTACHMENTS, true));
        this.referencesSection.setExpanded(!config.isEditorSectionCollapsed(this.task.getID(), SECTION_REFERENCES, true));
    }

    boolean saveChanges() {
        this.skipReload = true;
        this.enableComponents(false);
        final boolean[] retval = new boolean[]{true};
        Runnable outOfAWT = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                retval[0] = false;
                try {
                    retval[0] = TaskPanel.this.task.save();
                }
                catch (Throwable throwable) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TaskPanel.this.unsavedFields.clear();
                            TaskPanel.this.enableComponents(true);
                            TaskPanel.this.skipReload = false;
                            TaskPanel.this.refreshViewData();
                        }
                    });
                    throw throwable;
                }
                EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        };
        if (EventQueue.isDispatchThread()) {
            RP.post(outOfAWT);
            return true;
        }
        outOfAWT.run();
        return retval[0];
    }

    boolean discardUnsavedChanges() {
        this.skipReload = true;
        this.enableComponents(false);
        Runnable outOfAWT = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    TaskPanel.this.task.clearModifications();
                }
                catch (Throwable throwable) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TaskPanel.this.unsavedFields.clear();
                            TaskPanel.this.enableComponents(true);
                            TaskPanel.this.btnCancel.setEnabled(false);
                            TaskPanel.this.skipReload = false;
                            TaskPanel.this.refreshViewData();
                        }
                    });
                    throw throwable;
                }
                EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        };
        if (EventQueue.isDispatchThread()) {
            RP.post(outOfAWT);
        } else {
            outOfAWT.run();
        }
        return true;
    }

    void addChangeListener(ChangeListener l) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    void removeChangeListener(ChangeListener l) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private abstract class DatePickerListener
    implements ChangeListener {
        private final String attributeName;
        private final JComponent component;
        private final JComponent fieldLabel;

        public DatePickerListener(JComponent component, String attributeName, JComponent fieldLabel) {
            this.component = component;
            this.attributeName = attributeName;
            this.fieldLabel = fieldLabel;
        }

        void fieldModified() {
            if (!TaskPanel.this.reloading && this.isEnabled() && this.storeValue()) {
                TaskPanel.this.unsavedFields.add(this.attributeName);
                this.updateDecorations();
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.fieldModified();
        }

        public boolean isEnabled() {
            return this.component.isVisible() && this.component.isEnabled();
        }

        protected final void updateDecorations() {
            TaskPanel.this.updateFieldDecorations(this.attributeName, this.fieldLabel);
        }

        protected abstract boolean storeValue();
    }

    private class FieldChangeListener
    implements DocumentListener,
    ActionListener,
    ListSelectionListener {
        private final IssueField field;
        private final JComponent component;
        private final JComponent fieldLabel;

        public FieldChangeListener(JComponent component, IssueField field, JComponent fieldLabel) {
            this.component = component;
            this.field = field;
            this.fieldLabel = fieldLabel;
        }

        @Override
        public final void insertUpdate(DocumentEvent e) {
            this.fieldModified();
        }

        @Override
        public final void removeUpdate(DocumentEvent e) {
            this.fieldModified();
        }

        @Override
        public final void changedUpdate(DocumentEvent e) {
            this.fieldModified();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.component) {
                this.fieldModified();
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting() && e.getSource() == this.component) {
                this.fieldModified();
            }
        }

        void fieldModified() {
            if (!TaskPanel.this.reloading && this.isEnabled()) {
                if (this.component instanceof JTextComponent) {
                    TaskPanel.this.storeFieldValue(this.field, (JTextComponent)this.component);
                    this.updateDecorations();
                } else if (!(this.component instanceof JList) && !(this.component instanceof JComboBox) && this.component instanceof JCheckBox) {
                    TaskPanel.this.storeFieldValue(this.field, ((JCheckBox)this.component).isSelected() ? "1" : "0");
                    this.updateDecorations();
                }
            }
        }

        public boolean isEnabled() {
            return this.component.isVisible() && this.component.isEnabled();
        }

        protected final void updateDecorations() {
            TaskPanel.this.updateFieldDecorations(this.field.getKey(), this.fieldLabel);
        }
    }

    private class RemoveTaskReferenceAction
    extends AbstractAction {
        private final String repositoryId;
        private final String taskId;

        public RemoveTaskReferenceAction(String repositoryId, String taskId) {
            super(Bundle.CTL_TaskPanel_RemoveTaskReferenceAction_name());
            this.repositoryId = repositoryId;
            this.taskId = taskId;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TaskPanel.this.unsavedFields.add(TaskPanel.ATTRIBUTE_SUBTASKS);
            TaskPanel.this.updateFieldDecorations(TaskPanel.ATTRIBUTE_SUBTASKS, TaskPanel.this.referencesSection.getLabelComponent());
            TaskPanel.this.task.removeTaskReference(this.repositoryId, this.taskId);
            TaskPanel.this.refreshViewData();
        }
    }

    private class SubTaskTableMouseListener
    extends MouseAdapter {
        private SubTaskTableMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.handleMouseEvent(e, false);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.handleMouseEvent(e, true);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.handleMouseEvent(e, true);
        }

        private void handleMouseEvent(MouseEvent e, boolean popup) {
            final Point p = e.getPoint();
            int row = TaskPanel.this.subTaskTable.rowAtPoint(p);
            TableModel model = TaskPanel.this.subTaskTable.getModel();
            final String repositoryId = (String)model.getValueAt(row, 2);
            final String taskId = (String)model.getValueAt(row, 3);
            if (!repositoryId.isEmpty() && !taskId.isEmpty()) {
                if (!popup && e.getClickCount() == 2) {
                    RP.post(new Runnable(){

                        @Override
                        public void run() {
                            for (Repository r : RepositoryManager.getInstance().getRepositories()) {
                                if (!repositoryId.equals(r.getId())) continue;
                                Util.openIssue((Repository)r, (String)taskId);
                                break;
                            }
                        }
                    });
                } else if (e.isPopupTrigger()) {
                    TaskPanel.this.subTaskTable.getSelectionModel().setSelectionInterval(row, row);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JPopupMenu menu = new JPopupMenu();
                            menu.add(new RemoveTaskReferenceAction(repositoryId, taskId));
                            menu.show(TaskPanel.this.subTaskTable, p.x, p.y);
                        }
                    });
                }
            }
        }
    }

    private abstract class TaskAttributeListener
    implements DocumentListener {
        private final String attributeName;
        private final JComponent component;
        private final JComponent fieldLabel;

        public TaskAttributeListener(JComponent component, String attributeName, JComponent fieldLabel) {
            this.component = component;
            this.attributeName = attributeName;
            this.fieldLabel = fieldLabel;
        }

        @Override
        public final void insertUpdate(DocumentEvent e) {
            this.fieldModified();
        }

        @Override
        public final void removeUpdate(DocumentEvent e) {
            this.fieldModified();
        }

        @Override
        public final void changedUpdate(DocumentEvent e) {
            this.fieldModified();
        }

        void fieldModified() {
            if (!TaskPanel.this.reloading && this.isEnabled() && this.storeValue()) {
                TaskPanel.this.unsavedFields.add(this.attributeName);
                this.updateDecorations();
            }
        }

        public boolean isEnabled() {
            return this.component.isVisible() && this.component.isEnabled();
        }

        protected final void updateDecorations() {
            TaskPanel.this.updateFieldDecorations(this.attributeName, this.fieldLabel);
        }

        protected abstract boolean storeValue();
    }

    private class UnsavedFieldSet
    extends HashSet<String> {
        private UnsavedFieldSet() {
        }

        @Override
        public boolean add(String value) {
            boolean added = super.add(value);
            if (added) {
                TaskPanel.this.task.fireChangeEvent();
            }
            return added;
        }

        @Override
        public boolean remove(Object o) {
            boolean removed = super.remove(o);
            if (removed && this.isEmpty()) {
                TaskPanel.this.task.fireChangeEvent();
            }
            return removed;
        }

        @Override
        public void clear() {
            boolean fire = !this.isEmpty();
            super.clear();
            if (fire) {
                TaskPanel.this.task.fireChangeEvent();
            }
        }
    }
}

