/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localtasks;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import org.netbeans.modules.bugtracking.spi.QueryProvider;
import org.netbeans.modules.localtasks.Bundle;
import org.netbeans.modules.localtasks.LocalRepository;
import org.netbeans.modules.localtasks.task.LocalTask;

public final class LocalQuery {
    private static LocalQuery instance;
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private QueryProvider.IssueContainer<LocalTask> delegatingIssueContainer;

    static LocalQuery getInstance() {
        if (instance == null) {
            instance = new LocalQuery();
        }
        return instance;
    }

    private LocalQuery() {
    }

    String getDisplayName() {
        return Bundle.LBL_LocalQuery_displayName();
    }

    String getTooltip() {
        return Bundle.LBL_LocalQuery_tooltip();
    }

    Collection<LocalTask> getIssues() {
        return LocalRepository.getInstance().getTasks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refresh() {
        try {
            if (this.delegatingIssueContainer != null) {
                this.delegatingIssueContainer.refreshingStarted();
                for (LocalTask t : this.getIssues()) {
                    this.delegatingIssueContainer.add((Object[])new LocalTask[]{t});
                }
            }
        }
        finally {
            this.fireFinished();
        }
    }

    void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    void setIssueContainer(QueryProvider.IssueContainer<LocalTask> c) {
        this.delegatingIssueContainer = c;
    }

    void addTask(LocalTask lt) {
        if (this.delegatingIssueContainer != null) {
            this.delegatingIssueContainer.add((Object[])new LocalTask[]{lt});
        }
        this.fireFinished();
    }

    void removeTask(LocalTask lt) {
        if (this.delegatingIssueContainer != null) {
            this.delegatingIssueContainer.remove((Object[])new LocalTask[]{lt});
        }
        this.fireFinished();
    }

    void fireFinished() {
        if (this.delegatingIssueContainer != null) {
            this.delegatingIssueContainer.refreshingFinished();
        }
    }
}

