/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.lib;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.html.editor.lib.ElementsParser;
import org.netbeans.modules.html.editor.lib.api.elements.Element;

public class ElementsParserCache {
    static int CACHE_BLOCK_SIZE = 1000;
    final List<CacheBlock> cacheBlocks = new ArrayList<CacheBlock>();
    private final CharSequence sourceCode;
    private final TokenSequence<HTMLTokenId> tokenSequence;

    public ElementsParserCache(CharSequence sourceCode, TokenSequence<HTMLTokenId> tokenSequence) {
        this.sourceCode = sourceCode;
        this.tokenSequence = tokenSequence;
    }

    public Iterator<Element> createElementsIterator() {
        return new Iterator<Element>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.getCacheBlock().getEndIndex() > this.index;
            }

            @Override
            public Element next() {
                return this.getCacheBlock().getElementAtIndex(this.index++);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private CacheBlock getCacheBlock() {
                List<CacheBlock> list = ElementsParserCache.this.cacheBlocks;
                synchronized (list) {
                    CacheBlock item;
                    int blockIndex = this.index / CACHE_BLOCK_SIZE;
                    CacheBlock cacheBlock = item = ElementsParserCache.this.cacheBlocks.size() > blockIndex ? ElementsParserCache.this.cacheBlocks.get(blockIndex) : null;
                    if (item == null) {
                        int firstTokenIndex = blockIndex == 0 ? 0 : ElementsParserCache.this.cacheBlocks.get(blockIndex - 1).getLastTokenIndex() + 1;
                        item = new CacheBlock(ElementsParserCache.this.sourceCode, ElementsParserCache.this.tokenSequence, this.index, firstTokenIndex);
                        assert (blockIndex == ElementsParserCache.this.cacheBlocks.size());
                        ElementsParserCache.this.cacheBlocks.add(blockIndex, item);
                    }
                    return item;
                }
            }

            @Override
            public void remove() {
            }
        };
    }

    static class CacheBlock {
        int blockReads = 0;
        Reference<CacheBlockContent> blockReference;
        private final int startIndex;
        private final int endIndex;
        private final int startOffset;
        private final int endOffset;
        private final int firstTokenIndex;
        private final int lastTokenIndex;
        private final CharSequence code;
        private final TokenSequence<HTMLTokenId> tokenSequence;

        private CacheBlock(CharSequence code, TokenSequence<HTMLTokenId> tokenSequence, int firstElementIndex, int firstTokenIndex) {
            this.code = code;
            this.tokenSequence = tokenSequence;
            this.startIndex = firstElementIndex;
            this.firstTokenIndex = firstTokenIndex;
            CacheBlockContent block = new CacheBlockContent(code, tokenSequence, firstTokenIndex);
            int blockSize = block.getElements().size();
            this.endIndex = firstElementIndex + blockSize;
            this.startOffset = blockSize == 0 ? -1 : block.getFirstElement().from();
            this.endOffset = blockSize == 0 ? -1 : block.getLastElement().to();
            this.lastTokenIndex = block.getLastTokenIndex();
            ++this.blockReads;
            this.blockReference = new SoftReference<CacheBlockContent>(block);
        }

        public int getStartIndex() {
            return this.startIndex;
        }

        public int getEndIndex() {
            return this.endIndex;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public int getFirstTokenIndex() {
            return this.firstTokenIndex;
        }

        public int getLastTokenIndex() {
            return this.lastTokenIndex;
        }

        public Element getElementAtIndex(int index) {
            return this.getElements().get(index - this.getStartIndex());
        }

        public synchronized List<Element> getElements() {
            CacheBlockContent block = this.blockReference.get();
            if (block == null) {
                block = new CacheBlockContent(this.code, this.tokenSequence, this.startIndex);
                ++this.blockReads;
                this.blockReference = new SoftReference<CacheBlockContent>(block);
            }
            return block.getElements();
        }

        public String toString() {
            return "CacheBlock(hash=" + this.hashCode() + ",items=" + this.getElements().size();
        }
    }

    private static class CacheBlockContent {
        private final List<Element> elements;
        private final int firstTokenIndex;
        private final int lastTokenIndex;

        private CacheBlockContent(CharSequence code, TokenSequence<HTMLTokenId> tokenSequence, int firstTokenIndex) {
            this.firstTokenIndex = firstTokenIndex;
            ElementsParser parser = ElementsParser.forTokenIndex(code, tokenSequence, firstTokenIndex);
            this.elements = new ArrayList<Element>(CACHE_BLOCK_SIZE);
            int limit = CACHE_BLOCK_SIZE;
            while (limit-- > 0 && parser.hasNext()) {
                this.elements.add(parser.next());
            }
            this.lastTokenIndex = tokenSequence.index();
        }

        List<Element> getElements() {
            return this.elements;
        }

        Element getFirstElement() {
            return this.elements.get(0);
        }

        Element getLastElement() {
            return this.elements.get(this.elements.size() - 1);
        }

        int getFirstTokenIndex() {
            return this.firstTokenIndex;
        }

        int getLastTokenIndex() {
            return this.lastTokenIndex;
        }
    }
}

