/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.validator;

import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.SchemaFactory;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelFactory;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.Types;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.extensions.xsd.WSDLSchema;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.netbeans.modules.xml.xam.dom.DocumentModel;
import org.netbeans.modules.xml.xam.locator.CatalogModel;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.netbeans.modules.xml.xam.locator.CatalogModelFactory;
import org.netbeans.modules.xml.xam.spi.Validation;
import org.netbeans.modules.xml.xam.spi.ValidationResult;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.netbeans.modules.xml.xam.spi.XsdBasedValidator;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WSDLInlineSchemaValidator
extends XsdBasedValidator {
    public static final ValidationResult EMPTY_RESULT = new ValidationResult((Collection)Collections.EMPTY_SET, (Collection)Collections.EMPTY_SET);
    Pattern pattern = Pattern.compile("(<\\s*)(\\S*schema)(\\s*)");

    public String getName() {
        return "WSDLInlineSchemaValidator";
    }

    public ValidationResult validate(Model model, Validation validation, Validation.ValidationType validationType) {
        if (model instanceof WSDLModel) {
            WSDLModel wsdlModel = (WSDLModel)model;
            ArrayList<Model> validatedModels = new ArrayList<Model>();
            Vector resultItems = new Vector();
            if (validationType.equals((Object)Validation.ValidationType.COMPLETE) || validationType.equals((Object)Validation.ValidationType.PARTIAL)) {
                if (wsdlModel.getState() == Model.State.NOT_WELL_FORMED) {
                    return EMPTY_RESULT;
                }
                Definitions def = wsdlModel.getDefinitions();
                Map prefixes = ((AbstractDocumentComponent)def).getPrefixes();
                String systemId = this.getSystemId(wsdlModel);
                Types types = def.getTypes();
                if (types != null) {
                    List<WSDLSchema> schemas = types.getExtensibilityElements(WSDLSchema.class);
                    String text = this.getWSDLText(wsdlModel);
                    assert (text != null) : "there is no content in the wsdl document or couldnt be read";
                    List<Integer> linePositions = this.setupLinePositions(text);
                    WSDLLSResourceResolver resolver = new WSDLLSResourceResolver(wsdlModel, systemId, text, prefixes, linePositions);
                    for (WSDLSchema schema : schemas) {
                        Reader in = this.createInlineSchemaSource(text, prefixes, linePositions, schema);
                        if (in == null) continue;
                        SAXSource source = new SAXSource(new InputSource(in));
                        source.setSystemId(systemId);
                        int start = schema.findPosition();
                        int lineNumber = this.getLineNumber(start, linePositions);
                        InlineSchemaValidatorHandler handler = new InlineSchemaValidatorHandler((Model)wsdlModel, lineNumber);
                        this.validate(wsdlModel, source, handler, resolver);
                        resultItems.addAll(handler.getResultItems());
                    }
                    validatedModels.add(model);
                    return new ValidationResult(resultItems, validatedModels);
                }
                return EMPTY_RESULT;
            }
        }
        return null;
    }

    private String getSystemId(WSDLModel model) {
        File file = (File)model.getModelSource().getLookup().lookup(File.class);
        if (file != null) {
            return file.toURI().toString();
        }
        Source source = (Source)model.getModelSource().getLookup().lookup(Source.class);
        if (source != null) {
            return source.getSystemId();
        }
        return null;
    }

    private void validate(WSDLModel model, Source saxSource, XsdBasedValidator.Handler handler, LSResourceResolver resolver) {
        try {
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            if (resolver != null) {
                sf.setResourceResolver(resolver);
            }
            sf.setErrorHandler((ErrorHandler)handler);
            if (saxSource == null) {
                return;
            }
            sf.newSchema(saxSource);
        }
        catch (SAXException sax) {
        }
        catch (Exception ex) {
            handler.logValidationErrors(Validator.ResultType.ERROR, ex.getMessage());
        }
    }

    private String getEndTag(String startTag) {
        Matcher matcher = this.pattern.matcher(startTag);
        if (matcher.find()) {
            return "</" + matcher.group(2) + ">";
        }
        return null;
    }

    private List<Integer> setupLinePositions(String str) {
        ArrayList<Integer> linePositions = new ArrayList<Integer>();
        String[] lines = str.split("\n");
        linePositions.add(-1);
        int pos = 0;
        for (String line : lines) {
            linePositions.add(pos);
            pos += line.length() + 1;
        }
        return linePositions;
    }

    private int getLineNumber(int position, List<Integer> linePositions) {
        for (int i = 0; i < linePositions.size(); ++i) {
            if (position >= linePositions.get(i)) continue;
            return i - 1;
        }
        return -1;
    }

    protected javax.xml.validation.Schema getSchema(Model model) {
        return null;
    }

    private String getWSDLText(WSDLModel model) {
        Document d = (Document)model.getModelSource().getLookup().lookup(Document.class);
        try {
            return d.getText(0, d.getLength());
        }
        catch (BadLocationException e) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, "getWSDLText", e);
            return null;
        }
    }

    public DocumentModel resolveResource(String systemId, Model currentModel) {
        if (currentModel instanceof WSDLModel && systemId.equals(this.getSystemId((WSDLModel)currentModel))) {
            return (WSDLModel)currentModel;
        }
        try {
            CatalogModel cm = (CatalogModel)currentModel.getModelSource().getLookup().lookup(CatalogModel.class);
            ModelSource ms = cm.getModelSource(new URI(systemId));
            if (ms != null) {
                return SchemaModelFactory.getDefault().getModel(ms);
            }
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.FINE, "resolveResource", ex);
        }
        catch (CatalogModelException ex) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.FINE, "resolveResource", ex);
        }
        return null;
    }

    private Reader createInlineSchemaSource(String wsdlText, Map<String, String> wsdlPrefixes, List<Integer> wsdlLinePositions, WSDLSchema oneInlineSchema) {
        StringReader source = null;
        int start = oneInlineSchema.findPosition();
        int lineNumber = this.getLineNumber(start, wsdlLinePositions);
        String schemaString = oneInlineSchema.getContentFragment();
        if (wsdlText == null || schemaString == null) {
            return null;
        }
        int index = wsdlText.indexOf(schemaString, start);
        if (schemaString != null && schemaString.trim().length() > 0) {
            assert (index != -1) : "the text content under schema couldnt be found in the wsdl document";
            String schemaTop = wsdlText.substring(start, index);
            String[] splits = schemaTop.split(">");
            StringBuffer strBuf = new StringBuffer();
            if (splits.length > 0) {
                strBuf.append(splits[0]);
                Map schemaPrefixes = ((AbstractDocumentComponent)oneInlineSchema.getSchemaModel().getSchema()).getPrefixes();
                for (String prefix : wsdlPrefixes.keySet()) {
                    if (prefix == null || prefix.length() == 0 || schemaPrefixes.containsKey(prefix)) continue;
                    strBuf.append(" ").append("xmlns:").append(prefix).append("=\"").append(wsdlPrefixes.get(prefix)).append("\"");
                }
                for (int i = 1; i < splits.length; ++i) {
                    strBuf.append(">").append(splits[i]);
                }
                strBuf.append(">");
                strBuf.append(schemaString).append(this.getEndTag(splits[0]));
                schemaString = null;
                splits = null;
                schemaTop = null;
            }
            source = new StringReader(strBuf.toString());
            strBuf = null;
        }
        return source;
    }

    class InlineSchemaValidatorHandler
    extends XsdBasedValidator.Handler {
        int startingLineNumber;

        public InlineSchemaValidatorHandler(Model model, int lineNumber) {
            super((XsdBasedValidator)WSDLInlineSchemaValidator.this, model);
            this.startingLineNumber = lineNumber - 1;
        }

        public void logValidationErrors(Validator.ResultType resultType, String errorDescription, int lineNumber, int columnNumber) {
            super.logValidationErrors(resultType, errorDescription, this.startingLineNumber + lineNumber, columnNumber);
        }
    }

    class WSDLLSResourceResolver
    implements LSResourceResolver {
        private WSDLModel mModel;
        private LSResourceResolver mDelegate;
        private String mWsdlSystemId;
        private String mWsdlText;
        private Map<String, String> mWsdlPrefixes;
        private List<Integer> mWsdlLinePositions;

        public WSDLLSResourceResolver(WSDLModel wsdlmodel, String wsdlSystemId, String wsdlText, Map<String, String> wsdlPrefixes, List<Integer> wsdlLinePositions) {
            this.mModel = wsdlmodel;
            this.mWsdlSystemId = wsdlSystemId;
            this.mWsdlText = wsdlText;
            this.mWsdlPrefixes = wsdlPrefixes;
            this.mWsdlLinePositions = wsdlLinePositions;
            this.mDelegate = CatalogModelFactory.getDefault().getLSResourceResolver();
        }

        @Override
        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            Reader in;
            WSDLSchema schema;
            LSInput lsi = this.mDelegate.resolveResource(type, namespaceURI, publicId, systemId, baseURI);
            if (lsi == null && (schema = this.findSchema(namespaceURI)) != null && (in = WSDLInlineSchemaValidator.this.createInlineSchemaSource(this.mWsdlText, this.mWsdlPrefixes, this.mWsdlLinePositions, schema)) != null) {
                DOMImplementation domImpl = null;
                try {
                    domImpl = DocumentBuilderFactory.newInstance().newDocumentBuilder().getDOMImplementation();
                }
                catch (ParserConfigurationException ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "resolveResource", ex);
                    return null;
                }
                DOMImplementationLS dols = (DOMImplementationLS)domImpl.getFeature("LS", "3.0");
                lsi = dols.createLSInput();
                lsi.setCharacterStream(in);
                if (this.mWsdlSystemId != null) {
                    lsi.setSystemId(this.mWsdlSystemId);
                }
                return lsi;
            }
            return lsi;
        }

        private WSDLSchema findSchema(String namespaceURI) {
            WSDLSchema schema = null;
            Definitions def = this.mModel.getDefinitions();
            Types types = def.getTypes();
            if (types != null) {
                List<WSDLSchema> schemas = types.getExtensibilityElements(WSDLSchema.class);
                for (WSDLSchema sch : schemas) {
                    Schema s;
                    SchemaModel model = sch.getSchemaModel();
                    if (model == null || (s = model.getSchema()) == null || s.getTargetNamespace() == null || !s.getTargetNamespace().equals(namespaceURI)) continue;
                    schema = sch;
                    break;
                }
            }
            return schema;
        }
    }
}

