/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.wizards;

import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.autoupdate.ui.PluginManagerUI;
import org.netbeans.modules.autoupdate.ui.ProblemPanel;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.netbeans.modules.autoupdate.ui.actions.AutoupdateCheckScheduler;
import org.netbeans.modules.autoupdate.ui.actions.AutoupdateSettings;
import org.netbeans.modules.autoupdate.ui.actions.Installer;
import org.netbeans.modules.autoupdate.ui.wizards.Bundle;
import org.netbeans.modules.autoupdate.ui.wizards.InstallUnitWizardModel;
import org.netbeans.modules.autoupdate.ui.wizards.LazyInstallUnitWizardIterator;
import org.netbeans.modules.autoupdate.ui.wizards.OperationPanel;
import org.netbeans.modules.autoupdate.ui.wizards.OperationWizardModel;
import org.netbeans.modules.autoupdate.ui.wizards.PanelBodyContainer;
import org.netbeans.modules.autoupdate.ui.wizards.ValidationWarningPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public class InstallStep
implements WizardDescriptor.FinishablePanel<WizardDescriptor> {
    private OperationPanel panel;
    private PanelBodyContainer component;
    private InstallUnitWizardModel model = null;
    private boolean clearLazyUnits = false;
    private WizardDescriptor wd = null;
    private OperationSupport.Restarter restarter = null;
    private ProgressHandle systemHandle = null;
    private ProgressHandle spareHandle = null;
    private boolean spareHandleStarted = false;
    private boolean indeterminateProgress = false;
    private int processedUnits = 0;
    private int totalUnits = 0;
    private boolean userdirAsFallback;
    private static Notification restartNotification = null;
    private static final Logger log = Logger.getLogger(InstallStep.class.getName());
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private static final String TEXT_PROPERTY = "text";
    private static final String HEAD_DOWNLOAD = "InstallStep_Header_Download_Head";
    private static final String CONTENT_DOWNLOAD = "InstallStep_Header_Download_Content";
    private static final String HEAD_VERIFY = "InstallStep_Header_Verify_Head";
    private static final String CONTENT_VERIFY = "InstallStep_Header_Verify_Content";
    private static final String HEAD_INSTALL = "InstallStep_Header_Install_Head";
    private static final String CONTENT_INSTALL = "InstallStep_Header_Install_Content";
    private static final String HEAD_INSTALL_DONE = "InstallStep_Header_InstallDone_Head";
    private static final String CONTENT_INSTALL_DONE = "InstallStep_Header_InstallDone_Content";
    private static final String HEAD_INSTALL_UNSUCCESSFUL = "InstallStep_Header_InstallUnsuccessful_Head";
    private static final String CONTENT_INSTALL_UNSUCCESSFUL = "InstallStep_Header_InstallUnsuccessful_Content";
    private static final String HEAD_RESTART = "InstallStep_Header_Restart_Head";
    private static final String CONTENT_RESTART = "InstallStep_Header_Restart_Content";
    private boolean wasStored = false;
    private boolean runInBg = false;
    private boolean canceled = false;
    private OperationException installException;
    private final boolean allowRunInBackground;
    private final boolean runInBackground;
    private InstallSupport.Validator validator;

    public InstallStep(InstallUnitWizardModel model) {
        this(model, false);
    }

    public InstallStep(InstallUnitWizardModel model, boolean clearLazyUnits) {
        this(model, clearLazyUnits, true);
    }

    public InstallStep(InstallUnitWizardModel model, boolean clearLazyUnits, boolean allowRunInBackground) {
        this(model, clearLazyUnits, allowRunInBackground, false);
    }

    public InstallStep(InstallUnitWizardModel model, boolean clearLazyUnits, boolean allowRunInBackground, boolean runInBackground) {
        this.model = model;
        this.clearLazyUnits = clearLazyUnits;
        this.allowRunInBackground = allowRunInBackground;
        this.runInBackground = runInBackground;
        this.userdirAsFallback = InstallStep.getPreferences().getBoolean(Utilities.PLUGIN_MANAGER_DONT_CARE_WRITE_PERMISSION, false);
    }

    public boolean isFinishPanel() {
        return true;
    }

    public PanelBodyContainer getComponent() {
        if (this.component == null) {
            this.panel = new OperationPanel(this.allowRunInBackground, this.runInBackground);
            this.panel.addPropertyChangeListener(new PropertyChangeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("run-action".equals(evt.getPropertyName())) {
                        try {
                            RequestProcessor.Task it = InstallStep.this.createInstallTask();
                            PluginManagerUI.registerRunningTask(it);
                            it.waitFinished();
                        }
                        finally {
                            PluginManagerUI.unregisterRunningTask();
                        }
                    } else if ("run-in-background".equals(evt.getPropertyName())) {
                        InstallStep.this.setRunInBackground();
                    }
                }
            });
            this.component = new PanelBodyContainer(InstallStep.getBundle(HEAD_DOWNLOAD, new Object[0]), InstallStep.getBundle(CONTENT_DOWNLOAD, new Object[0]), this.panel);
            this.component.setPreferredSize(OperationWizardModel.PREFFERED_DIMENSION);
        }
        return this.component;
    }

    private RequestProcessor.Task createInstallTask() {
        return Installer.RP.create(new Runnable(){

            @Override
            public void run() {
                InstallStep.this.doDownloadAndVerificationAndInstall();
            }
        });
    }

    private void doDownloadAndVerificationAndInstall() {
        InstallSupport.Installer i;
        InstallSupport.Validator v;
        OperationContainer<InstallSupport> installContainer = this.model.getBaseContainer();
        InstallSupport support = (InstallSupport)installContainer.getSupport();
        assert (support != null) : "Operation failed: OperationSupport cannot be null because OperationContainer contains elements: " + installContainer.listAll() + " and invalid elements " + installContainer.listInvalid() + "\ncontainer: " + installContainer;
        assert (installContainer.listInvalid().isEmpty()) : support + ".listInvalid().isEmpty() but " + installContainer.listInvalid() + " container: " + installContainer;
        if (support == null) {
            log.log(Level.WARNING, "Operation failed: OperationSupport was null because OperationContainer either does not contain any elements: {0} or contains invalid elements {1}", new Object[]{this.model.getBaseContainer().listAll(), this.model.getBaseContainer().listInvalid()});
        }
        if ((v = this.handleDownload(support)) != null && (i = this.handleValidation(v, support)) != null) {
            OperationSupport.Restarter r = this.handleInstall(i, support);
            if (r != null) {
                this.presentInstallNeedsRestart(r, support);
            } else {
                this.presentInstallDone();
            }
        }
        if (!this.canceled) {
            this.fireChange();
        }
    }

    private InstallSupport.Validator handleDownload(InstallSupport support) {
        if (this.canceled) {
            log.fine("Quit handleDownload() because an previous installation was canceled.");
            return null;
        }
        this.validator = null;
        boolean finish = false;
        while (!finish) {
            finish = this.tryPerformDownload(support);
        }
        return this.validator;
    }

    private boolean runInBackground() {
        return this.runInBg;
    }

    private void setRunInBackground() {
        if (this.runInBg) {
            return;
        }
        PluginManagerUI.unregisterRunningTask();
        this.runInBg = true;
        assert (SwingUtilities.isEventDispatchThread()) : "In AWT queue only.";
        Window w = SwingUtilities.getWindowAncestor(this.getComponent());
        if (this.spareHandle != null && !this.spareHandleStarted) {
            this.indeterminateProgress = true;
            this.spareHandle.setInitialDelay(0);
            this.spareHandle.start();
            this.spareHandleStarted = true;
        }
        if (this.model.getPluginManager() != null) {
            this.model.getPluginManager().willClose();
        }
        if (w != null) {
            w.setVisible(false);
        }
        if (this.model.getPluginManager() != null) {
            this.model.getPluginManager().close();
        }
    }

    private boolean handleCancel() {
        if (this.spareHandle != null && this.spareHandleStarted) {
            this.spareHandle.finish();
            this.spareHandleStarted = false;
        }
        if (this.systemHandle != null) {
            this.systemHandle.finish();
        }
        try {
            this.canceled = true;
            this.model.doCleanup(true);
            PluginManagerUI.cancelRunningTask();
        }
        catch (OperationException x) {
            Logger.getLogger(InstallStep.class.getName()).log(Level.INFO, x.getMessage(), x);
        }
        return true;
    }

    private boolean tryPerformDownload(InstallSupport support) {
        this.validator = null;
        JLabel detailLabel = null;
        try {
            ProgressHandle handle = ProgressHandleFactory.createHandle((String)InstallStep.getBundle("InstallStep_Download_DownloadingPlugins", new Object[0]));
            JComponent progressComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)handle);
            JLabel mainLabel = ProgressHandleFactory.createMainLabelComponent((ProgressHandle)handle);
            detailLabel = ProgressHandleFactory.createDetailLabelComponent((ProgressHandle)handle);
            if (this.runInBackground()) {
                handle = this.systemHandle = ProgressHandleFactory.createHandle((String)InstallStep.getBundle("InstallStep_Download_DownloadingPlugins", new Object[0]), (Cancellable)new Cancellable(){

                    public boolean cancel() {
                        return InstallStep.this.handleCancel();
                    }
                });
            } else {
                this.spareHandle = ProgressHandleFactory.createHandle((String)InstallStep.getBundle("InstallStep_Download_DownloadingPlugins", new Object[0]), (Cancellable)new Cancellable(){

                    public boolean cancel() {
                        return InstallStep.this.handleCancel();
                    }
                });
                this.totalUnits = this.model.getBaseContainer().listAll().size();
                this.processedUnits = 0;
                detailLabel.addPropertyChangeListener(TEXT_PROPERTY, new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        assert (InstallStep.TEXT_PROPERTY.equals(evt.getPropertyName())) : "Listens onlo on text but was " + evt;
                        if (evt.getOldValue() != evt.getNewValue()) {
                            InstallStep.this.processedUnits++;
                            if (InstallStep.this.indeterminateProgress && InstallStep.this.spareHandleStarted && InstallStep.this.processedUnits < InstallStep.this.totalUnits - 1) {
                                InstallStep.this.totalUnits = InstallStep.this.totalUnits - InstallStep.this.processedUnits;
                                InstallStep.this.spareHandle.switchToDeterminate(InstallStep.this.totalUnits);
                                InstallStep.this.indeterminateProgress = false;
                            }
                            if (!InstallStep.this.indeterminateProgress && InstallStep.this.spareHandleStarted) {
                                InstallStep.this.spareHandle.progress(((JLabel)evt.getSource()).getText(), InstallStep.this.processedUnits < InstallStep.this.totalUnits - 1 ? InstallStep.this.processedUnits : InstallStep.this.totalUnits - 1);
                            }
                        }
                    }
                });
            }
            handle.setInitialDelay(0);
            this.panel.waitAndSetProgressComponents(mainLabel, progressComponent, detailLabel);
            this.validator = support.doDownload(handle, Utilities.isGlobalInstallation(), this.userdirAsFallback);
            if (this.validator == null) {
                this.handleCancel();
                return true;
            }
            this.panel.waitAndSetProgressComponents(mainLabel, progressComponent, new JLabel(InstallStep.getBundle("InstallStep_Done", new Object[0])));
            if (this.spareHandle != null && this.spareHandleStarted) {
                this.spareHandle.finish();
                this.spareHandleStarted = false;
            }
        }
        catch (OperationException ex) {
            log.log(Level.INFO, ex.getMessage(), ex);
            if (OperationException.ERROR_TYPE.PROXY == ex.getErrorType()) {
                if (this.runInBackground()) {
                    this.handleCancel();
                    this.notifyNetworkProblem(ex);
                } else {
                    JButton tryAgain = new JButton();
                    Mnemonics.setLocalizedText((AbstractButton)tryAgain, (String)InstallStep.getBundle("InstallStep_NetworkProblem_Continue", new Object[0]));
                    ProblemPanel problem = new ProblemPanel(InstallStep.getBundle("InstallStep_NetworkProblem_Text", ex.getLocalizedMessage()), tryAgain, this.model.getCancelButton(this.wd));
                    Object ret = problem.showNetworkProblemDialog();
                    if (tryAgain.equals(ret)) {
                        return false;
                    }
                    if (DialogDescriptor.CLOSED_OPTION.equals(ret)) {
                        this.model.getCancelButton(this.wd).doClick();
                    }
                }
            }
            if (OperationException.ERROR_TYPE.WRITE_PERMISSION == ex.getErrorType()) {
                if (this.runInBackground()) {
                    UpdateElement culprit = this.findCulprit(ex.getMessage());
                    this.handleCancel();
                    this.notifyWritePermissionProblem(ex, culprit);
                } else {
                    JButton cancel = new JButton();
                    Mnemonics.setLocalizedText((AbstractButton)cancel, (String)Bundle.cancel());
                    JButton install = new JButton();
                    Mnemonics.setLocalizedText((AbstractButton)install, (String)Bundle.install());
                    UpdateElement culprit = this.findCulprit(ex.getMessage());
                    ProblemPanel problem = new ProblemPanel(ex, culprit, false, new JButton[0]);
                    Object ret = problem.showWriteProblemDialog();
                    if (install.equals(ret)) {
                        this.userdirAsFallback = true;
                        return false;
                    }
                    this.model.getCancelButton(this.wd).doClick();
                }
            }
            String pluginName = detailLabel == null || detailLabel.getText().length() == 0 ? InstallStep.getBundle("InstallStep_DownloadProblem_SomePlugins", new Object[0]) : detailLabel.getText();
            String message = InstallStep.getBundle("InstallStep_DownloadProblem", pluginName, ex.getLocalizedMessage());
            Exceptions.attachLocalizedMessage((Throwable)ex, (String)message);
            log.log(Level.SEVERE, null, ex);
            this.handleCancel();
        }
        return true;
    }

    private InstallSupport.Installer handleValidation(InstallSupport.Validator v, InstallSupport support) {
        InstallSupport.Installer tmpInst;
        if (this.canceled) {
            log.fine("Quit handleValidation() because an previous installation was canceled.");
            return null;
        }
        this.component.setHeadAndContent(InstallStep.getBundle(HEAD_VERIFY, new Object[0]), InstallStep.getBundle(CONTENT_VERIFY, new Object[0]));
        ProgressHandle handle = ProgressHandleFactory.createHandle((String)InstallStep.getBundle("InstallStep_Validate_ValidatingPlugins", new Object[0]));
        JComponent progressComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)handle);
        JLabel mainLabel = ProgressHandleFactory.createMainLabelComponent((ProgressHandle)handle);
        JLabel detailLabel = ProgressHandleFactory.createDetailLabelComponent((ProgressHandle)handle);
        if (this.runInBackground()) {
            handle = this.systemHandle = ProgressHandleFactory.createHandle((String)InstallStep.getBundle("InstallStep_Validate_ValidatingPlugins", new Object[0]), (Cancellable)new Cancellable(){

                public boolean cancel() {
                    InstallStep.this.handleCancel();
                    return true;
                }
            });
        } else {
            this.spareHandle = ProgressHandleFactory.createHandle((String)InstallStep.getBundle("InstallStep_Validate_ValidatingPlugins", new Object[0]), (Cancellable)new Cancellable(){

                public boolean cancel() {
                    InstallStep.this.handleCancel();
                    return true;
                }
            });
            this.totalUnits = this.model.getBaseContainer().listAll().size();
            this.processedUnits = 0;
            if (this.indeterminateProgress) {
                detailLabel.addPropertyChangeListener(TEXT_PROPERTY, new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        assert (InstallStep.TEXT_PROPERTY.equals(evt.getPropertyName())) : "Listens onlo on text but was " + evt;
                        if (evt.getOldValue() != evt.getNewValue()) {
                            InstallStep.this.processedUnits++;
                            if (InstallStep.this.indeterminateProgress && InstallStep.this.spareHandleStarted && InstallStep.this.processedUnits < InstallStep.this.totalUnits - 1) {
                                InstallStep.this.totalUnits = InstallStep.this.totalUnits - InstallStep.this.processedUnits;
                                InstallStep.this.spareHandle.switchToDeterminate(InstallStep.this.totalUnits);
                                InstallStep.this.indeterminateProgress = false;
                            }
                            if (!InstallStep.this.indeterminateProgress) {
                                InstallStep.this.spareHandle.progress(((JLabel)evt.getSource()).getText(), InstallStep.this.processedUnits < InstallStep.this.totalUnits - 1 ? InstallStep.this.processedUnits : InstallStep.this.totalUnits - 1);
                            }
                        }
                    }
                });
            }
        }
        handle.setInitialDelay(0);
        this.panel.waitAndSetProgressComponents(mainLabel, progressComponent, detailLabel);
        if (this.spareHandle != null && this.spareHandleStarted) {
            this.spareHandle.finish();
        }
        try {
            tmpInst = support.doValidate(v, handle);
            if (tmpInst == null) {
                return null;
            }
        }
        catch (OperationException ex) {
            log.log(Level.INFO, ex.getMessage(), ex);
            ProblemPanel problem = new ProblemPanel(ex, false, new JButton[0]);
            problem.showNetworkProblemDialog();
            this.handleCancel();
            return null;
        }
        InstallSupport.Installer inst = tmpInst;
        ArrayList<UpdateElement> unsigned = new ArrayList<UpdateElement>();
        ArrayList<UpdateElement> untrusted = new ArrayList<UpdateElement>();
        String certs = "";
        for (UpdateElement el : this.model.getAllUpdateElements()) {
            if (!support.isSigned(inst, el)) {
                unsigned.add(el);
                continue;
            }
            if (support.isTrusted(inst, el)) continue;
            untrusted.add(el);
            String cert = support.getCertificate(inst, el);
            if (cert == null || cert.length() <= 0) continue;
            certs = certs + InstallStep.getBundle("ValidationWarningPanel_ShowCertificateFormat", el.getDisplayName(), cert);
        }
        if (untrusted.size() > 0 || unsigned.size() > 0 && !this.runInBackground()) {
            ValidationWarningPanel p = new ValidationWarningPanel(unsigned, untrusted);
            final JButton showCertificate = new JButton();
            boolean verifyCertificate = !untrusted.isEmpty() && certs.length() > 0;
            Mnemonics.setLocalizedText((AbstractButton)showCertificate, (String)InstallStep.getBundle("ValidationWarningPanel_ShowCertificateButton", new Object[0]));
            final String certificate = certs;
            showCertificate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (showCertificate.equals(e.getSource())) {
                        JTextArea ta = new JTextArea(certificate);
                        ta.setEditable(false);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)ta));
                    }
                }
            });
            JButton canContinue = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)canContinue, (String)InstallStep.getBundle("ValidationWarningPanel_ContinueButton", new Object[0]));
            JButton cancel = this.model.getCancelButton(this.wd);
            DialogDescriptor dd = new DialogDescriptor((Object)p, verifyCertificate ? InstallStep.getBundle("ValidationWarningPanel_VerifyCertificate_Title", new Object[0]) : InstallStep.getBundle("ValidationWarningPanel_Title", new Object[0]));
            dd.setOptions((Object[])new JButton[]{canContinue, cancel});
            dd.setClosingOptions((Object[])new JButton[]{canContinue, cancel});
            dd.setMessageType(2);
            if (verifyCertificate) {
                dd.setAdditionalOptions((Object[])new JButton[]{showCertificate});
            }
            final Dialog dlg = DialogDisplayer.getDefault().createDialog(dd);
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        dlg.setVisible(true);
                    }
                });
            }
            catch (InterruptedException ex) {
                log.log(Level.INFO, ex.getLocalizedMessage(), ex);
                return null;
            }
            catch (InvocationTargetException ex) {
                log.log(Level.INFO, ex.getLocalizedMessage(), ex);
                return null;
            }
            if (!canContinue.equals(dd.getValue())) {
                if (!cancel.equals(dd.getValue())) {
                    cancel.doClick();
                }
                return null;
            }
            assert (canContinue.equals(dd.getValue()));
        }
        this.panel.waitAndSetProgressComponents(mainLabel, progressComponent, new JLabel(InstallStep.getBundle("InstallStep_Done", new Object[0])));
        return inst;
    }

    private OperationSupport.Restarter handleInstall(InstallSupport.Installer i, InstallSupport support) {
        if (this.canceled) {
            log.fine("Quit handleInstall() because an previous installation was canceled.");
            return null;
        }
        this.installException = null;
        this.component.setHeadAndContent(InstallStep.getBundle(HEAD_INSTALL, new Object[0]), InstallStep.getBundle(CONTENT_INSTALL, new Object[0]));
        this.model.modifyOptionsForDisabledCancel(this.wd);
        ProgressHandle handle = ProgressHandleFactory.createHandle((String)InstallStep.getBundle("InstallStep_Install_InstallingPlugins", new Object[0]));
        JComponent progressComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)handle);
        JLabel mainLabel = ProgressHandleFactory.createMainLabelComponent((ProgressHandle)handle);
        JLabel detailLabel = ProgressHandleFactory.createDetailLabelComponent((ProgressHandle)handle);
        if (this.runInBackground()) {
            handle = this.systemHandle = ProgressHandleFactory.createHandle((String)InstallStep.getBundle("InstallStep_Install_InstallingPlugins", new Object[0]));
        } else {
            this.spareHandle = ProgressHandleFactory.createHandle((String)InstallStep.getBundle("InstallStep_Install_InstallingPlugins", new Object[0]));
            this.totalUnits = this.model.getBaseContainer().listAll().size();
            this.processedUnits = 0;
            if (this.indeterminateProgress) {
                detailLabel.addPropertyChangeListener(TEXT_PROPERTY, new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        assert (InstallStep.TEXT_PROPERTY.equals(evt.getPropertyName())) : "Listens onlo on text but was " + evt;
                        if (evt.getOldValue() != evt.getNewValue()) {
                            InstallStep.this.processedUnits++;
                            if (InstallStep.this.indeterminateProgress && InstallStep.this.spareHandleStarted && InstallStep.this.processedUnits < InstallStep.this.totalUnits - 1) {
                                InstallStep.this.totalUnits = InstallStep.this.totalUnits - InstallStep.this.processedUnits;
                                InstallStep.this.spareHandle.switchToDeterminate(InstallStep.this.totalUnits);
                                InstallStep.this.indeterminateProgress = false;
                            }
                            if (!InstallStep.this.indeterminateProgress) {
                                InstallStep.this.spareHandle.progress(((JLabel)evt.getSource()).getText(), InstallStep.this.processedUnits < InstallStep.this.totalUnits - 1 ? InstallStep.this.processedUnits : InstallStep.this.totalUnits - 1);
                            }
                        }
                    }
                });
            }
        }
        handle.setInitialDelay(0);
        this.panel.waitAndSetProgressComponents(mainLabel, progressComponent, detailLabel);
        OperationSupport.Restarter r = null;
        boolean success = false;
        try {
            r = support.doInstall(i, handle);
            success = true;
        }
        catch (OperationException ex) {
            log.log(Level.INFO, ex.getMessage(), ex);
            this.panel.waitAndSetProgressComponents(mainLabel, progressComponent, new JLabel(InstallStep.getBundle("InstallStep_Unsuccessful", ex.getLocalizedMessage())));
            this.installException = ex;
        }
        if (success) {
            this.panel.waitAndSetProgressComponents(mainLabel, progressComponent, new JLabel(InstallStep.getBundle("InstallStep_Done", new Object[0])));
        }
        if (this.spareHandle != null && this.spareHandleStarted) {
            this.spareHandle.finish();
        }
        return r;
    }

    private void presentInstallDone() {
        if (this.canceled) {
            log.fine("Quit presentInstallDone() because an previous installation was canceled.");
            return;
        }
        this.model.modifyOptionsForDoClose(this.wd);
        if (this.installException == null) {
            this.component.setHeadAndContent(InstallStep.getBundle(HEAD_INSTALL_DONE, new Object[0]), InstallStep.getBundle(CONTENT_INSTALL_DONE, new Object[0]));
            this.panel.setBody(InstallStep.getBundle("InstallStep_InstallDone_Text", new Object[0]), this.model.getAllVisibleUpdateElements());
        } else {
            this.component.setHeadAndContent(InstallStep.getBundle(HEAD_INSTALL_UNSUCCESSFUL, new Object[0]), InstallStep.getBundle(CONTENT_INSTALL_UNSUCCESSFUL, new Object[0]));
            this.panel.setBody(InstallStep.getBundle("InstallStep_InstallUnsuccessful_Text", this.installException.getLocalizedMessage()), this.model.getAllVisibleUpdateElements());
        }
        this.panel.hideRunInBackground();
    }

    private void presentInstallNeedsRestart(OperationSupport.Restarter r, InstallSupport support) {
        if (this.canceled) {
            log.fine("Quit presentInstallNeedsRestart() because an previous installation was canceled.");
            return;
        }
        this.component.setHeadAndContent(InstallStep.getBundle(HEAD_RESTART, new Object[0]), InstallStep.getBundle(CONTENT_RESTART, new Object[0]));
        this.model.modifyOptionsForDoClose(this.wd, true);
        this.restarter = r;
        this.panel.setRestartButtonsVisible(true);
        this.panel.setBody(InstallStep.getBundle("InstallStep_InstallDone_Text", new Object[0]), this.model.getAllVisibleUpdateElements());
        this.panel.hideRunInBackground();
        if (this.runInBackground()) {
            InstallStep.resetLastCheckWhenUpdatingFirstClassModules(this.model.getAllUpdateElements());
            support.doRestartLater(this.restarter);
            try {
                this.model.doCleanup(false);
            }
            catch (OperationException x) {
                log.log(Level.INFO, x.getMessage(), x);
            }
            if (this.clearLazyUnits) {
                LazyInstallUnitWizardIterator.LazyUnit.storeLazyUnits(this.model.getOperation(), null);
                AutoupdateCheckScheduler.notifyAvailable(null, OperationWizardModel.OperationType.UPDATE);
            }
            InstallStep.notifyInstallRestartNeeded(support, r);
        }
    }

    private static void notifyInstallRestartNeeded(final InstallSupport support, final OperationSupport.Restarter r) {
        Runnable onMouseClick = new Runnable(){

            @Override
            public void run() {
                try {
                    support.doRestart(r, null);
                }
                catch (OperationException x) {
                    log.log(Level.INFO, x.getMessage(), x);
                }
            }
        };
        InstallStep.notifyRestartNeeded(onMouseClick, InstallStep.getBundle("InstallSupport_RestartNeeded", new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void notifyRestartNeeded(final Runnable onMouseClick, String tooltip) {
        ActionListener onClickAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                onMouseClick.run();
            }
        };
        Class<InstallStep> clazz = InstallStep.class;
        synchronized (InstallStep.class) {
            if (restartNotification != null) {
                restartNotification.clear();
                restartNotification = null;
            }
            restartNotification = NotificationDisplayer.getDefault().notify(tooltip, (Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/autoupdate/ui/resources/restart.png", (boolean)false), InstallStep.getBundle("RestartNeeded_Details", new Object[0]), onClickAction, NotificationDisplayer.Priority.HIGH, NotificationDisplayer.Category.WARNING);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private void notifyNetworkProblem(final OperationException ex) {
        ActionListener onMouseClickAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProblemPanel problem = new ProblemPanel(ex, false, new JButton[0]);
                problem.showNetworkProblemDialog();
            }
        };
        String title = InstallStep.getBundle("InstallSupport_InBackground_NetworkError", new Object[0]);
        String description = InstallStep.getBundle("InstallSupport_InBackground_NetworkError_Details", new Object[0]);
        NotificationDisplayer.getDefault().notify(title, (Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/autoupdate/ui/resources/error.png", (boolean)false), description, onMouseClickAction, NotificationDisplayer.Priority.HIGH, NotificationDisplayer.Category.ERROR);
    }

    private void notifyWritePermissionProblem(final OperationException ex, final UpdateElement culprit) {
        ActionListener onMouseClickAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProblemPanel problem = new ProblemPanel(ex, culprit, false, new JButton[0]);
                problem.showWriteProblemDialog();
            }
        };
        String title = Bundle.inBackground_WritePermission(culprit.getDisplayName());
        String description = Bundle.inBackground_WritePermission_Details();
        NotificationDisplayer.getDefault().notify(title, (Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/autoupdate/ui/resources/error.png", (boolean)false), description, onMouseClickAction, NotificationDisplayer.Priority.HIGH, NotificationDisplayer.Category.ERROR);
    }

    public HelpCtx getHelp() {
        return null;
    }

    public void readSettings(WizardDescriptor wd) {
        this.wd = wd;
        this.wasStored = false;
    }

    public void storeSettings(WizardDescriptor wd) {
        assert (!WizardDescriptor.PREVIOUS_OPTION.equals(wd.getValue())) : "Cannot invoke Back in this case.";
        if (this.wasStored) {
            return;
        }
        this.wasStored = true;
        InstallSupport support = (InstallSupport)this.model.getBaseContainer().getSupport();
        if (WizardDescriptor.CANCEL_OPTION.equals(wd.getValue()) || WizardDescriptor.CLOSED_OPTION.equals(wd.getValue())) {
            try {
                this.model.doCleanup(true);
            }
            catch (OperationException x) {
                Logger.getLogger(InstallStep.class.getName()).log(Level.INFO, x.getMessage(), x);
            }
        } else if (this.restarter != null) {
            if (support == null) {
                assert (this.model.getBaseContainer().listAll() == null) : "storeSettings failed. OperationSupport is null because OperationContainer contains no elements: " + this.model.getBaseContainer().listAll();
                return;
            }
            if (this.panel.restartNow()) {
                InstallStep.resetLastCheckWhenUpdatingFirstClassModules(this.model.getAllUpdateElements());
                this.handleLazyUnits(this.clearLazyUnits, false);
                try {
                    support.doRestart(this.restarter, null);
                }
                catch (OperationException x) {
                    log.log(Level.INFO, x.getMessage(), x);
                }
            } else {
                InstallStep.resetLastCheckWhenUpdatingFirstClassModules(this.model.getAllUpdateElements());
                support.doRestartLater(this.restarter);
                this.handleLazyUnits(this.clearLazyUnits, true);
                try {
                    this.model.doCleanup(false);
                }
                catch (OperationException x) {
                    log.log(Level.INFO, x.getMessage(), x);
                }
                InstallStep.notifyInstallRestartNeeded(support, this.restarter);
            }
        } else {
            try {
                this.model.doCleanup(!WizardDescriptor.FINISH_OPTION.equals(wd.getValue()));
            }
            catch (OperationException x) {
                log.log(Level.INFO, x.getMessage(), x);
            }
        }
    }

    public boolean isValid() {
        return true;
    }

    public synchronized void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public synchronized void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    private void handleLazyUnits(boolean clearLazyUnits, boolean notifyUsers) {
        if (clearLazyUnits) {
            LazyInstallUnitWizardIterator.LazyUnit.storeLazyUnits(this.model.getOperation(), null);
            if (notifyUsers) {
                AutoupdateCheckScheduler.notifyAvailable(null, OperationWizardModel.OperationType.UPDATE);
            }
        } else {
            HashSet<String> tmp = new HashSet<String>();
            for (UpdateElement el : this.model.getAllUpdateElements()) {
                tmp.add(LazyInstallUnitWizardIterator.LazyUnit.toString(el));
            }
            HashSet<LazyInstallUnitWizardIterator.LazyUnit> res = new HashSet<LazyInstallUnitWizardIterator.LazyUnit>();
            for (LazyInstallUnitWizardIterator.LazyUnit lu : LazyInstallUnitWizardIterator.LazyUnit.loadLazyUnits(this.model.getOperation())) {
                if (tmp.contains(lu.toString())) continue;
                res.add(lu);
            }
            LazyInstallUnitWizardIterator.LazyUnit.storeLazyUnits(this.model.getOperation(), res);
            if (notifyUsers) {
                AutoupdateCheckScheduler.notifyAvailable(res, OperationWizardModel.OperationType.UPDATE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList<ChangeListener> templist;
        ChangeEvent e = new ChangeEvent(this);
        InstallStep installStep = this;
        synchronized (installStep) {
            templist = new ArrayList<ChangeListener>(this.listeners);
        }
        for (ChangeListener l : templist) {
            l.stateChanged(e);
        }
    }

    private static String getBundle(String key, Object ... params) {
        return NbBundle.getMessage(InstallStep.class, (String)key, (Object[])params);
    }

    private static void resetLastCheckWhenUpdatingFirstClassModules(Collection<UpdateElement> toUpdate) {
        boolean resetChecking = false;
        for (UpdateElement el : toUpdate) {
            if (!Utilities.getFirstClassModules().contains(el.getCodeName())) continue;
            resetChecking = true;
            break;
        }
        if (resetChecking) {
            AutoupdateSettings.setLastCheck(null);
        }
    }

    private static Preferences getPreferences() {
        return NbPreferences.forModule(Utilities.class);
    }

    private UpdateElement findCulprit(String codeName) {
        if (codeName == null || codeName.isEmpty()) {
            return null;
        }
        for (OperationContainer.OperationInfo info : this.model.getBaseContainer().listAll()) {
            if (!codeName.equals(info.getUpdateElement().getCodeName())) continue;
            return info.getUpdateElement();
        }
        return null;
    }
}

