/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jumpto.common;

import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.NonNull;

public class Utils {
    private static Pattern camelCasePattern = Pattern.compile("(?:\\p{javaUpperCase}(?:\\p{javaLowerCase}|\\p{Digit}|\\.|\\$)*){2,}");

    private Utils() {
        throw new IllegalStateException();
    }

    public static int containsWildCard(String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != '?' && text.charAt(i) != '*') continue;
            return i;
        }
        return -1;
    }

    public static boolean isCamelCase(String text) {
        return camelCasePattern.matcher(text).matches();
    }

    public static boolean isAllUpper(String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (Character.isUpperCase(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @NonNull
    public static String removeNonNeededWildCards(@NonNull String text) {
        StringBuilder sb = new StringBuilder();
        boolean lastAny = false;
        block4: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '*': {
                    if (!lastAny) {
                        sb.append(c);
                    }
                    lastAny = true;
                    continue block4;
                }
                case '?': {
                    if (lastAny) continue block4;
                    sb.append(c);
                    continue block4;
                }
                default: {
                    sb.append(c);
                    lastAny = false;
                }
            }
        }
        return sb.toString();
    }
}

