/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jumpto.common;

import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.jumpto.common.Factory;
import org.openide.util.Pair;

public final class Models {
    private Models() {
    }

    public static <T> ListModel fromList(List<? extends T> list) {
        return new ListListModel<T>(list);
    }

    public static <T, P> ListModel translating(ListModel model, Factory<T, P> factory) {
        return new TranslatingListModel<T, P>(model, factory);
    }

    public static <R, P> ListModel refreshable(@NonNull ListModel model, @NonNull Factory<R, Pair<P, Runnable>> convertor) {
        return new RefreshableListModel<R, P>(model, convertor);
    }

    private static class ListListModel<T>
    implements ListModel {
        private List<? extends T> list;

        public ListListModel(List<? extends T> list) {
            this.list = list;
        }

        public T getElementAt(int index) {
            return this.list.get(index);
        }

        @Override
        public int getSize() {
            return this.list.size();
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
        }

        @Override
        public void addListDataListener(ListDataListener l) {
        }
    }

    private static final class RefreshableListModel<R, P>
    extends AbstractListModel {
        private final ListModel delegate;
        private final Factory<R, Pair<P, Runnable>> convertor;
        private final Object[] cache;

        RefreshableListModel(@NonNull ListModel delegate, @NonNull Factory<R, Pair<P, Runnable>> convertor) {
            this.delegate = delegate;
            this.convertor = convertor;
            this.cache = new Object[delegate.getSize()];
        }

        @Override
        public int getSize() {
            if (this.cache.length != this.delegate.getSize()) {
                throw new IllegalStateException("Base model changed, only static models are suported.");
            }
            return this.cache.length;
        }

        @Override
        public Object getElementAt(final int index) {
            if (index < 0 || index >= this.cache.length) {
                throw new IllegalArgumentException(String.format("Invalid index: %d, model size: %d.", index, this.cache.length));
            }
            Object result = this.cache[index];
            if (result != null) {
                return result;
            }
            Object param = this.delegate.getElementAt(index);
            this.cache[index] = result = this.convertor.create(Pair.of(param, (Object)new Runnable(){

                @Override
                public void run() {
                    RefreshableListModel.this.fireContentsChanged(RefreshableListModel.this, index, index);
                }
            }));
            return result;
        }
    }

    private static class TranslatingListModel<T, P>
    implements ListModel {
        private Factory<T, P> factory;
        private ListModel listModel;

        public TranslatingListModel(ListModel model, Factory<T, P> factory) {
            this.listModel = model;
            this.factory = factory;
        }

        public T getElementAt(int index) {
            Object original = this.listModel.getElementAt(index);
            return this.factory.create(original);
        }

        @Override
        public int getSize() {
            return this.listModel.getSize();
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
        }

        @Override
        public void addListDataListener(ListDataListener l) {
        }
    }
}

