/*
 * Decompiled with CFR 0.152.
 */
package org.whattf.datatype;

import org.relaxng.datatype.DatatypeException;
import org.whattf.datatype.AbstractDatatype;

public class MimeTypeList
extends AbstractDatatype {
    public static final MimeTypeList THE_INSTANCE = new MimeTypeList();

    private MimeTypeList() {
    }

    @Override
    public void checkValid(CharSequence literal) throws DatatypeException {
        State state = State.WS_BEFORE_TYPE;
        block17: for (int i = 0; i < literal.length(); ++i) {
            char c = literal.charAt(i);
            switch (state) {
                case WS_BEFORE_TYPE: {
                    if (this.isWhitespace(c)) continue block17;
                    if (c == '*') {
                        state = State.ASTERISK_TYPE_SEEN;
                    } else {
                        if (this.isTokenChar(c)) {
                            state = State.IN_TYPE;
                            continue block17;
                        }
                        throw this.newDatatypeException(i, "Expected whitespace, a token character or \u201c*\u201d but saw ", c, " instead.");
                    }
                }
                case ASTERISK_TYPE_SEEN: {
                    if (c == '/') {
                        state = State.ASTERISK_AND_SLASH_SEEN;
                        continue block17;
                    }
                    throw this.newDatatypeException(i, "Expected \u201c/\u201d but saw ", c, " instead.");
                }
                case ASTERISK_AND_SLASH_SEEN: {
                    if (c == '*') {
                        state = State.WS_BEFORE_COMMA;
                        continue block17;
                    }
                    throw this.newDatatypeException(i, "Expected \u201c*\u201d but saw ", c, " instead.");
                }
                case IN_TYPE: {
                    if (c == '/') {
                        state = State.SLASH_SEEN;
                        continue block17;
                    }
                    if (this.isTokenChar(c)) continue block17;
                    throw this.newDatatypeException(i, "Expected a token character or \u201c/\u201d but saw ", c, " instead.");
                }
                case SLASH_SEEN: {
                    if (c == '*') {
                        state = State.WS_BEFORE_COMMA;
                        continue block17;
                    }
                    if (this.isTokenChar(c)) {
                        state = State.IN_SUBTYPE;
                        continue block17;
                    }
                    throw this.newDatatypeException(i, "Expected a token character or \u201c*\u201d but saw ", c, " instead.");
                }
                case IN_SUBTYPE: {
                    if (this.isWhitespace(c)) {
                        state = State.WS_BEFORE_COMMA;
                        continue block17;
                    }
                    if (c == ',') {
                        state = State.WS_BEFORE_TYPE;
                        continue block17;
                    }
                    if (this.isTokenChar(c)) continue block17;
                    throw this.newDatatypeException(i, "Expected a token character, whitespace or a comma but saw ", c, " instead.");
                }
                case WS_BEFORE_COMMA: {
                    if (c == ',') {
                        state = State.WS_BEFORE_TYPE;
                        continue block17;
                    }
                    if (this.isWhitespace(c)) continue block17;
                    throw this.newDatatypeException(i, "Expected whitespace or a comma but saw ", c, " instead.");
                }
            }
        }
        switch (state) {
            case IN_SUBTYPE: 
            case WS_BEFORE_COMMA: {
                return;
            }
            case ASTERISK_AND_SLASH_SEEN: {
                throw this.newDatatypeException("Expected \u201c*\u201d but the literal ended.");
            }
            case ASTERISK_TYPE_SEEN: {
                throw this.newDatatypeException("Expected \u201c/\u201d but the literal ended.");
            }
            case IN_TYPE: {
                throw this.newDatatypeException("Expected \u201c/\u201d but the literal ended.");
            }
            case SLASH_SEEN: {
                throw this.newDatatypeException("Expected subtype but the literal ended.");
            }
            case WS_BEFORE_TYPE: {
                throw this.newDatatypeException("Expected a MIME type but the literal ended.");
            }
        }
    }

    private boolean isTokenChar(char c) {
        return c >= '!' && c <= '~' && c != '(' && c != ')' && c != '<' && c != '>' && c != '@' && c != ',' && c != ';' && c != ':' && c != '\\' && c != '\"' && c != '/' && c != '[' && c != ']' && c != '?' && c != '=' && c != '{' && c != '}';
    }

    @Override
    public String getName() {
        return "MIME type list";
    }

    private static enum State {
        WS_BEFORE_TYPE,
        IN_TYPE,
        ASTERISK_TYPE_SEEN,
        ASTERISK_AND_SLASH_SEEN,
        WS_BEFORE_COMMA,
        SLASH_SEEN,
        IN_SUBTYPE;

    }
}

