/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.test;

import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import HTTPClient.ModuleException;
import HTTPClient.ParseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MapClientServletTest {
    private static transient Log log = LogFactory.getLog(MapClientServletTest.class);
    private String host = "localhost";
    private String sClassName;
    private String servletPath = "datain/map";
    private int portNo = 8080;
    private String port = this.portNo + "";
    private long lastUpdate = 0L;
    private long unitId = 1000L;

    public MapClientServletTest() {
        this.sClassName = this.getClass().getName();
    }

    public static void main(String[] args) {
        log.info((Object)" main() entered...");
        MapClientServletTest test = new MapClientServletTest();
        try {
            test.run();
        }
        catch (IOException ex) {
            log.error((Object)"Servlet not accessible ? Server not running ?", (Throwable)ex);
        }
        catch (ParseException ex) {
            log.error((Object)"Error parsing Content-Type: ", (Throwable)ex);
        }
        catch (ModuleException ex) {
            log.error((Object)"Error handling request: ", (Throwable)ex);
        }
        catch (Exception ex) {
            log.error((Object)"Exception: ", (Throwable)ex);
        }
    }

    public String getUrl() {
        String url = "http://" + this.host;
        if (this.port != null || this.port.length() > 0) {
            url = url + ":" + this.portNo;
        }
        url = url + "/" + this.servletPath + "?beginTime=0&endTime=0";
        return url;
    }

    public void run() throws Exception {
        String sMethodName = "run()";
        String url = this.getUrl();
        log.debug((Object)(sMethodName + ": URL: " + url));
        HTTPConnection con = new HTTPConnection(this.host, this.portNo);
        HTTPResponse rsp = con.Get(url);
        InputStream is = rsp.getInputStream();
        ObjectInputStream ois = new ObjectInputStream(is);
        Map mcr = (Map)ois.readObject();
        ois.close();
        log.debug((Object)("found a Map Client Response with " + mcr.size() + " vehicles"));
    }
}

