/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.test;

import de.proveo.wwt.logic.servlet.general.login.LoginResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.auth.NTLMScheme;
import org.apache.commons.httpclient.auth.RFC2617Scheme;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoginServletProxyTest {
    private static transient Log log = LogFactory.getLog(LoginServletProxyTest.class);
    private String host = "localhost";
    private String password;
    private String sClassName;
    private String servletPath = "datain/login";
    private String username;
    private int portNo = 8080;
    private String port = this.portNo + "";

    public LoginServletProxyTest() {
        this.sClassName = this.getClass().getName();
    }

    public static void main(String[] args) {
        log.info((Object)" main() entered...");
        LoginServletProxyTest test = new LoginServletProxyTest();
        try {
            test.run();
        }
        catch (IOException ioe) {
            log.error((Object)ioe.toString());
            log.error((Object)"Servlet not accessible ? Server not running ?");
        }
        catch (Exception ex) {
            log.error((Object)"Exception: ", (Throwable)ex);
        }
    }

    public String getUrl() {
        String url = "http://" + this.host;
        if (this.port != null || this.port.length() > 0) {
            url = url + ":" + this.portNo;
        }
        url = url + "/" + this.servletPath + "?username=" + this.username + "&password=" + this.password;
        return url;
    }

    public void run() throws Exception {
        String sMethodName = "run()";
        this.host = "localhost";
        this.port = "8080";
        this.servletPath = "datain/login";
        this.username = "proveo";
        this.password = "wwt";
        String url = this.getUrl();
        System.out.println("url=" + url);
        GetMethod httpget = new GetMethod(url);
        String proxyHost = "proxy";
        int proxyPort = 3128;
        boolean useProxy = false;
        HttpClient client = new HttpClient();
        if (useProxy) {
            this.host = "demo.proveo.de";
            url = this.getUrl();
            httpget = new GetMethod(url);
            HostConfiguration hostConf = client.getHostConfiguration();
            hostConf.setProxy(proxyHost, proxyPort);
            HttpClientParams params = client.getParams();
            params.setParameter("http.authentication.credential-provider", (Object)new ConsoleAuthPrompter());
        }
        ObjectInputStream ois = null;
        try {
            int status = client.executeMethod((HttpMethod)httpget);
            System.out.println(httpget.getStatusLine().toString());
            if (status != 200) {
                System.out.println("status not ok, break");
                return;
            }
            InputStream is = httpget.getResponseBodyAsStream();
            ois = new ObjectInputStream(is);
        }
        catch (HttpException e) {
            System.out.println(e.toString());
            System.out.println("URL was " + url);
        }
        catch (IOException ioe) {
            System.out.println(ioe.toString());
            String msg = "Servlet not accessible ? Server not running ?";
            System.out.println(msg);
            System.out.println("URL was " + url);
        }
        LoginResponse lr = null;
        try {
            lr = (LoginResponse)ois.readObject();
        }
        catch (IOException ioe) {
            log.error((Object)("Error : " + ioe.getMessage()));
            return;
        }
        catch (ClassNotFoundException ce) {
            log.error((Object)("Error : " + ce.getMessage()));
            return;
        }
        if (lr.isAccessPermitted()) {
            System.out.println("SUCCESS: access granted");
        } else {
            System.out.println("INVALID: no access granted");
        }
        ois.close();
        httpget.releaseConnection();
    }

    public class ConsoleAuthPrompter
    implements CredentialsProvider {
        private BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        private String domain;
        private String password;
        private String user;
        private int tries = 0;

        public ConsoleAuthPrompter() {
        }

        public ConsoleAuthPrompter(String u, String p) {
            this.user = u;
            this.password = p;
        }

        public Credentials getCredentials(AuthScheme authscheme, String host, int port, boolean proxy) throws CredentialsNotAvailableException {
            if (authscheme == null) {
                return null;
            }
            if (this.tries > 3) {
                System.out.println("wrong auth. after " + this.tries + " tries. break");
                throw new CredentialsNotAvailableException("to much tries");
            }
            ++this.tries;
            try {
                if (authscheme instanceof NTLMScheme) {
                    System.out.println(host + ":" + port + " requires Windows authentication");
                    System.out.print("Enter domain: ");
                    this.domain = this.readConsole();
                    System.out.print("Enter username: ");
                    this.user = this.readConsole();
                    System.out.print("Enter password: ");
                    this.password = this.readConsole();
                    return new NTCredentials(this.user, this.password, host, this.domain);
                }
                if (authscheme instanceof RFC2617Scheme) {
                    System.out.println(host + ":" + port + " requires authentication with the realm '" + authscheme.getRealm() + "'");
                    System.out.print("Enter username: ");
                    this.user = this.readConsole();
                    System.out.print("Enter password: ");
                    this.password = this.readConsole();
                    return new UsernamePasswordCredentials(this.user, this.password);
                }
                throw new CredentialsNotAvailableException("Unsupported authentication scheme: " + authscheme.getSchemeName());
            }
            catch (IOException e) {
                throw new CredentialsNotAvailableException(e.getMessage(), (Throwable)e);
            }
        }

        private String readConsole() throws IOException {
            return this.in.readLine();
        }
    }
}

