/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.test;

import de.proveo.util.connection.ServletConnection;
import de.proveo.util.connection.ServletConnectionException;
import de.proveo.util.connection.ssl.EasySSLProtocolSocketFactory;
import de.proveo.wwt.logic.servlet.general.login.LoginResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.auth.NTLMScheme;
import org.apache.commons.httpclient.auth.RFC2617Scheme;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoginServletProxySSLTest {
    private static transient Log log = LogFactory.getLog(LoginServletProxySSLTest.class);
    private String host = "localhost";
    private String password;
    private String port = "8080";
    private String protocol = "http";
    private String sClassName = this.getClass().getName();
    private String servletPath = "datain/login";
    private String username;

    public static void main(String[] args) {
        log.info((Object)" main() entered...");
        LoginServletProxySSLTest test = new LoginServletProxySSLTest();
        try {
            System.out.println(">> try with HttpClient, direct...");
            test.run();
        }
        catch (Exception ex) {
            log.error((Object)"Exception: ", (Throwable)ex);
        }
        try {
            System.out.println(">> try with class ServletConnection...");
            test.run_usingServletConnection();
        }
        catch (Exception ex) {
            log.error((Object)"Exception: ", (Throwable)ex);
        }
    }

    public String getUrl() {
        String url = this.protocol + "://" + this.host;
        if (this.port != null && this.port.length() > 0) {
            url = url + ":" + this.port;
        }
        url = url + "/" + this.servletPath + "?username=" + this.username + "&password=" + this.password;
        return url;
    }

    void run() throws Exception {
        String sMethodName = "run()";
        this.servletPath = "datain/login";
        this.protocol = "https";
        this.host = "sats.proveo.de";
        this.port = "443";
        this.username = "proveo";
        this.password = "wwt7sats";
        HttpClient client = new HttpClient();
        EasySSLProtocolSocketFactory psf = new EasySSLProtocolSocketFactory();
        Protocol easyhttps = new Protocol("https", (ProtocolSocketFactory)psf, 443);
        Protocol.registerProtocol((String)"https", (Protocol)easyhttps);
        boolean useProxy = false;
        if (useProxy) {
            String proxyHost = "proxy";
            int proxyPort = 3128;
            HostConfiguration hostConf = client.getHostConfiguration();
            hostConf.setProxy(proxyHost, proxyPort);
            HttpClientParams params = client.getParams();
            params.setParameter("http.authentication.credential-provider", (Object)new ConsoleAuthPrompter());
        }
        ObjectInputStream ois = null;
        String url = this.getUrl();
        System.out.println("url=" + url);
        GetMethod httpget = new GetMethod(url);
        try {
            int status = client.executeMethod((HttpMethod)httpget);
            System.out.println(httpget.getStatusLine().toString());
            if (status != 200) {
                System.out.println("status not ok, break");
                return;
            }
            InputStream is = httpget.getResponseBodyAsStream();
            ois = new ObjectInputStream(is);
        }
        catch (SocketTimeoutException ste) {
            System.out.println(ste.toString());
            System.out.println("URL was: " + url);
            throw new Exception("SocketTimeoutException");
        }
        catch (ConnectException ce) {
            System.out.println(ce.toString());
            System.out.println("URL was: " + url);
            throw new Exception("ConnectException");
        }
        catch (HttpException e) {
            System.out.println(e.toString());
            System.out.println("URL was: " + url);
            throw new Exception("HttpException");
        }
        catch (SSLHandshakeException ssle) {
            System.out.println(ssle.toString());
            System.out.println("URL was: " + url);
            throw new Exception("SSLHandshakeException");
        }
        catch (IOException ioe) {
            System.out.println(ioe.toString());
            String msg = "IOException, Servlet not accessible ? Server not running ?";
            System.out.println(msg);
            System.out.println("URL was: " + url);
            throw new Exception(msg);
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
            String msg = "Exception, Servlet not accessible ? Server not running ?";
            System.out.println(msg);
            System.out.println("URL was: " + url);
            throw new Exception(msg);
        }
        LoginResponse lr = null;
        try {
            lr = (LoginResponse)ois.readObject();
        }
        catch (IOException ioe) {
            log.error((Object)("Error : " + ioe.getMessage()));
            return;
        }
        catch (ClassNotFoundException ce) {
            log.error((Object)("Error : " + ce.getMessage()));
            return;
        }
        if (lr.isAccessPermitted()) {
            System.out.println("SUCCESS: access granted");
        } else {
            System.out.println("INVALID: no access granted");
        }
        ois.close();
        httpget.releaseConnection();
    }

    void run_usingServletConnection() {
        String sMethodName = "run_usingServletConnection(): ";
        log.debug((Object)(sMethodName + "setup servlet connection..."));
        this.protocol = "https";
        this.host = "sats.proveo.de";
        this.port = "443";
        this.username = "proveo";
        this.password = "wwt7sats";
        ServletConnection servletConnection = new ServletConnection(this.host, 443, this.protocol);
        boolean useProxy = false;
        if (useProxy) {
            log.debug((Object)(sMethodName + "a proxy should be used..."));
            String proxyHost = "proxy";
            int proxyPort = 3128;
            String proxyUser = "airportmap";
            String proxyPass = "airportmap";
            String proxyDomain = "";
            boolean proxyAuthentication = true;
            if (proxyAuthentication) {
                log.debug((Object)(sMethodName + "...with authentication."));
            } else {
                proxyUser = "";
                proxyPass = "";
            }
            servletConnection.setupProxy(proxyHost, proxyPort, proxyUser, proxyPass, proxyDomain);
        }
        servletConnection.connect();
        String loginServlet = "datain/login";
        String parameters = "username=" + this.username;
        String url = servletConnection.getSafeUrl(loginServlet, parameters);
        System.out.println("url=" + url + " (excluding password)");
        LoginResponse lr = null;
        try {
            lr = (LoginResponse)servletConnection.readObject(url, this.password);
            if (lr == null) {
                log.error((Object)(sMethodName + "LoginResponse==null, No LoginResponse established. Break."));
                return;
            }
        }
        catch (ServletConnectionException e) {
            int lastState = servletConnection.getLastState();
            String ex = e.getMessage();
            log.error((Object)(sMethodName + "servlet problem '" + ex + "'. HTTP state was '" + lastState + "'. Break."));
            log.error((Object)(sMethodName + "  URL was " + url));
            return;
        }
        if (lr.isAccessPermitted()) {
            System.out.println("SUCCESS: access granted");
        } else {
            System.out.println("INVALID: no access granted");
        }
        servletConnection.close();
    }

    public class ConsoleAuthPrompter
    implements CredentialsProvider {
        private BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        private String domain;
        private String password;
        private String user;
        private int tries = 0;

        public ConsoleAuthPrompter() {
        }

        public ConsoleAuthPrompter(String u, String p) {
            this.user = u;
            this.password = p;
        }

        public Credentials getCredentials(AuthScheme authscheme, String host, int port, boolean proxy) throws CredentialsNotAvailableException {
            if (authscheme == null) {
                return null;
            }
            if (this.tries > 3) {
                System.out.println("wrong auth. after " + this.tries + " tries. break");
                throw new CredentialsNotAvailableException("to much tries");
            }
            ++this.tries;
            try {
                if (authscheme instanceof NTLMScheme) {
                    System.out.println(host + ":" + port + " requires Windows authentication");
                    System.out.print("Enter domain: ");
                    this.domain = this.readConsole();
                    System.out.print("Enter username: ");
                    this.user = this.readConsole();
                    System.out.print("Enter password: ");
                    this.password = this.readConsole();
                    return new NTCredentials(this.user, this.password, host, this.domain);
                }
                if (authscheme instanceof RFC2617Scheme) {
                    System.out.println(host + ":" + port + " requires authentication with the realm '" + authscheme.getRealm() + "'");
                    System.out.print("Enter username: ");
                    this.user = this.readConsole();
                    System.out.print("Enter password: ");
                    this.password = this.readConsole();
                    return new UsernamePasswordCredentials(this.user, this.password);
                }
                throw new CredentialsNotAvailableException("Unsupported authentication scheme: " + authscheme.getSchemeName());
            }
            catch (IOException e) {
                throw new CredentialsNotAvailableException(e.getMessage(), (Throwable)e);
            }
        }

        private String readConsole() throws IOException {
            return this.in.readLine();
        }
    }
}

