/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.general.login;

import de.proveo.wwt.logic.app.security.LoginCallbackHandler;
import de.proveo.wwt.logic.app.security.LoginContextUtil;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.exception.AccessDeniedException;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.UserAdminFacade;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.UserAdminFacadeHome;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.user.AccountDataWithPermissions;
import de.proveo.wwt.logic.servlet.general.login.LoginResponse;
import de.proveo.wwt.logic.web.admin.AdminFacade;
import de.proveo.wwt.logic.web.admin.AdminFacadeHome;
import de.proveo.wwt.logic.web.security.PermissionChecker;
import de.proveo.wwt.logic.web.security.PermissionCheckerHome;
import java.beans.XMLEncoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;
import java.security.Principal;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import javax.ejb.CreateException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoginServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(LoginServlet.class);
    protected static final String INIT_PARAM_USERADMIN_JNDI_NAME = "UserAdminJNDI";
    protected static final String PARAM_USERNAME = "username";
    protected static final String PARAM_PASSWORD = "password";
    protected static final String PARAM_JAAS = "jaas";
    protected static final String PARAM_LOGOUT = "logout";
    private UserAdminFacade userAdminFacade;
    private AdminFacade adminFacade;
    private PermissionChecker permissionChecker;

    public void destroy() {
    }

    public String getServletInfo() {
        return "Authentication Servlet of proveo.wwt system";
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String jndiName = config.getInitParameter(INIT_PARAM_USERADMIN_JNDI_NAME);
        if (jndiName == null) {
            throw new ServletException("parameter UserAdminJNDI does not exist");
        }
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup(jndiName);
            UserAdminFacadeHome home = (UserAdminFacadeHome)PortableRemoteObject.narrow((Object)ref, UserAdminFacadeHome.class);
            this.userAdminFacade = home.create();
            ref = ctx.lookup("AdminFacade");
            AdminFacadeHome adminFacadeHome = (AdminFacadeHome)PortableRemoteObject.narrow((Object)ref, AdminFacadeHome.class);
            this.adminFacade = adminFacadeHome.create();
            ref = ctx.lookup("PermissionChecker");
            PermissionCheckerHome permissionCheckerHome = (PermissionCheckerHome)PortableRemoteObject.narrow((Object)ref, PermissionCheckerHome.class);
            this.permissionChecker = permissionCheckerHome.create();
        }
        catch (NamingException ex) {
            log.error((Object)"naming problem", (Throwable)ex);
            throw new ServletException("naming problem", (Throwable)ex);
        }
        catch (CreateException ex) {
            log.error((Object)"create problem", (Throwable)ex);
            throw new ServletException("create problem", (Throwable)ex);
        }
        catch (RemoteException ex) {
            log.error((Object)"remote problem", (Throwable)ex);
            throw new ServletException("remote problem", (Throwable)ex);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.warn((Object)"doGet(): don't use GET because of security reasons.");
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.userAdminFacade == null) {
            throw new ServletException("ejb remote interface missing. init problem");
        }
        String username = request.getParameter(PARAM_USERNAME);
        String password = request.getParameter(PARAM_PASSWORD);
        String str_jaas = request.getParameter(PARAM_JAAS);
        String logout = request.getParameter(PARAM_LOGOUT);
        boolean isLogout = false;
        if (username == null || username.length() == 0) {
            throw new ServletException("parameter 'username' missing or empty");
        }
        if (password == null || password.length() == 0) {
            throw new ServletException("parameter 'password' missing or empty");
        }
        if (logout == null || logout.length() == 0) {
            isLogout = false;
        } else {
            isLogout = Boolean.parseBoolean(logout);
            log.debug((Object)("processRequest(): isLogout='" + isLogout + "'"));
        }
        Object responseObj = !isLogout ? this.doLogin(str_jaas, username, password) : this.doLogout(str_jaas, username, password);
        ObjectOutputStream outputStream = new ObjectOutputStream((OutputStream)response.getOutputStream());
        outputStream.writeObject(responseObj);
        outputStream.flush();
        outputStream.close();
    }

    private Object doLogin(String str_jaas, String username, String password) throws ServletException {
        Object responseObj = str_jaas == null || !str_jaas.equals("true") ? this.getLoginResponse(username, password) : this.getXMLLoginResponse(username, password);
        return responseObj;
    }

    private Object doLogout(String str_jaas, String username, String password) throws ServletException {
        if (str_jaas == null || !str_jaas.equals("true")) {
            log.error((Object)"doLogout(): only implemented for JAAS Systems");
            return "";
        }
        String responseObj = this.getXMLLogoutResponse(username, password);
        return responseObj;
    }

    private String getXMLLoginResponse(String username, String password) {
        HashMap responseMap = new HashMap();
        try {
            LoginContextUtil lcu = new LoginContextUtil(username, password);
            responseMap = lcu.login4AirportMap();
        }
        catch (FailedLoginException ex) {
            log.error((Object)("runs into: " + ex.getMessage()));
            responseMap.put("AccessPermitted", false);
            responseMap.put("ReasonCode", "incorrectUsernameOrPassword");
        }
        catch (Throwable ex) {
            log.error((Object)"runs into", ex);
            responseMap.put("AccessPermitted", false);
            responseMap.put("ReasonCode", "applicationError");
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        XMLEncoder resultEncoder = new XMLEncoder(outputStream);
        resultEncoder.writeObject(responseMap);
        resultEncoder.flush();
        resultEncoder.close();
        String xml = null;
        try {
            xml = outputStream.toString("utf-8");
        }
        catch (UnsupportedEncodingException ex) {
            xml = outputStream.toString();
        }
        return xml;
    }

    private String getXMLLogoutResponse(String username, String password) {
        HashMap responseMap = new HashMap();
        try {
            LoginContextUtil lcu = new LoginContextUtil(username, password);
            responseMap = lcu.logout4AirportMap();
        }
        catch (Exception ex) {
            log.error((Object)"runs into", (Throwable)ex);
            responseMap.put("LogoutSuccessful", false);
            responseMap.put("LogoutReasonCode", "LogoutApplicationError");
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        XMLEncoder resultEncoder = new XMLEncoder(outputStream);
        resultEncoder.writeObject(responseMap);
        resultEncoder.flush();
        resultEncoder.close();
        String xml = null;
        try {
            xml = outputStream.toString("utf-8");
        }
        catch (UnsupportedEncodingException ex) {
            xml = outputStream.toString();
        }
        return xml;
    }

    private LoginResponse getLoginResponse(String username, String password) throws ServletException {
        LoginResponse loginResponse = new LoginResponse(false);
        LoginCallbackHandler cbh = new LoginCallbackHandler(username, password);
        try {
            LoginContext lc = new LoginContext("rts", (CallbackHandler)cbh);
            lc.login();
            loginResponse = new LoginResponse(true);
            Set<Principal> principals = lc.getSubject().getPrincipals();
            TreeSet<String> permissions = new TreeSet<String>();
            for (Principal principal : principals) {
                permissions.add(((Object)principal).toString());
            }
            loginResponse.setPortalPermissions(permissions);
            log.debug((Object)"jaas login ok");
        }
        catch (LoginException e1) {
            if (this.userAdminFacade == null) {
                throw new ServletException("ejb remote interface missing. init problem");
            }
            try {
                AccountDataWithPermissions accountData = this.userAdminFacade.checkUser(username, password.toCharArray());
                loginResponse = new LoginResponse(true);
                log.debug((Object)"login ok");
            }
            catch (AccessDeniedException ex) {
                loginResponse = new LoginResponse(false);
            }
            catch (RemoteException ex) {
                log.error((Object)"remote problem", (Throwable)ex);
                throw new ServletException("remote problem", (Throwable)ex);
            }
        }
        password = null;
        return loginResponse;
    }
}

