/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.general.infoman;

import de.proveo.wwt.logic.app.unit.exception.UnitNotFoundException;
import de.proveo.wwt.logic.ejb.general.use.unituser.UnitUser;
import de.proveo.wwt.logic.ejb.general.use.unituser.UnitUserUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InfomanACLServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(InfomanACLServlet.class);
    private static final Log acllog = LogFactory.getLog((String)"acllog");
    private static final String DEFAULT_CHARSET_NAME = "UTF-8";
    private UnitUser unitUser;
    private boolean compressionEnabled;
    private String charsetName = "UTF-8";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            this.unitUser = UnitUserUtil.getHome().create();
        }
        catch (Exception ex) {
            throw new ServletException("Cannot connect to InfomanSetupFacade", (Throwable)ex);
        }
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Object out;
        Set acl;
        long unitId;
        try {
            unitId = Long.parseLong(request.getParameter("u"));
        }
        catch (NumberFormatException ex) {
            log.error((Object)"runs into", (Throwable)ex);
            acllog.error((Object)"runs into", (Throwable)ex);
            response.sendError(400, ex.getMessage());
            return;
        }
        if (acllog.isDebugEnabled()) {
            acllog.debug((Object)("Unit '" + unitId + "' requests ACL"));
        }
        try {
            acl = this.unitUser.getUserKeys(unitId);
        }
        catch (UnitNotFoundException ex) {
            log.error((Object)"runs into", (Throwable)ex);
            acllog.error((Object)"runs into", (Throwable)ex);
            response.sendError(404, ex.getMessage());
            return;
        }
        if (acllog.isDebugEnabled()) {
            acllog.debug((Object)("ACL for Unit '" + unitId + "' size: " + acl.size()));
            acllog.debug((Object)("ACL for Unit '" + unitId + "' -> " + acl));
        }
        response.setContentType("text/plain;charset=" + this.getCharsetName());
        if (this.isCompressionSupported(request)) {
            response.addHeader("Content-Encoding", "gzip");
            out = new GZIPOutputStream((OutputStream)response.getOutputStream());
        } else {
            out = response.getOutputStream();
        }
        for (String key : acl) {
            ((OutputStream)out).write(key.getBytes(this.getCharsetName()));
            ((OutputStream)out).write(10);
        }
        ((OutputStream)out).close();
    }

    protected boolean isCompressionSupported(HttpServletRequest request) {
        if (!this.isCompressionEnabled()) {
            return false;
        }
        Enumeration e = request.getHeaders("Accept-Encoding");
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!"gzip".equals(name)) continue;
            return true;
        }
        return false;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Provide the Access Control List for an infoman";
    }

    public boolean isCompressionEnabled() {
        return this.compressionEnabled;
    }

    public void setCompressionEnabled(boolean compressionEnabled) {
        this.compressionEnabled = compressionEnabled;
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public void setCharsetName(String charsetName) {
        if (charsetName == null) {
            throw new IllegalArgumentException("parameter charsetName cannot be null");
        }
        this.charsetName = charsetName;
    }
}

