/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataOut.rpc;

import de.proveo.wwt.logic.app.security.LoginCallbackHandler;
import de.proveo.wwt.logic.servlet.dataOut.rpc.SimpleRPCHandler;
import de.proveo.wwt.logic.servlet.dataOut.rpc.SimpleXMLRPCCall;
import de.proveo.wwt.logic.servlet.dataOut.rpc.airportmap.GetAPVisibleUnitTreeHandler;
import de.proveo.wwt.logic.servlet.dataOut.rpc.infoman.AddConfigurationToInfomanRemoteUpdateHandler;
import de.proveo.wwt.logic.servlet.dataOut.rpc.infoman.BeginInfomanUpdateHandler;
import de.proveo.wwt.logic.servlet.dataOut.rpc.infoman.CreatePlanedInfomanUpdateHandler;
import de.proveo.wwt.logic.servlet.dataOut.rpc.infoman.GetAvailableInfomanSoftwareHandler;
import de.proveo.wwt.logic.servlet.dataOut.rpc.infoman.GetCurrentInfomanSetupHandler;
import de.proveo.wwt.logic.servlet.dataOut.rpc.infoman.GetInfomanSoftwareForPlanedUpdateHandler;
import de.proveo.wwt.logic.servlet.dataOut.rpc.infoman.GetPlannedInfomanRemoteUpdatesHandler;
import de.proveo.wwt.logic.servlet.dataOut.rpc.infoman.GetUnitTreeHandler;
import de.proveo.wwt.logic.servlet.dataOut.rpc.infoman.InfomanUpdateDoneHandler;
import de.proveo.wwt.logic.servlet.dataOut.rpc.infoman.LoginHandler;
import de.proveo.wwt.logic.servlet.dataOut.rpc.infoman.RemoveInfomanSoftwareFromPlanedUpdateHandler;
import de.proveo.wwt.logic.servlet.dataOut.rpc.infoman.SetInfomanSoftwareForPlanedUpdateHandler;
import de.proveo.wwt.logic.servlet.dataOut.rpc.infoman.UpdateScheduledInfomanUpdateHandler;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.dto.UnitTreeNode;
import java.beans.DefaultPersistenceDelegate;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleXMLRPCServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(SimpleXMLRPCServlet.class);
    private Map<String, SimpleRPCHandler> handler = new HashMap<String, SimpleRPCHandler>();

    public String getServletInfo() {
        return "Simple XML RPC Servlet";
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        SimpleRPCHandler handler = new AddConfigurationToInfomanRemoteUpdateHandler();
        this.handler.put(handler.getMethodName(), handler);
        handler = new BeginInfomanUpdateHandler();
        this.handler.put(handler.getMethodName(), handler);
        handler = new CreatePlanedInfomanUpdateHandler();
        this.handler.put(handler.getMethodName(), handler);
        handler = new GetAvailableInfomanSoftwareHandler();
        this.handler.put(handler.getMethodName(), handler);
        handler = new GetCurrentInfomanSetupHandler();
        this.handler.put(handler.getMethodName(), handler);
        handler = new GetInfomanSoftwareForPlanedUpdateHandler();
        this.handler.put(handler.getMethodName(), handler);
        handler = new GetPlannedInfomanRemoteUpdatesHandler();
        this.handler.put(handler.getMethodName(), handler);
        handler = new GetUnitTreeHandler();
        this.handler.put(handler.getMethodName(), handler);
        handler = new InfomanUpdateDoneHandler();
        this.handler.put(handler.getMethodName(), handler);
        handler = new LoginHandler();
        this.handler.put(handler.getMethodName(), handler);
        handler = new RemoveInfomanSoftwareFromPlanedUpdateHandler();
        this.handler.put(handler.getMethodName(), handler);
        handler = new SetInfomanSoftwareForPlanedUpdateHandler();
        this.handler.put(handler.getMethodName(), handler);
        handler = new UpdateScheduledInfomanUpdateHandler();
        this.handler.put(handler.getMethodName(), handler);
        handler = new GetAPVisibleUnitTreeHandler();
        this.handler.put(handler.getMethodName(), handler);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        throw new ServletException("HTTP GET is not supported");
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Object result;
        SimpleRPCHandler handler;
        String contentEncoding = request.getHeader("Content-Encoding");
        Object in = contentEncoding != null && contentEncoding.equals("gzip") ? new GZIPInputStream((InputStream)request.getInputStream()) : request.getInputStream();
        XMLDecoder decoder = new XMLDecoder((InputStream)in);
        SimpleXMLRPCCall call = (SimpleXMLRPCCall)decoder.readObject();
        decoder.close();
        String callerMethod = call.getMethod();
        if (callerMethod == null) {
            callerMethod = "";
        }
        if ((handler = this.handler.get(callerMethod)) == null) {
            throw new ServletException("unkown method: " + callerMethod);
        }
        log.trace((Object)("callerMethod: " + callerMethod));
        if (!callerMethod.equals("Login")) {
            String username = (String)call.getParameter("username");
            String password = (String)call.getParameter("password");
            if (username != null && password != null) {
                try {
                    LoginCallbackHandler cbh = new LoginCallbackHandler(username, password);
                    LoginContext lc = new LoginContext("rts", (CallbackHandler)cbh);
                    lc.login();
                }
                catch (LoginException ex) {
                    log.error((Object)"Login in failed", (Throwable)ex);
                }
            }
        }
        try {
            handler.init();
            result = handler.execute(call);
        }
        catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)("runs during execute '" + callerMethod + "' into"), (Throwable)ex);
            }
            result = ex;
        }
        response.setContentType("text/xml;charset=UTF-8");
        XMLEncoder resultEncoder = new XMLEncoder((OutputStream)response.getOutputStream());
        resultEncoder.setPersistenceDelegate(UnitTreeNode.class, new DefaultPersistenceDelegate(new String[]{"unitModelValue", "unitIdentityValue", "unitTypeIdentityValue"}));
        resultEncoder.writeObject(result);
        resultEncoder.close();
    }
}

