/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataOut.replay;

import de.proveo.util.observable.interfaces.ServletBlocker;
import de.proveo.wwt.logic.app.security.LoginCallbackHandler;
import de.proveo.wwt.logic.app.security.LoginContextUtil;
import de.proveo.wwt.logic.servlet.dataIn.observable.client.RemoteClient;
import de.proveo.wwt.logic.servlet.dataOut.replay.ReplayClient;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.SingleThreadModel;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReplayServlet
extends HttpServlet
implements SingleThreadModel,
ServletBlocker {
    private static final long serialVersionUID = -2985636220991187191L;
    private static final Log log = LogFactory.getLog(ReplayServlet.class);
    private static final String CONTENT_TYPE = "application/octet-stream";
    private static final String PARAM_USERNAME = "username";
    private static final String PARAM_PASSWORD = "password";
    private long requestedBeginTime;
    private long requestedEndTime;
    private boolean isRunning;
    private String username;
    private String password;

    public void destroy() {
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.warn((Object)"doGet(): use POST instead of GET !");
        this.doPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String method = "doPost(): ";
        String returnMsg = "'URL_DID_NOT_WORK'";
        response.setContentType(CONTENT_TYPE);
        this.requestedBeginTime = this.getTimeParameter(request, "beginTime");
        this.requestedEndTime = this.getTimeParameter(request, "endTime");
        if (this.requestedBeginTime <= 0L || this.requestedEndTime <= 0L || this.requestedBeginTime > this.requestedEndTime) {
            returnMsg = "begin/end time combination not allowed ! (" + this.requestedBeginTime + "/" + this.requestedEndTime + ")";
            log.error((Object)returnMsg);
            throw new ServletException(returnMsg);
        }
        this.username = request.getParameter(PARAM_USERNAME);
        this.password = request.getParameter(PARAM_PASSWORD);
        if (this.username == null || this.password == null) {
            log.warn((Object)(method + "username or password not given"));
        } else {
            try {
                LoginCallbackHandler cbh = new LoginCallbackHandler(this.username, this.password);
                LoginContext lc = new LoginContext("rts", (CallbackHandler)cbh);
                lc.login();
                log.debug((Object)(method + "login done."));
            }
            catch (LoginException e1) {
                log.error((Object)(method + "Login in ObservableClient failed: " + e1));
            }
        }
        this.handleRequest(request, response);
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    private long getTimeParameter(HttpServletRequest request, String key) throws ServletException {
        String par = request.getParameter(key);
        String msg = "";
        if (par == null) {
            msg = "URL parameter '" + key + "' missing !";
            log.error((Object)msg);
            throw new ServletException(msg);
        }
        long val = Long.parseLong(par);
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String method = "handleRequest(): ";
        log.debug((Object)(method + "start"));
        ServletOutputStream sos = response.getOutputStream();
        boolean isSuperAdmin = false;
        LoginContextUtil lcu = null;
        try {
            lcu = new LoginContextUtil(this.username, this.password);
            isSuperAdmin = lcu.isSuperAdmin();
        }
        catch (Exception ex) {
            log.error((Object)"LoginContextUtil runs into", (Throwable)ex);
        }
        ObjectOutputStream oos = new ObjectOutputStream((OutputStream)sos);
        ReplayClient replayClient = new ReplayClient(this, new RemoteClient(request, oos), isSuperAdmin);
        log.debug((Object)(method + "ReplayClient started..."));
        replayClient.setTime(this.requestedBeginTime, this.requestedEndTime);
        replayClient.collectAndSendData();
        log.debug((Object)(method + "ReplayClient has sent data."));
        try {
            ReplayServlet replayServlet = this;
            synchronized (replayServlet) {
                while (this.isRunning) {
                    ((Object)((Object)this)).wait(1000L);
                }
            }
        }
        catch (InterruptedException ex) {
            log.error((Object)ex);
        }
        finally {
            log.debug((Object)"handleRequest ended...");
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void stopRunning() {
        log.debug((Object)"MapClientServlet.stopRunning() called...");
        this.isRunning = false;
    }
}

