/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataOut.model;

import de.proveo.wwt.logic.ejb.general.unit.UnitData;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacade;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeUtil;
import java.beans.XMLEncoder;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UnitServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(UnitServlet.class);
    private UnitFacade unitFacade;

    public String getServletInfo() {
        return "Short description";
    }

    public void init(ServletConfig config) throws ServletException {
        try {
            this.unitFacade = UnitFacadeUtil.getHome().create();
        }
        catch (Exception ex) {
            log.error((Object)"init() runs into", (Throwable)ex);
            throw new ServletException((Throwable)ex);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HashSet values = new HashSet();
        try {
            UnitData[] rootUnits = this.unitFacade.getRootUnits();
            for (int i = 0; i < rootUnits.length; ++i) {
                long[] basicUnitIds = this.unitFacade.getBasicUnitIds(rootUnits[i].getUnitid().longValue());
                values.addAll(this.unitFacade.getUnitDatas(basicUnitIds));
            }
        }
        catch (Exception ex) {
            log.error((Object)"processRequest() runs into", (Throwable)ex);
            throw new ServletException((Throwable)ex);
        }
        response.setContentType("text/xml;charset=UTF-8");
        XMLEncoder encoder = new XMLEncoder((OutputStream)response.getOutputStream());
        encoder.writeObject(values);
        encoder.close();
    }
}

