/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataOut;

import de.proveo.wwt.logic.ejb.general.area.Area;
import de.proveo.wwt.logic.ejb.general.area.AreaHome;
import de.proveo.wwt.logic.ejb.general.area.AreaPK;
import de.proveo.wwt.logic.ejb.general.area.AreaPoints;
import de.proveo.wwt.logic.ejb.general.area.AreaPointsHome;
import de.proveo.wwt.logic.ejb.general.area.AreaPointsUtil;
import de.proveo.wwt.logic.ejb.general.area.AreaUtil;
import de.proveo.wwt.logic.ejb.general.area.AreaValue;
import java.awt.Point;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AreaServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(AreaServlet.class);
    private static final long serialVersionUID = 1649278135481L;
    private AreaHome areaHome;
    private AreaPointsHome areaPointsHome;

    public String getServletInfo() {
        return "Short description";
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            this.areaHome = AreaUtil.getHome();
            this.areaPointsHome = AreaPointsUtil.getHome();
        }
        catch (Exception ex) {
            log.error((Object)"Exception throwing during returning a AreaBean", (Throwable)ex);
            throw new ServletException("Exception throwing during returning a AreaBean ");
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String areaName = request.getParameter("areaName");
        HashMap areasHashMap = new HashMap();
        try {
            if (areaName == null) {
                Collection areaEntities = this.areaHome.findOrderedByPriority();
                for (Area area : areaEntities) {
                    AreaValue areaValue = area.getAreaValue();
                    String areaKey = areaValue.getArea();
                    HashMap<String, Object> areaValues = new HashMap<String, Object>();
                    areaValues.put("desc", areaValue.getDescription());
                    areaValues.put("prio", Integer.toString(areaValue.getPriority()));
                    areaValues.put("points", this.readPointsForArea(areaKey));
                    areasHashMap.put(areaKey, areaValues);
                }
            } else {
                Area area = this.areaHome.findByPrimaryKey(new AreaPK(areaName));
                AreaValue areaValue = area.getAreaValue();
                HashMap<String, Object> areaValues = new HashMap<String, Object>();
                areaValues.put("desc", areaValue.getDescription());
                areaValues.put("prio", Integer.toString(areaValue.getPriority()));
                areaValues.put("points", this.readPointsForArea(areaName));
                areasHashMap.put(areaName, areaValues);
            }
        }
        catch (Exception ex) {
            log.error((Object)"runs into", (Throwable)ex);
            throw new ServletException("Exception throwing during creating a area collection", (Throwable)ex);
        }
        response.setContentType("text/html;charset=UTF-8");
        ServletOutputStream sos = response.getOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream((OutputStream)sos);
        oos.writeObject(areasHashMap);
        oos.flush();
        oos.close();
    }

    private Collection readPointsForArea(String areaName) throws ServletException {
        ArrayList<Point> areaPoints = new ArrayList<Point>();
        try {
            for (AreaPoints areaPoint : this.areaPointsHome.findByArea(areaName)) {
                areaPoints.add(new Point(areaPoint.getAreaPointsValue().getLongitude(), areaPoint.getAreaPointsValue().getLatitude()));
            }
        }
        catch (Exception ex) {
            log.error((Object)"runs into", (Throwable)ex);
            throw new ServletException("Exception throwing during creating a points collection", (Throwable)ex);
        }
        return areaPoints;
    }
}

