/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataIn.observable.client;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class RemoteClient {
    private HttpServletRequest request = null;
    private ObjectOutputStream objectOutputStream = null;
    private Properties properties = null;

    public RemoteClient(HttpServletRequest request, ObjectOutputStream servletOutputStream) {
        this.request = request;
        this.objectOutputStream = servletOutputStream;
        this.properties = this.getPropertiesFromRequest(request);
    }

    public synchronized void sendObject(Object obj) throws IOException {
        this.objectOutputStream.writeObject(obj);
        this.objectOutputStream.flush();
        this.objectOutputStream.reset();
    }

    public synchronized void closeOutputStream() throws IOException {
        this.objectOutputStream.close();
    }

    public Properties getProperties() {
        return this.properties;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    protected Properties getPropertiesFromRequest(HttpServletRequest request) {
        Properties event = new Properties();
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            event.setProperty(key, request.getParameter(key));
        }
        return event;
    }
}

