/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataIn.observable.client;

import de.proveo.util.observable.interfaces.AllDataListener;
import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.logic.app.filter.MapFilter;
import de.proveo.wwt.logic.app.geo.GeoStruct;
import de.proveo.wwt.logic.app.keepalive.event.KeepAliveEvent;
import de.proveo.wwt.logic.app.notify.event.NotifyEvent;
import de.proveo.wwt.logic.app.security.LoginContextUtil;
import de.proveo.wwt.logic.app.use.event.UseEvent;
import de.proveo.wwt.logic.ejb.dataIn.informant.InformantClient;
import de.proveo.wwt.logic.ejb.dataIn.scanmanmsg.ScanmanMsgHistoryValue;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.CurrentStateCacheValue;
import de.proveo.wwt.logic.ejb.dataIn.use.UseFacade;
import de.proveo.wwt.logic.ejb.dataIn.use.UseFacadeUtil;
import de.proveo.wwt.logic.ejb.dataOut.mapclient.MapClientFacade;
import de.proveo.wwt.logic.ejb.dataOut.mapclient.MapClientFacadeUtil;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationClient;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserValue;
import de.proveo.wwt.logic.ejb.general.use.user.UserNotFoundException;
import de.proveo.wwt.logic.ejb.general.version.WwtVersion;
import de.proveo.wwt.logic.ejb.general.version.WwtVersionUtil;
import de.proveo.wwt.logic.servlet.dataIn.observable.client.ObservableClient;
import de.proveo.wwt.logic.servlet.dataIn.units.threads.AllDataThread;
import de.proveo.wwt.logic.servlet.dataOut.rpc.SimpleXMLRPCCallImpl;
import de.proveo.wwt.logic.servlet.dataOut.rpc.airportmap.GetAPVisibleUnitTreeHandler;
import java.beans.XMLEncoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import javax.ejb.CreateException;
import javax.jms.JMSException;
import javax.naming.NamingException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObservableUnitsClient
implements AllDataListener {
    private static final Log log = LogFactory.getLog(ObservableUnitsClient.class);
    private AllDataThread allDataThread = null;
    private HashSet<Long> unitPermissions;
    boolean notifyPermission = false;
    private InformantClient informantClient = null;
    private ConcurrentHashMap allStampsForMapClient = null;
    private volatile boolean updateRunning = false;
    private MapClientFacade mapClientFacade = null;
    private MapFilter mapFilter = new MapFilter();
    private ObservableClient observableClient = null;
    private UseFacade useFacade = null;
    private long infomanKeepaliveTimeout = 0L;
    private Set<Long> allClientUnitIDs = null;
    private WwtVersion wwtVersion = null;
    private LoginContextUtil lcu;
    private Map serverSideFilter;

    public ObservableUnitsClient(ObservableClient observableClient) {
        this.observableClient = observableClient;
        this.informantClient = new InformantClient();
        this.mapFilter = new MapFilter();
        this.allStampsForMapClient = new ConcurrentHashMap();
        try {
            this.mapClientFacade = MapClientFacadeUtil.getHome().create();
            this.useFacade = UseFacadeUtil.getHome().create();
            this.wwtVersion = WwtVersionUtil.getHome().create();
        }
        catch (RemoteException e) {
            log.error((Object)("ObservableUnitsClient() runs into RemoteException: " + e.toString()), (Throwable)e);
            this.informantClient.notify("ObservableUnitsClient() runs into RemoteException: " + e, "UnitErrorEvent");
        }
        catch (CreateException e) {
            log.error((Object)("ObservableUnitsClient() runs into CreateException: " + e.toString()), (Throwable)e);
            this.informantClient.notify("ObservableUnitsClient() runs into CreateException: " + (Object)((Object)e), "UnitErrorEvent");
        }
        catch (NamingException e) {
            log.error((Object)("ObservableUnitsClient() runs into NamingException: " + e.toString()), (Throwable)e);
            this.informantClient.notify("ObservableUnitsClient() runs into NamingException: " + e, "UnitErrorEvent");
        }
        long DEFAULT = 300L;
        long value = 300L;
        String key = "infoman.keepalive.timeout";
        ConfigurationClient cc = new ConfigurationClient();
        try {
            String para = cc.getParameter(key, Long.toString(300L));
            value = Long.parseLong(para);
        }
        catch (RemoteException ex) {
            log.error((Object)("ConfigurationClient.getParameter() runs into RemoteException, use DEFAULT 300 for '" + key + "'."));
        }
        this.infomanKeepaliveTimeout = value * 60L * 1000L;
        this.notifyPermission = this.getNotifyPermission();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAllStampsToClient() throws JMSException {
        String method = "sendAllStampsToClient(): ";
        if (this.serverSideFilter == null) {
            this.getServerSideFilter();
        }
        if (!this.observableClient.isMarkedForShutdown()) {
            try {
                Object unitTree;
                log.debug((Object)(method + "Start"));
                this.observableClient.unitsEventBufferActive = true;
                this.unitPermissions = this.mapClientFacade.getUnitPermissions();
                boolean infomanMessagesNeeded = this.observableClient.selector.indexOf("InfomanMessages") != -1;
                boolean notifyMessagesNeeded = this.observableClient.selector.indexOf("InfomanNotifyMessages") != -1 && this.notifyPermission;
                boolean useMessagesNeeded = this.observableClient.selector.indexOf("UseEvent") != -1;
                Set allStampsByDB = this.mapClientFacade.getOnlineMapData(infomanMessagesNeeded, notifyMessagesNeeded, useMessagesNeeded, this.observableClient.getUsername(), this.observableClient.getPassword());
                if (this.unitPermissions == null) {
                    log.error((Object)(method + "No unitPermissions from mapClientFacade received!!!!"));
                }
                HashMap filteredTmpData = this.mapFilter.filterData(allStampsByDB);
                ConcurrentHashMap concurrentHashMap = this.allStampsForMapClient;
                synchronized (concurrentHashMap) {
                    this.allStampsForMapClient.putAll(filteredTmpData);
                }
                log.trace((Object)"All data has been updated!");
                this.allClientUnitIDs = new HashSet<Long>(this.allStampsForMapClient.keySet());
                HashMap<String, Object> mcr = new HashMap<String, Object>();
                mcr.put("Java_Version", System.getProperty("java.version"));
                mcr.put("RTS_Version", this.wwtVersion.getVersionInfo("implVersion"));
                mcr.put("Stamps", filteredTmpData);
                mcr.put("DataType", "units");
                boolean isSuperAdmin = false;
                if (this.lcu == null) {
                    try {
                        this.lcu = new LoginContextUtil(this.observableClient.getUsername(), this.observableClient.getPassword());
                        isSuperAdmin = this.lcu.isSuperAdmin();
                    }
                    catch (Exception ex) {
                        log.error((Object)"LoginContextUtil runs into: ", (Throwable)ex);
                    }
                } else {
                    isSuperAdmin = this.lcu.isSuperAdmin();
                }
                ByteArrayOutputStream unitTreeXML = new ByteArrayOutputStream();
                SimpleXMLRPCCallImpl call = new SimpleXMLRPCCallImpl();
                GetAPVisibleUnitTreeHandler handler = new GetAPVisibleUnitTreeHandler();
                call.setMethod(handler.getMethodName());
                call.addParameter("isSuperadmin", isSuperAdmin);
                try {
                    handler.init();
                    unitTree = handler.execute(call);
                }
                catch (Exception ex) {
                    IOException ioEx = new IOException();
                    ioEx.initCause(ex);
                    throw ioEx;
                }
                XMLEncoder resultEncoder = new XMLEncoder(unitTreeXML);
                resultEncoder.writeObject(unitTree);
                resultEncoder.close();
                mcr.put("unitTreeXML", new String(unitTreeXML.toByteArray(), "utf-8"));
                mcr.put("ServerTime", new Long(System.currentTimeMillis()));
                mcr.put("ServerTimeZone", TimeZone.getDefault());
                log.debug((Object)(method + "Prepare finished --> Start sending to the Client."));
                this.sendResponse(mcr);
                log.debug((Object)(method + "Sending all stamps finished."));
                this.observableClient.pingThread.resetTimer();
                if (this.observableClient.unitEventBufferLinkedList.size() > 0) {
                    log.debug((Object)(method + "Finally sending buffer content..."));
                    this.observableClient.sendEventBufferToClient();
                } else {
                    this.observableClient.unitsEventBufferActive = false;
                    log.debug((Object)(method + "EventBuffer deactivated!"));
                }
                if (this.allDataThread == null) {
                    log.debug((Object)(method + "init new AllDataThread..."));
                    this.startAllDataThread();
                }
                log.debug((Object)(method + "All stamps sent to client!"));
            }
            catch (RemoteException re) {
                log.error((Object)(method + "runs into RemoteException!"), (Throwable)re);
                this.observableClient.setMarkedForShutdown(true);
            }
            catch (Exception e) {
                log.error((Object)(method + "Unkown Exception caught!!!!! Will shutdown all Client Threads as a precaution!!! See log-files for further infos!"), (Throwable)e);
                this.observableClient.setMarkedForShutdown(true);
            }
        } else {
            log.warn((Object)(method + "Client is marked for Shutdown."));
            if (this.allDataThread.isRunning()) {
                log.debug((Object)(method + "Stopping allDataThread."));
                this.cleanUp();
            }
        }
    }

    protected void cleanUp() {
        if (this.allDataThread != null) {
            this.allDataThread.stopRunning();
            try {
                this.allDataThread.interrupt();
            }
            catch (IllegalMonitorStateException e) {
                log.warn((Object)"IllegalMonitorStateException while notifing AllDataThread during cleanup in ObservableUnitsClient.");
            }
            catch (SecurityException e) {
                log.warn((Object)"SecurityException while notifing AllDataThread during cleanup in ObservableUnitsClient.");
            }
        }
        this.allDataThread = null;
    }

    protected void handleMessage(SerializableEventWrapper event) throws JMSException {
        if (this.serverSideFilter == null) {
            this.getServerSideFilter();
        }
        if (this.observableClient.unitsEventBufferActive && !this.observableClient.isMarkedForShutdown()) {
            this.observableClient.unitEventBufferLinkedList.addLast(event);
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.toString() + " - handleMessage(): Event sent to buffer!"));
            }
        } else {
            this.sendMessageToClient(event);
            this.observableClient.pingThread.resetTimer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendMessageToClient(SerializableEventWrapper eventWrapper) throws JMSException {
        Map stamp;
        HashMap eventMap;
        GeoStruct event;
        String eventType;
        String method = "sendMessageToClient() (" + this.toString() + "): ";
        if (this.serverSideFilter == null) {
            this.getServerSideFilter();
        }
        if ((eventType = eventWrapper.get_typeOfEvent()).equals("GeoStructHistoryAndCache")) {
            log.debug((Object)"Event type: GeoStruct");
            event = (GeoStruct)eventWrapper.get_cacheValue();
            eventMap = this.getGeoEventMap(event);
        } else if (eventType.equals("StateEventHistoryAndCache")) {
            log.debug((Object)"Event type: StateEvent");
            event = (CurrentStateCacheValue)eventWrapper.get_cacheValue();
            eventMap = this.getStateEventMap((CurrentStateCacheValue)event);
        } else if (eventType.equals("KeepAlive")) {
            log.debug((Object)"Event type: KeepAliveEvent");
            event = (KeepAliveEvent)eventWrapper.get_cacheValue();
            eventMap = this.getKeepaliveEventMap((KeepAliveEvent)event);
        } else if (eventType.equals("InfomanMessages")) {
            log.debug((Object)"Event type: InfomanEvent (Scanman Message)");
            event = (ScanmanMsgHistoryValue)eventWrapper.get_cacheValue();
            eventMap = this.getInfomanEventMap((ScanmanMsgHistoryValue)event);
        } else if (eventType.equals("InfomanNotifyMessages")) {
            log.debug((Object)"Event type: NotifyEvent");
            event = (NotifyEvent)eventWrapper.get_cacheValue();
            eventMap = this.getNotifyEventMap((NotifyEvent)event);
        } else if (eventType.equals("UseEvent")) {
            log.debug((Object)"Event type: UseEvent");
            event = (UseEvent)eventWrapper.get_cacheValue();
            eventMap = this.getUseEventMap((UseEvent)event);
        } else {
            log.error((Object)(method + "found unknown event type '" + eventType + "'!"));
            return;
        }
        boolean permission = this.checkPermission(eventMap);
        if (!permission) {
            return;
        }
        long unitID = (Long)eventMap.get("UnitId");
        ConcurrentHashMap concurrentHashMap = this.allStampsForMapClient;
        synchronized (concurrentHashMap) {
            stamp = (Map)this.allStampsForMapClient.get(unitID);
        }
        if (stamp != null) {
            stamp.putAll(eventMap);
            this.mapFilter.markStamp(stamp);
            boolean matchFilter = false;
            if (stamp.containsKey("FilterPassed")) {
                matchFilter = (Boolean)stamp.get("FilterPassed");
            } else {
                log.error((Object)(method + "stamp does not contain key for filter marker '" + "FilterPassed" + "'"));
            }
            boolean sendToClient = true;
            if (this.mapFilter.isFilterSet()) {
                if (matchFilter) {
                    sendToClient = true;
                    this.allClientUnitIDs.add(unitID);
                } else if (this.allClientUnitIDs.contains(unitID)) {
                    sendToClient = true;
                    this.allClientUnitIDs.remove(unitID);
                } else {
                    sendToClient = false;
                }
            }
            if (sendToClient) {
                eventMap.put("DataType", "SingleUnitEvent");
                this.sendResponse(eventMap);
            }
        } else {
            log.error((Object)("Unit ID " + unitID + "hasn't been found in local GSE data. System was not able to update this entry!"));
        }
    }

    private HashMap getGeoEventMap(GeoStruct geoStruct) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        valueMap.put("EventType", "GeoStruct");
        valueMap.put("UnitId", geoStruct.getUnitId());
        valueMap.put("GpsRmc", geoStruct.getRmcRec());
        valueMap.put("GpsGga", geoStruct.getGgaRec());
        valueMap.put("GeoBegin", geoStruct.getBeginReceiveTime());
        valueMap.put("Area", geoStruct.getArea());
        valueMap.put("AreaName", geoStruct.getAreaDescription());
        valueMap.put("GpsLatMsec", geoStruct.getLatMSEC());
        valueMap.put("GpsLongMsec", geoStruct.getLongMSEC());
        return valueMap;
    }

    private HashMap getKeepaliveEventMap(KeepAliveEvent keepAliveEvent) {
        long timeStamp = keepAliveEvent.getTimestamp();
        boolean timeout = false;
        if (System.currentTimeMillis() - timeStamp > this.infomanKeepaliveTimeout) {
            timeout = true;
        }
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        valueMap.put("EventType", "KeepAliveEvent");
        valueMap.put("UnitId", keepAliveEvent.getUnitId());
        valueMap.put("KeepaliveTimestamp", timeStamp);
        valueMap.put("KeepaliveTimeout", timeout);
        return valueMap;
    }

    private HashMap getNotifyEventMap(NotifyEvent notifyEvent) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        valueMap.put("EventType", "data_type_notification_event");
        valueMap.put("NotifyTimestamp", new Long(notifyEvent.getTimestamp()));
        valueMap.put("NotifyEntry", new Boolean(notifyEvent.isEntry()));
        valueMap.put("NotifyMessageID", new Long(notifyEvent.getMessageId()));
        valueMap.put("NotifyMessage", notifyEvent.getMessage());
        valueMap.put("NotifyReceiveTime", new Long(notifyEvent.getReceiveTime()));
        valueMap.put("UnitId", new Long(notifyEvent.getUnitId()));
        return valueMap;
    }

    private HashMap getInfomanEventMap(ScanmanMsgHistoryValue scanmanMsgHistoryValue) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        valueMap.put("EventType", "data_type_infoman_event");
        valueMap.put("UnitId", scanmanMsgHistoryValue.getUnitId());
        if (scanmanMsgHistoryValue.getType() == 9 || scanmanMsgHistoryValue.getType() == 25 || scanmanMsgHistoryValue.getType() == 10) {
            if (scanmanMsgHistoryValue.getType() == 9) {
                valueMap.put("SmErrorTimestamp", scanmanMsgHistoryValue.getCreateTime());
                valueMap.put("SmErrorMessage", scanmanMsgHistoryValue.getMsgToString());
            } else if (scanmanMsgHistoryValue.getType() == 25) {
                valueMap.put("SmBootTimestamp", scanmanMsgHistoryValue.getCreateTime());
                valueMap.put("SmBootMessage", scanmanMsgHistoryValue.getMsgToString());
            } else if (scanmanMsgHistoryValue.getType() == 10) {
                valueMap.put("SmIpTimestamp", scanmanMsgHistoryValue.getCreateTime());
                valueMap.put("SmIpMessage", scanmanMsgHistoryValue.getMsgToString());
            }
        }
        return valueMap;
    }

    private HashMap getStateEventMap(CurrentStateCacheValue stateEvent) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        valueMap.put("EventType", "StateEvent");
        valueMap.put("UnitId", stateEvent.getUnitId());
        valueMap.put("StateModelID", stateEvent.getStateModelId());
        this.fillupStateEventData(stateEvent, valueMap);
        return valueMap;
    }

    private HashMap getUseEventMap(UseEvent useEvent) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        valueMap.put("EventType", "UseEvent");
        valueMap.put("UseEventUserKey", useEvent.getUserKey());
        try {
            long userId = this.useFacade.getUserIdByKey(useEvent.getUserKey());
            UseUserValue useUserValue = this.useFacade.getUser(userId);
            valueMap.put("UseEventDriverName", useUserValue.getName());
            valueMap.put("UseEventPersonalNumber", useUserValue.getPersonalNumber());
        }
        catch (RemoteException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        catch (UserNotFoundException e) {
            log.warn((Object)("user not found for key: " + useEvent.getUserKey()));
        }
        valueMap.put("UnitId", useEvent.getUnitId());
        valueMap.put("UseEventTimestamp", useEvent.getTimestamp());
        valueMap.put("UseEventUserGroupId", useEvent.getUserGroupId());
        valueMap.put("UseEventLogin", useEvent.isLogin());
        valueMap.put("UseEventReceiveTime", useEvent.getReceiveTime());
        return valueMap;
    }

    private void fillupStateEventData(CurrentStateCacheValue stateEvent, HashMap valueMap) {
        if (stateEvent.getStateModelId() == 2010L) {
            valueMap.put("MotorState", stateEvent.getState());
            valueMap.put("MotorStateBegin", stateEvent.getBeginTime());
        } else if (stateEvent.getStateModelId() == 2110L) {
            valueMap.put("InfomanOnlineState", stateEvent.getState());
            valueMap.put("InfomanOnlineStateBegin", stateEvent.getBeginTime());
        } else if (stateEvent.getStateModelId() == 2050L) {
            valueMap.put("OperationState", stateEvent.getState());
            valueMap.put("OperationStateBegin", stateEvent.getBeginTime());
        } else if (stateEvent.getStateModelId() == 2090L) {
            valueMap.put("ServiceState", stateEvent.getState());
            valueMap.put("ServiceStateBegin", stateEvent.getBeginTime());
            valueMap.put("ServiceStateRemark", stateEvent.getRemark());
        } else if (stateEvent.getStateModelId() == 2100L) {
            valueMap.put("AssignedState", stateEvent.getState());
            valueMap.put("AssignedStateBegin", stateEvent.getBeginTime());
            valueMap.put("AssignedStateRemark", stateEvent.getRemark());
        } else if (stateEvent.getStateModelId() == 2030L) {
            valueMap.put("FuelState", stateEvent.getState());
            valueMap.put("FuelStateBegin", stateEvent.getBeginTime());
        } else if (stateEvent.getStateModelId() == 2120L) {
            valueMap.put("GseAssignmentState", stateEvent.getState());
            valueMap.put("GseAssignmentStateBegin", stateEvent.getBeginTime());
        } else if (stateEvent.getStateModelId() == 2020L) {
            valueMap.put("ConnectorState", stateEvent.getState());
            valueMap.put("ConnectorStateBegin", stateEvent.getBeginTime());
        } else if (stateEvent.getStateModelId() == 2910L) {
            valueMap.put("Flag1State", stateEvent.getState());
            valueMap.put("Flag1StateBegin", stateEvent.getBeginTime());
            valueMap.put("Flag1StateRemark", stateEvent.getRemark());
        } else if (stateEvent.getStateModelId() == 2920L) {
            valueMap.put("Flag2State", stateEvent.getState());
            valueMap.put("Flag2StateBegin", stateEvent.getBeginTime());
            valueMap.put("Flag2StateRemark", stateEvent.getRemark());
        } else if (stateEvent.getStateModelId() == 2930L) {
            valueMap.put("Flag3State", stateEvent.getState());
            valueMap.put("Flag3StateBegin", stateEvent.getBeginTime());
            valueMap.put("Flag3StateRemark", stateEvent.getRemark());
        } else {
            log.error((Object)("fillupStateEventData(): unknown state model ID " + stateEvent.getStateModelId() + " !"));
        }
    }

    private void sendResponse(Map responseMap) {
        String method = "sendResponse(): ";
        try {
            this.observableClient.client.sendObject(responseMap);
            if (log.isDebugEnabled()) {
                log.debug((Object)(method + "Message sent to client."));
            }
        }
        catch (IOException e) {
            log.warn((Object)(method + "runs into IOException! Probably the client was shut down. Session will be unsubscribed!"));
            this.observableClient.setMarkedForShutdown(true);
        }
        catch (NullPointerException e) {
            log.error((Object)(method + "runs into NullPointerException! Session will be unsubscribed!"), (Throwable)e);
            this.observableClient.setMarkedForShutdown(true);
        }
        catch (Exception e) {
            log.error((Object)"Unkown Exception caught!!!!! Will shutdown all Client Threads as a precaution!!! See log-files for further infos!", (Throwable)e);
            this.informantClient.notify(method + "" + this.toString() + " -  runs into Exception: " + e, "UnitErrorEvent");
            this.observableClient.setMarkedForShutdown(true);
        }
    }

    private void startAllDataThread() {
        this.allDataThread = new AllDataThread();
        this.allDataThread.setListener(this);
        this.allDataThread.start();
    }

    private boolean checkPermission(Map eventMap) {
        long unitID = (Long)eventMap.get("UnitId");
        if (!this.unitPermissions.contains(unitID)) {
            return false;
        }
        String eventType = (String)eventMap.get("EventType");
        if (eventType.equals("data_type_notification_event")) {
            return this.notifyPermission;
        }
        return true;
    }

    private boolean getNotifyPermission() {
        String method = "getNotifyPermission(): ";
        log.debug((Object)(method + "..."));
        try {
            this.lcu = new LoginContextUtil(this.observableClient.getUsername(), this.observableClient.getPassword());
        }
        catch (Exception ex) {
            log.error((Object)"LoginContextUtil runs into: ", (Throwable)ex);
            return false;
        }
        if (this.lcu.isSuperAdmin()) {
            return true;
        }
        if (this.lcu.isUserInRole("section.airportmap.notification")) {
            log.debug((Object)(method + "client has permission for notifications."));
            return true;
        }
        log.debug((Object)(method + "client has NO permission for notifications."));
        return false;
    }

    private void getServerSideFilter() {
        HttpServletRequest request = this.observableClient.getClient().getRequest();
        if (request != null) {
            Map params = request.getParameterMap();
            if (!params.containsKey("serversideFilter")) {
                return;
            }
            log.error((Object)"*** server side filter found! do not use yet!");
            this.serverSideFilter.clear();
            this.getServerSideFilterValue(params, "beginTime");
            this.getServerSideFilterValue(params, "endTime");
            this.getServerSideFilterValue(params, "unitId");
            this.getServerSideFilterValue(params, "isAlive");
            this.getServerSideFilterValue(params, "onlineState");
            this.getServerSideFilterValue(params, "unitKind");
            this.getServerSideFilterValue(params, "gseAssignmentState");
            this.getServerSideFilterValue(params, "operationState");
            this.getServerSideFilterValue(params, "motorState");
            this.getServerSideFilterValue(params, "serviceState");
            this.getServerSideFilterValue(params, "assignedState");
            this.getServerSideFilterValue(params, "fuelState");
            this.getServerSideFilterValue(params, "connectorState");
            this.getServerSideFilterValue(params, "flag1State");
            this.getServerSideFilterValue(params, "flag2State");
            this.getServerSideFilterValue(params, "flag3State");
            this.mapFilter.setFilter(this.serverSideFilter);
        } else {
            log.error((Object)"getServerSideFilter() - servlet request is null");
        }
    }

    private void getServerSideFilterValue(Map params, String key) {
        if (params.containsKey(key)) {
            this.serverSideFilter.put(key, params.get(key));
        }
    }
}

