/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataIn.observable.client;

import de.proveo.util.observable.stands.StandsDataFactory;
import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.logic.ejb.dataIn.informant.InformantClient;
import de.proveo.wwt.logic.ejb.dataIn.stands.parser.GSEAndStaffConverterFacade;
import de.proveo.wwt.logic.ejb.dataIn.stands.parser.GSEAndStaffConverterFacadeUtil;
import de.proveo.wwt.logic.servlet.dataIn.observable.client.ObservableClient;
import de.proveo.wwt.logic.servlet.dataIn.stands.connector.AbstractStandsConnector;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Map;
import javax.ejb.CreateException;
import javax.jms.JMSException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObservableStandsClient {
    private static final Log log = LogFactory.getLog(ObservableStandsClient.class);
    private InformantClient informantClient = null;
    private ObservableClient observableClient = null;
    private GSEAndStaffConverterFacade gSEandStaffConverterFacade = null;

    public ObservableStandsClient(ObservableClient observableClient) {
        this.observableClient = observableClient;
        this.informantClient = new InformantClient();
        try {
            this.gSEandStaffConverterFacade = GSEAndStaffConverterFacadeUtil.getHome().create();
        }
        catch (RemoteException e) {
            log.error((Object)"ObservableStandsClient runs into RemoteException: ", (Throwable)e);
        }
        catch (CreateException e) {
            log.error((Object)"ObservableStandsClient runs into CreateException: ", (Throwable)e);
        }
        catch (NamingException e) {
            log.error((Object)"ObservableStandsClient runs into NamingException: ", (Throwable)e);
        }
    }

    protected void cleanUp() {
        this.observableClient = null;
    }

    protected void handleMessage(SerializableEventWrapper event) {
        if (this.observableClient.standsEventBufferActive && !this.observableClient.isMarkedForShutdown()) {
            this.observableClient.standsEventBufferLinkedList.addLast(event);
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.toString() + " - onMessage(): Event sent to buffer!"));
            }
        } else {
            try {
                this.sendMessageToClient(event);
                this.observableClient.pingThread.resetTimer();
            }
            catch (JMSException e) {
                log.error((Object)"sendMessageToClient runs into JMSException: ", (Throwable)e);
                this.informantClient.notify("handleMessage() ends in JMSException: " + (Object)((Object)e), "StandErrorEvent");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendAllStandsToClient() {
        if (AbstractStandsConnector._standsDataFactory != null) {
            try {
                log.debug((Object)"sendAllStandsToClient(): Sending all stands information to client...");
                SerializableEventWrapper eventWrapper = new SerializableEventWrapper((Serializable)AbstractStandsConnector._standsDataFactory);
                eventWrapper.set_typeOfEvent("AllStandData");
                this.sendMessageToClient(eventWrapper);
                if (this.observableClient.standsEventBufferLinkedList.size() > 0) {
                    this.observableClient.sendEventBufferToClient();
                } else {
                    this.observableClient.standsEventBufferActive = false;
                    log.debug((Object)"sendAllStandsToClient():StandsEventBuffer deactivated!");
                }
                this.observableClient.pingThread.resetTimer();
            }
            catch (JMSException e) {
                log.error((Object)"sendMessageToClient runs into JMSException: ", (Throwable)e);
                this.informantClient.notify("sendAllStandsToClient() ends in JMSException: " + (Object)((Object)e), "StandErrorEvent");
            }
        } else {
            ObservableStandsClient observableStandsClient = this;
            synchronized (observableStandsClient) {
                try {
                    log.debug((Object)"Server doesn't own any stands information. Can't send information data to client. Retrying...");
                    this.wait(3000L);
                    this.sendAllStandsToClient();
                }
                catch (InterruptedException e) {
                    log.error((Object)"sendAllStandsToClient() runs into InterruptedException: ", (Throwable)e);
                    this.informantClient.notify("sendAllStandsToClient() ends in InterruptedException: " + e, "StandErrorEvent");
                }
            }
        }
    }

    protected void sendMessageToClient(SerializableEventWrapper eventWrapper) throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"sendMessageToClient() started...");
        }
        try {
            if (eventWrapper.get_typeOfEvent().equals("AllStandData")) {
                this.observableClient.client.sendObject(this.createValueMap(eventWrapper));
                if (log.isDebugEnabled()) {
                    log.debug((Object)"sendMessageToClient(): All stand informations to client sent!");
                }
            } else if (eventWrapper.get_typeOfEvent().equals("StandEvent")) {
                Map eventMap = this.createEventMap(eventWrapper);
                if (eventMap != null) {
                    this.observableClient.client.sendObject(eventMap);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"sendMessageToClient(): One single stand event to client sent!");
                    }
                }
            } else if (eventWrapper.get_typeOfEvent().equals("StaffAllocationEvent")) {
                Map staffValueMap = (Map)eventWrapper.get_cacheValue();
                String eventType = (String)staffValueMap.get("StaffAllocationEventType");
                if (eventType == null) {
                    eventType = "";
                }
                if (eventType.equals("StaffAllocationEventUpdate")) {
                    staffValueMap.put("ServerTime", new Long(System.currentTimeMillis()));
                    staffValueMap.put("DataType", "data_type_SinglStaffAllocationEventUPDATE");
                    this.observableClient.client.sendObject(staffValueMap);
                    log.debug((Object)"sendMessageToClient(): Staff allocation event (update) to client sent!");
                } else if (eventType.equals("StaffAllocationEventDelete")) {
                    staffValueMap.put("ServerTime", new Long(System.currentTimeMillis()));
                    staffValueMap.put("DataType", "data_type_SinglStaffAllocationEventDELETE");
                    this.observableClient.client.sendObject(staffValueMap);
                    log.debug((Object)"sendMessageToClient(): Staff allocation event (delete) to client sent!");
                } else {
                    log.error((Object)("unknown staff allocation event received: '" + eventType + "'"));
                }
            } else if (eventWrapper.get_typeOfEvent().equals("GSEAllocationEvent")) {
                Map staffValueMap = (Map)eventWrapper.get_cacheValue();
                String eventType = (String)staffValueMap.get("GSEAllocationEventType");
                if (eventType == null) {
                    eventType = "";
                }
                if (eventType.equals("GSEAllocationEventUpdate")) {
                    staffValueMap.put("ServerTime", new Long(System.currentTimeMillis()));
                    staffValueMap.put("DataType", "data_type_SinglGSEAllocationEventUPDATE");
                    this.observableClient.client.sendObject(staffValueMap);
                    log.debug((Object)"sendMessageToClient(): GSE allocation event (update) to client sent!");
                } else if (eventType.equals("GSEAllocationEventDelete")) {
                    staffValueMap.put("ServerTime", new Long(System.currentTimeMillis()));
                    staffValueMap.put("DataType", "data_type_SinglGSEAllocationEventDELETE");
                    this.observableClient.client.sendObject(staffValueMap);
                    log.debug((Object)"sendMessageToClient(): GSE allocation event (delete) to client sent!");
                } else {
                    log.error((Object)("unknown GSE allocation event received: '" + eventType + "'"));
                }
            }
        }
        catch (IOException e) {
            log.debug((Object)"sendMessageToClient() runs into IOException! Probably the client was shut down. Session will be unsubscribed!");
            this.observableClient.setMarkedForShutdown(true);
        }
        catch (NullPointerException e) {
            log.debug((Object)"sendMessageToClient() runs into NullPointerException! Session will be unsubscribed!");
            this.observableClient.setMarkedForShutdown(true);
        }
        catch (Exception ex) {
            log.error((Object)"sendMessageToClient() Unkown Exception caught!!!!! Will shutdown all Client Threads as a precaution!!! See log-files for further infos!", (Throwable)ex);
            this.informantClient.notify("sendMessageToClient() " + this.toString() + " - onMessage() runs into Exception: " + ex, "StandErrorEvent");
            this.observableClient.setMarkedForShutdown(true);
        }
    }

    private Map createEventMap(SerializableEventWrapper eventWrapper) {
        Map eventMap = (Map)eventWrapper.get_cacheValue();
        eventMap.put("ServerTime", new Long(System.currentTimeMillis()));
        eventMap.put("DataType", "data_type_SingleStandEvent");
        return eventMap;
    }

    private Map createValueMap(SerializableEventWrapper eventWrapper) {
        StandsDataFactory sendingData = new StandsDataFactory();
        sendingData = (StandsDataFactory)eventWrapper.get_cacheValue();
        sendingData.addGeneralValue("ServerTime", (Object)new Long(System.currentTimeMillis()));
        sendingData.addGeneralValue("DataType", (Object)"data_type_stands");
        sendingData.updateOnOffStateOfStands();
        return sendingData.getTransferData();
    }
}

