/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataIn.observable;

import de.proveo.wwt.logic.app.security.LoginCallbackHandler;
import de.proveo.wwt.logic.servlet.dataIn.observable.client.ObservableClient;
import de.proveo.wwt.logic.servlet.dataIn.observable.client.ObservableClientFactory;
import de.proveo.wwt.logic.servlet.dataIn.observable.client.RemoteClient;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.SingleThreadModel;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObservableClientServlet
extends HttpServlet
implements SingleThreadModel {
    private static final long serialVersionUID = 6912602153837173070L;
    private static final String CONTENT_TYPE = "application/octet-stream";
    private final Log log = LogFactory.getLog(ObservableClientServlet.class);
    private boolean isRunning = true;

    public void destroy() {
        this.log.debug((Object)("destroy() is called! --> Instance: " + ((Object)((Object)this)).toString()));
        this.log.debug((Object)"Servlet instance removed.");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        String method = "doGet(): ";
        this.log.warn((Object)(method + "avoid GET, use POST instead!"));
        this.log.debug((Object)(method + "incoming GET request in instance " + ((Object)((Object)this)).toString()));
        this.createClient(request, response);
        this.log.debug((Object)(method + "GET finished fo instance " + ((Object)((Object)this)).toString()));
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        String method = "doPost(): ";
        this.log.debug((Object)(method + "incoming POST request in instance " + ((Object)((Object)this)).toString()));
        this.createClient(request, response);
        this.log.debug((Object)(method + "POST finished fo instance " + ((Object)((Object)this)).toString()));
    }

    public void init(ServletConfig config) throws ServletException {
        this.log.debug((Object)"init()");
        super.init(config);
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createClient(HttpServletRequest request, HttpServletResponse response) {
        block21: {
            String clientId = request.getParameter("clientId");
            this.isRunning = true;
            response.setContentType(CONTENT_TYPE);
            try {
                Object oldClient;
                String username = request.getParameter("username");
                String password = request.getParameter("password");
                if (username == null || password == null) {
                    this.log.warn((Object)"username or password not given");
                } else {
                    try {
                        LoginCallbackHandler cbh = new LoginCallbackHandler(username, password);
                        LoginContext lc = new LoginContext("rts", (CallbackHandler)cbh);
                        lc.login();
                    }
                    catch (LoginException e1) {
                        this.log.error((Object)("Login in ObservableClient failed: " + e1));
                    }
                }
                ServletOutputStream sos = response.getOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream((OutputStream)sos);
                this.log.debug((Object)"Streams initialized.");
                boolean newClientThread = false;
                ObservableClientFactory observerClientFactory = ObservableClientFactory.getInstance();
                newClientThread = observerClientFactory.createObserverClient(this, clientId, username, password, new RemoteClient(request, oos));
                if (!newClientThread) {
                    this.log.debug((Object)("The client with Id: " + clientId + " is already running in another Thread. Client will be replaced!!"));
                    oldClient = observerClientFactory.getObservableClient(clientId);
                    this.log.debug((Object)"Old client marked for shutdown. Will wait 5s until shutdown completed.");
                    ((ObservableClient)oldClient).setMarkedForShutdown(true);
                    try {
                        ObservableClientServlet observableClientServlet = this;
                        synchronized (observableClientServlet) {
                            ((Object)((Object)this)).wait(5000L);
                        }
                    }
                    catch (InterruptedException e) {
                        this.log.error((Object)"Interrupt while waiting for shutdown of the old client thread.", (Throwable)e);
                    }
                    this.log.debug((Object)"Waiting finished - init new client Thread.");
                    observerClientFactory.removeClient(clientId);
                    this.log.debug((Object)"Old client instance removed. Init new client thread.");
                    newClientThread = observerClientFactory.createObserverClient(this, clientId, username, password, new RemoteClient(request, oos));
                    this.log.debug((Object)("New client established? " + newClientThread));
                } else {
                    this.log.debug((Object)("ClientId " + clientId + " unknown! Will initialize new client."));
                }
                if (newClientThread) {
                    try {
                        oldClient = this;
                        synchronized (oldClient) {
                            this.log.debug((Object)("New ObservableClientServlet -> " + ((Object)((Object)this)).toString() + " with id " + clientId + " on hold."));
                            while (this.isRunning) {
                                ((Object)((Object)this)).wait(1000L);
                                ObservableClient myClient = observerClientFactory.getObservableClient(clientId);
                                if (myClient == null || !myClient.isMarkedForShutdown()) continue;
                                this.log.debug((Object)("Client: " + clientId + " is marked for shutdown!! Doing cleanup..."));
                                myClient.cleanUp();
                                observerClientFactory.removeClient(clientId);
                                this.log.debug((Object)("cleanup of client: " + clientId + " finished."));
                                this.isRunning = false;
                            }
                            this.log.debug((Object)("Endless loop in ObservableClientServlet has stopped --> ServletID: " + ((Object)((Object)this)).toString()));
                            this.log.debug((Object)"Terminating method createClient().");
                            break block21;
                        }
                    }
                    catch (InterruptedException ex) {
                        this.log.error((Object)ex);
                    }
                    break block21;
                }
                this.log.debug((Object)"Client was already known - ServletLock skipped.");
            }
            catch (IOException e) {
                this.log.error((Object)"ObserverServlet.doGet() runs into IOException", (Throwable)e);
            }
        }
    }

    public void setRunning(boolean isRunning) {
        this.isRunning = isRunning;
    }
}

