/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime.linker;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.Undefined;
import jdk.nashorn.internal.runtime.linker.Bootstrap;
import jdk.nashorn.internal.runtime.linker.JavaAdapterFactory;
import jdk.nashorn.internal.runtime.linker.JavaArgumentConverters;
import jdk.nashorn.internal.runtime.linker.Lookup;
import org.dynalang.dynalink.CallSiteDescriptor;
import org.dynalang.dynalink.linker.ConversionComparator;
import org.dynalang.dynalink.linker.GuardedInvocation;
import org.dynalang.dynalink.linker.GuardingTypeConverterFactory;
import org.dynalang.dynalink.linker.LinkRequest;
import org.dynalang.dynalink.linker.LinkerServices;
import org.dynalang.dynalink.linker.TypeBasedGuardingDynamicLinker;
import org.dynalang.dynalink.support.Guards;

public class NashornLinker
implements TypeBasedGuardingDynamicLinker,
GuardingTypeConverterFactory,
ConversionComparator {
    private static final MethodHandle IS_SCRIPT_FUNCTION = Guards.isInstance(ScriptFunction.class, (MethodType)Lookup.MH.type(Boolean.TYPE, Object.class));
    private static final MethodHandle IS_NASHORN_OR_UNDEFINED_TYPE = NashornLinker.findOwnMH("isNashornTypeOrUndefined", Boolean.TYPE, Object.class);

    public boolean canLinkType(Class<?> type) {
        return NashornLinker.canLinkTypeStatic(type);
    }

    static boolean canLinkTypeStatic(Class<?> type) {
        return ScriptObject.class.isAssignableFrom(type) || Undefined.class == type;
    }

    public GuardedInvocation getGuardedInvocation(LinkRequest request, LinkerServices linkerServices) throws Exception {
        GuardedInvocation inv;
        LinkRequest requestWithoutContext = request.withoutRuntimeContext();
        Object self = requestWithoutContext.getReceiver();
        CallSiteDescriptor desc = requestWithoutContext.getCallSiteDescriptor();
        if (desc.getNameTokenCount() < 2 || !"dyn".equals(desc.getNameToken(0))) {
            return null;
        }
        if (self instanceof ScriptObject) {
            inv = ((ScriptObject)self).lookup(desc, request);
        } else if (self instanceof Undefined) {
            inv = Undefined.lookup(desc);
        } else {
            throw new AssertionError();
        }
        return Bootstrap.asType(inv, linkerServices, desc);
    }

    public GuardedInvocation convertToType(Class<?> sourceType, Class<?> targetType) throws Exception {
        GuardedInvocation gi = NashornLinker.convertToTypeNoCast(sourceType, targetType);
        return gi == null ? null : gi.asType(Lookup.MH.type(targetType, sourceType));
    }

    private static GuardedInvocation convertToTypeNoCast(Class<?> sourceType, Class<?> targetType) throws Exception {
        MethodHandle mh = JavaArgumentConverters.getConverter(targetType);
        if (mh != null) {
            return new GuardedInvocation(mh, NashornLinker.canLinkTypeStatic(sourceType) ? null : IS_NASHORN_OR_UNDEFINED_TYPE);
        }
        return NashornLinker.getSamTypeConverter(sourceType, targetType);
    }

    private static GuardedInvocation getSamTypeConverter(Class<?> sourceType, Class<?> targetType) throws Exception {
        boolean isSourceTypeGeneric = sourceType.isAssignableFrom(ScriptFunction.class);
        if ((isSourceTypeGeneric || ScriptFunction.class.isAssignableFrom(sourceType)) && NashornLinker.isAutoConvertibleFromFunction(targetType)) {
            MethodHandle ctor = JavaAdapterFactory.getConstructor(ScriptFunction.class, targetType);
            assert (ctor != null);
            return new GuardedInvocation(ctor, isSourceTypeGeneric ? IS_SCRIPT_FUNCTION : null);
        }
        return null;
    }

    private static boolean isAutoConvertibleFromFunction(Class<?> clazz) {
        return JavaAdapterFactory.isAbstractClass(clazz) && !ScriptObject.class.isAssignableFrom(clazz) && JavaAdapterFactory.isAutoConvertibleFromFunction(clazz);
    }

    public ConversionComparator.Comparison compareConversion(Class<?> sourceType, Class<?> targetType1, Class<?> targetType2) {
        if (ScriptObject.class.isAssignableFrom(sourceType)) {
            if (targetType1.isInterface()) {
                if (!targetType2.isInterface()) {
                    return ConversionComparator.Comparison.TYPE_1_BETTER;
                }
            } else if (targetType2.isInterface()) {
                return ConversionComparator.Comparison.TYPE_2_BETTER;
            }
        }
        return ConversionComparator.Comparison.INDETERMINATE;
    }

    private static boolean isNashornTypeOrUndefined(Object obj) {
        return obj instanceof ScriptObject || obj instanceof Undefined;
    }

    private static MethodHandle findOwnMH(String name, Class<?> rtype, Class<?> ... types) {
        return Lookup.MH.findStatic(MethodHandles.lookup(), NashornLinker.class, name, Lookup.MH.type(rtype, types));
    }
}

