/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime.linker;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.SwitchPoint;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import jdk.nashorn.internal.runtime.ConsString;
import jdk.nashorn.internal.runtime.Debug;
import jdk.nashorn.internal.runtime.DebugLogger;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.linker.MethodHandleFunctionality;
import jdk.nashorn.internal.runtime.options.Options;

public final class MethodHandleFactory {
    private static final MethodHandles.Lookup PUBLIC_LOOKUP = MethodHandles.publicLookup();
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final Level TRACE_LEVEL = Level.INFO;
    private static final MethodHandleFunctionality STANDARD = new StandardMethodHandleFunctionality();
    private static final MethodHandleFunctionality FUNC;
    private static final String DEBUG_PROPERTY = "nashorn.methodhandles.debug";
    private static final DebugLogger LOG;
    private static final boolean PRINT_STACKTRACE;
    private static final MethodHandle TRACE;
    private static final MethodHandle TRACE_RETURN;

    private MethodHandleFactory() {
    }

    public static String stripName(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof Class) {
            return ((Class)obj).getSimpleName();
        }
        return obj.toString();
    }

    public static MethodHandleFunctionality getFunctionality() {
        return FUNC;
    }

    static Object traceReturn(DebugLogger logger, Object value) {
        String str = "\treturn: " + MethodHandleFactory.stripName(value) + " [type=" + (value == null ? "null" : MethodHandleFactory.stripName(value.getClass()) + ']');
        logger.log(str, TRACE_LEVEL);
        return value;
    }

    static void traceArgs(DebugLogger logger, String tag, int paramStart, Object ... args) {
        StringBuilder sb = new StringBuilder();
        sb.append(tag);
        for (int i = paramStart; i < args.length; ++i) {
            if (i == paramStart) {
                sb.append(" => args: ");
            }
            sb.append('\'').append(MethodHandleFactory.stripName(MethodHandleFactory.argString(args[i]))).append('\'').append(' ').append('[').append("type=").append(args[i] == null ? "null" : MethodHandleFactory.stripName(args[i].getClass())).append(']');
            if (i + 1 >= args.length) continue;
            sb.append(", ");
        }
        assert (logger != null);
        logger.log(sb.toString(), TRACE_LEVEL);
        MethodHandleFactory.stacktrace(logger);
    }

    private static void stacktrace(DebugLogger logger) {
        if (!PRINT_STACKTRACE) {
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        new Throwable().printStackTrace(ps);
        logger.log(baos.toString(), TRACE_LEVEL);
    }

    private static String argString(Object arg) {
        if (arg == null) {
            return "null";
        }
        if (arg.getClass().isArray()) {
            ArrayList<String> list = new ArrayList<String>();
            for (Object elem : (Object[])arg) {
                list.add('\'' + MethodHandleFactory.argString(elem) + '\'');
            }
            return ((Object)list).toString();
        }
        if (arg instanceof ScriptObject) {
            return arg.toString() + " (map=" + Debug.id(((ScriptObject)arg).getMap()) + ")";
        }
        return arg.toString();
    }

    public static MethodHandle addDebugPrintout(DebugLogger logger, MethodHandle mh, Object tag) {
        return MethodHandleFactory.addDebugPrintout(logger, mh, 0, true, tag);
    }

    public static MethodHandle addDebugPrintout(DebugLogger logger, MethodHandle mh, int paramStart, boolean printReturnValue, Object tag) {
        MethodType type = mh.type();
        if (logger != null && logger.levelAbove(TRACE_LEVEL)) {
            return mh;
        }
        assert (logger != null);
        assert (TRACE != null);
        MethodHandle trace = MethodHandles.insertArguments(TRACE, 0, logger, tag, paramStart);
        trace = MethodHandles.foldArguments(mh, trace.asCollector(Object[].class, type.parameterCount()).asType(type.changeReturnType(Void.TYPE)));
        TypeDescriptor.OfField retType = type.returnType();
        if (retType != Void.TYPE && printReturnValue) {
            MethodHandle traceReturn = MethodHandles.insertArguments(TRACE_RETURN, 0, logger);
            trace = MethodHandles.filterReturnValue(trace, traceReturn.asType(traceReturn.type().changeParameterType(0, (Class<?>)retType).changeReturnType((Class<?>)retType)));
        }
        return trace;
    }

    static {
        LOG = new DebugLogger("methodhandles", DEBUG_PROPERTY);
        FUNC = LOG.isEnabled() || Options.getBooleanProperty(DEBUG_PROPERTY) ? (Options.getStringProperty(DEBUG_PROPERTY, "").equals("create") ? new TraceCreateMethodHandleFunctionality() : new TraceMethodHandleFunctionality()) : STANDARD;
        PRINT_STACKTRACE = Options.getBooleanProperty("nashorn.methodhandles.debug.stacktrace");
        TRACE = STANDARD.findStatic(LOOKUP, MethodHandleFactory.class, "traceArgs", MethodType.methodType(Void.TYPE, DebugLogger.class, String.class, Integer.TYPE, Object[].class));
        TRACE_RETURN = STANDARD.findStatic(LOOKUP, MethodHandleFactory.class, "traceReturn", MethodType.methodType(Object.class, DebugLogger.class, Object.class));
    }

    public static class LookupException
    extends RuntimeException {
        public LookupException(Exception e) {
            super(e);
        }
    }

    private static class StandardMethodHandleFunctionality
    implements MethodHandleFunctionality {
        private StandardMethodHandleFunctionality() {
        }

        @Override
        public MethodHandle filterArguments(MethodHandle target, int pos, MethodHandle ... filters) {
            return MethodHandles.filterArguments(target, pos, filters);
        }

        @Override
        public MethodHandle filterReturnValue(MethodHandle target, MethodHandle filter) {
            return MethodHandles.filterReturnValue(target, filter);
        }

        @Override
        public MethodHandle guardWithTest(MethodHandle test, MethodHandle target, MethodHandle fallback) {
            return MethodHandles.guardWithTest(test, target, fallback);
        }

        @Override
        public MethodHandle insertArguments(MethodHandle target, int pos, Object ... values) {
            return MethodHandles.insertArguments(target, pos, values);
        }

        @Override
        public MethodHandle dropArguments(MethodHandle target, int pos, Class<?> ... valueTypes) {
            return MethodHandles.dropArguments(target, pos, valueTypes);
        }

        @Override
        public MethodHandle dropArguments(MethodHandle target, int pos, List<Class<?>> valueTypes) {
            return MethodHandles.dropArguments(target, pos, valueTypes);
        }

        @Override
        public MethodHandle asType(MethodHandle handle, MethodType type) {
            return handle.asType(type);
        }

        @Override
        public MethodHandle bindTo(MethodHandle handle, Object x) {
            return handle.bindTo(x);
        }

        @Override
        public MethodHandle foldArguments(MethodHandle target, MethodHandle combiner) {
            return MethodHandles.foldArguments(target, combiner);
        }

        @Override
        public MethodHandle explicitCastArguments(MethodHandle target, MethodType type) {
            return MethodHandles.explicitCastArguments(target, type);
        }

        @Override
        public MethodHandle arrayElementGetter(Class<?> type) {
            return MethodHandles.arrayElementGetter(type);
        }

        @Override
        public MethodHandle arrayElementSetter(Class<?> type) {
            return MethodHandles.arrayElementSetter(type);
        }

        @Override
        public MethodHandle throwException(Class<?> returnType, Class<? extends Throwable> exType) {
            return MethodHandles.throwException(returnType, exType);
        }

        @Override
        public MethodHandle constant(Class<?> type, Object value) {
            return MethodHandles.constant(type, value);
        }

        @Override
        public MethodHandle asCollector(MethodHandle handle, Class<?> arrayType, int arrayLength) {
            return handle.asCollector(arrayType, arrayLength);
        }

        @Override
        public MethodHandle asSpreader(MethodHandle handle, Class<?> arrayType, int arrayLength) {
            return handle.asSpreader(arrayType, arrayLength);
        }

        @Override
        public MethodHandle getter(MethodHandles.Lookup explicitLookup, Class<?> clazz, String name, Class<?> type) {
            try {
                return explicitLookup.findGetter(clazz, name, type);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new LookupException(e);
            }
        }

        @Override
        public MethodHandle staticGetter(MethodHandles.Lookup explicitLookup, Class<?> clazz, String name, Class<?> type) {
            try {
                return explicitLookup.findStaticGetter(clazz, name, type);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new LookupException(e);
            }
        }

        @Override
        public MethodHandle setter(MethodHandles.Lookup explicitLookup, Class<?> clazz, String name, Class<?> type) {
            try {
                return explicitLookup.findSetter(clazz, name, type);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new LookupException(e);
            }
        }

        @Override
        public MethodHandle staticSetter(MethodHandles.Lookup explicitLookup, Class<?> clazz, String name, Class<?> type) {
            try {
                return explicitLookup.findStaticSetter(clazz, name, type);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new LookupException(e);
            }
        }

        @Override
        public MethodHandle find(Method method) {
            try {
                return PUBLIC_LOOKUP.unreflect(method);
            }
            catch (IllegalAccessException e) {
                throw new LookupException(e);
            }
        }

        @Override
        public MethodHandle findStatic(MethodHandles.Lookup explicitLookup, Class<?> clazz, String name, MethodType type) {
            try {
                return explicitLookup.findStatic(clazz, name, type);
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new LookupException(e);
            }
        }

        @Override
        public MethodHandle findVirtual(MethodHandles.Lookup explicitLookup, Class<?> clazz, String name, MethodType type) {
            try {
                return explicitLookup.findVirtual(clazz, name, type);
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new LookupException(e);
            }
        }

        @Override
        public SwitchPoint createSwitchPoint() {
            return new SwitchPoint();
        }

        @Override
        public MethodHandle guardWithTest(SwitchPoint sp, MethodHandle before, MethodHandle after) {
            return sp.guardWithTest(before, after);
        }

        @Override
        public MethodType type(Class<?> returnType, Class<?> ... paramTypes) {
            return MethodType.methodType(returnType, paramTypes);
        }
    }

    private static class TraceCreateMethodHandleFunctionality
    extends TraceMethodHandleFunctionality {
        private TraceCreateMethodHandleFunctionality() {
        }

        @Override
        public MethodHandle debug(MethodHandle master, String str, Object ... args) {
            LOG.log(str + ' ' + TraceCreateMethodHandleFunctionality.describe(args), TRACE_LEVEL);
            MethodHandleFactory.stacktrace(LOG);
            return master;
        }
    }

    private static class TraceMethodHandleFunctionality
    extends StandardMethodHandleFunctionality {
        private TraceMethodHandleFunctionality() {
        }

        protected static String describe(Object ... data) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < data.length; ++i) {
                Object d = data[i];
                if (d == null) {
                    sb.append("<null> ");
                } else if (d instanceof String || d instanceof ConsString) {
                    sb.append(d.toString());
                    sb.append(' ');
                } else if (d.getClass().isArray()) {
                    sb.append("[ ");
                    for (Object da : (Object[])d) {
                        sb.append(TraceMethodHandleFunctionality.describe(da)).append(' ');
                    }
                    sb.append("] ");
                } else {
                    sb.append(d).append('{').append(Integer.toHexString(System.identityHashCode(d))).append('}');
                }
                if (i + 1 >= data.length) continue;
                sb.append(", ");
            }
            return sb.toString();
        }

        public MethodHandle debug(MethodHandle master, String str, Object ... args) {
            return MethodHandleFactory.addDebugPrintout(LOG, master, Integer.MAX_VALUE, false, str + ' ' + TraceMethodHandleFunctionality.describe(args));
        }

        @Override
        public MethodHandle filterArguments(MethodHandle target, int pos, MethodHandle ... filters) {
            MethodHandle mh = super.filterArguments(target, pos, filters);
            return this.debug(mh, "filterArguments", target, pos, filters);
        }

        @Override
        public MethodHandle filterReturnValue(MethodHandle target, MethodHandle filter) {
            MethodHandle mh = super.filterReturnValue(target, filter);
            return this.debug(mh, "filterReturnValue", target, filter);
        }

        @Override
        public MethodHandle guardWithTest(MethodHandle test, MethodHandle target, MethodHandle fallback) {
            MethodHandle mh = super.guardWithTest(test, target, fallback);
            return this.debug(mh, "guardWithTest", test, target, fallback);
        }

        @Override
        public MethodHandle insertArguments(MethodHandle target, int pos, Object ... values) {
            MethodHandle mh = super.insertArguments(target, pos, values);
            return this.debug(mh, "insertArguments", target, pos, values);
        }

        @Override
        public MethodHandle dropArguments(MethodHandle target, int pos, Class<?> ... values) {
            MethodHandle mh = super.dropArguments(target, pos, values);
            return this.debug(mh, "dropArguments", target, pos, values);
        }

        @Override
        public MethodHandle dropArguments(MethodHandle target, int pos, List<Class<?>> values) {
            MethodHandle mh = super.dropArguments(target, pos, values);
            return this.debug(mh, "dropArguments", target, pos, values);
        }

        @Override
        public MethodHandle asType(MethodHandle handle, MethodType type) {
            MethodHandle mh = super.asType(handle, type);
            return this.debug(mh, "asType", handle, type);
        }

        @Override
        public MethodHandle bindTo(MethodHandle handle, Object x) {
            MethodHandle mh = super.bindTo(handle, x);
            return this.debug(mh, "bindTo", handle, x);
        }

        @Override
        public MethodHandle foldArguments(MethodHandle target, MethodHandle combiner) {
            MethodHandle mh = super.foldArguments(target, combiner);
            return this.debug(mh, "foldArguments", target, combiner);
        }

        @Override
        public MethodHandle explicitCastArguments(MethodHandle target, MethodType type) {
            MethodHandle mh = super.explicitCastArguments(target, type);
            return this.debug(mh, "explicitCastArguments", target, type);
        }

        @Override
        public MethodHandle arrayElementGetter(Class<?> type) {
            MethodHandle mh = super.arrayElementGetter(type);
            return this.debug(mh, "arrayElementGetter", type);
        }

        @Override
        public MethodHandle arrayElementSetter(Class<?> type) {
            MethodHandle mh = super.arrayElementSetter(type);
            return this.debug(mh, "arrayElementSetter", type);
        }

        @Override
        public MethodHandle throwException(Class<?> returnType, Class<? extends Throwable> exType) {
            MethodHandle mh = super.throwException(returnType, exType);
            return this.debug(mh, "throwException", returnType, exType);
        }

        @Override
        public MethodHandle constant(Class<?> type, Object value) {
            MethodHandle mh = super.constant(type, value);
            return this.debug(mh, "constant", type, value);
        }

        @Override
        public MethodHandle asCollector(MethodHandle handle, Class<?> arrayType, int arrayLength) {
            MethodHandle mh = super.asCollector(handle, arrayType, arrayLength);
            return this.debug(mh, "asCollector", handle, arrayType, arrayLength);
        }

        @Override
        public MethodHandle asSpreader(MethodHandle handle, Class<?> arrayType, int arrayLength) {
            MethodHandle mh = super.asCollector(handle, arrayType, arrayLength);
            return this.debug(mh, "asSpreader", handle, arrayType, arrayLength);
        }

        @Override
        public MethodHandle getter(MethodHandles.Lookup explicitLookup, Class<?> clazz, String name, Class<?> type) {
            MethodHandle mh = super.getter(explicitLookup, clazz, name, type);
            return this.debug(mh, "getter", explicitLookup, clazz, name, type);
        }

        @Override
        public MethodHandle staticGetter(MethodHandles.Lookup explicitLookup, Class<?> clazz, String name, Class<?> type) {
            MethodHandle mh = super.staticGetter(explicitLookup, clazz, name, type);
            return this.debug(mh, "static getter", explicitLookup, clazz, name, type);
        }

        @Override
        public MethodHandle setter(MethodHandles.Lookup explicitLookup, Class<?> clazz, String name, Class<?> type) {
            MethodHandle mh = super.setter(explicitLookup, clazz, name, type);
            return this.debug(mh, "setter", explicitLookup, clazz, name, type);
        }

        @Override
        public MethodHandle staticSetter(MethodHandles.Lookup explicitLookup, Class<?> clazz, String name, Class<?> type) {
            MethodHandle mh = super.staticSetter(explicitLookup, clazz, name, type);
            return this.debug(mh, "static setter", explicitLookup, clazz, name, type);
        }

        @Override
        public MethodHandle find(Method method) {
            MethodHandle mh = super.find(method);
            return this.debug(mh, "find", method);
        }

        @Override
        public MethodHandle findStatic(MethodHandles.Lookup explicitLookup, Class<?> clazz, String name, MethodType type) {
            MethodHandle mh = super.findStatic(explicitLookup, clazz, name, type);
            return this.debug(mh, "findStatic", explicitLookup, clazz, name, type);
        }

        @Override
        public MethodHandle findVirtual(MethodHandles.Lookup explicitLookup, Class<?> clazz, String name, MethodType type) {
            MethodHandle mh = super.findVirtual(explicitLookup, clazz, name, type);
            return this.debug(mh, "findVirtual", explicitLookup, clazz, name, type);
        }

        @Override
        public SwitchPoint createSwitchPoint() {
            SwitchPoint sp = super.createSwitchPoint();
            LOG.log("createSwitchPoint " + sp, TRACE_LEVEL);
            return sp;
        }

        @Override
        public MethodHandle guardWithTest(SwitchPoint sp, MethodHandle before, MethodHandle after) {
            MethodHandle mh = super.guardWithTest(sp, before, after);
            return this.debug(mh, "guardWithTest", sp, before, after);
        }

        @Override
        public MethodType type(Class<?> returnType, Class<?> ... paramTypes) {
            MethodType mt = super.type(returnType, paramTypes);
            LOG.log("methodType " + returnType + ' ' + Arrays.toString(paramTypes) + ' ' + mt, TRACE_LEVEL);
            return mt;
        }
    }
}

