/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime.linker;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.SecureClassLoader;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.ECMAErrors;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.Undefined;
import jdk.nashorn.internal.runtime.linker.Bootstrap;
import jdk.nashorn.internal.runtime.linker.Lookup;
import jdk.nashorn.internal.runtime.linker.NashornCallSiteDescriptor;
import org.dynalang.dynalink.CallSiteDescriptor;
import org.dynalang.dynalink.beans.StaticClass;
import org.dynalang.dynalink.linker.LinkRequest;
import org.dynalang.dynalink.support.LinkRequestImpl;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.InstructionAdapter;

public final class JavaAdapterFactory {
    private static final Type SCRIPT_FUNCTION_TYPE = Type.getType(ScriptFunction.class);
    private static final Type SCRIPT_OBJECT_TYPE = Type.getType(ScriptObject.class);
    private static final Type OBJECT_TYPE = Type.getType(Object.class);
    private static final Type STRING_TYPE = Type.getType(String.class);
    private static final Type CONTEXT_TYPE = Type.getType(Context.class);
    private static final Type METHOD_TYPE_TYPE = Type.getType(MethodType.class);
    private static final Type METHOD_HANDLE_TYPE = Type.getType(MethodHandle.class);
    private static final String GET_HANDLE_OBJECT_DESCRIPTOR = Type.getMethodDescriptor((Type)METHOD_HANDLE_TYPE, (Type[])new Type[]{OBJECT_TYPE, STRING_TYPE, METHOD_TYPE_TYPE, Type.BOOLEAN_TYPE});
    private static final String GET_HANDLE_FUNCTION_DESCRIPTOR = Type.getMethodDescriptor((Type)METHOD_HANDLE_TYPE, (Type[])new Type[]{SCRIPT_FUNCTION_TYPE, METHOD_TYPE_TYPE, Type.BOOLEAN_TYPE});
    private static final Type RUNTIME_EXCEPTION_TYPE = Type.getType(RuntimeException.class);
    private static final Type THROWABLE_TYPE = Type.getType(Throwable.class);
    private static final Type PRIVILEGED_ACTION_TYPE = Type.getType(PrivilegedAction.class);
    private static final Type UNSUPPORTED_OPERATION_TYPE = Type.getType(UnsupportedOperationException.class);
    private static final String THIS_CLASS_TYPE_NAME = Type.getInternalName(JavaAdapterFactory.class);
    private static final String RUNTIME_EXCEPTION_TYPE_NAME = RUNTIME_EXCEPTION_TYPE.getInternalName();
    private static final String ERROR_TYPE_NAME = Type.getInternalName(Error.class);
    private static final String THROWABLE_TYPE_NAME = THROWABLE_TYPE.getInternalName();
    private static final String CONTEXT_TYPE_NAME = CONTEXT_TYPE.getInternalName();
    private static final String OBJECT_TYPE_NAME = OBJECT_TYPE.getInternalName();
    private static final String PRIVILEGED_ACTION_TYPE_NAME = PRIVILEGED_ACTION_TYPE.getInternalName();
    private static final String UNSUPPORTED_OPERATION_TYPE_NAME = UNSUPPORTED_OPERATION_TYPE.getInternalName();
    private static final String METHOD_HANDLE_TYPE_DESCRIPTOR = METHOD_HANDLE_TYPE.getDescriptor();
    private static final String SCRIPT_OBJECT_TYPE_DESCRIPTOR = SCRIPT_OBJECT_TYPE.getDescriptor();
    private static final String GET_GLOBAL_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)SCRIPT_OBJECT_TYPE, (Type[])new Type[0]);
    private static final String SET_GLOBAL_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{SCRIPT_OBJECT_TYPE});
    private static final String GET_CLASS_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)Type.getType(Class.class), (Type[])new Type[0]);
    private static final String PRIVILEGED_RUN_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)OBJECT_TYPE, (Type[])new Type[0]);
    private static final String ADAPTER_PACKAGE_PREFIX = "jdk/nashorn/internal/javaadapters/";
    private static final String ADAPTER_CLASS_NAME_SUFFIX = "$$NashornJavaAdapter";
    private static final String JAVA_PACKAGE_PREFIX = "java/";
    private static final int MAX_GENERATED_TYPE_NAME_LENGTH = 238;
    private static final String INIT = "<init>";
    private static final String VOID_NOARG = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]);
    private static final String GLOBAL_FIELD_NAME = "global";
    private static final Collection<MethodInfo> EXCLUDED = JavaAdapterFactory.getExcludedMethods();
    private static final ClassValue<Map<List<Class<?>>, AdapterInfo>> ADAPTER_INFO_MAPS = new ClassValue<Map<List<Class<?>>, AdapterInfo>>(){

        @Override
        protected Map<List<Class<?>>, AdapterInfo> computeValue(Class<?> type) {
            return new HashMap();
        }
    };
    private static final Random random = new SecureRandom();
    private static final ProtectionDomain GENERATED_PROTECTION_DOMAIN = JavaAdapterFactory.createGeneratedProtectionDomain();
    private final Class<?> superClass;
    private final ClassLoader commonLoader;
    private final String superClassName;
    private final String generatedClassName;
    private final String globalSetterClassName;
    private final Set<String> usedFieldNames = new HashSet<String>();
    private final Set<String> abstractMethodNames = new HashSet<String>();
    private final String samName;
    private final Set<MethodInfo> finalMethods = new HashSet<MethodInfo>(EXCLUDED);
    private final Set<MethodInfo> methodInfos = new HashSet<MethodInfo>();
    private boolean autoConvertibleFromFunction = false;
    private final ClassWriter cw;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JavaAdapterFactory(Class<?> superType, List<Class<?>> interfaces, ClassAndLoader definingClassAndLoader) throws AdaptationException {
        long l;
        assert (superType != null && !superType.isInterface());
        assert (interfaces != null);
        assert (definingClassAndLoader != null);
        this.superClass = superType;
        this.commonLoader = JavaAdapterFactory.findCommonLoader(definingClassAndLoader);
        this.cw = new ClassWriter(3){

            protected String getCommonSuperClass(String type1, String type2) {
                return JavaAdapterFactory.this.getCommonSuperClass(type1, type2);
            }
        };
        this.superClassName = Type.getInternalName(superType);
        this.generatedClassName = JavaAdapterFactory.getGeneratedClassName(superType, interfaces);
        Random random = JavaAdapterFactory.random;
        synchronized (random) {
            l = JavaAdapterFactory.random.nextLong();
        }
        this.globalSetterClassName = this.generatedClassName.concat("$" + Long.toHexString(l & Long.MAX_VALUE));
        this.cw.visit(51, 49, this.generatedClassName, null, this.superClassName, JavaAdapterFactory.getInternalTypeNames(interfaces));
        this.cw.visitField(18, GLOBAL_FIELD_NAME, SCRIPT_OBJECT_TYPE_DESCRIPTOR, null, null).visitEnd();
        this.usedFieldNames.add(GLOBAL_FIELD_NAME);
        this.gatherMethods(superType);
        this.gatherMethods(interfaces);
        this.samName = this.abstractMethodNames.size() == 1 ? this.abstractMethodNames.iterator().next() : null;
        this.generateFields();
        this.generateConstructors();
        this.generateMethods();
        this.cw.visitEnd();
    }

    private static String getGeneratedClassName(Class<?> superType, List<Class<?>> interfaces) {
        Class<?> namingType = superType == Object.class ? (interfaces.isEmpty() ? Object.class : interfaces.get(0)) : superType;
        Package pkg = namingType.getPackage();
        String namingTypeName = Type.getInternalName(namingType);
        StringBuilder buf = new StringBuilder();
        if (namingTypeName.startsWith(JAVA_PACKAGE_PREFIX) || pkg == null || pkg.isSealed()) {
            buf.append(ADAPTER_PACKAGE_PREFIX).append(namingTypeName);
        } else {
            buf.append(namingTypeName).append(ADAPTER_CLASS_NAME_SUFFIX);
        }
        Iterator<Class<?>> it = interfaces.iterator();
        if (superType == Object.class && it.hasNext()) {
            it.next();
        }
        while (it.hasNext()) {
            buf.append("$$").append(it.next().getSimpleName());
        }
        return buf.toString().substring(0, Math.min(238, buf.length()));
    }

    private static String[] getInternalTypeNames(List<Class<?>> classes) {
        int interfaceCount = classes.size();
        String[] interfaceNames = new String[interfaceCount];
        for (int i = 0; i < interfaceCount; ++i) {
            interfaceNames[i] = Type.getInternalName(classes.get(i));
        }
        return interfaceNames;
    }

    static boolean isAbstractClass(Class<?> clazz) {
        return Modifier.isAbstract(clazz.getModifiers()) && !clazz.isArray();
    }

    public static StaticClass getAdapterClassFor(Class<?>[] types) {
        assert (types != null && types.length > 0);
        AdapterInfo adapterInfo = JavaAdapterFactory.getAdapterInfo(types);
        StaticClass clazz = adapterInfo.adapterClass;
        if (clazz != null) {
            return clazz;
        }
        adapterInfo.adaptationOutcome.typeError();
        throw new AssertionError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AdapterInfo getAdapterInfo(Class<?>[] types) {
        AdapterInfo adapterInfo;
        ClassAndLoader definingClassAndLoader = JavaAdapterFactory.getDefiningClassAndLoader(types);
        Map<List<Class<?>>, AdapterInfo> adapterInfoMap = ADAPTER_INFO_MAPS.get(definingClassAndLoader.clazz);
        List<Object> typeList = types.length == 1 ? JavaAdapterFactory.getSingletonClassList(types[0]) : Arrays.asList((Object[])types.clone());
        Map<List<Class<?>>, AdapterInfo> map = adapterInfoMap;
        synchronized (map) {
            adapterInfo = adapterInfoMap.get(typeList);
            if (adapterInfo == null) {
                adapterInfo = JavaAdapterFactory.createAdapterInfo(types, definingClassAndLoader);
                adapterInfoMap.put(typeList, adapterInfo);
            }
        }
        return adapterInfo;
    }

    private static List<Class<?>> getSingletonClassList(Class<?> clazz) {
        return Collections.singletonList(clazz);
    }

    static boolean isAutoConvertibleFromFunction(Class<?> clazz) {
        return JavaAdapterFactory.getAdapterInfo(new Class[]{clazz}).autoConvertibleFromFunction;
    }

    public static MethodHandle getConstructor(Class<?> sourceType, Class<?> targetType) throws Exception {
        StaticClass adapterClass = JavaAdapterFactory.getAdapterClassFor(new Class[]{targetType});
        return Lookup.MH.bindTo(Bootstrap.getLinkerServices().getGuardedInvocation((LinkRequest)new LinkRequestImpl((CallSiteDescriptor)NashornCallSiteDescriptor.get("dyn:new", MethodType.methodType(targetType, StaticClass.class, sourceType), 0), false, new Object[]{adapterClass, null})).getInvocation(), adapterClass);
    }

    private Class<?> generateClass() {
        String binaryName = this.generatedClassName.replace('/', '.');
        try {
            return Class.forName(binaryName, true, JavaAdapterFactory.createClassLoader(this.commonLoader, binaryName, this.cw.toByteArray(), this.globalSetterClassName.replace('/', '.')));
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static boolean isAdapterClass(Class<?> clazz) {
        return clazz.getClassLoader() instanceof AdapterLoader;
    }

    private static ClassLoader createClassLoader(ClassLoader parentLoader, final String className, final byte[] classBytes, final String privilegedActionClassName) {
        return new AdapterLoader(parentLoader){

            @Override
            protected Class<?> findClass(String name) throws ClassNotFoundException {
                if (name.equals(className)) {
                    byte[] bytes = classBytes;
                    return this.defineClass(name, bytes, 0, bytes.length, GENERATED_PROTECTION_DOMAIN);
                }
                if (name.equals(privilegedActionClassName)) {
                    byte[] bytes = JavaAdapterFactory.generatePrivilegedActionClassBytes(privilegedActionClassName.replace('.', '/'));
                    return this.defineClass(name, bytes, 0, bytes.length, this.getClass().getProtectionDomain());
                }
                throw new ClassNotFoundException(name);
            }
        };
    }

    private static byte[] generatePrivilegedActionClassBytes(String className) {
        ClassWriter w = new ClassWriter(3);
        w.visit(51, 48, className, null, OBJECT_TYPE_NAME, new String[]{PRIVILEGED_ACTION_TYPE_NAME});
        w.visitField(18, GLOBAL_FIELD_NAME, SCRIPT_OBJECT_TYPE_DESCRIPTOR, null, null).visitEnd();
        InstructionAdapter mv = new InstructionAdapter(w.visitMethod(2, INIT, SET_GLOBAL_METHOD_DESCRIPTOR, null, new String[0]));
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.invokespecial(OBJECT_TYPE_NAME, INIT, VOID_NOARG);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.putfield(className, GLOBAL_FIELD_NAME, SCRIPT_OBJECT_TYPE_DESCRIPTOR);
        mv.visitInsn(177);
        mv.visitEnd();
        mv.visitMaxs(0, 0);
        mv = new InstructionAdapter(w.visitMethod(1, "run", PRIVILEGED_RUN_METHOD_DESCRIPTOR, null, new String[0]));
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.getfield(className, GLOBAL_FIELD_NAME, SCRIPT_OBJECT_TYPE_DESCRIPTOR);
        mv.invokestatic(CONTEXT_TYPE_NAME, "setGlobal", SET_GLOBAL_METHOD_DESCRIPTOR);
        mv.visitInsn(1);
        mv.visitInsn(176);
        mv.visitEnd();
        mv.visitMaxs(0, 0);
        mv = new InstructionAdapter(w.visitMethod(8, "setGlobal", SET_GLOBAL_METHOD_DESCRIPTOR, null, new String[0]));
        mv.visitCode();
        mv.anew(Type.getType((String)("L" + className + ";")));
        mv.dup();
        mv.visitVarInsn(25, 0);
        mv.invokespecial(className, INIT, SET_GLOBAL_METHOD_DESCRIPTOR);
        mv.invokestatic(Type.getInternalName(AccessController.class), "doPrivileged", Type.getMethodDescriptor((Type)OBJECT_TYPE, (Type[])new Type[]{PRIVILEGED_ACTION_TYPE}));
        mv.pop();
        mv.visitInsn(177);
        mv.visitEnd();
        mv.visitMaxs(0, 0);
        return w.toByteArray();
    }

    private void generateFields() {
        for (MethodInfo mi : this.methodInfos) {
            this.cw.visitField(18, mi.methodHandleFieldName, METHOD_HANDLE_TYPE_DESCRIPTOR, null, null).visitEnd();
        }
    }

    private void generateConstructors() throws AdaptationException {
        boolean gotCtor = false;
        for (Constructor<?> ctor : this.superClass.getDeclaredConstructors()) {
            int modifier = ctor.getModifiers();
            if ((modifier & 5) == 0) continue;
            this.generateConstructor(ctor);
            gotCtor = true;
        }
        if (!gotCtor) {
            throw new AdaptationException(AdaptationOutcome.ERROR_NO_ACCESSIBLE_CONSTRUCTOR, this.superClass.getCanonicalName());
        }
    }

    boolean isAutoConvertibleFromFunction() {
        return this.autoConvertibleFromFunction;
    }

    private void generateConstructor(Constructor<?> ctor) {
        this.generateConstructor(ctor, false);
        if (this.samName != null) {
            if (!this.autoConvertibleFromFunction && ctor.getParameterTypes().length == 0) {
                this.autoConvertibleFromFunction = true;
            }
            this.generateConstructor(ctor, true);
        }
    }

    private void generateConstructor(Constructor<?> ctor, boolean fromFunction) {
        Type extraArgumentType;
        Type originalCtorType = Type.getType(ctor);
        Type[] originalArgTypes = originalCtorType.getArgumentTypes();
        int argLen = originalArgTypes.length;
        Type[] newArgTypes = new Type[argLen + 1];
        newArgTypes[argLen] = extraArgumentType = fromFunction ? SCRIPT_FUNCTION_TYPE : OBJECT_TYPE;
        System.arraycopy(originalArgTypes, 0, newArgTypes, 0, argLen);
        InstructionAdapter mv = new InstructionAdapter(this.cw.visitMethod(1, INIT, Type.getMethodDescriptor((Type)originalCtorType.getReturnType(), (Type[])newArgTypes), null, null));
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        Class<?>[] argTypes = ctor.getParameterTypes();
        int offset = 1;
        for (int i = 0; i < argLen; ++i) {
            Type argType = Type.getType(argTypes[i]);
            mv.load(offset, argType);
            offset += argType.getSize();
        }
        mv.invokespecial(this.superClassName, INIT, originalCtorType.getDescriptor());
        String getHandleDescriptor = fromFunction ? GET_HANDLE_FUNCTION_DESCRIPTOR : GET_HANDLE_OBJECT_DESCRIPTOR;
        for (MethodInfo mi : this.methodInfos) {
            mv.visitVarInsn(25, 0);
            if (fromFunction && !mi.getName().equals(this.samName)) {
                mv.visitInsn(1);
            } else {
                mv.visitVarInsn(25, offset);
                if (!fromFunction) {
                    mv.aconst((Object)mi.getName());
                }
                mv.aconst((Object)Type.getMethodType((String)mi.type.toMethodDescriptorString()));
                mv.iconst(mi.method.isVarArgs() ? 1 : 0);
                mv.invokestatic(THIS_CLASS_TYPE_NAME, "getHandle", getHandleDescriptor);
            }
            mv.putfield(this.generatedClassName, mi.methodHandleFieldName, METHOD_HANDLE_TYPE_DESCRIPTOR);
        }
        mv.visitVarInsn(25, 0);
        JavaAdapterFactory.invokeGetGlobal(mv);
        mv.dup();
        mv.invokevirtual(OBJECT_TYPE_NAME, "getClass", GET_CLASS_METHOD_DESCRIPTOR);
        mv.pop();
        mv.putfield(this.generatedClassName, GLOBAL_FIELD_NAME, SCRIPT_OBJECT_TYPE_DESCRIPTOR);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void invokeGetGlobal(InstructionAdapter mv) {
        mv.invokestatic(CONTEXT_TYPE_NAME, "getGlobal", GET_GLOBAL_METHOD_DESCRIPTOR);
    }

    private void invokeSetGlobal(InstructionAdapter mv) {
        mv.invokestatic(this.globalSetterClassName, "setGlobal", SET_GLOBAL_METHOD_DESCRIPTOR);
    }

    public static MethodHandle getHandle(ScriptFunction fn, MethodType type, boolean varArg) {
        return JavaAdapterFactory.adaptHandle(fn.getBoundInvokeHandle(null), type, varArg);
    }

    public static MethodHandle getHandle(Object obj, String name, MethodType type, boolean varArg) {
        if (!(obj instanceof ScriptObject)) {
            ECMAErrors.typeError("not.an.object", ScriptRuntime.safeToString(obj));
            throw new AssertionError();
        }
        ScriptObject sobj = (ScriptObject)obj;
        if ("toString".equals(name) && !sobj.hasOwnProperty("toString")) {
            return null;
        }
        Object fnObj = sobj.get(name);
        if (fnObj instanceof ScriptFunction) {
            return JavaAdapterFactory.adaptHandle(((ScriptFunction)fnObj).getBoundInvokeHandle(sobj), type, varArg);
        }
        if (fnObj == null || fnObj instanceof Undefined) {
            return null;
        }
        ECMAErrors.typeError("not.a.function", name);
        throw new AssertionError();
    }

    private static MethodHandle adaptHandle(MethodHandle handle, MethodType type, boolean varArg) {
        return Bootstrap.getLinkerServices().asType(ScriptObject.pairArguments(handle, type, varArg), type);
    }

    private void generateMethods() {
        for (MethodInfo mi : this.methodInfos) {
            this.generateMethod(mi);
        }
    }

    private void generateMethod(MethodInfo mi) {
        Label throwableHandler;
        Method method = mi.method;
        int mod = method.getModifiers();
        int access = 1 | (method.isVarArgs() ? 128 : 0);
        Class<?>[] exceptions = method.getExceptionTypes();
        String[] exceptionNames = new String[exceptions.length];
        for (int i = 0; i < exceptions.length; ++i) {
            exceptionNames[i] = Type.getInternalName(exceptions[i]);
        }
        MethodType type = mi.type;
        String methodDesc = type.toMethodDescriptorString();
        String name = mi.getName();
        Type asmType = Type.getMethodType((String)methodDesc);
        Type[] asmArgTypes = asmType.getArgumentTypes();
        int nextLocalVar = 1;
        for (Type t : asmArgTypes) {
            nextLocalVar += t.getSize();
        }
        InstructionAdapter mv = new InstructionAdapter(this.cw.visitMethod(access, name, methodDesc, null, exceptionNames));
        mv.visitCode();
        Label methodHandleNotNull = new Label();
        Label methodEnd = new Label();
        Type returnType = Type.getType((Class)type.returnType());
        mv.visitVarInsn(25, 0);
        mv.getfield(this.generatedClassName, mi.methodHandleFieldName, METHOD_HANDLE_TYPE_DESCRIPTOR);
        mv.visitInsn(89);
        mv.visitJumpInsn(199, methodHandleNotNull);
        if (Modifier.isAbstract(mod)) {
            mv.anew(UNSUPPORTED_OPERATION_TYPE);
            mv.dup();
            mv.invokespecial(UNSUPPORTED_OPERATION_TYPE_NAME, INIT, VOID_NOARG);
            mv.athrow();
        } else {
            mv.visitVarInsn(25, 0);
            int nextParam = 1;
            for (Type t : asmArgTypes) {
                mv.load(nextParam, t);
                nextParam += t.getSize();
            }
            mv.invokespecial(this.superClassName, name, methodDesc);
            mv.areturn(returnType);
        }
        mv.visitLabel(methodHandleNotNull);
        int currentGlobalVar = nextLocalVar++;
        int globalsDifferVar = nextLocalVar++;
        JavaAdapterFactory.invokeGetGlobal(mv);
        mv.dup();
        mv.visitVarInsn(58, currentGlobalVar);
        this.loadGlobalOnStack(mv);
        Label globalsDiffer = new Label();
        mv.ifacmpne(globalsDiffer);
        mv.iconst(0);
        Label proceed = new Label();
        mv.goTo(proceed);
        mv.visitLabel(globalsDiffer);
        this.loadGlobalOnStack(mv);
        this.invokeSetGlobal(mv);
        mv.iconst(1);
        mv.visitLabel(proceed);
        mv.visitVarInsn(54, globalsDifferVar);
        int varOffset = 1;
        for (Type t : asmArgTypes) {
            mv.load(varOffset, t);
            varOffset += t.getSize();
        }
        Label tryBlockStart = new Label();
        mv.visitLabel(tryBlockStart);
        mv.invokevirtual(METHOD_HANDLE_TYPE.getInternalName(), "invokeExact", type.toMethodDescriptorString());
        Label tryBlockEnd = new Label();
        mv.visitLabel(tryBlockEnd);
        this.emitFinally(mv, currentGlobalVar, globalsDifferVar);
        mv.areturn(returnType);
        boolean throwableDeclared = JavaAdapterFactory.isThrowableDeclared(exceptions);
        if (!throwableDeclared) {
            throwableHandler = new Label();
            mv.visitLabel(throwableHandler);
            mv.anew(RUNTIME_EXCEPTION_TYPE);
            mv.dupX1();
            mv.swap();
            mv.invokespecial(RUNTIME_EXCEPTION_TYPE_NAME, INIT, Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{THROWABLE_TYPE}));
        } else {
            throwableHandler = null;
        }
        Label rethrowHandler = new Label();
        mv.visitLabel(rethrowHandler);
        this.emitFinally(mv, currentGlobalVar, globalsDifferVar);
        mv.athrow();
        mv.visitLabel(methodEnd);
        mv.visitLocalVariable("currentGlobal", SCRIPT_OBJECT_TYPE_DESCRIPTOR, null, methodHandleNotNull, methodEnd, currentGlobalVar);
        mv.visitLocalVariable("globalsDiffer", Type.INT_TYPE.getDescriptor(), null, methodHandleNotNull, methodEnd, globalsDifferVar);
        if (throwableDeclared) {
            mv.visitTryCatchBlock(tryBlockStart, tryBlockEnd, rethrowHandler, THROWABLE_TYPE_NAME);
            assert (throwableHandler == null);
        } else {
            mv.visitTryCatchBlock(tryBlockStart, tryBlockEnd, rethrowHandler, RUNTIME_EXCEPTION_TYPE_NAME);
            mv.visitTryCatchBlock(tryBlockStart, tryBlockEnd, rethrowHandler, ERROR_TYPE_NAME);
            for (String excName : exceptionNames) {
                mv.visitTryCatchBlock(tryBlockStart, tryBlockEnd, rethrowHandler, excName);
            }
            mv.visitTryCatchBlock(tryBlockStart, tryBlockEnd, throwableHandler, THROWABLE_TYPE_NAME);
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void emitFinally(InstructionAdapter mv, int currentGlobalVar, int globalsDifferVar) {
        mv.visitVarInsn(21, globalsDifferVar);
        Label skip = new Label();
        mv.ifeq(skip);
        mv.visitVarInsn(25, currentGlobalVar);
        this.invokeSetGlobal(mv);
        mv.visitLabel(skip);
    }

    private void loadGlobalOnStack(InstructionAdapter mv) {
        mv.visitVarInsn(25, 0);
        mv.getfield(this.generatedClassName, GLOBAL_FIELD_NAME, SCRIPT_OBJECT_TYPE_DESCRIPTOR);
    }

    private static boolean isThrowableDeclared(Class<?>[] exceptions) {
        for (Class<?> exception : exceptions) {
            if (exception != Throwable.class) continue;
            return true;
        }
        return false;
    }

    private void gatherMethods(Class<?> type) {
        if (Modifier.isPublic(type.getModifiers())) {
            Method[] typeMethods = type.isInterface() ? type.getMethods() : type.getDeclaredMethods();
            for (GenericDeclaration genericDeclaration : typeMethods) {
                int m = ((Method)genericDeclaration).getModifiers();
                if (Modifier.isStatic(m) || !Modifier.isPublic(m) && !Modifier.isProtected(m)) continue;
                MethodInfo mi = new MethodInfo((Method)genericDeclaration);
                if (Modifier.isFinal(m)) {
                    this.finalMethods.add(mi);
                    continue;
                }
                if (this.finalMethods.contains(mi) || !this.methodInfos.add(mi)) continue;
                if (Modifier.isAbstract(m)) {
                    this.abstractMethodNames.add(mi.getName());
                }
                mi.setIsCanonical(this.usedFieldNames);
            }
        }
        if (!type.isInterface()) {
            Class<?> superType = type.getSuperclass();
            if (superType != null) {
                this.gatherMethods(superType);
            }
            for (GenericDeclaration genericDeclaration : type.getInterfaces()) {
                this.gatherMethods((Class<?>)genericDeclaration);
            }
        }
    }

    private void gatherMethods(List<Class<?>> classes) {
        for (Class<?> c : classes) {
            this.gatherMethods(c);
        }
    }

    private static Collection<MethodInfo> getExcludedMethods() {
        return AccessController.doPrivileged(new PrivilegedAction<Collection<MethodInfo>>(){

            @Override
            public Collection<MethodInfo> run() {
                try {
                    return Arrays.asList(new MethodInfo((Class)Object.class, "finalize", new Class[0]), new MethodInfo((Class)Object.class, "clone", new Class[0]));
                }
                catch (NoSuchMethodException e) {
                    throw new AssertionError((Object)e);
                }
            }
        });
    }

    private static ProtectionDomain createGeneratedProtectionDomain() {
        Permissions permissions = new Permissions();
        permissions.add(new AllPermission());
        return new ProtectionDomain(new CodeSource(null, (CodeSigner[])null), permissions);
    }

    private static AdapterInfo createAdapterInfo(Class<?>[] types, final ClassAndLoader definingClassAndLoader) {
        Class<?> superClass = null;
        final ArrayList interfaces = new ArrayList(types.length);
        for (Class<?> t : types) {
            int mod = t.getModifiers();
            if (!t.isInterface()) {
                if (superClass != null) {
                    return new AdapterInfo(AdaptationOutcome.ERROR_MULTIPLE_SUPERCLASSES, t.getCanonicalName() + " and " + superClass.getCanonicalName());
                }
                if (Modifier.isFinal(mod)) {
                    return new AdapterInfo(AdaptationOutcome.ERROR_FINAL_CLASS, t.getCanonicalName());
                }
                superClass = t;
            } else {
                interfaces.add(t);
            }
            if (Modifier.isPublic(mod)) continue;
            return new AdapterInfo(AdaptationOutcome.ERROR_NON_PUBLIC_CLASS, t.getCanonicalName());
        }
        final Class effectiveSuperClass = superClass == null ? Object.class : superClass;
        return AccessController.doPrivileged(new PrivilegedAction<AdapterInfo>(){

            @Override
            public AdapterInfo run() {
                try {
                    JavaAdapterFactory factory = new JavaAdapterFactory(effectiveSuperClass, interfaces, definingClassAndLoader);
                    return new AdapterInfo(StaticClass.forClass((Class)factory.generateClass()), factory.isAutoConvertibleFromFunction());
                }
                catch (AdaptationException e) {
                    return new AdapterInfo(e.outcome);
                }
            }
        });
    }

    private String getCommonSuperClass(String type1, String type2) {
        try {
            Class<?> c1 = Class.forName(type1.replace('/', '.'), false, this.commonLoader);
            Class<?> c2 = Class.forName(type2.replace('/', '.'), false, this.commonLoader);
            if (c1.isAssignableFrom(c2)) {
                return type1;
            }
            if (c2.isAssignableFrom(c1)) {
                return type2;
            }
            if (c1.isInterface() || c2.isInterface()) {
                return "java/lang/Object";
            }
            return JavaAdapterFactory.assignableSuperClass(c1, c2).getName().replace('.', '/');
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static Class<?> assignableSuperClass(Class<?> c1, Class<?> c2) {
        Class<?> superClass = c1.getSuperclass();
        return superClass.isAssignableFrom(c2) ? superClass : JavaAdapterFactory.assignableSuperClass(superClass, c2);
    }

    private static ClassLoader findCommonLoader(ClassAndLoader classAndLoader) throws AdaptationException {
        ClassLoader loader = classAndLoader.getLoader();
        if (JavaAdapterFactory.canSeeClass(loader, ScriptObject.class)) {
            return loader;
        }
        ClassLoader nashornLoader = ScriptObject.class.getClassLoader();
        if (JavaAdapterFactory.canSeeClass(nashornLoader, classAndLoader.clazz)) {
            return nashornLoader;
        }
        throw new AdaptationException(AdaptationOutcome.ERROR_NO_COMMON_LOADER, classAndLoader.clazz.getCanonicalName());
    }

    private static boolean canSeeClass(ClassLoader cl, Class<?> clazz) {
        try {
            return Class.forName(clazz.getName(), false, cl) == clazz;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static ClassAndLoader getDefiningClassAndLoader(final Class<?>[] types) {
        if (types.length == 1) {
            return new ClassAndLoader(types[0], false);
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassAndLoader>(){

            @Override
            public ClassAndLoader run() {
                return JavaAdapterFactory.getDefiningClassAndLoaderPrivileged(types);
            }
        });
    }

    private static ClassAndLoader getDefiningClassAndLoaderPrivileged(Class<?>[] types) {
        Collection<ClassAndLoader> maximumVisibilityLoaders = JavaAdapterFactory.getMaximumVisibilityLoaders(types);
        Iterator<ClassAndLoader> it = maximumVisibilityLoaders.iterator();
        if (maximumVisibilityLoaders.size() == 1) {
            return it.next();
        }
        assert (maximumVisibilityLoaders.size() > 1);
        StringBuilder b = new StringBuilder();
        b.append(it.next().clazz.getCanonicalName());
        while (it.hasNext()) {
            b.append(", ").append(it.next().clazz.getCanonicalName());
        }
        ECMAErrors.typeError("extend.ambiguous.defining.class", b.toString());
        throw new AssertionError();
    }

    private static Collection<ClassAndLoader> getMaximumVisibilityLoaders(Class<?>[] types) {
        LinkedList<ClassAndLoader> maximumVisibilityLoaders = new LinkedList<ClassAndLoader>();
        block0: for (ClassAndLoader maxCandidate : JavaAdapterFactory.getClassLoadersForTypes(types)) {
            Iterator it = maximumVisibilityLoaders.iterator();
            while (it.hasNext()) {
                ClassAndLoader existingMax = (ClassAndLoader)it.next();
                boolean candidateSeesExisting = JavaAdapterFactory.canSeeClass(maxCandidate.getRetrievedLoader(), existingMax.clazz);
                boolean exitingSeesCandidate = JavaAdapterFactory.canSeeClass(existingMax.getRetrievedLoader(), maxCandidate.clazz);
                if (candidateSeesExisting) {
                    if (exitingSeesCandidate) continue;
                    it.remove();
                    continue;
                }
                if (!exitingSeesCandidate) continue;
                continue block0;
            }
            maximumVisibilityLoaders.add(maxCandidate);
        }
        return maximumVisibilityLoaders;
    }

    private static Collection<ClassAndLoader> getClassLoadersForTypes(Class<?>[] types) {
        LinkedHashMap<ClassAndLoader, ClassAndLoader> classesAndLoaders = new LinkedHashMap<ClassAndLoader, ClassAndLoader>();
        for (Class<?> c : types) {
            ClassAndLoader cl = new ClassAndLoader(c, true);
            if (classesAndLoaders.containsKey(cl)) continue;
            classesAndLoaders.put(cl, cl);
        }
        return classesAndLoaders.keySet();
    }

    private static class AdaptationException
    extends Exception {
        private final AnnotatedAdaptationOutcome outcome;

        AdaptationException(AdaptationOutcome outcome, String classList) {
            this.outcome = new AnnotatedAdaptationOutcome(outcome, classList);
        }
    }

    private static enum AdaptationOutcome {
        SUCCESS,
        ERROR_FINAL_CLASS,
        ERROR_NON_PUBLIC_CLASS,
        ERROR_NO_ACCESSIBLE_CONSTRUCTOR,
        ERROR_MULTIPLE_SUPERCLASSES,
        ERROR_NO_COMMON_LOADER;

    }

    private static class AdapterInfo {
        final StaticClass adapterClass;
        final boolean autoConvertibleFromFunction;
        final AnnotatedAdaptationOutcome adaptationOutcome;

        AdapterInfo(StaticClass adapterClass, boolean autoConvertibleFromFunction) {
            this.adapterClass = adapterClass;
            this.autoConvertibleFromFunction = autoConvertibleFromFunction;
            this.adaptationOutcome = AnnotatedAdaptationOutcome.SUCCESS;
        }

        AdapterInfo(AdaptationOutcome outcome, String classList) {
            this(new AnnotatedAdaptationOutcome(outcome, classList));
        }

        AdapterInfo(AnnotatedAdaptationOutcome adaptationOutcome) {
            this.adapterClass = null;
            this.autoConvertibleFromFunction = false;
            this.adaptationOutcome = adaptationOutcome;
        }
    }

    private static class AdapterLoader
    extends SecureClassLoader {
        AdapterLoader(ClassLoader parent) {
            super(parent);
        }
    }

    private static class AnnotatedAdaptationOutcome {
        static final AnnotatedAdaptationOutcome SUCCESS = new AnnotatedAdaptationOutcome(AdaptationOutcome.SUCCESS, "");
        private final AdaptationOutcome adaptationOutcome;
        private final String classList;

        AnnotatedAdaptationOutcome(AdaptationOutcome adaptationOutcome, String classList) {
            this.adaptationOutcome = adaptationOutcome;
            this.classList = classList;
        }

        void typeError() {
            assert (this.adaptationOutcome != AdaptationOutcome.SUCCESS);
            ECMAErrors.typeError("extend." + (Object)((Object)this.adaptationOutcome), this.classList);
        }
    }

    private static final class ClassAndLoader {
        private final Class<?> clazz;
        private ClassLoader loader;
        private boolean loaderRetrieved;

        ClassAndLoader(Class<?> clazz, boolean retrieveLoader) {
            this.clazz = clazz;
            if (retrieveLoader) {
                this.retrieveLoader();
            }
        }

        ClassLoader getLoader() {
            if (!this.loaderRetrieved) {
                this.retrieveLoader();
            }
            return this.getRetrievedLoader();
        }

        ClassLoader getRetrievedLoader() {
            assert (this.loaderRetrieved);
            return this.loader;
        }

        private void retrieveLoader() {
            this.loader = this.clazz.getClassLoader();
            this.loaderRetrieved = true;
        }

        public boolean equals(Object obj) {
            return obj instanceof ClassAndLoader && ((ClassAndLoader)obj).getRetrievedLoader() == this.getRetrievedLoader();
        }

        public int hashCode() {
            return System.identityHashCode(this.getRetrievedLoader());
        }
    }

    private static class MethodInfo {
        private final Method method;
        private final MethodType type;
        private String methodHandleFieldName;

        private MethodInfo(Class<?> clazz, String name, Class<?> ... argTypes) throws NoSuchMethodException {
            this(clazz.getDeclaredMethod(name, argTypes));
        }

        private MethodInfo(Method method) {
            this.method = method;
            this.type = Lookup.MH.type(method.getReturnType(), method.getParameterTypes());
        }

        public boolean equals(Object obj) {
            return obj instanceof MethodInfo && this.equals((MethodInfo)obj);
        }

        private boolean equals(MethodInfo other) {
            return this.getName().equals(other.getName()) && this.type.equals((Object)other.type);
        }

        String getName() {
            return this.method.getName();
        }

        public int hashCode() {
            return this.getName().hashCode() ^ this.type.hashCode();
        }

        void setIsCanonical(Set<String> usedFieldNames) {
            int i = 0;
            String fieldName = this.getName();
            while (!usedFieldNames.add(fieldName)) {
                fieldName = this.getName() + i++;
            }
            this.methodHandleFieldName = fieldName;
        }
    }
}

