/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import jdk.nashorn.internal.runtime.DefaultPropertyAccess;
import jdk.nashorn.internal.runtime.ECMAErrors;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.linker.Lookup;
import org.dynalang.dynalink.CallSiteDescriptor;
import org.dynalang.dynalink.linker.GuardedInvocation;
import org.dynalang.dynalink.support.CallSiteDescriptorFactory;
import org.dynalang.dynalink.support.Guards;

public final class Undefined
extends DefaultPropertyAccess {
    private static final Undefined UNDEFINED = new Undefined();
    private static final Undefined EMPTY = new Undefined();
    private static final MethodHandle UNDEFINED_GUARD = Guards.getIdentityGuard((Object)UNDEFINED);

    private Undefined() {
    }

    public static Undefined getUndefined() {
        return UNDEFINED;
    }

    public static Undefined getEmpty() {
        return EMPTY;
    }

    public String getClassName() {
        return "Undefined";
    }

    public String toString() {
        return "undefined";
    }

    public static GuardedInvocation lookup(CallSiteDescriptor desc) {
        String operator;
        switch (operator = (String)CallSiteDescriptorFactory.tokenizeOperators((CallSiteDescriptor)desc).get(0)) {
            case "new": 
            case "call": {
                Undefined.lookupTypeError("cant.call.undefined", desc);
                break;
            }
            case "callMethod": {
                Undefined.lookupTypeError("cant.read.property.of.undefined", desc);
                break;
            }
            case "getProp": 
            case "getElem": 
            case "getMethod": {
                if (desc.getNameTokenCount() < 3) {
                    return Undefined.findGetIndexMethod(desc, new Object[0]);
                }
                Undefined.lookupTypeError("cant.read.property.of.undefined", desc);
                break;
            }
            case "setProp": 
            case "setElem": {
                if (desc.getNameTokenCount() < 3) {
                    return Undefined.findSetIndexMethod(desc);
                }
                Undefined.lookupTypeError("cant.set.property.of.undefined", desc);
                break;
            }
        }
        return null;
    }

    private static void lookupTypeError(String msg, CallSiteDescriptor desc) {
        ECMAErrors.typeError(msg, desc.getNameTokenCount() > 2 ? desc.getNameToken(2) : null);
    }

    private static GuardedInvocation findGetIndexMethod(CallSiteDescriptor desc, Object ... args) {
        MethodType callType = desc.getMethodType();
        TypeDescriptor.OfField returnClass = callType.returnType();
        TypeDescriptor.OfField keyClass = callType.parameterType(1);
        String name = "get";
        if (((Class)returnClass).isPrimitive()) {
            String returnTypeName = ((Class)returnClass).getName();
            name = name + Character.toUpperCase(returnTypeName.charAt(0)) + returnTypeName.substring(1, returnTypeName.length());
        }
        MethodHandle methodHandle = Undefined.findOwnMH(name, returnClass, new Class[]{keyClass});
        methodHandle = Lookup.MH.asType(methodHandle, methodHandle.type().changeParameterType(0, Object.class));
        return new GuardedInvocation(methodHandle, UNDEFINED_GUARD);
    }

    private static GuardedInvocation findSetIndexMethod(CallSiteDescriptor desc) {
        MethodType callType = desc.getMethodType();
        TypeDescriptor.OfField keyClass = callType.parameterType(1);
        TypeDescriptor.OfField valueClass = callType.parameterType(2);
        MethodHandle methodHandle = Undefined.findOwnMH("set", Void.TYPE, new Class[]{keyClass, valueClass, Boolean.TYPE});
        methodHandle = Lookup.MH.asType(methodHandle, methodHandle.type().changeParameterType(0, Object.class));
        methodHandle = Lookup.MH.insertArguments(methodHandle, 3, false);
        return new GuardedInvocation(methodHandle, UNDEFINED_GUARD);
    }

    @Override
    public Object get(Object key) {
        ECMAErrors.typeError("cant.read.property.of.undefined", ScriptRuntime.safeToString(key));
        return ScriptRuntime.UNDEFINED;
    }

    @Override
    public void set(Object key, Object value, boolean strict) {
        ECMAErrors.typeError("cant.set.property.of.undefined", ScriptRuntime.safeToString(key));
    }

    @Override
    public boolean delete(Object key, boolean strict) {
        ECMAErrors.typeError("cant.delete.property.of.undefined", ScriptRuntime.safeToString(key));
        return false;
    }

    @Override
    public boolean has(Object key) {
        return false;
    }

    @Override
    public boolean hasOwnProperty(Object key) {
        return false;
    }

    private static MethodHandle findOwnMH(String name, Class<?> rtype, Class<?> ... types) {
        return Lookup.MH.findVirtual(MethodHandles.lookup(), Undefined.class, name, Lookup.MH.type(rtype, types));
    }
}

