/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import jdk.nashorn.internal.parser.Lexer;
import jdk.nashorn.internal.parser.Scanner;
import jdk.nashorn.internal.runtime.BitVector;

public class RegExpScanner
extends Scanner {
    private final StringBuilder sb;
    private String errorMessage;
    private boolean neverMatches;
    private String javaPattern;
    private final Map<Character, Integer> expected = new HashMap<Character, Integer>();
    private final List<Capture> caps = new LinkedList<Capture>();
    private final Map<Integer, Token> forwardReferences = new LinkedHashMap<Integer, Token>();
    private int negativeLookaheadLevel;
    private static final String NON_IDENT_ESCAPES = "$^*+(){}[]|\\.?";

    private RegExpScanner(String string) {
        super(string);
        this.sb = new StringBuilder(this.limit);
        this.reset(0);
        this.expected.put(Character.valueOf(']'), 0);
        this.expected.put(Character.valueOf('}'), 0);
    }

    private void processForwardReferences() {
        if (this.neverMatches()) {
            return;
        }
        for (Map.Entry<Integer, Token> fwdRef : this.forwardReferences.entrySet()) {
            if (fwdRef.getKey() > this.caps.size()) {
                this.neverMatches = true;
                break;
            }
            fwdRef.getValue().setIsDead(true);
        }
        this.forwardReferences.clear();
    }

    public static RegExpScanner scan(String string) {
        Token pattern;
        RegExpScanner scanner = new RegExpScanner(string);
        try {
            pattern = scanner.pattern();
        }
        catch (Exception e) {
            throw new PatternSyntaxException(e.getMessage(), string, scanner.sb.length());
        }
        scanner.processForwardReferences();
        if (scanner.neverMatches()) {
            return null;
        }
        Iterator<Token> iter = pattern.iterator();
        while (iter.hasNext()) {
            Token next = iter.next();
            if (!next.getIsDead()) continue;
            next.getParent().remove(next);
        }
        String p = pattern.toString();
        if (!string.equals(scanner.getStringBuilder().toString())) {
            throw new PatternSyntaxException(string, p, p.length() + 1);
        }
        scanner.javaPattern = p;
        return scanner;
    }

    private boolean neverMatches() {
        return this.neverMatches;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    final StringBuilder getStringBuilder() {
        return this.sb;
    }

    String getJavaPattern() {
        return this.javaPattern;
    }

    BitVector getGroupsInNegativeLookahead() {
        BitVector vec = null;
        for (int i = 0; i < this.caps.size(); ++i) {
            Capture cap = this.caps.get(i);
            if (cap.getNegativeLookaheadLevel() <= 0) continue;
            if (vec == null) {
                vec = new BitVector(this.caps.size() + 1);
            }
            vec.set(i + 1);
        }
        return vec;
    }

    private Token commit(Token token, int n) {
        int startIn = this.position;
        switch (n) {
            case 1: {
                this.sb.append(this.ch0);
                this.skip(1);
                break;
            }
            case 2: {
                this.sb.append(this.ch0);
                this.sb.append(this.ch1);
                this.skip(2);
                break;
            }
            case 3: {
                this.sb.append(this.ch0);
                this.sb.append(this.ch1);
                this.sb.append(this.ch2);
                this.skip(3);
                break;
            }
            default: {
                assert (false) : "Should not reach here";
                break;
            }
        }
        if (token == null) {
            return null;
        }
        return token.add(this.sb.substring(startIn, this.sb.length()));
    }

    private void restart(int startIn, int startOut) {
        this.reset(startIn);
        this.sb.setLength(startOut);
    }

    private void push(char ch) {
        this.expected.put(Character.valueOf(ch), this.expected.get(Character.valueOf(ch)) + 1);
    }

    private void pop(char ch) {
        this.expected.put(Character.valueOf(ch), Math.min(0, this.expected.get(Character.valueOf(ch)) - 1));
    }

    private Token pattern() {
        Token token = new Token(Token.Type.PATTERN);
        Token child = this.disjunction();
        if (child != null) {
            return token.add(child);
        }
        return null;
    }

    private Token disjunction() {
        Token token = new Token(Token.Type.DISJUNCTION);
        while (true) {
            token.add(this.alternative());
            if (this.ch0 != '|') break;
            this.commit(token, 1);
        }
        return token;
    }

    private Token alternative() {
        Token child;
        Token token = new Token(Token.Type.ALTERNATIVE);
        while ((child = this.term()) != null) {
            token.add(child);
        }
        return token;
    }

    private Token term() {
        int startIn = this.position;
        int startOut = this.sb.length();
        Token token = new Token(Token.Type.TERM);
        Token child = this.assertion();
        if (child != null) {
            return token.add(child);
        }
        child = this.atom();
        if (child != null) {
            boolean emptyCharacterClass = false;
            if ("[]".equals(child.toString())) {
                emptyCharacterClass = true;
            }
            token.add(child);
            Token quantifier = this.quantifier();
            if (quantifier != null) {
                token.add(quantifier);
            }
            if (emptyCharacterClass) {
                if (quantifier == null) {
                    this.neverMatches = true;
                } else {
                    String qs = quantifier.toString();
                    if ("+".equals(qs) || "*".equals(qs) || qs.startsWith("{0,")) {
                        token.setIsDead(true);
                    }
                }
            }
            return token;
        }
        this.restart(startIn, startOut);
        return null;
    }

    private Token assertion() {
        int startIn = this.position;
        int startOut = this.sb.length();
        Token token = new Token(Token.Type.ASSERTION);
        switch (this.ch0) {
            case '$': 
            case '^': {
                return this.commit(token, 1);
            }
            case '\\': {
                if (this.ch1 != 'b' && this.ch1 != 'B') break;
                return this.commit(token, 2);
            }
            case '(': {
                if (this.ch1 != '?' || this.ch2 != '=' && this.ch2 != '!') break;
                boolean isNegativeLookahead = this.ch2 == '!';
                this.commit(token, 3);
                if (isNegativeLookahead) {
                    ++this.negativeLookaheadLevel;
                }
                Token disjunction = this.disjunction();
                if (isNegativeLookahead) {
                    for (Capture cap : this.caps) {
                        if (cap.getNegativeLookaheadLevel() < this.negativeLookaheadLevel) continue;
                        cap.setDead();
                    }
                    --this.negativeLookaheadLevel;
                }
                if (disjunction == null || this.ch0 != ')') break;
                token.add(disjunction);
                return this.commit(token, 1);
            }
        }
        this.restart(startIn, startOut);
        return null;
    }

    private Token quantifier() {
        Token token = new Token(Token.Type.QUANTIFIER);
        Token child = this.quantifierPrefix();
        if (child != null) {
            token.add(child);
            if (this.ch0 == '?') {
                this.commit(token, 1);
            }
            return token;
        }
        return null;
    }

    private Token quantifierPrefix() {
        int startIn = this.position;
        int startOut = this.sb.length();
        Token token = new Token(Token.Type.QUANTIFIER_PREFIX);
        switch (this.ch0) {
            case '*': 
            case '+': 
            case '?': {
                return this.commit(token, 1);
            }
            case '{': {
                this.commit(token, 1);
                Token child = this.decimalDigits();
                if (child == null) break;
                this.push('}');
                token.add(child);
                if (this.ch0 == ',') {
                    this.commit(token, 1);
                    token.add(this.decimalDigits());
                }
                if (this.ch0 == '}') {
                    this.pop('}');
                    this.commit(token, 1);
                }
                return token;
            }
        }
        this.restart(startIn, startOut);
        return null;
    }

    private Token atom() {
        int startIn = this.position;
        int startOut = this.sb.length();
        Token token = new Token(Token.Type.ATOM);
        Token child = this.patternCharacter();
        if (child != null) {
            return token.add(child);
        }
        if (this.ch0 == '.') {
            return this.commit(token, 1);
        }
        if (this.ch0 == '\\') {
            this.commit(token, 1);
            child = this.atomEscape();
            if (child != null) {
                char idEscape;
                if (child.hasChildOfType(Token.Type.IDENTITY_ESCAPE) && NON_IDENT_ESCAPES.indexOf(idEscape = child.toString().charAt(0)) == -1) {
                    token.reset();
                }
                token.add(child);
                if (child.hasChildOfType(Token.Type.DECIMAL_ESCAPE) && !"\u0000".equals(child.toString())) {
                    int refNum = Integer.parseInt(child.toString());
                    if (refNum - 1 < this.caps.size() && this.caps.get(refNum - 1).isDead()) {
                        token.setIsDead(true);
                    } else if (this.caps.size() < refNum) {
                        this.forwardReferences.put(refNum, token);
                    }
                }
                return token;
            }
        }
        if ((child = this.characterClass()) != null) {
            return token.add(child);
        }
        if (this.ch0 == '(') {
            boolean capturingParens = true;
            this.commit(token, 1);
            if (this.ch0 == '?' && this.ch1 == ':') {
                capturingParens = false;
                this.commit(token, 2);
            }
            if ((child = this.disjunction()) != null) {
                token.add(child);
                if (this.ch0 == ')') {
                    Token atom = this.commit(token, 1);
                    if (capturingParens) {
                        this.caps.add(new Capture(this.negativeLookaheadLevel));
                    }
                    return atom;
                }
            }
        }
        this.restart(startIn, startOut);
        return null;
    }

    private Token patternCharacter() {
        if (this.atEOF()) {
            return null;
        }
        switch (this.ch0) {
            case '$': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case '.': 
            case '?': 
            case '[': 
            case '\\': 
            case '^': 
            case '|': {
                return null;
            }
            case ']': 
            case '}': {
                int n = this.expected.get(Character.valueOf(this.ch0));
                if (n != 0) {
                    return null;
                }
            }
            case '{': {
                Token quant = this.quantifierPrefix();
                return quant == null ? this.commit(new Token(Token.Type.PATTERN_CHARACTER).add("\\"), 1) : null;
            }
        }
        return this.commit(new Token(Token.Type.PATTERN_CHARACTER), 1);
    }

    private Token atomEscape() {
        Token token = new Token(Token.Type.ATOM_ESCAPE);
        Token child = this.decimalEscape();
        if (child != null) {
            return token.add(child);
        }
        child = this.characterClassEscape();
        if (child != null) {
            return token.add(child);
        }
        child = this.characterEscape();
        if (child != null) {
            return token.add(child);
        }
        return null;
    }

    private Token characterEscape() {
        int startIn = this.position;
        int startOut = this.sb.length();
        Token token = new Token(Token.Type.CHARACTER_ESCAPE);
        Token child = this.controlEscape();
        if (child != null) {
            return token.add(child);
        }
        if (this.ch0 == 'c') {
            this.commit(token, 1);
            child = this.controlLetter();
            if (child != null) {
                return token.add(child);
            }
            this.restart(startIn, startOut);
        }
        if ((child = this.hexEscapeSequence()) != null) {
            return token.add(child);
        }
        child = this.unicodeEscapeSequence();
        if (child != null) {
            return token.add(child);
        }
        child = this.identityEscape();
        if (child != null) {
            return token.add(child);
        }
        this.restart(startIn, startOut);
        return null;
    }

    private boolean scanEscapeSequence(char leader, int length, Token token) {
        int startIn = this.position;
        int startOut = this.sb.length();
        if (this.ch0 != leader) {
            return false;
        }
        this.commit(token, 1);
        for (int i = 0; i < length; ++i) {
            char ch0l = Character.toLowerCase(this.ch0);
            if (!(ch0l >= 'a' && ch0l <= 'f' || RegExpScanner.isDecimalDigit(this.ch0))) {
                this.restart(startIn, startOut);
                return false;
            }
            this.commit(token, 1);
        }
        return true;
    }

    private Token hexEscapeSequence() {
        Token token = new Token(Token.Type.HEX_ESCAPESEQUENCE);
        if (this.scanEscapeSequence('x', 2, token)) {
            return token;
        }
        return null;
    }

    private Token unicodeEscapeSequence() {
        Token token = new Token(Token.Type.UNICODE_ESCAPESEQUENCE);
        if (this.scanEscapeSequence('u', 4, token)) {
            return token;
        }
        return null;
    }

    private Token controlEscape() {
        switch (this.ch0) {
            case 'f': 
            case 'n': 
            case 'r': 
            case 't': 
            case 'v': {
                return this.commit(new Token(Token.Type.CONTROL_ESCAPE), 1);
            }
        }
        return null;
    }

    private Token controlLetter() {
        char c = Character.toUpperCase(this.ch0);
        if (c >= 'A' && c <= 'Z') {
            Token token = new Token(Token.Type.CONTROL_LETTER);
            this.commit(token, 1);
            return token;
        }
        return null;
    }

    private Token identityEscape() {
        Token token = new Token(Token.Type.IDENTITY_ESCAPE);
        this.commit(token, 1);
        return token;
    }

    private Token decimalEscape() {
        Token token = new Token(Token.Type.DECIMAL_ESCAPE);
        int startIn = this.position;
        int startOut = this.sb.length();
        if (this.ch0 == '0' && !RegExpScanner.isDecimalDigit(this.ch1)) {
            this.commit(token, 1);
            token.removeLast();
            return token.add("\u0000");
        }
        if (RegExpScanner.isDecimalDigit(this.ch0)) {
            while (RegExpScanner.isDecimalDigit(this.ch0)) {
                this.commit(token, 1);
            }
            return token;
        }
        this.restart(startIn, startOut);
        return null;
    }

    private Token characterClassEscape() {
        switch (this.ch0) {
            case 'D': 
            case 'S': 
            case 'W': 
            case 'd': 
            case 's': 
            case 'w': {
                return this.commit(new Token(Token.Type.CHARACTERCLASS_ESCAPE), 1);
            }
        }
        return null;
    }

    private Token characterClass() {
        int startIn = this.position;
        int startOut = this.sb.length();
        Token token = new Token(Token.Type.CHARACTERCLASS);
        if (this.ch0 == '[') {
            Token child;
            this.push(']');
            this.commit(token, 1);
            if (this.ch0 == '^') {
                this.commit(token, 1);
            }
            if ((child = this.classRanges()) != null && this.ch0 == ']') {
                this.pop(']');
                token.add(child);
                return this.commit(token, 1);
            }
        }
        this.restart(startIn, startOut);
        return null;
    }

    private Token classRanges() {
        return new Token(Token.Type.CLASSRANGES).add(this.nonemptyClassRanges());
    }

    private Token nonemptyClassRanges() {
        int startIn = this.position;
        int startOut = this.sb.length();
        Token token = new Token(Token.Type.NON_EMPTY_CLASSRANGES);
        Token child = this.classAtom();
        if (child != null) {
            token.add(child);
            if (this.ch0 == '-') {
                this.commit(token, 1);
                Token child1 = this.classAtom();
                Token child2 = this.classRanges();
                if (child1 != null && child2 != null) {
                    token.add(child1);
                    token.add(child2);
                    return token;
                }
            }
            if ((child = this.nonemptyClassRangesNoDash()) != null) {
                token.add(child);
                return token;
            }
            return token;
        }
        this.restart(startIn, startOut);
        return null;
    }

    private Token nonemptyClassRangesNoDash() {
        int startIn = this.position;
        int startOut = this.sb.length();
        Token token = new Token(Token.Type.NON_EMPTY_CLASSRANGES_NODASH);
        Token child = this.classAtomNoDash();
        if (child != null) {
            token.add(child);
            if (this.ch0 == '-') {
                this.commit(token, 1);
                Token child1 = this.classAtom();
                Token child2 = this.classRanges();
                if (child1 != null && child2 != null) {
                    token.add(child1);
                    return token.add(child2);
                }
            }
            if ((child = this.nonemptyClassRangesNoDash()) != null) {
                token.add(child);
            }
            return token;
        }
        child = this.classAtom();
        if (child != null) {
            return token.add(child);
        }
        this.restart(startIn, startOut);
        return null;
    }

    private Token classAtom() {
        Token token = new Token(Token.Type.CLASSATOM);
        if (this.ch0 == '-') {
            return this.commit(token, 1);
        }
        Token child = this.classAtomNoDash();
        if (child != null) {
            return token.add(child);
        }
        return null;
    }

    private Token classAtomNoDash() {
        int startIn = this.position;
        int startOut = this.sb.length();
        Token token = new Token(Token.Type.CLASSATOM_NODASH);
        switch (this.ch0) {
            case '\u0000': 
            case '-': 
            case ']': {
                return null;
            }
            case '[': {
                return this.commit(token.add("\\"), 1);
            }
            case '\\': {
                this.commit(token, 1);
                Token child = this.classEscape();
                if (child != null) {
                    return token.add(child);
                }
                this.restart(startIn, startOut);
                return null;
            }
        }
        return this.commit(token, 1);
    }

    private Token classEscape() {
        Token token = new Token(Token.Type.CLASS_ESCAPE);
        Token child = this.decimalEscape();
        if (child != null) {
            return token.add(child);
        }
        if (this.ch0 == 'b') {
            return this.commit(token, 1);
        }
        child = this.characterEscape();
        if (child != null) {
            return token.add(child);
        }
        child = this.characterClassEscape();
        if (child != null) {
            return token.add(child);
        }
        return null;
    }

    private Token decimalDigits() {
        if (!RegExpScanner.isDecimalDigit(this.ch0)) {
            return null;
        }
        Token token = new Token(Token.Type.DECIMALDIGITS);
        while (RegExpScanner.isDecimalDigit(this.ch0)) {
            this.commit(token, 1);
        }
        return token;
    }

    private static boolean isDecimalDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private static class Capture {
        private final int negativeLookaheadLevel;
        private boolean isDead;

        Capture(int negativeLookaheadLevel) {
            this.negativeLookaheadLevel = negativeLookaheadLevel;
        }

        public int getNegativeLookaheadLevel() {
            return this.negativeLookaheadLevel;
        }

        public boolean isDead() {
            return this.isDead;
        }

        public void setDead() {
            this.isDead = true;
        }
    }

    private static class Token {
        private final Type type;
        private final List<Object> children;
        private Token parent;
        private boolean isDead;
        private static final Map<Type, ToString> toStringMap = new HashMap<Type, ToString>();
        private static final ToString DEFAULT_TOSTRING = new ToString();

        private static String unicode(int value) {
            StringBuilder sb = new StringBuilder();
            String hex = Integer.toHexString(value);
            sb.append('u');
            for (int i = 0; i < 4 - hex.length(); ++i) {
                sb.append('0');
            }
            sb.append(hex);
            return sb.toString();
        }

        Token(Type type) {
            this.type = type;
            this.children = new ArrayList<Object>();
        }

        public Token add(String child) {
            this.children.add(child);
            return this;
        }

        public Token add(Token child) {
            if (child != null) {
                this.children.add(child);
                child.setParent(this);
            }
            return this;
        }

        public boolean remove(Token child) {
            return this.children.remove(child);
        }

        public Object removeLast() {
            return this.children.remove(this.children.size() - 1);
        }

        private void setIsDead(boolean isDead) {
            this.isDead = isDead;
        }

        private boolean getIsDead() {
            return this.isDead;
        }

        public Token getParent() {
            return this.parent;
        }

        public boolean hasParentOfType(Type parentType) {
            for (Token p = this.getParent(); p != null; p = p.getParent()) {
                if (p.getType() != parentType) continue;
                return true;
            }
            return false;
        }

        public boolean hasChildOfType(Type childType) {
            Iterator<Token> iter = this.iterator();
            while (iter.hasNext()) {
                if (iter.next().getType() != childType) continue;
                return true;
            }
            return false;
        }

        private void setParent(Token parent) {
            this.parent = parent;
        }

        public Object[] getChildren() {
            return this.children.toArray();
        }

        public void reset() {
            this.children.clear();
        }

        public Iterator<Token> iterator() {
            return new TokenIterator(this);
        }

        public Type getType() {
            return this.type;
        }

        public String toString() {
            ToString t = toStringMap.get((Object)this.getType());
            if (t == null) {
                t = DEFAULT_TOSTRING;
            }
            return t.toString(this);
        }

        static {
            toStringMap.put(Type.CHARACTERCLASS, new ToString(){

                @Override
                public String toString(Token token) {
                    return super.toString(token).replace("\\b", "\b");
                }
            });
            toStringMap.put(Type.CHARACTER_ESCAPE, new ToString(){

                @Override
                public String toString(Token token) {
                    String str = super.toString(token);
                    if (str.length() == 2) {
                        return Token.unicode(Character.toLowerCase(str.charAt(1)) - 97 + 1);
                    }
                    return str;
                }
            });
            toStringMap.put(Type.DECIMAL_ESCAPE, new ToString(){

                @Override
                public String toString(Token token) {
                    String str = super.toString(token);
                    if ("\u0000".equals(str)) {
                        return str;
                    }
                    if (!token.hasParentOfType(Type.CLASSRANGES)) {
                        return str;
                    }
                    int value = Integer.parseInt(str, 8);
                    if (value > 255) {
                        throw new NumberFormatException(str);
                    }
                    return Token.unicode(value);
                }
            });
        }

        private static class ToString {
            private ToString() {
            }

            String toString(Token token) {
                String str;
                StringBuilder sb = new StringBuilder();
                for (Object child : token.getChildren()) {
                    sb.append(child);
                }
                switch (str = sb.toString()) {
                    case "\\s": {
                        str = "[" + Lexer.getWhitespaceRegExp() + "]";
                        break;
                    }
                    case "\\S": {
                        str = "[^" + Lexer.getWhitespaceRegExp() + "]";
                        break;
                    }
                    case "[^]": {
                        str = "[\\s\\S]";
                        break;
                    }
                }
                return str;
            }
        }

        private static class TokenIterator
        implements Iterator<Token> {
            private final List<Token> preorder = new ArrayList<Token>();

            private void init(Token root) {
                this.preorder.add(root);
                for (Object child : root.getChildren()) {
                    if (!(child instanceof Token)) continue;
                    this.init((Token)child);
                }
            }

            TokenIterator(Token root) {
                this.init(root);
            }

            @Override
            public boolean hasNext() {
                return !this.preorder.isEmpty();
            }

            @Override
            public Token next() {
                return this.preorder.remove(0);
            }

            @Override
            public void remove() {
                this.next();
            }
        }

        private static enum Type {
            PATTERN,
            DISJUNCTION,
            ALTERNATIVE,
            TERM,
            ASSERTION,
            QUANTIFIER,
            QUANTIFIER_PREFIX,
            ATOM,
            PATTERN_CHARACTER,
            ATOM_ESCAPE,
            CHARACTER_ESCAPE,
            CONTROL_ESCAPE,
            CONTROL_LETTER,
            IDENTITY_ESCAPE,
            DECIMAL_ESCAPE,
            CHARACTERCLASS_ESCAPE,
            CHARACTERCLASS,
            CLASSRANGES,
            NON_EMPTY_CLASSRANGES,
            NON_EMPTY_CLASSRANGES_NODASH,
            CLASSATOM,
            CLASSATOM_NODASH,
            CLASS_ESCAPE,
            DECIMALDIGITS,
            HEX_ESCAPESEQUENCE,
            UNICODE_ESCAPESEQUENCE;

        }
    }
}

