/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.objects;

import jdk.nashorn.internal.objects.ArrayBufferView;
import jdk.nashorn.internal.objects.Global;
import jdk.nashorn.internal.objects.NativeArrayBuffer;
import jdk.nashorn.internal.objects.annotations.Constructor;
import jdk.nashorn.internal.objects.annotations.Function;
import jdk.nashorn.internal.objects.annotations.ScriptClass;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.arrays.ArrayData;

@ScriptClass(value="Int8Array")
public class NativeInt8Array
extends ArrayBufferView {
    private static final int BYTES_PER_ELEMENT = 1;
    private static final ArrayBufferView.Factory FACTORY = new ArrayBufferView.Factory(1){

        @Override
        public ArrayBufferView construct(NativeArrayBuffer buffer, int byteOffset, int length) {
            return new NativeInt8Array(buffer, byteOffset, length);
        }

        @Override
        public ArrayData createArrayData(NativeArrayBuffer buffer, int byteOffset, int length) {
            return new Int8ArrayData(buffer, byteOffset, length);
        }
    };

    @Constructor(arity=1)
    public static Object constructor(boolean newObj, Object self, Object ... args) {
        return NativeInt8Array.constructorImpl(args, FACTORY);
    }

    NativeInt8Array(NativeArrayBuffer buffer, int byteOffset, int length) {
        super(buffer, byteOffset, length);
    }

    @Override
    protected ArrayBufferView.Factory factory() {
        return FACTORY;
    }

    @Function(attributes=2)
    protected static Object set(Object self, Object array, Object offset) {
        return ArrayBufferView.setImpl(self, array, offset);
    }

    @Function(attributes=2)
    protected static Object subarray(Object self, Object begin, Object end) {
        return ArrayBufferView.subarrayImpl(self, begin, end);
    }

    @Override
    protected ScriptObject getPrototype() {
        return Global.instance().getInt8ArrayPrototype();
    }

    private static final class Int8ArrayData
    extends ArrayBufferView.ArrayDataImpl {
        private Int8ArrayData(NativeArrayBuffer buffer, int byteOffset, int elementLength) {
            super(buffer, byteOffset, elementLength);
        }

        @Override
        protected int byteIndex(int index) {
            return index * 1 + this.byteOffset;
        }

        @Override
        protected int getIntImpl(int index) {
            return this.buffer.getByteArray()[this.byteIndex(index)];
        }

        @Override
        protected void setImpl(int index, int value) {
            this.buffer.getByteArray()[this.byteIndex((int)index)] = (byte)value;
        }
    }
}

