/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.objects;

import jdk.nashorn.internal.objects.ArrayBufferView;
import jdk.nashorn.internal.objects.Global;
import jdk.nashorn.internal.objects.NativeArrayBuffer;
import jdk.nashorn.internal.objects.annotations.Constructor;
import jdk.nashorn.internal.objects.annotations.Function;
import jdk.nashorn.internal.objects.annotations.ScriptClass;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.arrays.ArrayData;

@ScriptClass(value="Int32Array")
public class NativeInt32Array
extends ArrayBufferView {
    private static final int BYTES_PER_ELEMENT = 4;
    private static final ArrayBufferView.Factory FACTORY = new ArrayBufferView.Factory(4){

        @Override
        public ArrayBufferView construct(NativeArrayBuffer buffer, int byteOffset, int length) {
            return new NativeInt32Array(buffer, byteOffset, length);
        }

        @Override
        public ArrayData createArrayData(NativeArrayBuffer buffer, int byteOffset, int length) {
            return new Int32ArrayData(buffer, byteOffset, length);
        }
    };

    @Constructor(arity=1)
    public static Object constructor(boolean newObj, Object self, Object ... args) {
        return NativeInt32Array.constructorImpl(args, FACTORY);
    }

    NativeInt32Array(NativeArrayBuffer buffer, int byteOffset, int length) {
        super(buffer, byteOffset, length);
    }

    @Override
    protected ArrayBufferView.Factory factory() {
        return FACTORY;
    }

    @Function(attributes=2)
    protected static Object set(Object self, Object array, Object offset) {
        return ArrayBufferView.setImpl(self, array, offset);
    }

    @Function(attributes=2)
    protected static Object subarray(Object self, Object begin, Object end) {
        return ArrayBufferView.subarrayImpl(self, begin, end);
    }

    @Override
    protected ScriptObject getPrototype() {
        return Global.instance().getInt32ArrayPrototype();
    }

    private static final class Int32ArrayData
    extends ArrayBufferView.ArrayDataImpl {
        private Int32ArrayData(NativeArrayBuffer buffer, int byteOffset, int elementLength) {
            super(buffer, byteOffset, elementLength);
        }

        @Override
        protected int byteIndex(int index) {
            return index * 4 + this.byteOffset;
        }

        @Override
        protected int getIntImpl(int index) {
            int byteIndex = this.byteIndex(index);
            byte[] byteArray = this.buffer.getByteArray();
            return byteArray[byteIndex] & 0xFF | byteArray[byteIndex + 1] << 8 & 0xFF00 | byteArray[byteIndex + 2] << 16 & 0xFF0000 | byteArray[byteIndex + 3] << 24 & 0xFF000000;
        }

        @Override
        protected void setImpl(int index, int value) {
            int byteIndex = this.byteIndex(index);
            byte[] byteArray = this.buffer.getByteArray();
            byteArray[byteIndex] = (byte)(value & 0xFF);
            byteArray[byteIndex + 1] = (byte)(value >>> 8 & 0xFF);
            byteArray[byteIndex + 2] = (byte)(value >>> 16 & 0xFF);
            byteArray[byteIndex + 3] = (byte)(value >>> 24 & 0xFF);
        }
    }
}

