/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jdk.nashorn.internal.codegen.CompileUnit;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.PropertyKey;
import jdk.nashorn.internal.ir.Symbol;
import jdk.nashorn.internal.ir.UnaryNode;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.parser.Lexer;
import jdk.nashorn.internal.parser.Token;
import jdk.nashorn.internal.parser.TokenType;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.Source;
import jdk.nashorn.internal.runtime.Undefined;

public abstract class LiteralNode<T>
extends Node
implements PropertyKey {
    protected T value;

    protected LiteralNode(Source source, long token, int finish, T value) {
        super(source, token, finish);
        this.value = value;
    }

    protected LiteralNode(LiteralNode<T> literalNode) {
        super(literalNode);
        this.value = literalNode.value;
    }

    @Override
    public boolean isAtom() {
        return true;
    }

    public boolean isNull() {
        return this.value == null;
    }

    @Override
    public int hashCode() {
        return this.value == null ? 0 : this.value.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof LiteralNode)) {
            return false;
        }
        LiteralNode otherNode = (LiteralNode)other;
        if (otherNode.isNull()) {
            return this.isNull();
        }
        return ((LiteralNode)other).getValue().equals(this.value);
    }

    public boolean isTrue() {
        return JSType.toBoolean(this.value);
    }

    @Override
    public Type getType() {
        return Type.typeFor(this.value.getClass());
    }

    @Override
    public String getPropertyName() {
        return JSType.toString(this.getObject());
    }

    public boolean getBoolean() {
        return JSType.toBoolean(this.value);
    }

    public int getInt32() {
        return JSType.toInt32(this.value);
    }

    public long getUint32() {
        return JSType.toUint32(this.value);
    }

    public long getLong() {
        return JSType.toLong(this.value);
    }

    public double getNumber() {
        return JSType.toNumber(this.value);
    }

    public Node[] getArray() {
        assert (false) : "not an array node";
        return null;
    }

    public String getString() {
        return JSType.toString(this.value);
    }

    public Object getObject() {
        return this.value;
    }

    public boolean isString() {
        return this.value instanceof String;
    }

    public boolean isNumeric() {
        return this.value instanceof Number;
    }

    @Override
    public Node accept(NodeVisitor visitor) {
        if (visitor.enter(this) != null) {
            return visitor.leave(this);
        }
        return this;
    }

    @Override
    public void toString(StringBuilder sb) {
        if (this.value == null) {
            sb.append("null");
        } else {
            sb.append(this.value.toString());
        }
    }

    public T getValue() {
        return this.value;
    }

    public static LiteralNode<Node> newInstance(Source source, long token, int finish) {
        return new NodeLiteralNode(source, token, finish);
    }

    public static LiteralNode<?> newInstance(Node parent) {
        return new NodeLiteralNode(parent.getSource(), parent.getToken(), parent.getFinish());
    }

    public static LiteralNode<Boolean> newInstance(Source source, long token, int finish, boolean value) {
        return new BooleanLiteralNode(source, token, finish, value);
    }

    public static LiteralNode<?> newInstance(Node parent, boolean value) {
        return new BooleanLiteralNode(parent.getSource(), parent.getToken(), parent.getFinish(), value);
    }

    public static LiteralNode<Number> newInstance(Source source, long token, int finish, Number value) {
        return new NumberLiteralNode(source, token, finish, value);
    }

    public static LiteralNode<?> newInstance(Node parent, Number value) {
        return new NumberLiteralNode(parent.getSource(), parent.getToken(), parent.getFinish(), value);
    }

    public static LiteralNode<Undefined> newInstance(Source source, long token, int finish, Undefined value) {
        return new UndefinedLiteralNode(source, token, finish);
    }

    public static LiteralNode<?> newInstance(Node parent, Undefined value) {
        return new UndefinedLiteralNode(parent.getSource(), parent.getToken(), parent.getFinish());
    }

    public static LiteralNode<String> newInstance(Source source, long token, int finish, String value) {
        return new StringLiteralNode(source, token, finish, value);
    }

    public static LiteralNode<?> newInstance(Node parent, String value) {
        return new StringLiteralNode(parent.getSource(), parent.getToken(), parent.getFinish(), value);
    }

    public static LiteralNode<Lexer.LexerToken> newInstance(Source source, long token, int finish, Lexer.LexerToken value) {
        return new LexerTokenLiteralNode(source, token, finish, value);
    }

    public static LiteralNode<?> newInstance(Node parent, Lexer.LexerToken value) {
        return new LexerTokenLiteralNode(parent.getSource(), parent.getToken(), parent.getFinish(), value);
    }

    public static LiteralNode<Node> newInstance(Source source, long token, int finish, Node value) {
        return new NodeLiteralNode(source, token, finish, value);
    }

    public static LiteralNode<?> newInstance(Node parent, Node value) {
        return new NodeLiteralNode(parent.getSource(), parent.getToken(), parent.getFinish(), value);
    }

    public static LiteralNode<Node[]> newInstance(Source source, long token, int finish, List<Node> value) {
        return new ArrayLiteralNode(source, token, finish, value.toArray(new Node[value.size()]));
    }

    public static LiteralNode<?> newInstance(Node parent, List<Node> value) {
        return new ArrayLiteralNode(parent.getSource(), parent.getToken(), parent.getFinish(), value.toArray(new Node[value.size()]));
    }

    public static LiteralNode<Node[]> newInstance(Source source, long token, int finish, Node[] value) {
        return new ArrayLiteralNode(source, token, finish, value);
    }

    public static class ArrayLiteralNode
    extends LiteralNode<Node[]> {
        private static PostsetMarker POSTSET_MARKER = new PostsetMarker();
        private Type elementType;
        private Object presets;
        private int[] postsets;
        private List<ArrayUnit> units;

        protected ArrayLiteralNode(Source source, long token, int finish, Node[] value) {
            super(source, Token.recast(token, TokenType.ARRAY), finish, value);
            this.elementType = Type.UNKNOWN;
        }

        protected ArrayLiteralNode(ArrayLiteralNode node) {
            super(node);
            this.elementType = node.elementType;
        }

        @Override
        protected Node copy(Node.CopyState cs) {
            return new ArrayLiteralNode(this);
        }

        public void analyze() {
            this.elementType = Type.INT;
            this.analyzeElements();
            if (this.elementType == Type.INT) {
                this.presetIntArray();
            } else if (this.elementType.isNumeric()) {
                this.presetNumberArray();
            } else {
                this.presetObjectArray();
            }
        }

        private void presetIntArray() {
            int[] array = new int[((Node[])this.value).length];
            int[] computed = new int[((Node[])this.value).length];
            int nComputed = 0;
            for (int i = 0; i < ((Node[])this.value).length; ++i) {
                Object element = this.objectAsConstant(((Node[])this.value)[i]);
                if (element instanceof Number) {
                    array[i] = ((Number)element).intValue();
                    continue;
                }
                computed[nComputed++] = i;
            }
            this.presets = array;
            this.postsets = Arrays.copyOf(computed, nComputed);
        }

        private void presetNumberArray() {
            double[] array = new double[((Node[])this.value).length];
            int[] computed = new int[((Node[])this.value).length];
            int nComputed = 0;
            for (int i = 0; i < ((Node[])this.value).length; ++i) {
                Object element = this.objectAsConstant(((Node[])this.value)[i]);
                if (element instanceof Number) {
                    array[i] = ((Number)element).doubleValue();
                    continue;
                }
                computed[nComputed++] = i;
            }
            this.presets = array;
            this.postsets = Arrays.copyOf(computed, nComputed);
        }

        private void presetObjectArray() {
            Object[] array = new Object[((Node[])this.value).length];
            int[] computed = new int[((Node[])this.value).length];
            int nComputed = 0;
            for (int i = 0; i < ((Node[])this.value).length; ++i) {
                Node node = ((Node[])this.value)[i];
                if (node == null) {
                    computed[nComputed++] = i;
                    continue;
                }
                Object element = this.objectAsConstant(node);
                if (element != POSTSET_MARKER) {
                    array[i] = element;
                    continue;
                }
                computed[nComputed++] = i;
            }
            this.presets = array;
            this.postsets = Arrays.copyOf(computed, nComputed);
        }

        private void analyzeElements() {
            for (Node node : (Node[])this.value) {
                if (node == null) {
                    this.elementType = this.elementType.widest(Type.OBJECT);
                    break;
                }
                Symbol symbol = node.getSymbol();
                assert (symbol != null);
                Type symbolType = symbol.getSymbolType();
                if (symbolType.isUnknown()) {
                    symbolType = Type.OBJECT;
                }
                if (symbolType.isBoolean()) {
                    this.elementType = this.elementType.widest(Type.OBJECT);
                    break;
                }
                this.elementType = this.elementType.widest(symbolType);
                if (this.elementType.isObject()) break;
            }
        }

        private Object objectAsConstant(Object object) {
            UnaryNode unaryNode;
            if (object == null) {
                return null;
            }
            if (object instanceof Number || object instanceof String || object instanceof Boolean) {
                return object;
            }
            if (object instanceof LiteralNode) {
                return this.objectAsConstant(((LiteralNode)object).getValue());
            }
            if (object instanceof UnaryNode && (unaryNode = (UnaryNode)object).isTokenType(TokenType.CONVERT) && unaryNode.getType().isObject()) {
                return this.objectAsConstant(unaryNode.rhs());
            }
            return POSTSET_MARKER;
        }

        @Override
        public Node[] getArray() {
            return (Node[])this.value;
        }

        @Override
        public Type getType() {
            if (this.elementType.isInteger()) {
                return Type.INT_ARRAY;
            }
            if (this.elementType.isNumeric()) {
                return Type.NUMBER_ARRAY;
            }
            return Type.OBJECT_ARRAY;
        }

        public Type getElementType() {
            return this.elementType;
        }

        public int[] getPostsets() {
            return this.postsets;
        }

        public Object getPresets() {
            return this.presets;
        }

        public List<ArrayUnit> getUnits() {
            return this.units == null ? null : Collections.unmodifiableList(this.units);
        }

        public void setUnits(List<ArrayUnit> units) {
            this.units = units;
        }

        @Override
        public Node accept(NodeVisitor visitor) {
            if (visitor.enter(this) != null) {
                for (int i = 0; i < ((Node[])this.value).length; ++i) {
                    Node element = ((Node[])this.value)[i];
                    if (element == null) continue;
                    ((Node[])this.value)[i] = element.accept(visitor);
                }
                return visitor.leave(this);
            }
            return this;
        }

        @Override
        public void toString(StringBuilder sb) {
            sb.append('[');
            boolean first = true;
            for (Node node : (Node[])this.value) {
                if (!first) {
                    sb.append(',');
                    sb.append(' ');
                }
                if (node == null) {
                    sb.append("undefined");
                } else {
                    node.toString(sb);
                }
                first = false;
            }
            sb.append(']');
        }

        public static class ArrayUnit {
            private final CompileUnit compileUnit;
            private final int lo;
            private final int hi;

            public ArrayUnit(CompileUnit compileUnit, int lo, int hi) {
                this.compileUnit = compileUnit;
                this.lo = lo;
                this.hi = hi;
            }

            public int getHi() {
                return this.hi;
            }

            public int getLo() {
                return this.lo;
            }

            public CompileUnit getCompileUnit() {
                return this.compileUnit;
            }
        }

        private static class PostsetMarker {
            private PostsetMarker() {
            }
        }
    }

    private static class BooleanLiteralNode
    extends LiteralNode<Boolean> {
        private BooleanLiteralNode(Source source, long token, int finish, boolean value) {
            super(source, Token.recast(token, value ? TokenType.TRUE : TokenType.FALSE), finish, value);
        }

        private BooleanLiteralNode(BooleanLiteralNode literalNode) {
            super(literalNode);
        }

        @Override
        protected Node copy(Node.CopyState cs) {
            return new BooleanLiteralNode(this);
        }

        @Override
        public boolean isTrue() {
            return (Boolean)this.value;
        }

        @Override
        public Type getType() {
            return Type.BOOLEAN;
        }

        @Override
        public Type getWidestOperationType() {
            return Type.BOOLEAN;
        }
    }

    private static class LexerTokenLiteralNode
    extends LiteralNode<Lexer.LexerToken> {
        private LexerTokenLiteralNode(Source source, long token, int finish, Lexer.LexerToken value) {
            super(source, Token.recast(token, TokenType.STRING), finish, value);
        }

        private LexerTokenLiteralNode(LexerTokenLiteralNode literalNode) {
            super(literalNode);
        }

        @Override
        protected Node copy(Node.CopyState cs) {
            return new LexerTokenLiteralNode(this);
        }

        @Override
        public Type getType() {
            return Type.OBJECT;
        }

        @Override
        public void toString(StringBuilder sb) {
            sb.append(((Lexer.LexerToken)this.value).toString());
        }
    }

    private static class NodeLiteralNode
    extends LiteralNode<Node> {
        private NodeLiteralNode(Source source, long token, int finish) {
            this(source, token, finish, (Node)null);
        }

        private NodeLiteralNode(Source source, long token, int finish, Node value) {
            super(source, Token.recast(token, TokenType.OBJECT), finish, value);
        }

        private NodeLiteralNode(LiteralNode<Node> literalNode) {
            super(literalNode);
        }

        @Override
        protected Node copy(Node.CopyState cs) {
            return new NodeLiteralNode(this);
        }

        @Override
        public Node accept(NodeVisitor visitor) {
            if (visitor.enter(this) != null) {
                if (this.value != null) {
                    this.value = ((Node)this.value).accept(visitor);
                }
                return visitor.leave(this);
            }
            return this;
        }

        @Override
        public Type getType() {
            return this.value == null ? Type.OBJECT : super.getType();
        }

        @Override
        public Type getWidestOperationType() {
            return this.value == null ? Type.OBJECT : ((Node)this.value).getWidestOperationType();
        }
    }

    private static class NumberLiteralNode
    extends LiteralNode<Number> {
        private final Type type;

        private NumberLiteralNode(Source source, long token, int finish, Number value) {
            super(source, Token.recast(token, TokenType.DECIMAL), finish, value);
            this.type = NumberLiteralNode.numberGetType((Number)this.value);
        }

        private NumberLiteralNode(NumberLiteralNode literalNode) {
            super(literalNode);
            this.type = NumberLiteralNode.numberGetType((Number)this.value);
        }

        private static Type numberGetType(Number number) {
            if (number instanceof Integer) {
                return Type.INT;
            }
            if (number instanceof Long) {
                return Type.LONG;
            }
            if (number instanceof Double) {
                return Type.NUMBER;
            }
            assert (false);
            return null;
        }

        @Override
        protected Node copy(Node.CopyState cs) {
            return new NumberLiteralNode(this);
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public Type getWidestOperationType() {
            return this.getType();
        }
    }

    private static class StringLiteralNode
    extends LiteralNode<String> {
        private StringLiteralNode(Source source, long token, int finish, String value) {
            super(source, Token.recast(token, TokenType.STRING), finish, value);
        }

        private StringLiteralNode(StringLiteralNode literalNode) {
            super(literalNode);
        }

        @Override
        protected Node copy(Node.CopyState cs) {
            return new StringLiteralNode(this);
        }

        @Override
        public void toString(StringBuilder sb) {
            sb.append('\"');
            sb.append((String)this.value);
            sb.append('\"');
        }
    }

    private static class UndefinedLiteralNode
    extends LiteralNode<Undefined> {
        private UndefinedLiteralNode(Source source, long token, int finish) {
            super(source, Token.recast(token, TokenType.OBJECT), finish, ScriptRuntime.UNDEFINED);
        }

        private UndefinedLiteralNode(UndefinedLiteralNode literalNode) {
            super(literalNode);
        }

        @Override
        protected Node copy(Node.CopyState cs) {
            return new UndefinedLiteralNode(this);
        }
    }
}

